/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogFile;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.jdbc.JdbcConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LogMinerHelperTest {
    private OracleConnection connection = (OracleConnection)Mockito.mock(OracleConnection.class);
    private int current;
    private String[][] mockRows;

    @Before
    public void beforeEach() throws Exception {
        this.current = 0;
        this.mockRows = new String[0][];
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Connection conn = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.connection.connection()).thenReturn((Object)conn);
        Mockito.when((Object)this.connection.connection(false)).thenReturn((Object)conn);
        PreparedStatement pstmt = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        JdbcConnection.StatementFactory factory = (JdbcConnection.StatementFactory)Mockito.mock(JdbcConnection.StatementFactory.class);
        Mockito.when((Object)factory.createStatement(conn)).thenReturn((Object)pstmt);
        Mockito.when((Object)conn.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)pstmt);
        Mockito.when((Object)pstmt.executeQuery()).thenReturn((Object)rs);
        Mockito.when((Object)rs.next()).thenAnswer(it -> ++this.current <= this.mockRows.length);
        Mockito.when((Object)rs.getString(ArgumentMatchers.anyInt())).thenAnswer(it -> this.mockRows[this.current - 1][(Integer)it.getArguments()[0] - 1]);
        Mockito.when((Object)rs.getLong(ArgumentMatchers.anyInt())).thenAnswer(it -> Long.valueOf(this.mockRows[this.current - 1][(Integer)it.getArguments()[0] - 1]));
        ((OracleConnection)Mockito.doAnswer(a -> {
            JdbcConnection.ResultSetConsumer consumer = (JdbcConnection.ResultSetConsumer)a.getArgument(1);
            consumer.accept(rs);
            return null;
        }).when((Object)this.connection)).query(ArgumentMatchers.anyString(), (JdbcConnection.ResultSetConsumer)ArgumentMatchers.any(JdbcConnection.ResultSetConsumer.class));
    }

    @Test
    public void logsWithRegularScns() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "103700", "YES", null, "ARCHIVED", "1", "YES", "YES"}, {"logfile2", "103700", "104000", "NO", "ACTIVE", "ONLINE", "2", "NO", "NO"}};
        List logs = LogMinerHelper.getLogFilesForOffsetScn((OracleConnection)this.connection, (Scn)Scn.valueOf((long)10L), (Duration)Duration.ofDays(60L), (boolean)false, null);
        Assertions.assertThat((List)logs).hasSize(2);
        Assertions.assertThat((Object)LogMinerHelperTest.getLogFileNextScnByName(logs, "logfile1")).isEqualTo((Object)Scn.valueOf((long)103700L));
        Assertions.assertThat((Object)LogMinerHelperTest.getLogFileNextScnByName(logs, "logfile2")).isEqualTo((Object)Scn.valueOf((long)104000L));
    }

    @Test
    public void excludeLogsBeforeOffsetScn() throws Exception {
        this.mockRows = new String[][]{{"logfile3", "103300", "103400", "YES", null, "ARCHIVED", "1", "YES", "YES"}, {"logfile1", "103400", "103700", "YES", null, "ARCHIVED", "2", "YES", "YES"}, {"logfile2", "103700", "104000", "NO", "ACTIVE", "ONLINE", "3", "NO", "NO"}};
        List logs = LogMinerHelper.getLogFilesForOffsetScn((OracleConnection)this.connection, (Scn)Scn.valueOf((int)103401), (Duration)Duration.ofDays(60L), (boolean)false, null);
        Assertions.assertThat((List)logs).hasSize(2);
        Assertions.assertThat((Object)LogMinerHelperTest.getLogFileNextScnByName(logs, "logfile3")).isNull();
    }

    @Test
    public void nullsHandledAsMaxScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "103700", "YES", null, "ARCHIVED", "1", "YES", "YES"}, {"logfile2", "103700", "104000", "YES", null, "ARCHIVED", "2", "YES", "YES"}, {"logfile3", "104000", null, "NO", "CURRENT", "ONLINE", "3", "NO", "NO"}};
        List onlineLogs = LogMinerHelper.getLogFilesForOffsetScn((OracleConnection)this.connection, (Scn)Scn.valueOf((long)600L), (Duration)Duration.ofDays(60L), (boolean)false, null);
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals((Object)LogMinerHelperTest.getLogFileNextScnByName(onlineLogs, "logfile3"), (Object)Scn.MAX);
    }

    @Test
    public void canHandleMaxScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "103700", "YES", null, "ARCHIVED", "1", "YES", "YES"}, {"logfile2", "103700", "104000", "YES", null, "ARCHIVED", "2", "YES", "YES"}, {"logfile3", "104000", "18446744073709551615", "NO", "CURRENT", "ONLINE", "3", "NO", "NO"}};
        List onlineLogs = LogMinerHelper.getLogFilesForOffsetScn((OracleConnection)this.connection, (Scn)Scn.valueOf((long)600L), (Duration)Duration.ofDays(60L), (boolean)false, null);
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals((Object)LogMinerHelperTest.getLogFileNextScnByName(onlineLogs, "logfile3"), (Object)Scn.MAX);
    }

    @Test
    public void logsWithVeryLargeScnAreSupported() throws Exception {
        String scnLonger = "18446744073709551615";
        this.mockRows = new String[][]{{"logfile1", "103400", "103700", "YES", null, "ARCHIVED", "1", "YES", "YES"}, {"logfile2", "103700", "104000", "YES", null, "ARCHIVED", "2", "YES", "YES"}, {"logfile3", "104000", "18446744073709551615", "NO", "ACTIVE", "ONLINE", "3", "NO", "NO"}};
        List onlineLogs = LogMinerHelper.getLogFilesForOffsetScn((OracleConnection)this.connection, (Scn)Scn.valueOf((long)600L), (Duration)Duration.ofDays(60L), (boolean)false, null);
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals((Object)LogMinerHelperTest.getLogFileNextScnByName(onlineLogs, "logfile3"), (Object)Scn.valueOf((String)scnLonger));
    }

    private static Scn getLogFileNextScnByName(List<LogFile> logs, String name) {
        Optional<LogFile> file = logs.stream().filter(l -> l.getFileName().equals(name)).findFirst();
        if (file.isPresent()) {
            return file.get().getNextScn();
        }
        return null;
    }
}

