/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.relational.ddl.DdlParserListener;
import io.debezium.util.IoUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OracleDdlParserTest {
    private static final String TABLE_NAME = "TEST";
    private static final String PDB_NAME = "ORCLPDB1";
    private OracleDdlParser parser;
    private Tables tables;

    @Before
    public void setUp() {
        this.parser = new OracleDdlParser(true, null, null);
        this.tables = new Tables();
    }

    @Test
    public void shouldParseCreateAndAlterTable() throws Exception {
        String createStatement = IoUtil.read((InputStream)IoUtil.getResourceAsStream((String)"ddl/create_table.sql", null, this.getClass(), null, null));
        Objects.requireNonNull(createStatement);
        this.parser.parse(createStatement, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, TABLE_NAME));
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Assertions.assertThat((List)table.retrieveColumnNames()).containsExactly(new Object[]{"ID", "COL1", "COL2", "COL3", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9", "COL10", "COL11", "COL12", "COL13"});
        Assertions.assertThat((int)table.columnWithName("ID").position()).isEqualTo(1);
        Assertions.assertThat((boolean)table.isPrimaryKeyColumn("ID"));
        this.testColumn(table, "ID", false, 2, "NUMBER", 19, 0, false, null);
        this.testColumn(table, "COL1", true, 2, "NUMBER", 4, 2, true, null);
        this.testColumn(table, "COL2", false, 12, "VARCHAR2", 255, null, true, "debezium");
        this.testColumn(table, "COL3", false, -9, "NVARCHAR2", 255, null, false, null);
        this.testColumn(table, "COL4", true, 1, "CHAR", 1, null, true, null);
        this.testColumn(table, "COL5", true, -15, "NCHAR", 1, 0, true, null);
        this.testColumn(table, "COL6", true, 6, "FLOAT", 126, 0, true, null);
        this.testColumn(table, "COL7", true, 93, "DATE", -1, null, true, null);
        this.testColumn(table, "COL8", true, 93, "TIMESTAMP", 6, null, true, null);
        this.testColumn(table, "COL9", true, 2004, "BLOB", -1, null, true, null);
        this.testColumn(table, "COL10", true, 2005, "CLOB", -1, null, true, null);
        this.testColumn(table, "col11", true, 2002, "MDSYS.SDO_GEOMETRY", -1, null, true, null);
        this.testColumn(table, "col12", true, 2, "NUMBER", 1, 0, true, null);
        this.testColumn(table, "col13", false, 93, "DATE", -1, null, false, null);
        String ddl = "alter table TEST add (col21 varchar2(20), col22 number(19));";
        this.parser.parse(ddl, this.tables);
        Table alteredTable = this.tables.forTable(new TableId(null, null, TABLE_NAME));
        Assertions.assertThat((List)alteredTable.retrieveColumnNames()).containsExactly(new Object[]{"ID", "COL1", "COL2", "COL3", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9", "COL10", "COL11", "COL12", "COL13", "COL21", "COL22"});
        this.testColumn(alteredTable, "COL21", true, 12, "VARCHAR2", 20, null, true, null);
        this.testColumn(alteredTable, "COL22", true, 2, "NUMBER", 19, 0, true, null);
        ddl = "alter table TEST add col23 varchar2(20);";
        try {
            this.parser.parse(ddl, this.tables);
        }
        catch (Exception e) {
            Assertions.assertThat((boolean)e.getMessage().contains("no viable alternative at input"));
        }
        ddl = "alter table TEST add (col23 varchar2(20) not null);";
        this.parser.parse(ddl, this.tables);
        alteredTable = this.tables.forTable(new TableId(null, null, TABLE_NAME));
        Assertions.assertThat((List)alteredTable.retrieveColumnNames()).containsExactly(new Object[]{"ID", "COL1", "COL2", "COL3", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9", "COL10", "COL11", "COL12", "COL13", "COL21", "COL22", "COL23"});
        this.testColumn(alteredTable, "COL23", false, 12, "VARCHAR2", 20, null, false, null);
        ddl = "alter table TEST drop (col22, col23);";
        this.parser.parse(ddl, this.tables);
        alteredTable = this.tables.forTable(new TableId(null, null, TABLE_NAME));
        Assertions.assertThat((List)alteredTable.retrieveColumnNames()).containsExactly(new Object[]{"ID", "COL1", "COL2", "COL3", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9", "COL10", "COL11", "COL12", "COL13", "COL21"});
        ddl = "drop table TEST;";
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isZero();
        ddl = "drop table TEST cascade constrains purge;";
        ddl = "ALTER TABLE TEST ADD CONSTRAINT FKB97209E040C4205 FOREIGN KEY (col1) REFERENCES debezium_ref(ID);";
        ddl = "ALTER TABLE TEST MODIFY COL1 varchar2(50) not null;";
    }

    @Test
    public void shouldParseCreateTable() {
        this.parser.setCurrentDatabase(PDB_NAME);
        this.parser.setCurrentSchema("DEBEZIUM");
        String CREATE_SIMPLE_TABLE = "create table debezium.customer (  id int not null,   name varchar2(1000),   score decimal(6, 2),   registered date,   primary key (id));";
        this.parser.parse(CREATE_SIMPLE_TABLE, this.tables);
        Table table = this.tables.forTable(new TableId(PDB_NAME, "DEBEZIUM", "CUSTOMER"));
        Assertions.assertThat((Object)table).isNotNull();
        Column id = table.columnWithName("ID");
        Assertions.assertThat((boolean)id.isOptional()).isFalse();
        Assertions.assertThat((int)id.jdbcType()).isEqualTo(2);
        Assertions.assertThat((String)id.typeName()).isEqualTo((Object)"NUMBER");
        Column name = table.columnWithName("NAME");
        Assertions.assertThat((boolean)name.isOptional()).isTrue();
        Assertions.assertThat((int)name.jdbcType()).isEqualTo(12);
        Assertions.assertThat((String)name.typeName()).isEqualTo((Object)"VARCHAR2");
        Assertions.assertThat((int)name.length()).isEqualTo(1000);
        Column score = table.columnWithName("SCORE");
        Assertions.assertThat((boolean)score.isOptional()).isTrue();
        Assertions.assertThat((int)score.jdbcType()).isEqualTo(2);
        Assertions.assertThat((String)score.typeName()).isEqualTo((Object)"NUMBER");
        Assertions.assertThat((int)score.length()).isEqualTo(6);
        Assertions.assertThat((Integer)((Integer)score.scale().get())).isEqualTo(2);
        Assertions.assertThat((List)table.columns()).hasSize(4);
        Assertions.assertThat((boolean)table.isPrimaryKeyColumn("ID"));
    }

    @Test
    public void testParsingMultiStatementTableMetadataResult() throws Exception {
        this.parser.setCurrentDatabase(PDB_NAME);
        this.parser.setCurrentSchema("IDENTITYDB");
        String MULTI_STATEMENT_DDL = "  CREATE TABLE \"IDENTITYDB\".\"CHANGE_NUMBERS\"\n   (    \"CHANGE_NO\" NUMBER(*,0) NOT NULL ENABLE,\n    \"SOURCE_INFO\" VARCHAR2(128) NOT NULL ENABLE,\n    \"CHANGED_TIME\" TIMESTAMP (6) DEFAULT SYSDATE,\n    \"ENTITY_TYPE\" VARCHAR2(36) NOT NULL ENABLE,\n    \"ORGANIZATIONID\" VARCHAR2(36),\n    \"PROCESSED\" NUMBER(1,0) DEFAULT 1 NOT NULL ENABLE,\n    \"TRACKING_ID\" VARCHAR2(256) NOT NULL ENABLE,\n    \"EXPIRY_TIME\" TIMESTAMP (6),\n    \"ACTOR\" VARCHAR2(36),\n    \"ENTITY_ID\" VARCHAR2(36)\n   )\n  PARTITION BY RANGE (\"EXPIRY_TIME\") INTERVAL (NUMTODSINTERVAL(7, 'DAY'))\n  SUBPARTITION BY HASH (\"CHANGE_NO\")\n  SUBPARTITIONS 16\n (PARTITION \"SYS_P44414\"  VALUES LESS THAN (TIMESTAMP' 2021-07-06 00:00:00')\n ( SUBPARTITION \"SYS_SUBP44398\" ,\n  SUBPARTITION \"SYS_SUBP44399\" ,\n  SUBPARTITION \"SYS_SUBP44400\" ,\n  SUBPARTITION \"SYS_SUBP44401\" ,\n  SUBPARTITION \"SYS_SUBP44402\" ,\n  SUBPARTITION \"SYS_SUBP44403\" ,\n  SUBPARTITION \"SYS_SUBP44404\" ,\n  SUBPARTITION \"SYS_SUBP44405\" ,\n  SUBPARTITION \"SYS_SUBP44406\" ,\n  SUBPARTITION \"SYS_SUBP44407\" ,\n  SUBPARTITION \"SYS_SUBP44408\" ,\n  SUBPARTITION \"SYS_SUBP44409\" ,\n  SUBPARTITION \"SYS_SUBP44410\" ,\n  SUBPARTITION \"SYS_SUBP44411\" ,\n  SUBPARTITION \"SYS_SUBP44412\" ,\n  SUBPARTITION \"SYS_SUBP44413\" ) );\n  CREATE UNIQUE INDEX \"IDENTITYDB\".\"IDX_CHANGENUMBERS_PK\" ON \"IDENTITYDB\".\"CHANGE_NUMBERS\" (\"CHANGE_NO\", \"EXPIRY_TIME\")\n   LOCAL\n (PARTITION \"SYS_P44414\" NOCOMPRESS\n ( SUBPARTITION \"SYS_SUBP44398\" ,\n  SUBPARTITION \"SYS_SUBP44399\" ,\n  SUBPARTITION \"SYS_SUBP44400\" ,\n  SUBPARTITION \"SYS_SUBP44401\" ,\n  SUBPARTITION \"SYS_SUBP44402\" ,\n  SUBPARTITION \"SYS_SUBP44403\" ,\n  SUBPARTITION \"SYS_SUBP44404\" ,\n  SUBPARTITION \"SYS_SUBP44405\" ,\n  SUBPARTITION \"SYS_SUBP44406\" ,\n  SUBPARTITION \"SYS_SUBP44407\" ,\n  SUBPARTITION \"SYS_SUBP44408\" ,\n  SUBPARTITION \"SYS_SUBP44409\" ,\n  SUBPARTITION \"SYS_SUBP44410\" ,\n  SUBPARTITION \"SYS_SUBP44411\" ,\n  SUBPARTITION \"SYS_SUBP44412\" ,\n  SUBPARTITION \"SYS_SUBP44413\" ) );\nALTER TABLE \"IDENTITYDB\".\"CHANGE_NUMBERS\" ADD CONSTRAINT \"IDX_CHANGENUMBERS_PK\" PRIMARY KEY (\"CHANGE_NO\", \"EXPIRY_TIME\")\n  USING INDEX \"IDENTITYDB\".\"IDX_CHANGENUMBERS_PK\"  ENABLE NOVALIDATE;";
        this.parser.parse(MULTI_STATEMENT_DDL, this.tables);
        DdlChanges changes = this.parser.getDdlChanges();
        ArrayList eventTypes = new ArrayList();
        changes.getEventsByDatabase((dbName, events) -> events.forEach(event -> eventTypes.add(event.type())));
        Assertions.assertThat(eventTypes).containsExactly(new Object[]{DdlParserListener.EventType.CREATE_TABLE, DdlParserListener.EventType.ALTER_TABLE});
        Table table = this.tables.forTable(new TableId(PDB_NAME, "IDENTITYDB", "CHANGE_NUMBERS"));
        List columnNames = table.retrieveColumnNames();
        Assertions.assertThat((List)columnNames).contains(new Object[]{"CHANGE_NO", "SOURCE_INFO", "CHANGED_TIME", "ENTITY_TYPE", "ORGANIZATIONID", "PROCESSED", "TRACKING_ID", "EXPIRY_TIME", "ACTOR", "ENTITY_ID"});
        Assertions.assertThat((List)table.primaryKeyColumnNames()).containsExactly(new Object[]{"CHANGE_NO", "EXPIRY_TIME"});
    }

    private void testColumn(@NotNull Table table, @NotNull String name, boolean isOptional, Integer jdbcType, String typeName, Integer length, Integer scale, Boolean hasDefault, Object defaultValue) {
        Column column = table.columnWithName(name);
        Assertions.assertThat((boolean)column.isOptional()).isEqualTo(isOptional);
        Assertions.assertThat((int)column.jdbcType()).isEqualTo((Object)jdbcType);
        Assertions.assertThat((String)column.typeName()).isEqualTo((Object)typeName);
        Assertions.assertThat((int)column.length()).isEqualTo((Object)length);
        Optional oScale = column.scale();
        if (oScale.isPresent()) {
            Assertions.assertThat((Integer)((Integer)oScale.get())).isEqualTo((Object)scale);
        }
        Assertions.assertThat((boolean)column.hasDefaultValue()).isEqualTo((Object)hasDefault);
        if (column.hasDefaultValue() && column.defaultValue() != null) {
            Assertions.assertThat((boolean)defaultValue.equals(column.defaultValue()));
        }
    }
}

