/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.memory;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogMinerChangeRecordEmitter;
import io.debezium.connector.oracle.logminer.LogMinerQueryBuilder;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.connector.oracle.logminer.events.DmlEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import io.debezium.connector.oracle.logminer.events.Transaction;
import io.debezium.connector.oracle.logminer.processor.AbstractLogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.TransactionCache;
import io.debezium.connector.oracle.logminer.processor.memory.MemoryTransactionCache;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryLogMinerEventProcessor
extends AbstractLogMinerEventProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryLogMinerEventProcessor.class);
    private final ChangeEventSource.ChangeEventSourceContext context;
    private final OracleConnection jdbcConnection;
    private final EventDispatcher<TableId> dispatcher;
    private final OracleOffsetContext offsetContext;
    private final OracleStreamingChangeEventSourceMetrics metrics;
    private final MemoryTransactionCache transactionCache;
    private final Map<String, Scn> recentlyCommittedTransactionsCache = new HashMap<String, Scn>();
    private final Set<Scn> schemaChangesCache = new HashSet<Scn>();
    private final Set<String> abandonedTransactionsCache = new HashSet<String>();
    private final Set<String> rollbackTransactionsCache = new HashSet<String>();
    private Scn currentOffsetScn = Scn.NULL;
    private Scn currentOffsetCommitScn = Scn.NULL;
    private Scn lastCommittedScn = Scn.NULL;
    private Scn maxCommittedScn = Scn.NULL;

    public MemoryLogMinerEventProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, EventDispatcher<TableId> dispatcher, OracleOffsetContext offsetContext, OracleDatabaseSchema schema, OracleStreamingChangeEventSourceMetrics metrics) {
        super(context, connectorConfig, schema, offsetContext, dispatcher, metrics);
        this.context = context;
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.offsetContext = offsetContext;
        this.metrics = metrics;
        this.transactionCache = new MemoryTransactionCache();
    }

    @Override
    protected TransactionCache<?> getTransactionCache() {
        return this.transactionCache;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public Scn process(Scn startScn, Scn endScn) throws SQLException, InterruptedException {
        this.counters.reset();
        try (PreparedStatement statement = this.createQueryStatement();){
            Scn scn;
            block14: {
                statement.setFetchSize(this.getConfig().getMaxQueueSize());
                statement.setFetchDirection(1000);
                statement.setString(1, startScn.toString());
                statement.setString(2, endScn.toString());
                Instant queryStart = Instant.now();
                ResultSet resultSet = statement.executeQuery();
                try {
                    this.metrics.setLastDurationOfBatchCapturing(Duration.between(queryStart, Instant.now()));
                    Instant startProcessTime = Instant.now();
                    this.processResults(resultSet);
                    Duration totalTime = Duration.between(startProcessTime, Instant.now());
                    this.metrics.setLastCapturedDmlCount(this.counters.dmlCount);
                    this.metrics.setLastDurationOfBatchCapturing(totalTime);
                    if (this.counters.dmlCount > 0 || this.counters.commitCount > 0 || this.counters.rollbackCount > 0) {
                        this.warnPotentiallyStuckScn(this.currentOffsetScn, this.currentOffsetCommitScn);
                        this.currentOffsetScn = this.offsetContext.getScn();
                        if (this.offsetContext.getCommitScn() != null) {
                            this.currentOffsetCommitScn = this.offsetContext.getCommitScn();
                        }
                    }
                    LOGGER.debug("{}.", (Object)this.counters);
                    LOGGER.debug("Processed in {} ms. Log: {}. Offset SCN: {}, Offset Commit SCN: {}, Active Transactions: {}, Sleep: {}", new Object[]{totalTime.toMillis(), this.metrics.getLagFromSourceInMilliseconds(), this.offsetContext.getScn(), this.offsetContext.getCommitScn(), this.metrics.getNumberOfActiveTransactions(), this.metrics.getMillisecondToSleepBetweenMiningQuery()});
                    this.metrics.addProcessedRows(this.counters.rows);
                    scn = this.calculateNewStartScn(endScn);
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return scn;
        }
    }

    @Override
    public void abandonTransactions(Duration retention) {
        if (!Duration.ZERO.equals(retention)) {
            Scn offsetScn = this.offsetContext.getScn();
            Optional<Scn> lastScnToAbandonTransactions = this.getLastScnToAbandon(this.jdbcConnection, offsetScn, retention);
            lastScnToAbandonTransactions.ifPresent(thresholdScn -> {
                LOGGER.warn("All transactions with SCN <= {} will be abandoned.", thresholdScn);
                Scn smallestScn = this.transactionCache.getMinimumScn();
                if (!smallestScn.isNull()) {
                    if (thresholdScn.compareTo(smallestScn) < 0) {
                        thresholdScn = smallestScn;
                    }
                    Iterator<Map.Entry<String, Transaction>> iterator = this.transactionCache.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, Transaction> entry = iterator.next();
                        if (entry.getValue().getStartScn().compareTo((Scn)thresholdScn) > 0) continue;
                        LOGGER.warn("Transaction {} is being abandoned.", (Object)entry.getKey());
                        this.abandonedTransactionsCache.add(entry.getKey());
                        iterator.remove();
                        this.metrics.addAbandonedTransactionId(entry.getKey());
                        this.metrics.setActiveTransactions(this.transactionCache.size());
                    }
                    smallestScn = this.transactionCache.getMinimumScn();
                    this.metrics.setOldestScn(smallestScn.isNull() ? Scn.valueOf(-1) : smallestScn);
                }
                this.offsetContext.setScn((Scn)thresholdScn);
            });
        }
    }

    @Override
    protected boolean isRecentlyCommitted(String transactionId) {
        return this.recentlyCommittedTransactionsCache.containsKey(transactionId);
    }

    @Override
    protected boolean isTransactionIdAllowed(String transactionId) {
        if (this.abandonedTransactionsCache.contains(transactionId)) {
            LOGGER.warn("Event for abandoned transaction {}, skipped.", (Object)transactionId);
            return false;
        }
        if (this.rollbackTransactionsCache.contains(transactionId)) {
            LOGGER.warn("Event for rolled back transaction {}, skipped.", (Object)transactionId);
            return false;
        }
        if (this.recentlyCommittedTransactionsCache.containsKey(transactionId)) {
            LOGGER.trace("Event for already committed transaction {}, skipped.", (Object)transactionId);
            return false;
        }
        return true;
    }

    @Override
    protected boolean hasSchemaChangeBeenSeen(LogMinerEventRow row) {
        return this.schemaChangesCache.contains(row.getScn());
    }

    @Override
    protected void handleCommit(LogMinerEventRow row) throws InterruptedException {
        String transactionId = row.getTransactionId();
        if (this.recentlyCommittedTransactionsCache.containsKey(transactionId)) {
            return;
        }
        Transaction transaction = this.transactionCache.remove(transactionId);
        if (transaction == null) {
            LOGGER.trace("Transaction {} not found.", (Object)transactionId);
            return;
        }
        Scn smallestScn = this.transactionCache.getMinimumScn();
        this.metrics.setOldestScn(smallestScn.isNull() ? Scn.valueOf(-1) : smallestScn);
        this.abandonedTransactionsCache.remove(transactionId);
        Scn commitScn = row.getScn();
        Scn offsetCommitScn = this.offsetContext.getCommitScn();
        if (offsetCommitScn != null && offsetCommitScn.compareTo(commitScn) > 0 || this.lastCommittedScn.compareTo(commitScn) > 0) {
            LOGGER.debug("Transaction {} has already been processed. Commit SCN in offset is {} while commit SCN of transaction is {} and last seen committed SCN is {}.", new Object[]{transactionId, offsetCommitScn, commitScn, this.lastCommittedScn});
            this.metrics.setActiveTransactions(this.transactionCache.size());
            return;
        }
        ++this.counters.commitCount;
        Instant start = Instant.now();
        this.getReconciliation().reconcile(transaction);
        int numEvents = transaction.getEvents().size();
        LOGGER.trace("Commit: (smallest SCN {}) {}", (Object)smallestScn, (Object)row);
        LOGGER.trace("Transaction {} has {} events", (Object)transactionId, (Object)numEvents);
        for (LogMinerEvent event : transaction.getEvents()) {
            if (!this.context.isRunning()) {
                return;
            }
            if (smallestScn.isNull() || commitScn.compareTo(smallestScn) < 0) {
                this.offsetContext.setScn(event.getScn());
                this.metrics.setOldestScn(event.getScn());
            }
            this.offsetContext.setTransactionId(transactionId);
            this.offsetContext.setSourceTime(event.getChangeTime());
            this.offsetContext.setTableId(event.getTableId());
            if (--numEvents == 0) {
                this.offsetContext.setCommitScn(commitScn);
            }
            DmlEvent dmlEvent = (DmlEvent)event;
            this.dispatcher.dispatchDataChangeEvent((DataCollectionId)event.getTableId(), (ChangeRecordEmitter)new LogMinerChangeRecordEmitter(this.offsetContext, dmlEvent.getEventType(), dmlEvent.getDmlEntry().getOldValues(), dmlEvent.getDmlEntry().getNewValues(), this.getSchema().tableFor(event.getTableId()), Clock.system()));
        }
        this.lastCommittedScn = Scn.valueOf(commitScn.longValue());
        if (!transaction.getEvents().isEmpty()) {
            this.dispatcher.dispatchTransactionCommittedEvent((OffsetContext)this.offsetContext);
        } else {
            this.dispatcher.dispatchHeartbeatEvent((OffsetContext)this.offsetContext);
        }
        this.metrics.calculateLagMetrics(row.getChangeTime());
        if (this.lastCommittedScn.compareTo(this.maxCommittedScn) > 0) {
            this.maxCommittedScn = this.lastCommittedScn;
        }
        if (this.getConfig().isLobEnabled()) {
            this.recentlyCommittedTransactionsCache.put(transactionId, commitScn);
        }
        this.metrics.incrementCommittedTransactions();
        this.metrics.setActiveTransactions(this.transactionCache.size());
        this.metrics.incrementCommittedDmlCount(transaction.getEvents().size());
        this.metrics.setCommittedScn(commitScn);
        this.metrics.setOffsetScn(this.offsetContext.getScn());
        this.metrics.setLastCommitDuration(Duration.between(start, Instant.now()));
    }

    @Override
    protected void handleRollback(LogMinerEventRow row) {
        Transaction transaction = this.transactionCache.get(row.getTransactionId());
        if (transaction != null) {
            this.transactionCache.remove(row.getTransactionId());
            this.abandonedTransactionsCache.remove(row.getTransactionId());
            this.rollbackTransactionsCache.add(row.getTransactionId());
            this.metrics.setActiveTransactions(this.transactionCache.size());
            this.metrics.incrementRolledBackTransactions();
            this.metrics.addRolledBackTransactionId(row.getTransactionId());
            ++this.counters.rollbackCount;
        }
    }

    @Override
    protected void handleSchemaChange(LogMinerEventRow row) throws InterruptedException {
        super.handleSchemaChange(row);
        if (row.getTableName() != null) {
            this.schemaChangesCache.add(row.getScn());
        }
    }

    private PreparedStatement createQueryStatement() throws SQLException {
        String query = LogMinerQueryBuilder.build(this.getConfig());
        return this.jdbcConnection.connection().prepareStatement(query, 1003, 1007, 1);
    }

    private Scn calculateNewStartScn(Scn endScn) throws InterruptedException {
        if (this.getConfig().isLobEnabled()) {
            if (this.transactionCache.isEmpty() && !this.maxCommittedScn.isNull()) {
                this.offsetContext.setScn(this.maxCommittedScn);
                this.dispatcher.dispatchHeartbeatEvent((OffsetContext)this.offsetContext);
            } else {
                Scn minStartScn = this.transactionCache.getMinimumScn();
                if (!minStartScn.isNull()) {
                    this.recentlyCommittedTransactionsCache.entrySet().removeIf(entry -> ((Scn)entry.getValue()).compareTo(minStartScn) < 0);
                    this.schemaChangesCache.removeIf(scn -> scn.compareTo(minStartScn) < 0);
                    this.offsetContext.setScn(minStartScn.subtract(Scn.valueOf(1)));
                    this.dispatcher.dispatchHeartbeatEvent((OffsetContext)this.offsetContext);
                }
            }
            return this.offsetContext.getScn();
        }
        if (this.transactionCache.isEmpty()) {
            this.offsetContext.setScn(endScn);
            this.dispatcher.dispatchHeartbeatEvent((OffsetContext)this.offsetContext);
        }
        return endScn;
    }

    protected Optional<Scn> getLastScnToAbandon(OracleConnection connection, Scn offsetScn, Duration retention) {
        try {
            Float diffInDays = (Float)connection.singleOptionalValue(SqlUtils.diffInDaysQuery(offsetScn), rs -> Float.valueOf(rs.getFloat(1)));
            if (diffInDays != null && diffInDays.floatValue() * 24.0f > (float)retention.toHours()) {
                return Optional.of(offsetScn);
            }
            return Optional.empty();
        }
        catch (SQLException e) {
            LOGGER.error("Cannot calculate days difference for transaction abandonment", (Throwable)e);
            this.metrics.incrementErrorCount();
            return Optional.of(offsetScn);
        }
    }
}

