/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerDatabaseStateWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerDatabaseStateWriter.class);

    public static void write(OracleConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configured redo logs are:");
            try {
                LogMinerDatabaseStateWriter.logQueryResults(connection, "SELECT * FROM V$LOGFILE");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain redo log table entries", (Throwable)e);
            }
            LOGGER.debug("Archive logs for last 48 hours:");
            try {
                LogMinerDatabaseStateWriter.logQueryResults(connection, "SELECT * FROM V$ARCHIVED_LOG WHERE FIST_TIME >= SYSDATE - 2");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain archive log table entries", (Throwable)e);
            }
            LOGGER.debug("Available logs are:");
            try {
                LogMinerDatabaseStateWriter.logQueryResults(connection, "SELECT * FROM V$LOG");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain log table entries", (Throwable)e);
            }
            LOGGER.debug("Log history last 24 hours:");
            try {
                LogMinerDatabaseStateWriter.logQueryResults(connection, "SELECT * FROM V$LOG_HISTORY WHERE FIRST_TIME >= SYSDATE - 1");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain log history", (Throwable)e);
            }
            LOGGER.debug("Log entries registered with LogMiner are:");
            try {
                LogMinerDatabaseStateWriter.logQueryResults(connection, "SELECT * FROM V$LOGMNR_LOGS");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain registered logs with LogMiner", (Throwable)e);
            }
            LOGGER.debug("Log mining session parameters are:");
            try {
                LogMinerDatabaseStateWriter.logQueryResults(connection, "SELECT * FROM V$LOGMNR_PARAMETERS");
            }
            catch (SQLException e) {
                LOGGER.debug("Failed to obtain log mining session parameters", (Throwable)e);
            }
        }
    }

    private static void logQueryResults(OracleConnection connection, String query) throws SQLException {
        connection.query(query, rs -> {
            int columns = rs.getMetaData().getColumnCount();
            ArrayList<String> columnNames = new ArrayList<String>();
            for (int index = 1; index <= columns; ++index) {
                columnNames.add(rs.getMetaData().getColumnName(index));
            }
            LOGGER.debug("{}", columnNames);
            while (rs.next()) {
                ArrayList<Object> columnValues = new ArrayList<Object>();
                for (int index = 1; index <= columns; ++index) {
                    columnValues.add(rs.getObject(index));
                }
                LOGGER.debug("{}", columnValues);
            }
        });
    }
}

