/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogMinerDatabaseStateWriter;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.connector.oracle.logminer.logwriter.CommitLogWriterFlushStrategy;
import io.debezium.connector.oracle.logminer.logwriter.LogWriterFlushStrategy;
import io.debezium.connector.oracle.logminer.logwriter.RacCommitLogWriterFlushStrategy;
import io.debezium.connector.oracle.logminer.processor.LogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.infinispan.InfinispanLogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.memory.MemoryLogMinerEventProcessor;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerStreamingChangeEventSource
implements StreamingChangeEventSource<OraclePartition, OracleOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerStreamingChangeEventSource.class);
    private static final String ALL_COLUMN_LOGGING = "ALL COLUMN LOGGING";
    private final OracleConnection jdbcConnection;
    private final EventDispatcher<TableId> dispatcher;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final JdbcConfiguration jdbcConfiguration;
    private final OracleConnectorConfig.LogMiningStrategy strategy;
    private final ErrorHandler errorHandler;
    private final boolean isContinuousMining;
    private final OracleStreamingChangeEventSourceMetrics streamingMetrics;
    private final OracleConnectorConfig connectorConfig;
    private final Duration archiveLogRetention;
    private final boolean archiveLogOnlyMode;
    private final String archiveDestinationName;
    private Scn startScn;
    private Scn endScn;
    private List<BigInteger> currentRedoLogSequences;

    public LogMinerStreamingChangeEventSource(OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, EventDispatcher<TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, Configuration jdbcConfig, OracleStreamingChangeEventSourceMetrics streamingMetrics) {
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.schema = schema;
        this.connectorConfig = connectorConfig;
        this.strategy = connectorConfig.getLogMiningStrategy();
        this.isContinuousMining = connectorConfig.isContinuousMining();
        this.errorHandler = errorHandler;
        this.streamingMetrics = streamingMetrics;
        this.jdbcConfiguration = JdbcConfiguration.adapt((Configuration)jdbcConfig);
        this.archiveLogRetention = connectorConfig.getLogMiningArchiveLogRetention();
        this.archiveLogOnlyMode = connectorConfig.isArchiveLogOnlyMode();
        this.archiveDestinationName = connectorConfig.getLogMiningArchiveDestinationName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ChangeEventSource.ChangeEventSourceContext context, OraclePartition partition, OracleOffsetContext offsetContext) {
        try {
            this.startScn = offsetContext.getScn();
            try (LogWriterFlushStrategy flushStrategy = this.resolveFlushStrategy();){
                if (!this.isContinuousMining && this.startScn.compareTo(this.getFirstScnInLogs(this.jdbcConnection)) < 0) {
                    throw new DebeziumException("Online REDO LOG files or archive log files do not contain the offset scn " + this.startScn + ".  Please perform a new snapshot.");
                }
                this.setNlsSessionParameters(this.jdbcConnection);
                this.checkSupplementalLogging(this.jdbcConnection, this.connectorConfig.getPdbName(), this.schema);
                try (LogMinerEventProcessor processor = this.createProcessor(context, offsetContext);){
                    this.currentRedoLogSequences = this.getCurrentRedoLogSequences();
                    this.initializeRedoLogsForMining(this.jdbcConnection, false, this.startScn);
                    while (context.isRunning()) {
                        this.streamingMetrics.calculateTimeDifference(this.getDatabaseSystemTime(this.jdbcConnection));
                        Instant start = Instant.now();
                        this.endScn = this.calculateEndScn(this.jdbcConnection, this.startScn, this.endScn);
                        flushStrategy.flush(this.jdbcConnection.getCurrentScn());
                        if (this.hasLogSwitchOccurred()) {
                            this.endMiningSession(this.jdbcConnection, offsetContext);
                            this.initializeRedoLogsForMining(this.jdbcConnection, true, this.startScn);
                            processor.abandonTransactions(this.connectorConfig.getLogMiningTransactionRetention());
                            this.currentRedoLogSequences = this.getCurrentRedoLogSequences();
                        }
                        if (!context.isRunning()) continue;
                        this.startMiningSession(this.jdbcConnection, this.startScn, this.endScn);
                        this.startScn = processor.process(this.startScn, this.endScn);
                        this.captureSessionMemoryStatistics(this.jdbcConnection);
                        this.streamingMetrics.setCurrentBatchProcessingTime(Duration.between(start, Instant.now()));
                        this.pauseBetweenMiningSessions();
                    }
                }
            }
        }
        catch (Throwable t) {
            LogMinerHelper.logError(this.streamingMetrics, "Mining session stopped due to the {}", t);
            this.errorHandler.setProducerThrowable(t);
        }
        finally {
            LOGGER.info("startScn={}, endScn={}", (Object)this.startScn, (Object)this.endScn);
            LOGGER.info("Streaming metrics dump: {}", (Object)this.streamingMetrics.toString());
            LOGGER.info("Offsets: {}", (Object)offsetContext);
        }
    }

    private void captureSessionMemoryStatistics(OracleConnection connection) throws SQLException {
        long sessionUserGlobalAreaMemory = connection.getSessionStatisticByName("session uga memory");
        long sessionUserGlobalAreaMaxMemory = connection.getSessionStatisticByName("session uga memory max");
        this.streamingMetrics.setUserGlobalAreaMemory(sessionUserGlobalAreaMemory, sessionUserGlobalAreaMaxMemory);
        long sessionProcessGlobalAreaMemory = connection.getSessionStatisticByName("session pga memory");
        long sessionProcessGlobalAreaMaxMemory = connection.getSessionStatisticByName("session pga memory max");
        this.streamingMetrics.setProcessGlobalAreaMemory(sessionProcessGlobalAreaMemory, sessionProcessGlobalAreaMaxMemory);
        DecimalFormat format = new DecimalFormat("#.##");
        LOGGER.info("Oracle Session UGA {}MB (max = {}MB), PGA {}MB (max = {}MB)", new Object[]{format.format((float)sessionUserGlobalAreaMemory / 1024.0f / 1024.0f), format.format((float)sessionUserGlobalAreaMaxMemory / 1024.0f / 1024.0f), format.format((float)sessionProcessGlobalAreaMemory / 1024.0f / 1024.0f), format.format((float)sessionProcessGlobalAreaMaxMemory / 1024.0f / 1024.0f)});
    }

    private LogMinerEventProcessor createProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleOffsetContext offsetContext) {
        if (OracleConnectorConfig.LogMiningBufferType.INFINISPAN.equals((Object)this.connectorConfig.getLogMiningBufferType())) {
            return new InfinispanLogMinerEventProcessor(context, this.connectorConfig, this.jdbcConnection, this.dispatcher, offsetContext, this.schema, this.streamingMetrics);
        }
        return new MemoryLogMinerEventProcessor(context, this.connectorConfig, this.jdbcConnection, this.dispatcher, offsetContext, this.schema, this.streamingMetrics);
    }

    private Scn getFirstScnInLogs(OracleConnection connection) throws SQLException {
        String oldestScn = (String)connection.singleOptionalValue(SqlUtils.oldestFirstChangeQuery(this.archiveLogRetention, this.archiveDestinationName), rs -> rs.getString(1));
        if (oldestScn == null) {
            throw new DebeziumException("Failed to calculate oldest SCN available in logs");
        }
        LOGGER.trace("Oldest SCN in logs is '{}'", (Object)oldestScn);
        return Scn.valueOf(oldestScn);
    }

    private void initializeRedoLogsForMining(OracleConnection connection, boolean postEndMiningSession, Scn startScn) throws SQLException {
        if (!postEndMiningSession) {
            if (OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO.equals((Object)this.strategy)) {
                this.buildDataDictionary(connection);
            }
            if (!this.isContinuousMining) {
                LogMinerHelper.setLogFilesForMining(connection, startScn, this.archiveLogRetention, this.archiveLogOnlyMode, this.archiveDestinationName);
            }
        } else if (!this.isContinuousMining) {
            if (OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO.equals((Object)this.strategy)) {
                this.buildDataDictionary(connection);
            }
            LogMinerHelper.setLogFilesForMining(connection, startScn, this.archiveLogRetention, this.archiveLogOnlyMode, this.archiveDestinationName);
        }
    }

    private void buildDataDictionary(OracleConnection connection) throws SQLException {
        LOGGER.trace("Building data dictionary");
        connection.executeWithoutCommitting(new String[]{"BEGIN DBMS_LOGMNR_D.BUILD (options => DBMS_LOGMNR_D.STORE_IN_REDO_LOGS); END;"});
    }

    private boolean hasLogSwitchOccurred() throws SQLException {
        List<BigInteger> newSequences = this.getCurrentRedoLogSequences();
        if (!newSequences.equals(this.currentRedoLogSequences)) {
            LOGGER.debug("Current log sequence(s) is now {}, was {}", newSequences, this.currentRedoLogSequences);
            this.currentRedoLogSequences = newSequences;
            Map logStatuses = (Map)this.jdbcConnection.queryAndMap(SqlUtils.redoLogStatusQuery(), rs -> {
                LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
                while (rs.next()) {
                    results.put(rs.getString(1), rs.getString(2));
                }
                return results;
            });
            int logSwitchCount = (Integer)this.jdbcConnection.queryAndMap(SqlUtils.switchHistoryQuery(this.archiveDestinationName), rs -> {
                if (rs.next()) {
                    return rs.getInt(2);
                }
                return 0;
            });
            Set<String> fileNames = this.getCurrentRedoLogFiles(this.jdbcConnection);
            this.streamingMetrics.setRedoLogStatus(logStatuses);
            this.streamingMetrics.setSwitchCount(logSwitchCount);
            this.streamingMetrics.setCurrentLogFileName(fileNames);
            return true;
        }
        return false;
    }

    private Set<String> getCurrentRedoLogFiles(OracleConnection connection) throws SQLException {
        HashSet<String> fileNames = new HashSet<String>();
        connection.query(SqlUtils.currentRedoNameQuery(), rs -> {
            while (rs.next()) {
                fileNames.add(rs.getString(1));
            }
        });
        LOGGER.trace("Current redo log filenames: {}", fileNames);
        return fileNames;
    }

    private List<BigInteger> getCurrentRedoLogSequences() throws SQLException {
        return (List)this.jdbcConnection.queryAndMap(SqlUtils.currentRedoLogSequenceQuery(), rs -> {
            ArrayList<BigInteger> sequences = new ArrayList<BigInteger>();
            while (rs.next()) {
                sequences.add(new BigInteger(rs.getString(1)));
            }
            return sequences;
        });
    }

    private void pauseBetweenMiningSessions() throws InterruptedException {
        Duration period = Duration.ofMillis(this.streamingMetrics.getMillisecondToSleepBetweenMiningQuery());
        Metronome.sleeper((Duration)period, (Clock)this.clock).pause();
    }

    private void setNlsSessionParameters(OracleConnection connection) throws SQLException {
        String NLS_SESSION_PARAMETERS = "ALTER SESSION SET   NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'  NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF'  NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM'  NLS_NUMERIC_CHARACTERS = '.,'";
        connection.executeWithoutCommitting(new String[]{"ALTER SESSION SET   NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'  NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF'  NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM'  NLS_NUMERIC_CHARACTERS = '.,'"});
        connection.executeWithoutCommitting(new String[]{"ALTER SESSION SET TIME_ZONE = '00:00'"});
    }

    private OffsetDateTime getDatabaseSystemTime(OracleConnection connection) throws SQLException {
        return (OffsetDateTime)connection.singleOptionalValue("SELECT SYSTIMESTAMP FROM DUAL", rs -> rs.getObject(1, OffsetDateTime.class));
    }

    public void startMiningSession(OracleConnection connection, Scn startScn, Scn endScn) throws SQLException {
        LOGGER.trace("Starting mining session startScn={}, endScn={}, strategy={}, continuous={}", new Object[]{startScn, endScn, this.strategy, this.isContinuousMining});
        try {
            Instant start = Instant.now();
            connection.executeWithoutCommitting(new String[]{SqlUtils.startLogMinerStatement(startScn, endScn, this.strategy, this.isContinuousMining)});
            this.streamingMetrics.addCurrentMiningSessionStart(Duration.between(start, Instant.now()));
        }
        catch (SQLException e) {
            LogMinerDatabaseStateWriter.write(connection);
            throw e;
        }
    }

    public void endMiningSession(OracleConnection connection, OracleOffsetContext offsetContext) throws SQLException {
        try {
            LOGGER.trace("Ending log mining startScn={}, endScn={}, offsetContext.getScn={}, strategy={}, continuous={}", new Object[]{this.startScn, this.endScn, offsetContext.getScn(), this.strategy, this.isContinuousMining});
            connection.executeWithoutCommitting(new String[]{"BEGIN SYS.DBMS_LOGMNR.END_LOGMNR(); END;"});
        }
        catch (SQLException e) {
            if (e.getMessage().toUpperCase().contains("ORA-01307")) {
                LOGGER.info("LogMiner mining session is already closed.");
                return;
            }
            throw e;
        }
    }

    private Scn calculateEndScn(OracleConnection connection, Scn startScn, Scn prevEndScn) throws SQLException {
        Scn currentScn = connection.getCurrentScn();
        this.streamingMetrics.setCurrentScn(currentScn);
        Scn topScnToMine = startScn.add(Scn.valueOf(this.streamingMetrics.getBatchSize()));
        boolean topMiningScnInFarFuture = false;
        Scn defaultBatchScn = Scn.valueOf(this.connectorConfig.getLogMiningBatchSizeDefault());
        if (topScnToMine.subtract(currentScn).compareTo(defaultBatchScn) > 0) {
            this.streamingMetrics.changeBatchSize(false, this.connectorConfig.isLobEnabled());
            topMiningScnInFarFuture = true;
        }
        if (currentScn.subtract(topScnToMine).compareTo(defaultBatchScn) > 0) {
            this.streamingMetrics.changeBatchSize(true, this.connectorConfig.isLobEnabled());
        }
        if (currentScn.compareTo(topScnToMine) < 0) {
            if (!topMiningScnInFarFuture) {
                this.streamingMetrics.changeSleepingTime(true);
            }
            LOGGER.debug("Using current SCN {} as end SCN.", (Object)currentScn);
            return currentScn;
        }
        if (prevEndScn != null && topScnToMine.compareTo(prevEndScn) <= 0) {
            LOGGER.debug("Max batch size too small, using current SCN {} as end SCN.", (Object)currentScn);
            return currentScn;
        }
        this.streamingMetrics.changeSleepingTime(false);
        if (topScnToMine.compareTo(startScn) < 0) {
            LOGGER.debug("Top SCN calculation resulted in end before start SCN, using current SCN {} as end SCN.", (Object)currentScn);
            return currentScn;
        }
        LOGGER.debug("Using Top SCN calculation {} as end SCN.", (Object)topScnToMine);
        return topScnToMine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSupplementalLogging(OracleConnection connection, String pdbName, OracleDatabaseSchema schema) throws SQLException {
        try {
            if (pdbName != null) {
                connection.setSessionToPdb(pdbName);
            }
            if (!this.isDatabaseAllSupplementalLoggingEnabled(connection)) {
                if (!this.isDatabaseMinSupplementalLoggingEnabled(connection)) {
                    throw new DebeziumException("Supplemental logging not properly configured. Use: ALTER DATABASE ADD SUPPLEMENTAL LOG DATA");
                }
                for (TableId tableId : schema.getTables().tableIds()) {
                    if (this.isTableAllColumnsSupplementalLoggingEnabled(connection, tableId)) continue;
                    throw new DebeziumException("Supplemental logging not properly configured for table " + tableId + ". Use: ALTER TABLE " + tableId.schema() + "." + tableId.table() + " ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS");
                }
            }
        }
        finally {
            if (pdbName != null) {
                connection.resetSessionToCdb();
            }
        }
    }

    private boolean isDatabaseAllSupplementalLoggingEnabled(OracleConnection connection) throws SQLException {
        return (Boolean)connection.queryAndMap(SqlUtils.databaseSupplementalLoggingAllCheckQuery(), rs -> {
            while (rs.next()) {
                if (!"YES".equalsIgnoreCase(rs.getString(2))) continue;
                return true;
            }
            return false;
        });
    }

    private boolean isDatabaseMinSupplementalLoggingEnabled(OracleConnection connection) throws SQLException {
        return (Boolean)connection.queryAndMap(SqlUtils.databaseSupplementalLoggingMinCheckQuery(), rs -> {
            while (rs.next()) {
                if (!"YES".equalsIgnoreCase(rs.getString(2))) continue;
                return true;
            }
            return false;
        });
    }

    private boolean isTableAllColumnsSupplementalLoggingEnabled(OracleConnection connection, TableId tableId) throws SQLException {
        return (Boolean)connection.queryAndMap(SqlUtils.tableSupplementalLoggingCheckQuery(tableId), rs -> {
            while (rs.next()) {
                if (!ALL_COLUMN_LOGGING.equals(rs.getString(2))) continue;
                return true;
            }
            return false;
        });
    }

    private LogWriterFlushStrategy resolveFlushStrategy() {
        if (this.connectorConfig.isRacSystem().booleanValue()) {
            return new RacCommitLogWriterFlushStrategy(this.connectorConfig, this.jdbcConfiguration, this.streamingMetrics);
        }
        return new CommitLogWriterFlushStrategy(this.jdbcConnection);
    }

    public void commitOffset(Map<String, ?> offset) {
    }
}

