/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseVersion;
import io.debezium.connector.oracle.Scn;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnection
extends JdbcConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleConnection.class);
    private static final int ORACLE_UNSET_SCALE = -127;
    private static final Pattern SYS_NC_PATTERN = Pattern.compile("^SYS_NC(?:_OID|_ROWINFO|[0-9][0-9][0-9][0-9][0-9])\\$$");
    private static final Field URL = Field.create((String)"url", (String)"Raw JDBC url");
    private final OracleDatabaseVersion databaseVersion = this.resolveOracleDatabaseVersion();

    public OracleConnection(Configuration config, Supplier<ClassLoader> classLoaderSupplier) {
        super(config, OracleConnection.resolveConnectionFactory(config), classLoaderSupplier);
        LOGGER.info("Database Version: {}", (Object)this.databaseVersion.getBanner());
    }

    public void setSessionToPdb(String pdbName) {
        Statement statement = null;
        try {
            statement = this.connection().createStatement();
            statement.execute("alter session set container=" + pdbName);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.error("Couldn't close statement", (Throwable)e);
                }
            }
        }
    }

    public void resetSessionToCdb() {
        Statement statement = null;
        try {
            statement = this.connection().createStatement();
            statement.execute("alter session set container=cdb$root");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.error("Couldn't close statement", (Throwable)e);
                }
            }
        }
    }

    public OracleDatabaseVersion getOracleVersion() {
        return this.databaseVersion;
    }

    private OracleDatabaseVersion resolveOracleDatabaseVersion() {
        String versionStr;
        try {
            try {
                versionStr = (String)this.queryAndMap("SELECT BANNER_FULL FROM V$VERSION WHERE BANNER_FULL LIKE 'Oracle Database%'", rs -> {
                    if (rs.next()) {
                        return rs.getString(1);
                    }
                    return null;
                });
            }
            catch (SQLException e) {
                if (e.getMessage().contains("ORA-00904: \"BANNER_FULL\"")) {
                    LOGGER.debug("BANNER_FULL column not in V$VERSION, using BANNER column as fallback");
                    versionStr = null;
                }
                throw e;
            }
            if (versionStr == null) {
                versionStr = (String)this.queryAndMap("SELECT BANNER FROM V$VERSION WHERE BANNER LIKE 'Oracle Database%'", rs -> {
                    if (rs.next()) {
                        return rs.getString(1);
                    }
                    return null;
                });
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to resolve Oracle database version", e);
        }
        if (versionStr == null) {
            throw new RuntimeException("Failed to resolve Oracle database version");
        }
        return OracleDatabaseVersion.parse(versionStr);
    }

    public Set<TableId> readTableNames(String databaseCatalog, String schemaNamePattern, String tableNamePattern, String[] tableTypes) throws SQLException {
        Set tableIds = super.readTableNames(null, schemaNamePattern, tableNamePattern, tableTypes);
        return tableIds.stream().map(t -> new TableId(databaseCatalog, t.schema(), t.table())).collect(Collectors.toSet());
    }

    protected Set<TableId> getAllTableIds(String catalogName) throws SQLException {
        String query = "select owner, table_name from all_tables where table_name NOT LIKE 'MDRT_%' and table_name NOT LIKE 'MDRS_%' and table_name NOT LIKE 'MDXT_%' and (table_name NOT LIKE 'SYS_IOT_OVER_%' and IOT_NAME IS NULL) ";
        HashSet<TableId> tableIds = new HashSet<TableId>();
        this.query("select owner, table_name from all_tables where table_name NOT LIKE 'MDRT_%' and table_name NOT LIKE 'MDRS_%' and table_name NOT LIKE 'MDXT_%' and (table_name NOT LIKE 'SYS_IOT_OVER_%' and IOT_NAME IS NULL) ", rs -> {
            while (rs.next()) {
                tableIds.add(new TableId(catalogName, rs.getString(1), rs.getString(2)));
            }
            LOGGER.trace("TableIds are: {}", (Object)tableIds);
        });
        return tableIds;
    }

    private ResultSet getTableColumnsInfo(String schemaNamePattern, String tableName) throws SQLException {
        String columnQuery = "select column_name, data_type, data_length, data_precision, data_scale, default_length, density, char_length from all_tab_columns where owner like '" + schemaNamePattern + "' and table_name='" + tableName + "'";
        PreparedStatement statement = this.connection().prepareStatement(columnQuery);
        return statement.executeQuery();
    }

    public void readSchemaForCapturedTables(Tables tables, String databaseCatalog, String schemaNamePattern, Tables.ColumnNameFilter columnFilter, boolean removeTablesNotFoundInJdbc, Set<TableId> capturedTables) throws SQLException {
        HashSet tableIdsBefore = new HashSet(tables.tableIds());
        DatabaseMetaData metadata = this.connection().getMetaData();
        HashMap columnsByTable = new HashMap();
        for (TableId tableId : capturedTables) {
            ResultSet columnMetadata = metadata.getColumns(databaseCatalog, schemaNamePattern, tableId.table(), null);
            try {
                while (columnMetadata.next()) {
                    this.readTableColumn(columnMetadata, tableId, columnFilter).ifPresent(column -> columnsByTable.computeIfAbsent(tableId, t -> new ArrayList()).add(column.create()));
                }
            }
            finally {
                if (columnMetadata == null) continue;
                columnMetadata.close();
            }
        }
        for (Map.Entry entry : columnsByTable.entrySet()) {
            List pkColumnNames = this.readPrimaryKeyNames(metadata, (TableId)entry.getKey());
            List columns = (List)entry.getValue();
            Collections.sort(columns);
            tables.overwriteTable((TableId)entry.getKey(), columns, pkColumnNames, null);
        }
        if (removeTablesNotFoundInJdbc) {
            tableIdsBefore.removeAll(columnsByTable.keySet());
            tableIdsBefore.forEach(arg_0 -> ((Tables)tables).removeTable(arg_0));
        }
        for (TableId tableId : capturedTables) {
            this.overrideOracleSpecificColumnTypes(tables, tableId, tableId);
        }
    }

    public void readSchema(Tables tables, String databaseCatalog, String schemaNamePattern, Tables.TableFilter tableFilter, Tables.ColumnNameFilter columnFilter, boolean removeTablesNotFoundInJdbc) throws SQLException {
        super.readSchema(tables, null, schemaNamePattern, tableFilter, columnFilter, removeTablesNotFoundInJdbc);
        Set tableIds = tables.tableIds().stream().filter(x -> schemaNamePattern.equals(x.schema())).collect(Collectors.toSet());
        for (TableId tableId : tableIds) {
            TableId tableIdWithCatalog = new TableId(databaseCatalog, tableId.schema(), tableId.table());
            if (tableFilter.isIncluded(tableIdWithCatalog)) {
                this.overrideOracleSpecificColumnTypes(tables, tableId, tableIdWithCatalog);
            }
            tables.removeTable(tableId);
        }
    }

    public List<String> readTableUniqueIndices(DatabaseMetaData metadata, TableId id) throws SQLException {
        return super.readTableUniqueIndices(metadata, id.toDoubleQuoted());
    }

    protected boolean isTableUniqueIndexIncluded(String indexName, String columnName) {
        if (columnName != null) {
            return !SYS_NC_PATTERN.matcher(columnName).matches();
        }
        return false;
    }

    private void overrideOracleSpecificColumnTypes(Tables tables, TableId tableId, TableId tableIdWithCatalog) {
        TableEditor editor = tables.editTable(tableId);
        editor.tableId(tableIdWithCatalog);
        ArrayList columnNames = new ArrayList(editor.columnNames());
        for (String columnName : columnNames) {
            Column column = editor.columnWithName(columnName);
            if (column.jdbcType() == 93) {
                editor.addColumn(column.edit().length(column.scale().orElse(-1).intValue()).scale(null).create());
                continue;
            }
            if (column.jdbcType() != 2) continue;
            column.scale().filter(s -> s == -127).ifPresent(s -> editor.addColumn(column.edit().scale(null).create()));
        }
        tables.overwriteTable(editor.create());
    }

    public Scn getCurrentScn() throws SQLException {
        return (Scn)this.queryAndMap("SELECT CURRENT_SCN FROM V$DATABASE", rs -> {
            if (rs.next()) {
                return Scn.valueOf(rs.getString(1));
            }
            throw new IllegalStateException("Could not get SCN");
        });
    }

    public String getTableMetadataDdl(TableId tableId) throws SQLException {
        String string;
        try {
            this.executeWithoutCommitting(new String[]{"begin dbms_metadata.set_transform_param(DBMS_METADATA.SESSION_TRANSFORM, 'STORAGE', false); end;"});
            this.executeWithoutCommitting(new String[]{"begin dbms_metadata.set_transform_param(DBMS_METADATA.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', false); end;"});
            this.executeWithoutCommitting(new String[]{"begin dbms_metadata.set_transform_param(DBMS_METADATA.SESSION_TRANSFORM, 'SQLTERMINATOR', true); end;"});
            string = (String)this.queryAndMap("SELECT dbms_metadata.get_ddl('TABLE','" + tableId.table() + "','" + tableId.schema() + "') FROM DUAL", rs -> {
                if (!rs.next()) {
                    throw new DebeziumException("Could not get DDL metadata for table: " + tableId);
                }
                Object res = rs.getObject(1);
                return ((Clob)res).getSubString(1L, (int)((Clob)res).length());
            });
        }
        catch (Throwable throwable) {
            this.executeWithoutCommitting(new String[]{"begin dbms_metadata.set_transform_param(DBMS_METADATA.SESSION_TRANSFORM, 'DEFAULT'); end;"});
            throw throwable;
        }
        this.executeWithoutCommitting(new String[]{"begin dbms_metadata.set_transform_param(DBMS_METADATA.SESSION_TRANSFORM, 'DEFAULT'); end;"});
        return string;
    }

    public static String connectionString(Configuration config) {
        return config.getString(URL) != null ? config.getString(URL) : OracleConnectorConfig.ConnectorAdapter.parse(config.getString("connection.adapter")).getConnectionUrl();
    }

    private static JdbcConnection.ConnectionFactory resolveConnectionFactory(Configuration config) {
        return JdbcConnection.patternBasedFactory((String)OracleConnection.connectionString(config), (Field[])new Field[0]);
    }
}

