/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.config.Configuration;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.TransactionalBuffer;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntryImpl;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class TransactionalBufferTest {
    private static final String SERVER_NAME = "serverX";
    private static final String TRANSACTION_ID = "transaction";
    private static final String OTHER_TRANSACTION_ID = "other_transaction";
    private static final String MESSAGE = "OK";
    private static final Scn SCN_ONE;
    private static final Scn SCN;
    private static final Scn OTHER_SCN;
    private static final Timestamp TIMESTAMP;
    private static final TableId TABLE_ID;
    private static final String ROW_ID = "AAABCD871DFAA";
    private static final String OTHER_ROW_ID = "BAABCD871DFAA";
    private static final LogMinerDmlEntry DML_ENTRY;
    private static final Configuration config;
    private static final OracleConnectorConfig connectorConfig;
    private static OracleOffsetContext offsetContext;
    private OracleTaskContext taskContext;
    private ErrorHandler errorHandler;
    private TransactionalBuffer transactionalBuffer;
    private OracleStreamingChangeEventSourceMetrics streamingMetrics;
    private OracleDatabaseSchema schema;
    private Clock clock;
    private EventDispatcher<TableId> dispatcher;
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    @Before
    public void before() {
        ChangeEventQueue queue = new ChangeEventQueue.Builder().pollInterval(Duration.of(8192L, ChronoUnit.MILLIS)).maxBatchSize(2048).maxQueueSize(8192).build();
        this.errorHandler = new ErrorHandler(OracleConnector.class, SERVER_NAME, queue);
        this.taskContext = (OracleTaskContext)Mockito.mock(OracleTaskContext.class);
        Mockito.when((Object)this.taskContext.getConnectorName()).thenReturn((Object)"connector name");
        Mockito.when((Object)this.taskContext.getConnectorType()).thenReturn((Object)"connector type");
        this.dispatcher = (EventDispatcher)Mockito.mock(EventDispatcher.class);
        this.schema = (OracleDatabaseSchema)Mockito.mock(OracleDatabaseSchema.class);
        this.clock = (Clock)Mockito.mock(Clock.class);
        this.streamingMetrics = new OracleStreamingChangeEventSourceMetrics((CdcSourceTaskContext)this.taskContext, (ChangeEventQueueMetrics)queue, null, connectorConfig);
        this.transactionalBuffer = new TransactionalBuffer(connectorConfig, this.schema, this.clock, this.errorHandler, this.streamingMetrics);
    }

    @After
    public void after() throws InterruptedException {
        this.transactionalBuffer.close();
    }

    @Test
    public void testIsEmpty() {
        Assertions.assertThat((boolean)this.transactionalBuffer.isEmpty()).isEqualTo(true);
    }

    @Test
    public void testIsNotEmptyWhenTransactionIsRegistered() {
        this.registerDmlOperation(TRANSACTION_ID, SCN, ROW_ID);
        Assertions.assertThat((boolean)this.transactionalBuffer.isEmpty()).isEqualTo(false);
    }

    @Test
    public void testIsEmptyWhenTransactionIsCommitted() throws InterruptedException {
        this.registerDmlOperation(TRANSACTION_ID, SCN, ROW_ID);
        offsetContext = new OracleOffsetContext(connectorConfig, SCN, SCN, (String)null, false, true, new TransactionContext());
        this.transactionalBuffer.commit(TRANSACTION_ID, SCN.add(SCN_ONE), offsetContext, TIMESTAMP, () -> true, MESSAGE, this.dispatcher);
        Assertions.assertThat((boolean)this.transactionalBuffer.isEmpty()).isTrue();
    }

    @Test
    public void testIsEmptyWhenTransactionIsRolledBack() {
        this.registerDmlOperation(TRANSACTION_ID, SCN, ROW_ID);
        this.transactionalBuffer.rollback(TRANSACTION_ID, "");
        Assertions.assertThat((boolean)this.transactionalBuffer.isEmpty()).isTrue();
    }

    @Test
    public void testNonEmptyFirstTransactionIsRolledBack() {
        this.registerDmlOperation(TRANSACTION_ID, SCN, ROW_ID);
        this.registerDmlOperation(OTHER_TRANSACTION_ID, OTHER_SCN, OTHER_ROW_ID);
        this.transactionalBuffer.rollback(TRANSACTION_ID, "");
        Assertions.assertThat((boolean)this.transactionalBuffer.isEmpty()).isFalse();
        Assertions.assertThat((boolean)this.transactionalBuffer.getRolledBackTransactionIds().contains(TRANSACTION_ID)).isTrue();
        Assertions.assertThat((boolean)this.transactionalBuffer.getRolledBackTransactionIds().contains(OTHER_TRANSACTION_ID)).isFalse();
    }

    @Test
    public void testNonEmptySecondTransactionIsRolledBack() {
        this.registerDmlOperation(TRANSACTION_ID, SCN, ROW_ID);
        this.registerDmlOperation(OTHER_TRANSACTION_ID, OTHER_SCN, OTHER_ROW_ID);
        this.transactionalBuffer.rollback(OTHER_TRANSACTION_ID, "");
        Assertions.assertThat((boolean)this.transactionalBuffer.isEmpty()).isFalse();
        Assertions.assertThat((boolean)this.transactionalBuffer.getRolledBackTransactionIds().contains(TRANSACTION_ID)).isFalse();
        Assertions.assertThat((boolean)this.transactionalBuffer.getRolledBackTransactionIds().contains(OTHER_TRANSACTION_ID)).isTrue();
    }

    @Test
    public void testCalculateScnWhenTransactionIsCommitted() throws InterruptedException {
        this.registerDmlOperation(TRANSACTION_ID, SCN, ROW_ID);
        offsetContext = new OracleOffsetContext(connectorConfig, SCN, SCN, null, false, true, new TransactionContext());
        this.transactionalBuffer.commit(TRANSACTION_ID, SCN.add(SCN_ONE), offsetContext, TIMESTAMP, () -> true, MESSAGE, this.dispatcher);
        Assertions.assertThat((String)this.streamingMetrics.getOldestScn()).isEqualTo((Object)SCN.toString());
        Assertions.assertThat((boolean)this.transactionalBuffer.getRolledBackTransactionIds().isEmpty()).isTrue();
    }

    @Test
    public void testCalculateScnWhenFirstTransactionIsCommitted() throws InterruptedException {
        this.registerDmlOperation(TRANSACTION_ID, SCN, ROW_ID);
        this.registerDmlOperation(OTHER_TRANSACTION_ID, OTHER_SCN, OTHER_ROW_ID);
        offsetContext = new OracleOffsetContext(connectorConfig, SCN, SCN, null, false, true, new TransactionContext());
        this.transactionalBuffer.commit(TRANSACTION_ID, SCN.add(SCN_ONE), offsetContext, TIMESTAMP, () -> true, MESSAGE, this.dispatcher);
        Assertions.assertThat((String)this.streamingMetrics.getOldestScn()).isEqualTo((Object)SCN.toString());
        Assertions.assertThat((boolean)this.transactionalBuffer.getRolledBackTransactionIds().isEmpty()).isTrue();
        this.transactionalBuffer.commit(OTHER_TRANSACTION_ID, OTHER_SCN.add(SCN_ONE), offsetContext, TIMESTAMP, () -> true, MESSAGE, this.dispatcher);
        Assertions.assertThat((String)this.streamingMetrics.getOldestScn()).isEqualTo((Object)OTHER_SCN.toString());
    }

    @Test
    public void testCalculateScnWhenSecondTransactionIsCommitted() throws InterruptedException {
        this.registerDmlOperation(TRANSACTION_ID, SCN, ROW_ID);
        this.registerDmlOperation(OTHER_TRANSACTION_ID, OTHER_SCN, OTHER_ROW_ID);
        offsetContext = new OracleOffsetContext(connectorConfig, OTHER_SCN, OTHER_SCN, null, false, true, new TransactionContext());
        this.transactionalBuffer.commit(OTHER_TRANSACTION_ID, OTHER_SCN.add(SCN_ONE), offsetContext, TIMESTAMP, () -> true, MESSAGE, this.dispatcher);
        Assertions.assertThat((String)this.streamingMetrics.getOldestScn()).isEqualTo((Object)SCN.toString());
        Assertions.assertThat((boolean)this.transactionalBuffer.getRolledBackTransactionIds().isEmpty()).isTrue();
    }

    @Test
    public void testAbandoningOneTransaction() {
        this.registerDmlOperation(TRANSACTION_ID, SCN, ROW_ID);
        offsetContext = new OracleOffsetContext(connectorConfig, SCN, SCN, (String)null, false, true, new TransactionContext());
        this.transactionalBuffer.abandonLongTransactions(SCN, offsetContext);
        Assertions.assertThat((boolean)this.transactionalBuffer.isEmpty()).isTrue();
    }

    @Test
    public void testAbandoningTransactionHavingAnotherOne() {
        this.registerDmlOperation(TRANSACTION_ID, SCN, ROW_ID);
        this.registerDmlOperation(OTHER_TRANSACTION_ID, OTHER_SCN, OTHER_ROW_ID);
        this.transactionalBuffer.abandonLongTransactions(SCN, offsetContext);
        Assertions.assertThat((boolean)this.transactionalBuffer.isEmpty()).isFalse();
    }

    @Test
    public void testTransactionDump() {
        this.registerDmlOperation(TRANSACTION_ID, SCN, ROW_ID);
        this.registerDmlOperation(OTHER_TRANSACTION_ID, OTHER_SCN, OTHER_ROW_ID);
        this.registerDmlOperation(OTHER_TRANSACTION_ID, OTHER_SCN, OTHER_ROW_ID);
        Assertions.assertThat((String)this.transactionalBuffer.toString()).contains(String.valueOf(SCN));
        Assertions.assertThat((String)this.transactionalBuffer.toString()).contains(String.valueOf(OTHER_SCN));
    }

    private void registerDmlOperation(String txId, Scn scn, String rowId) {
        this.transactionalBuffer.registerDmlOperation(1, txId, scn, TABLE_ID, DML_ENTRY, Instant.now(), rowId, null, 0L);
    }

    static {
        SCN = SCN_ONE = new Scn(BigInteger.ONE);
        OTHER_SCN = Scn.valueOf((long)10L);
        TIMESTAMP = new Timestamp(System.currentTimeMillis());
        TABLE_ID = new TableId("server1", "DEBEZIUM", "TEST");
        DML_ENTRY = LogMinerDmlEntryImpl.forInsert((Object[])new Object[0]);
        config = new Configuration(){

            public Set<String> keys() {
                return Collections.emptySet();
            }

            public String getString(String key) {
                return null;
            }
        };
        connectorConfig = new OracleConnectorConfig(config);
    }
}

