/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.logminer.parser.LogMinerDmlParser;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntry;
import io.debezium.doc.FixFor;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class LogMinerDmlParserTest {
    private LogMinerDmlParser fastDmlParser;

    @Before
    public void beforeEach() throws Exception {
        this.fastDmlParser = new LogMinerDmlParser();
    }

    @Test
    @FixFor(value={"DBZ-3078"})
    public void testParsingInsert() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.TEST")).addColumn(Column.editor().name("ID").create()).addColumn(Column.editor().name("NAME").create()).addColumn(Column.editor().name("TS").create()).addColumn(Column.editor().name("UT").create()).addColumn(Column.editor().name("DATE").create()).addColumn(Column.editor().name("UT2").create()).addColumn(Column.editor().name("C1").create()).addColumn(Column.editor().name("C2").create()).addColumn(Column.editor().name("UNUSED").create()).create();
        String sql = "insert into \"DEBEZIUM\".\"TEST\"(\"ID\",\"NAME\",\"TS\",\"UT\",\"DATE\",\"UT2\",\"C1\",\"C2\") values ('1','Acme',TO_TIMESTAMP('2020-02-01 00:00:00.'),Unsupported Type,TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS'),Unsupported Type,NULL,NULL);";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(1);
        Assertions.assertThat((Object[])entry.getOldValues()).isEmpty();
        Assertions.assertThat((Object[])entry.getNewValues()).hasSize(9);
        Assertions.assertThat((Object)entry.getNewValues()[0]).isEqualTo((Object)"1");
        Assertions.assertThat((Object)entry.getNewValues()[1]).isEqualTo((Object)"Acme");
        Assertions.assertThat((Object)entry.getNewValues()[2]).isEqualTo((Object)"TO_TIMESTAMP('2020-02-01 00:00:00.')");
        Assertions.assertThat((Object)entry.getNewValues()[3]).isNull();
        Assertions.assertThat((Object)entry.getNewValues()[4]).isEqualTo((Object)"TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS')");
        Assertions.assertThat((Object)entry.getNewValues()[5]).isNull();
        Assertions.assertThat((Object)entry.getNewValues()[6]).isNull();
        Assertions.assertThat((Object)entry.getNewValues()[7]).isNull();
        Assertions.assertThat((Object)entry.getNewValues()[8]).isNull();
    }

    @Test
    @FixFor(value={"DBZ-3078"})
    public void testParsingUpdate() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.TEST")).addColumn(Column.editor().name("ID").create()).addColumn(Column.editor().name("NAME").create()).addColumn(Column.editor().name("TS").create()).addColumn(Column.editor().name("UT").create()).addColumn(Column.editor().name("DATE").create()).addColumn(Column.editor().name("UT2").create()).addColumn(Column.editor().name("C1").create()).addColumn(Column.editor().name("IS").create()).addColumn(Column.editor().name("IS2").create()).addColumn(Column.editor().name("UNUSED").create()).create();
        String sql = "update \"DEBEZIUM\".\"TEST\" set \"NAME\" = 'Bob', \"TS\" = TO_TIMESTAMP('2020-02-02 00:00:00.'), \"UT\" = Unsupported Type, \"DATE\" = TO_DATE('2020-02-02 00:00:00', 'YYYY-MM-DD HH24:MI:SS'), \"UT2\" = Unsupported Type, \"C1\" = NULL where \"ID\" = '1' and \"NAME\" = 'Acme' and \"TS\" = TO_TIMESTAMP('2020-02-01 00:00:00.') and \"UT\" = Unsupported Type and \"DATE\" = TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS') and \"UT2\" = Unsupported Type and \"C1\" = NULL and \"IS\" IS NULL and \"IS2\" IS NULL;";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(3);
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(10);
        Assertions.assertThat((Object)entry.getOldValues()[0]).isEqualTo((Object)"1");
        Assertions.assertThat((Object)entry.getOldValues()[1]).isEqualTo((Object)"Acme");
        Assertions.assertThat((Object)entry.getOldValues()[2]).isEqualTo((Object)"TO_TIMESTAMP('2020-02-01 00:00:00.')");
        Assertions.assertThat((Object)entry.getOldValues()[3]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[4]).isEqualTo((Object)"TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS')");
        Assertions.assertThat((Object)entry.getOldValues()[5]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[6]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[7]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[8]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[9]).isNull();
        Assertions.assertThat((Object[])entry.getNewValues()).hasSize(10);
        Assertions.assertThat((Object)entry.getNewValues()[0]).isEqualTo((Object)"1");
        Assertions.assertThat((Object)entry.getNewValues()[1]).isEqualTo((Object)"Bob");
        Assertions.assertThat((Object)entry.getNewValues()[2]).isEqualTo((Object)"TO_TIMESTAMP('2020-02-02 00:00:00.')");
        Assertions.assertThat((Object)entry.getNewValues()[3]).isNull();
        Assertions.assertThat((Object)entry.getNewValues()[4]).isEqualTo((Object)"TO_DATE('2020-02-02 00:00:00', 'YYYY-MM-DD HH24:MI:SS')");
        Assertions.assertThat((Object)entry.getNewValues()[5]).isNull();
        Assertions.assertThat((Object)entry.getNewValues()[6]).isNull();
        Assertions.assertThat((Object)entry.getNewValues()[7]).isNull();
        Assertions.assertThat((Object)entry.getNewValues()[8]).isNull();
        Assertions.assertThat((Object)entry.getNewValues()[9]).isNull();
    }

    @Test
    @FixFor(value={"DBZ-3078"})
    public void testParsingDelete() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.TEST")).addColumn(Column.editor().name("ID").create()).addColumn(Column.editor().name("NAME").create()).addColumn(Column.editor().name("TS").create()).addColumn(Column.editor().name("UT").create()).addColumn(Column.editor().name("DATE").create()).addColumn(Column.editor().name("IS").create()).addColumn(Column.editor().name("IS2").create()).addColumn(Column.editor().name("UNUSED").create()).create();
        String sql = "delete from \"DEBEZIUM\".\"TEST\" where \"ID\" = '1' and \"NAME\" = 'Acme' and \"TS\" = TO_TIMESTAMP('2020-02-01 00:00:00.') and \"UT\" = Unsupported Type and \"DATE\" = TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS') and \"IS\" IS NULL and \"IS2\" IS NULL;";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(2);
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(8);
        Assertions.assertThat((Object)entry.getOldValues()[0]).isEqualTo((Object)"1");
        Assertions.assertThat((Object)entry.getOldValues()[1]).isEqualTo((Object)"Acme");
        Assertions.assertThat((Object)entry.getOldValues()[2]).isEqualTo((Object)"TO_TIMESTAMP('2020-02-01 00:00:00.')");
        Assertions.assertThat((Object)entry.getOldValues()[3]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[4]).isEqualTo((Object)"TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS')");
        Assertions.assertThat((Object)entry.getOldValues()[5]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[6]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[7]).isNull();
        Assertions.assertThat((Object[])entry.getNewValues()).isEmpty();
    }

    @Test
    @FixFor(value={"DBZ-3235"})
    public void testParsingUpdateWithNoWhereClauseIsAcceptable() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.TEST")).addColumn(Column.editor().name("COL1").create()).addColumn(Column.editor().name("COL2").create()).addColumn(Column.editor().name("COL3").create()).addColumn(Column.editor().name("UNUSED").create()).create();
        String sql = "update \"DEBEZIUM\".\"TEST\" set \"COL1\" = '1', \"COL2\" = NULL, \"COL3\" = 'Hello';";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(3);
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(4);
        Assertions.assertThat((Object)entry.getOldValues()[0]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[1]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[2]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[3]).isNull();
        Assertions.assertThat((Object[])entry.getNewValues()).hasSize(4);
        Assertions.assertThat((Object)entry.getNewValues()[0]).isEqualTo((Object)"1");
        Assertions.assertThat((Object)entry.getNewValues()[1]).isNull();
        Assertions.assertThat((Object)entry.getNewValues()[2]).isEqualTo((Object)"Hello");
        Assertions.assertThat((Object)entry.getNewValues()[3]).isNull();
    }

    @Test
    @FixFor(value={"DBZ-3235"})
    public void testParsingDeleteWithNoWhereClauseIsAcceptable() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.TEST")).addColumn(Column.editor().name("COL1").create()).addColumn(Column.editor().name("COL2").create()).addColumn(Column.editor().name("COL3").create()).addColumn(Column.editor().name("UNUSED").create()).create();
        String sql = "delete from \"DEBEZIUM\".\"TEST\";";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(2);
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(4);
        Assertions.assertThat((Object)entry.getOldValues()[0]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[1]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[2]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[3]).isNull();
        Assertions.assertThat((Object[])entry.getNewValues()).isEmpty();
    }

    @Test
    @FixFor(value={"DBZ-3258"})
    public void testNameWithWhitespaces() throws Exception {
        Table table = Table.editor().tableId(new TableId(null, "UNKNOWN", "OBJ# 74858")).addColumn(Column.editor().name("COL 1").create()).create();
        String sql = "insert into \"UNKNOWN\".\"OBJ# 74858\"(\"COL 1\") values (1)";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(1);
        Assertions.assertThat((Object[])entry.getOldValues()).isEmpty();
        Assertions.assertThat((Object[])entry.getNewValues()).hasSize(1);
        Assertions.assertThat((Object)entry.getNewValues()[0]).isEqualTo((Object)"1");
    }

    @Test
    @FixFor(value={"DBZ-3305"})
    public void testParsingUpdateWithNoWhereClauseFunctionAsLastColumn() throws Exception {
        Table table = Table.editor().tableId(new TableId(null, "TICKETUSER", "CRS_ORDER")).addColumn(Column.editor().name("AMOUNT_PAID").create()).addColumn(Column.editor().name("AMOUNT_UNPAID").create()).addColumn(Column.editor().name("PAY_STATUS").create()).addColumn(Column.editor().name("IS_DEL").create()).addColumn(Column.editor().name("TM_UPDATE").create()).create();
        String sql = "update \"TICKETUSER\".\"CRS_ORDER\" set \"AMOUNT_PAID\" = '0', \"AMOUNT_UNPAID\" = '540', \"PAY_STATUS\" = '10111015', \"IS_DEL\" = '0', \"TM_UPDATE\" = TO_DATE('2021-03-17 10:18:55', 'YYYY-MM-DD HH24:MI:SS');";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(3);
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(5);
        Assertions.assertThat((Object)entry.getOldValues()[0]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[1]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[2]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[3]).isNull();
        Assertions.assertThat((Object)entry.getOldValues()[4]).isNull();
        Assertions.assertThat((Object[])entry.getNewValues()).hasSize(5);
        Assertions.assertThat((Object)entry.getNewValues()[0]).isEqualTo((Object)"0");
        Assertions.assertThat((Object)entry.getNewValues()[1]).isEqualTo((Object)"540");
        Assertions.assertThat((Object)entry.getNewValues()[2]).isEqualTo((Object)"10111015");
        Assertions.assertThat((Object)entry.getNewValues()[3]).isEqualTo((Object)"0");
        Assertions.assertThat((Object)entry.getNewValues()[4]).isEqualTo((Object)"TO_DATE('2021-03-17 10:18:55', 'YYYY-MM-DD HH24:MI:SS')");
    }

    @Test
    @FixFor(value={"DBZ-3367"})
    public void shouldParsingRedoSqlWithParenthesisInFunctionArgumentStrings() throws Exception {
        Table table = Table.editor().tableId(new TableId(null, "DEBEZIUM", "TEST")).addColumn(Column.editor().name("C1").create()).addColumn(Column.editor().name("C2").create()).create();
        String sql = "insert into \"DEBEZIUM\".\"TEST\" (\"C1\",\"C2\") values (UNISTR('\\963F\\72F8\\5C0F\\706B\\8F66\\5BB6\\5EAD\\7968(\\60CA\\559C\\FF09\\FF082161\\FF09'),NULL);";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(1);
        Assertions.assertThat((Object[])entry.getOldValues()).isEmpty();
        Assertions.assertThat((Object[])entry.getNewValues()).hasSize(2);
        Assertions.assertThat((Object)entry.getNewValues()[0]).isEqualTo((Object)"UNISTR('\\963F\\72F8\\5C0F\\706B\\8F66\\5BB6\\5EAD\\7968(\\60CA\\559C\\FF09\\FF082161\\FF09')");
        Assertions.assertThat((Object)entry.getNewValues()[1]).isNull();
        sql = "update \"DEBEZIUM\".\"TEST\" set \"C2\" = UNISTR('\\963F\\72F8\\5C0F\\706B\\8F66\\5BB6\\5EAD\\7968(\\60CA\\559C\\FF09\\FF082161\\FF09') where \"C1\" = UNISTR('\\963F\\72F8\\5C0F\\706B\\8F66\\5BB6\\5EAD\\7968(\\60CA\\559C\\FF09\\FF082161\\FF09');";
        entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(3);
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(2);
        Assertions.assertThat((Object)entry.getOldValues()[0]).isEqualTo((Object)"UNISTR('\\963F\\72F8\\5C0F\\706B\\8F66\\5BB6\\5EAD\\7968(\\60CA\\559C\\FF09\\FF082161\\FF09')");
        Assertions.assertThat((Object)entry.getOldValues()[1]).isNull();
        Assertions.assertThat((Object[])entry.getNewValues()).hasSize(2);
        Assertions.assertThat((Object)entry.getNewValues()[0]).isEqualTo((Object)"UNISTR('\\963F\\72F8\\5C0F\\706B\\8F66\\5BB6\\5EAD\\7968(\\60CA\\559C\\FF09\\FF082161\\FF09')");
        Assertions.assertThat((Object)entry.getNewValues()[1]).isEqualTo((Object)"UNISTR('\\963F\\72F8\\5C0F\\706B\\8F66\\5BB6\\5EAD\\7968(\\60CA\\559C\\FF09\\FF082161\\FF09')");
        sql = "delete from \"DEBEZIUM\".\"TEST\" where \"C1\" = UNISTR('\\963F\\72F8\\5C0F\\706B\\8F66\\5BB6\\5EAD\\7968(\\60CA\\559C\\FF09\\FF082161\\FF09');";
        entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(2);
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(2);
        Assertions.assertThat((Object)entry.getOldValues()[0]).isEqualTo((Object)"UNISTR('\\963F\\72F8\\5C0F\\706B\\8F66\\5BB6\\5EAD\\7968(\\60CA\\559C\\FF09\\FF082161\\FF09')");
        Assertions.assertThat((Object)entry.getOldValues()[1]).isNull();
        Assertions.assertThat((Object[])entry.getNewValues()).isEmpty();
    }

    @Test
    @FixFor(value={"DBZ-3413"})
    public void testParsingDoubleSingleQuoteInWhereClause() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.TEST")).addColumn(Column.editor().name("COL1").create()).addColumn(Column.editor().name("COL2").create()).create();
        String sql = "insert into \"DEBEZIUM\".\"TEST\"(\"COL1\",\"COL2\") values ('Bob''s dog','0');";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(1);
        Assertions.assertThat((Object[])entry.getOldValues()).isEmpty();
        Assertions.assertThat((Object[])entry.getNewValues()).hasSize(2);
        Assertions.assertThat((Object)entry.getNewValues()[0]).isEqualTo((Object)"Bob''s dog");
        Assertions.assertThat((Object)entry.getNewValues()[1]).isEqualTo((Object)"0");
        sql = "update \"DEBEZIUM\".\"TEST\" set \"COL2\" = '1' where \"COL1\" = 'Bob''s dog' and \"COL2\" = '0';";
        entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(3);
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(2);
        Assertions.assertThat((Object)entry.getOldValues()[0]).isEqualTo((Object)"Bob''s dog");
        Assertions.assertThat((Object)entry.getOldValues()[1]).isEqualTo((Object)"0");
        Assertions.assertThat((Object[])entry.getNewValues()).hasSize(2);
        Assertions.assertThat((Object)entry.getNewValues()[0]).isEqualTo((Object)"Bob''s dog");
        Assertions.assertThat((Object)entry.getNewValues()[1]).isEqualTo((Object)"1");
        sql = "delete from \"DEBEZIUM\".\"TEST\" where \"COL1\" = 'Bob''s dog' and \"COL2\" = '1';";
        entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(2);
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(2);
        Assertions.assertThat((Object)entry.getOldValues()[0]).isEqualTo((Object)"Bob''s dog");
        Assertions.assertThat((Object)entry.getOldValues()[1]).isEqualTo((Object)"1");
        Assertions.assertThat((Object[])entry.getNewValues()).isEmpty();
    }
}

