/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.relational.TableId;
import java.io.IOException;
import java.sql.SQLRecoverableException;
import java.time.Duration;
import org.fest.assertions.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class SqlUtilsTest {
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    @Test
    public void testStatements() {
        SqlUtils.setRac((boolean)false);
        String result = SqlUtils.addLogFileStatement((String)"ADD", (String)"FILENAME");
        String expected = "BEGIN sys.dbms_logmnr.add_logfile(LOGFILENAME => 'FILENAME', OPTIONS => ADD);END;";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.databaseSupplementalLoggingMinCheckQuery();
        expected = "SELECT 'KEY', SUPPLEMENTAL_LOG_DATA_MIN FROM V$DATABASE";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.tableSupplementalLoggingCheckQuery((TableId)new TableId(null, "s", "t"));
        expected = "SELECT 'KEY', LOG_GROUP_TYPE FROM ALL_LOG_GROUPS WHERE OWNER = 's' AND TABLE_NAME = 't'";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.startLogMinerStatement((Scn)Scn.valueOf((long)10L), (Scn)Scn.valueOf((long)20L), (OracleConnectorConfig.LogMiningStrategy)OracleConnectorConfig.LogMiningStrategy.ONLINE_CATALOG, (boolean)true);
        expected = "BEGIN sys.dbms_logmnr.start_logmnr(startScn => '10', endScn => '20', OPTIONS => DBMS_LOGMNR.DICT_FROM_ONLINE_CATALOG  + DBMS_LOGMNR.CONTINUOUS_MINE  + DBMS_LOGMNR.NO_ROWID_IN_STMT);END;";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.startLogMinerStatement((Scn)Scn.valueOf((long)10L), (Scn)Scn.valueOf((long)20L), (OracleConnectorConfig.LogMiningStrategy)OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO, (boolean)false);
        expected = "BEGIN sys.dbms_logmnr.start_logmnr(startScn => '10', endScn => '20', OPTIONS => DBMS_LOGMNR.DICT_FROM_REDO_LOGS + DBMS_LOGMNR.DDL_DICT_TRACKING  + DBMS_LOGMNR.NO_ROWID_IN_STMT);END;";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.truncateTableStatement((String)"table_name");
        expected = "TRUNCATE TABLE table_name";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.diffInDaysQuery((Scn)Scn.valueOf((long)123L));
        expected = "select sysdate - CAST(scn_to_timestamp(123) as date) from dual";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.diffInDaysQuery(null);
        Assertions.assertThat((String)result).isNull();
        result = SqlUtils.redoLogStatusQuery();
        expected = "SELECT F.MEMBER, R.STATUS FROM V$LOGFILE F, V$LOG R WHERE F.GROUP# = R.GROUP# ORDER BY 2";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.switchHistoryQuery();
        expected = "SELECT 'TOTAL', COUNT(1) FROM V$ARCHIVED_LOG WHERE FIRST_TIME > TRUNC(SYSDATE) AND DEST_ID IN (SELECT DEST_ID FROM V$ARCHIVE_DEST_STATUS WHERE STATUS='VALID' AND TYPE='LOCAL' AND ROWNUM=1)";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.currentRedoNameQuery();
        expected = "SELECT F.MEMBER FROM V$LOG LOG, V$LOGFILE F  WHERE LOG.GROUP#=F.GROUP# AND LOG.STATUS='CURRENT'";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.currentRedoLogSequenceQuery();
        expected = "SELECT SEQUENCE# FROM V$LOG WHERE STATUS = 'CURRENT'";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.databaseSupplementalLoggingAllCheckQuery();
        expected = "SELECT 'KEY', SUPPLEMENTAL_LOG_DATA_ALL FROM V$DATABASE";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.currentScnQuery();
        expected = "SELECT CURRENT_SCN FROM V$DATABASE";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.oldestFirstChangeQuery((Duration)Duration.ofHours(0L));
        expected = "SELECT MIN(FIRST_CHANGE#) FROM (SELECT MIN(FIRST_CHANGE#) AS FIRST_CHANGE# FROM V$LOG UNION SELECT MIN(FIRST_CHANGE#) AS FIRST_CHANGE# FROM V$ARCHIVED_LOG WHERE DEST_ID IN (SELECT DEST_ID FROM V$ARCHIVE_DEST_STATUS WHERE STATUS='VALID' AND TYPE='LOCAL' AND ROWNUM=1) AND STATUS='A')";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.tableExistsQuery((String)"table_name");
        expected = "SELECT '1' AS ONE FROM USER_TABLES WHERE TABLE_NAME = 'table_name'";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.logMiningHistoryDdl((String)"table_name");
        expected = "create  TABLE table_name(row_sequence NUMBER(19,0), captured_scn NUMBER(19,0), table_name VARCHAR2(30 CHAR), seg_owner VARCHAR2(30 CHAR), operation_code NUMBER(19,0), change_time TIMESTAMP(6), transaction_id VARCHAR2(50 CHAR), csf NUMBER(19,0), redo_sql VARCHAR2(4000 CHAR)) nologging";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.allMinableLogsQuery((Scn)Scn.valueOf((long)10L), (Duration)Duration.ofHours(0L), (boolean)false);
        expected = "SELECT MIN(F.MEMBER) AS FILE_NAME, L.FIRST_CHANGE# FIRST_CHANGE, L.NEXT_CHANGE# NEXT_CHANGE, L.ARCHIVED, L.STATUS, 'ONLINE' AS TYPE, L.SEQUENCE# AS SEQ, 'NO' AS DICT_START, 'NO' AS DICT_END FROM V$LOGFILE F, V$LOG L LEFT JOIN V$ARCHIVED_LOG A ON A.FIRST_CHANGE# = L.FIRST_CHANGE# AND A.NEXT_CHANGE# = L.NEXT_CHANGE# WHERE A.FIRST_CHANGE# IS NULL AND F.GROUP# = L.GROUP# GROUP BY F.GROUP#, L.FIRST_CHANGE#, L.NEXT_CHANGE#, L.STATUS, L.ARCHIVED, L.SEQUENCE# UNION SELECT A.NAME AS FILE_NAME, A.FIRST_CHANGE# FIRST_CHANGE, A.NEXT_CHANGE# NEXT_CHANGE, 'YES', NULL, 'ARCHIVED', A.SEQUENCE# AS SEQ, A.DICTIONARY_BEGIN, A.DICTIONARY_END FROM V$ARCHIVED_LOG A WHERE A.NAME IS NOT NULL AND A.ARCHIVED = 'YES' AND A.STATUS = 'A' AND A.NEXT_CHANGE# > 10 AND A.DEST_ID IN (SELECT DEST_ID FROM V$ARCHIVE_DEST_STATUS WHERE STATUS='VALID' AND TYPE='LOCAL' AND ROWNUM=1) ORDER BY 7";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.allMinableLogsQuery((Scn)Scn.valueOf((long)10L), (Duration)Duration.ofHours(0L), (boolean)true);
        expected = "SELECT A.NAME AS FILE_NAME, A.FIRST_CHANGE# FIRST_CHANGE, A.NEXT_CHANGE# NEXT_CHANGE, 'YES', NULL, 'ARCHIVED', A.SEQUENCE# AS SEQ, A.DICTIONARY_BEGIN, A.DICTIONARY_END FROM V$ARCHIVED_LOG A WHERE A.NAME IS NOT NULL AND A.ARCHIVED = 'YES' AND A.STATUS = 'A' AND A.NEXT_CHANGE# > 10 AND A.DEST_ID IN (SELECT DEST_ID FROM V$ARCHIVE_DEST_STATUS WHERE STATUS='VALID' AND TYPE='LOCAL' AND ROWNUM=1) ORDER BY 7";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.allMinableLogsQuery((Scn)Scn.valueOf((long)10L), (Duration)Duration.ofHours(1L), (boolean)false);
        expected = "SELECT MIN(F.MEMBER) AS FILE_NAME, L.FIRST_CHANGE# FIRST_CHANGE, L.NEXT_CHANGE# NEXT_CHANGE, L.ARCHIVED, L.STATUS, 'ONLINE' AS TYPE, L.SEQUENCE# AS SEQ, 'NO' AS DICT_START, 'NO' AS DICT_END FROM V$LOGFILE F, V$LOG L LEFT JOIN V$ARCHIVED_LOG A ON A.FIRST_CHANGE# = L.FIRST_CHANGE# AND A.NEXT_CHANGE# = L.NEXT_CHANGE# WHERE A.FIRST_CHANGE# IS NULL AND F.GROUP# = L.GROUP# GROUP BY F.GROUP#, L.FIRST_CHANGE#, L.NEXT_CHANGE#, L.STATUS, L.ARCHIVED, L.SEQUENCE# UNION SELECT A.NAME AS FILE_NAME, A.FIRST_CHANGE# FIRST_CHANGE, A.NEXT_CHANGE# NEXT_CHANGE, 'YES', NULL, 'ARCHIVED', A.SEQUENCE# AS SEQ, A.DICTIONARY_BEGIN, A.DICTIONARY_END FROM V$ARCHIVED_LOG A WHERE A.NAME IS NOT NULL AND A.ARCHIVED = 'YES' AND A.STATUS = 'A' AND A.NEXT_CHANGE# > 10 AND A.DEST_ID IN (SELECT DEST_ID FROM V$ARCHIVE_DEST_STATUS WHERE STATUS='VALID' AND TYPE='LOCAL' AND ROWNUM=1) AND A.FIRST_TIME >= SYSDATE - (1/24) ORDER BY 7";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.allMinableLogsQuery((Scn)Scn.valueOf((long)10L), (Duration)Duration.ofHours(1L), (boolean)true);
        expected = "SELECT A.NAME AS FILE_NAME, A.FIRST_CHANGE# FIRST_CHANGE, A.NEXT_CHANGE# NEXT_CHANGE, 'YES', NULL, 'ARCHIVED', A.SEQUENCE# AS SEQ, A.DICTIONARY_BEGIN, A.DICTIONARY_END FROM V$ARCHIVED_LOG A WHERE A.NAME IS NOT NULL AND A.ARCHIVED = 'YES' AND A.STATUS = 'A' AND A.NEXT_CHANGE# > 10 AND A.DEST_ID IN (SELECT DEST_ID FROM V$ARCHIVE_DEST_STATUS WHERE STATUS='VALID' AND TYPE='LOCAL' AND ROWNUM=1) AND A.FIRST_TIME >= SYSDATE - (1/24) ORDER BY 7";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.deleteLogFileStatement((String)"file_name");
        expected = "BEGIN SYS.DBMS_LOGMNR.REMOVE_LOGFILE(LOGFILENAME => 'file_name');END;";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.dropTableStatement((String)"table_name");
        expected = "DROP TABLE TABLE_NAME PURGE";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
    }

    @Test
    public void shouldDetectConnectionProblems() {
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new IOException("connection"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new SQLRecoverableException("connection"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Throwable())).isFalse();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-03135 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-12543 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-00604 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-01089 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-00600 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-99999 problem"))).isFalse();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("NO MORE DATA TO READ FROM SOCKET problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("12543 problem"))).isFalse();
    }
}

