/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.logminer.parser.SelectLobParser;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntry;
import io.debezium.doc.FixFor;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class SelectLobParserTest {
    private static SelectLobParser parser = new SelectLobParser();

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldParseSimpleClobBasedLobSelect() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.CLOB_TEST")).addColumn(Column.editor().name("ID").create()).addColumn(Column.editor().name("VAL_DATA").create()).addColumn(Column.editor().name("VAL_CLOB").create()).create();
        String redoSql = "DECLARE \n loc_c CLOB; \n buf_c VARCHAR2(6174); \n loc_b BLOB; \n buf_b RAW(6174); \n loc_nc NCLOB; \n buf_nc NVARCHAR2(6174); \nBEGIN\n select \"VAL_CLOB\" into loc_c from \"DEBEZIUM\".\"CLOB_TEST\" where \"ID\" = '2' and \"VAL_DATA\" = 'Test2' for update;";
        LogMinerDmlEntry entry = parser.parse(redoSql, table);
        Assertions.assertThat((boolean)parser.isBinary()).isFalse();
        Assertions.assertThat((String)parser.getColumnName()).isEqualTo((Object)"VAL_CLOB");
        Assertions.assertThat((String)entry.getObjectOwner()).isEqualTo((Object)"DEBEZIUM");
        Assertions.assertThat((String)entry.getObjectName()).isEqualTo((Object)"CLOB_TEST");
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(9);
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(3);
        Assertions.assertThat((Object)entry.getOldValues()[0]).isEqualTo((Object)"2");
        Assertions.assertThat((Object)entry.getOldValues()[1]).isEqualTo((Object)"Test2");
        Assertions.assertThat((Object[])entry.getNewValues()).hasSize(3);
        Assertions.assertThat((Object)entry.getNewValues()[0]).isEqualTo((Object)"2");
        Assertions.assertThat((Object)entry.getNewValues()[1]).isEqualTo((Object)"Test2");
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldParseSimpleBlobBasedLobSelect() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.BLOB_TEST")).addColumn(Column.editor().name("ID").create()).addColumn(Column.editor().name("VAL_DATA").create()).addColumn(Column.editor().name("VAL_BLOB").create()).create();
        String redoSql = "DECLARE \n loc_c CLOB; \n buf_c VARCHAR2(6174); \n loc_b BLOB; \n buf_b RAW(6174); \n loc_nc NCLOB; \n buf_nc NVARCHAR2(6174); \nBEGIN\n select \"VAL_BLOB\" into loc_b from \"DEBEZIUM\".\"BLOB_TEST\" where \"ID\" = '2' and \"VAL_DATA\" = 'Test2' for update;";
        LogMinerDmlEntry entry = parser.parse(redoSql, table);
        Assertions.assertThat((boolean)parser.isBinary()).isTrue();
        Assertions.assertThat((String)parser.getColumnName()).isEqualTo((Object)"VAL_BLOB");
        Assertions.assertThat((String)entry.getObjectOwner()).isEqualTo((Object)"DEBEZIUM");
        Assertions.assertThat((String)entry.getObjectName()).isEqualTo((Object)"BLOB_TEST");
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(9);
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(3);
        Assertions.assertThat((Object)entry.getOldValues()[0]).isEqualTo((Object)"2");
        Assertions.assertThat((Object)entry.getOldValues()[1]).isEqualTo((Object)"Test2");
        Assertions.assertThat((Object[])entry.getNewValues()).hasSize(3);
        Assertions.assertThat((Object)entry.getNewValues()[0]).isEqualTo((Object)"2");
        Assertions.assertThat((Object)entry.getNewValues()[1]).isEqualTo((Object)"Test2");
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldParseComplexClobBasedLobSelect() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.BIG_TABLE")).addColumn(Column.editor().name("ID").create()).addColumn(Column.editor().name("NAME").create()).addColumn(Column.editor().name("AGE").create()).addColumn(Column.editor().name("ADRESS").create()).addColumn(Column.editor().name("TD").create()).addColumn(Column.editor().name("FLAG").create()).addColumn(Column.editor().name("CLOB_COL").create()).create();
        String redoSql = "DECLARE \n loc_c CLOB; \n buf_c VARCHAR2(6426); \n loc_b BLOB; \n buf_b RAW(6426); \n loc_nc NCLOB; \n buf_nc NVARCHAR2(6426); \nBEGIN\n select \"CLOB_COL\" into loc_c from \"DEBEZIUM\".\"BIG_TABLE\" where \"ID\" = '651900002' and \"NAME\" = 'person number 651900002' and \"AGE\" = '125' and \"ADRESS\" = 'street:651900002 av: 651900002 house: 651900002' and \"TD\" = TO_DATE('15-MAY-21', 'DD-MON-RR') and \"FLAG\" IS NULL for update;";
        LogMinerDmlEntry entry = parser.parse(redoSql, table);
        Assertions.assertThat((boolean)parser.isBinary()).isFalse();
        Assertions.assertThat((String)parser.getColumnName()).isEqualTo((Object)"CLOB_COL");
        Assertions.assertThat((String)entry.getObjectOwner()).isEqualTo((Object)"DEBEZIUM");
        Assertions.assertThat((String)entry.getObjectName()).isEqualTo((Object)"BIG_TABLE");
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(9);
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(7);
        Assertions.assertThat((Object)entry.getOldValues()[0]).isEqualTo((Object)"651900002");
        Assertions.assertThat((Object)entry.getOldValues()[1]).isEqualTo((Object)"person number 651900002");
        Assertions.assertThat((Object)entry.getOldValues()[2]).isEqualTo((Object)"125");
        Assertions.assertThat((Object)entry.getOldValues()[3]).isEqualTo((Object)"street:651900002 av: 651900002 house: 651900002");
        Assertions.assertThat((Object)entry.getOldValues()[4]).isEqualTo((Object)"TO_DATE('15-MAY-21', 'DD-MON-RR')");
        Assertions.assertThat((Object)entry.getOldValues()[5]).isNull();
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(7);
        Assertions.assertThat((Object)entry.getNewValues()[0]).isEqualTo((Object)"651900002");
        Assertions.assertThat((Object)entry.getNewValues()[1]).isEqualTo((Object)"person number 651900002");
        Assertions.assertThat((Object)entry.getNewValues()[2]).isEqualTo((Object)"125");
        Assertions.assertThat((Object)entry.getNewValues()[3]).isEqualTo((Object)"street:651900002 av: 651900002 house: 651900002");
        Assertions.assertThat((Object)entry.getNewValues()[4]).isEqualTo((Object)"TO_DATE('15-MAY-21', 'DD-MON-RR')");
        Assertions.assertThat((Object)entry.getNewValues()[5]).isNull();
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldParseComplexBlobBasedLobSelect() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.BIG_TABLE")).addColumn(Column.editor().name("ID").create()).addColumn(Column.editor().name("NAME").create()).addColumn(Column.editor().name("AGE").create()).addColumn(Column.editor().name("ADRESS").create()).addColumn(Column.editor().name("TD").create()).addColumn(Column.editor().name("FLAG").create()).addColumn(Column.editor().name("BLOB_COL").create()).create();
        String redoSql = "DECLARE \n loc_c CLOB; \n buf_c VARCHAR2(6426); \n loc_b BLOB; \n buf_b RAW(6426); \n loc_nc NCLOB; \n buf_nc NVARCHAR2(6426); \nBEGIN\n select \"BLOB_COL\" into loc_b from \"DEBEZIUM\".\"BIG_TABLE\" where \"ID\" = '651900002' and \"NAME\" = 'person number 651900002' and \"AGE\" = '125' and \"ADRESS\" = 'street:651900002 av: 651900002 house: 651900002' and \"TD\" = TO_DATE('15-MAY-21', 'DD-MON-RR') and \"FLAG\" IS NULL for update;";
        LogMinerDmlEntry entry = parser.parse(redoSql, table);
        Assertions.assertThat((boolean)parser.isBinary()).isTrue();
        Assertions.assertThat((String)parser.getColumnName()).isEqualTo((Object)"BLOB_COL");
        Assertions.assertThat((String)entry.getObjectOwner()).isEqualTo((Object)"DEBEZIUM");
        Assertions.assertThat((String)entry.getObjectName()).isEqualTo((Object)"BIG_TABLE");
        Assertions.assertThat((int)entry.getOperation()).isEqualTo(9);
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(7);
        Assertions.assertThat((Object)entry.getOldValues()[0]).isEqualTo((Object)"651900002");
        Assertions.assertThat((Object)entry.getOldValues()[1]).isEqualTo((Object)"person number 651900002");
        Assertions.assertThat((Object)entry.getOldValues()[2]).isEqualTo((Object)"125");
        Assertions.assertThat((Object)entry.getOldValues()[3]).isEqualTo((Object)"street:651900002 av: 651900002 house: 651900002");
        Assertions.assertThat((Object)entry.getOldValues()[4]).isEqualTo((Object)"TO_DATE('15-MAY-21', 'DD-MON-RR')");
        Assertions.assertThat((Object)entry.getOldValues()[5]).isNull();
        Assertions.assertThat((Object[])entry.getOldValues()).hasSize(7);
        Assertions.assertThat((Object)entry.getNewValues()[0]).isEqualTo((Object)"651900002");
        Assertions.assertThat((Object)entry.getNewValues()[1]).isEqualTo((Object)"person number 651900002");
        Assertions.assertThat((Object)entry.getNewValues()[2]).isEqualTo((Object)"125");
        Assertions.assertThat((Object)entry.getNewValues()[3]).isEqualTo((Object)"street:651900002 av: 651900002 house: 651900002");
        Assertions.assertThat((Object)entry.getNewValues()[4]).isEqualTo((Object)"TO_DATE('15-MAY-21', 'DD-MON-RR')");
        Assertions.assertThat((Object)entry.getNewValues()[5]).isNull();
    }
}

