/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.LogMinerQueryBuilder;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.history.DatabaseHistory;
import java.util.Iterator;
import org.fest.assertions.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class LogMinerQueryBuilderTest {
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();
    private static final String OPERATION_CODES_LOB_ENABLED = "(1,2,3,9,10,11,29)";
    private static final String OPERATION_CODES_LOB_DISABLED = "(1,2,3)";
    private static final String LOG_MINER_CONTENT_QUERY_TEMPLATE1 = "SELECT SCN, SQL_REDO, OPERATION_CODE, TIMESTAMP, XID, CSF, TABLE_NAME, SEG_OWNER, OPERATION, USERNAME, ROW_ID, ROLLBACK, RS_ID, ORA_HASH(SCN||OPERATION||RS_ID||SEQUENCE#||RTRIM(SUBSTR(SQL_REDO,1,256))) FROM V$LOGMNR_CONTENTS WHERE SCN > ? AND SCN <= ? AND ((OPERATION_CODE IN (6,7,34,36) OR (OPERATION_CODE = 5 AND USERNAME NOT IN ('SYS','SYSTEM','${user}') AND INFO NOT LIKE 'INTERNAL DDL%' AND (TABLE_NAME IS NULL OR TABLE_NAME NOT LIKE 'ORA_TEMP_%')) ) OR (OPERATION_CODE IN ${operationCodes} AND TABLE_NAME != 'LOG_MINING_FLUSH' ${systemTablePredicate}${schemaPredicate}${tablePredicate}))";
    private static final String LOG_MINER_CONTENT_QUERY_TEMPLATE2 = "SELECT SCN, SQL_REDO, OPERATION_CODE, TIMESTAMP, XID, CSF, TABLE_NAME, SEG_OWNER, OPERATION, USERNAME, ROW_ID, ROLLBACK, RS_ID, ORA_HASH(SCN||OPERATION||RS_ID||SEQUENCE#||RTRIM(SUBSTR(SQL_REDO,1,256))) FROM V$LOGMNR_CONTENTS WHERE SCN > ? AND SCN <= ? AND ((OPERATION_CODE IN (6,7,34,36)) OR ((OPERATION_CODE IN ${operationCodes} OR (OPERATION_CODE = 5 AND USERNAME NOT IN ('SYS','SYSTEM','${user}') AND INFO NOT LIKE 'INTERNAL DDL%' AND (TABLE_NAME IS NULL OR TABLE_NAME NOT LIKE 'ORA_TEMP_%'))) AND TABLE_NAME != 'LOG_MINING_FLUSH' ${systemTablePredicate}${schemaPredicate}${tablePredicate}))";
    private static final String USERNAME = "USERNAME";

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithNoFilters() {
        Configuration config = TestHelper.defaultConfig().build();
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(config);
        String result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(connectorConfig, null, null));
        config = ((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        connectorConfig = new OracleConnectorConfig(config);
        result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(connectorConfig, null, null));
        config = ((Configuration.Builder)TestHelper.defaultConfig().with(DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).build();
        connectorConfig = new OracleConnectorConfig(config);
        result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(connectorConfig, null, null));
        config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        connectorConfig = new OracleConnectorConfig(config);
        result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(connectorConfig, null, null));
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithSchemaInclude() {
        String schema = "AND (REGEXP_LIKE(SEG_OWNER,'^SCHEMA1$','i') OR REGEXP_LIKE(SEG_OWNER,'^SCHEMA2$','i')) ";
        this.assertQueryWithConfig(RelationalDatabaseConnectorConfig.SCHEMA_INCLUDE_LIST, "SCHEMA1,SCHEMA2", schema, null);
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithSchemaExclude() {
        String schema = "AND (NOT REGEXP_LIKE(SEG_OWNER,'^SCHEMA1$','i') AND NOT REGEXP_LIKE(SEG_OWNER,'^SCHEMA2$','i')) ";
        this.assertQueryWithConfig(OracleConnectorConfig.SCHEMA_EXCLUDE_LIST, "SCHEMA1,SCHEMA2", schema, null);
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithTableInclude() {
        String table = "AND (REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEA$','i') OR REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEB$','i')) ";
        this.assertQueryWithConfig(RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.TABLEA,DEBEZIUM\\.TABLEB", null, table);
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithTableExcludes() {
        String table = "AND (NOT REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEA$','i') AND NOT REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEB$','i')) ";
        this.assertQueryWithConfig(RelationalDatabaseConnectorConfig.TABLE_EXCLUDE_LIST, "DEBEZIUM\\.TABLEA,DEBEZIUM\\.TABLEB", null, table);
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithSchemaTableIncludes() {
        String schema = "AND (REGEXP_LIKE(SEG_OWNER,'^SCHEMA1$','i') OR REGEXP_LIKE(SEG_OWNER,'^SCHEMA2$','i')) ";
        String table = "AND (REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEA$','i') OR REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEB$','i')) ";
        this.assertQueryWithConfig(RelationalDatabaseConnectorConfig.SCHEMA_INCLUDE_LIST, "SCHEMA1,SCHEMA2", RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.TABLEA,DEBEZIUM\\.TABLEB", schema, table);
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithSchemaTableExcludes() {
        String schema = "AND (NOT REGEXP_LIKE(SEG_OWNER,'^SCHEMA1$','i') AND NOT REGEXP_LIKE(SEG_OWNER,'^SCHEMA2$','i')) ";
        String table = "AND (NOT REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEA$','i') AND NOT REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEB$','i')) ";
        this.assertQueryWithConfig(RelationalDatabaseConnectorConfig.SCHEMA_EXCLUDE_LIST, "SCHEMA1,SCHEMA2", RelationalDatabaseConnectorConfig.TABLE_EXCLUDE_LIST, "DEBEZIUM\\.TABLEA,DEBEZIUM\\.TABLEB", schema, table);
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithSchemaExcludeTableInclude() {
        String schema = "AND (NOT REGEXP_LIKE(SEG_OWNER,'^SCHEMA1$','i') AND NOT REGEXP_LIKE(SEG_OWNER,'^SCHEMA2$','i')) ";
        String table = "AND (REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEA$','i') OR REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEB$','i')) ";
        this.assertQueryWithConfig(RelationalDatabaseConnectorConfig.SCHEMA_EXCLUDE_LIST, "SCHEMA1,SCHEMA2", RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.TABLEA,DEBEZIUM\\.TABLEB", schema, table);
    }

    private void assertQueryWithConfig(Field field, Object fieldValue, String schemaValue, String tableValue) {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(field, fieldValue)).build();
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(config);
        String result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(connectorConfig, schemaValue, tableValue));
        config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(field, fieldValue)).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        connectorConfig = new OracleConnectorConfig(config);
        result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(connectorConfig, schemaValue, tableValue));
        config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(field, fieldValue)).with(DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).build();
        connectorConfig = new OracleConnectorConfig(config);
        result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(connectorConfig, schemaValue, tableValue));
        config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(field, fieldValue)).with(DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        connectorConfig = new OracleConnectorConfig(config);
        result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(connectorConfig, schemaValue, tableValue));
    }

    private void assertQueryWithConfig(Field field1, Object fieldValue1, Field field2, Object fieldValue2, String schemaValue, String tableValue) {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(field1, fieldValue1)).with(field2, fieldValue2)).build();
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(config);
        String result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(connectorConfig, schemaValue, tableValue));
        config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(field1, fieldValue1)).with(field2, fieldValue2)).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        connectorConfig = new OracleConnectorConfig(config);
        result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(connectorConfig, schemaValue, tableValue));
        config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(field1, fieldValue1)).with(field2, fieldValue2)).with(DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).build();
        connectorConfig = new OracleConnectorConfig(config);
        result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(connectorConfig, schemaValue, tableValue));
        config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(field1, fieldValue1)).with(field2, fieldValue2)).with(DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        connectorConfig = new OracleConnectorConfig(config);
        result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(connectorConfig, schemaValue, tableValue));
    }

    private String resolveLogMineryContentQueryFromTemplate(OracleConnectorConfig config, String schemaReplacement, String tableReplacement) {
        String query;
        String string = query = config.getDatabaseHistory().storeOnlyCapturedTables() ? LOG_MINER_CONTENT_QUERY_TEMPLATE2 : LOG_MINER_CONTENT_QUERY_TEMPLATE1;
        if (!OracleConnectorConfig.EXCLUDED_SCHEMAS.isEmpty()) {
            StringBuilder systemPredicate = new StringBuilder();
            systemPredicate.append("AND SEG_OWNER NOT IN (");
            Iterator i = OracleConnectorConfig.EXCLUDED_SCHEMAS.iterator();
            while (i.hasNext()) {
                String excludedSchema = (String)i.next();
                systemPredicate.append("'").append(excludedSchema.toUpperCase()).append("'");
                if (!i.hasNext()) continue;
                systemPredicate.append(",");
            }
            systemPredicate.append(") ");
            query = query.replace("${systemTablePredicate}", systemPredicate.toString());
        } else {
            query = query.replace("${systemTablePredicate}", "");
        }
        query = query.replace("${operationCodes}", config.isLobEnabled() ? OPERATION_CODES_LOB_ENABLED : OPERATION_CODES_LOB_DISABLED);
        query = query.replace("${schemaPredicate}", schemaReplacement == null ? "" : schemaReplacement);
        query = query.replace("${tablePredicate}", tableReplacement == null ? "" : tableReplacement);
        query = query.replace("${user}", USERNAME);
        return query;
    }
}

