/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.Envelope;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.util.IoUtil;
import io.debezium.util.Testing;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.Blob;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.awaitility.Awaitility;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class OracleBlobDataTypesIT
extends AbstractConnectorTest {
    private static final byte[] BIN_DATA = OracleBlobDataTypesIT.readBinaryData("data/test_lob_data.json");
    @Rule
    public final TestRule skipAdapterRule = new SkipTestDependingOnAdapterNameRule();
    private OracleConnection connection;

    @Before
    public void before() {
        this.connection = TestHelper.testConnection();
        TestHelper.dropTable(this.connection, "BLOB_TEST");
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws Exception {
        if (this.connection != null) {
            TestHelper.dropTable(this.connection, "BLOB_TEST");
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldSnapshotBlobDataTypes() throws Exception {
        String ddl = "CREATE TABLE BLOB_TEST (ID numeric(9,0), VAL_BLOB blob, primary key(id))";
        this.connection.execute(new String[]{ddl});
        String dml = "INSERT INTO BLOB_TEST VALUES (1, utl_raw.cast_to_raw('Hello World'))";
        this.connection.execute(new String[]{dml});
        TestHelper.streamTable(this.connection, "debezium.blob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.BLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleBlobDataTypesIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidRead((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)ByteBuffer.wrap("Hello World".getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldStreamSmallBlobDataTypeValues() throws Exception {
        String ddl = "CREATE TABLE BLOB_TEST (ID numeric(9,0), VAL_BLOB blob, primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.blob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.BLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleBlobDataTypesIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Blob blob1 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 0, 100));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (1, ?)", p -> p.setBlob(1, blob1), null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1));
        Blob blob2 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 0, 200));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (2, ?)", p -> p.setBlob(1, blob2), null);
        Blob blob3 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 0, 300));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (3, ?)", p -> p.setBlob(1, blob3), null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob2));
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(1);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)3);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob3));
        Blob blob1Update = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 1, 201));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blob = ? WHERE id = 1", p -> p.setBlob(1, blob1Update), null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(1);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1Update));
        Blob blob2Update = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 2, 202));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blob = ? WHERE id = 2", p -> p.setBlob(1, blob2Update), null);
        Blob blob3Update = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 3, 303));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blob = ? WHERE id = 3", p -> p.setBlob(1, blob3Update), null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)2);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob2Update));
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(1);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)3);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob3Update));
        this.connection.execute(new String[]{"DELETE FROM debezium.blob_test WHERE id = 1"});
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
        Struct before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.blob_test WHERE id = 2"});
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.blob_test WHERE id = 3"});
        this.connection.execute(new String[]{"COMMIT"});
        records = this.consumeRecordsByTopic(4);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(4);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)2);
        before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(2);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)3);
        before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldStreamSmallBlobDataTypeValuesWithNonBlobFields() throws Exception {
        String ddl = "CREATE TABLE BLOB_TEST (ID numeric(9,0), VAL_BLOB blob, VAL_DATA varchar2(50), primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.blob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.BLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleBlobDataTypesIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Blob blob1 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 0, 100));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (1, ?, 'Test1')", p -> p.setBlob(1, blob1), null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test1");
        Blob blob2 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 0, 200));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (2, ?, 'Test2')", p -> p.setBlob(1, blob2), null);
        Blob blob3 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 0, 300));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (3, ?, 'Test3')", p -> p.setBlob(1, blob3), null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob2));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test2");
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(1);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)3);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob3));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test3");
        Blob blob1Update = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 1, 201));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blob = ?, val_data = 'Test1U' WHERE id = 1", p -> p.setBlob(1, blob1Update), null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(1);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1Update));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test1U");
        Blob blob2Update = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 2, 202));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blob = ?, val_data = 'Test2U' WHERE id = 2", p -> p.setBlob(1, blob2Update), null);
        Blob blob3Update = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 3, 303));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blob = ?, val_data = 'Test3U' WHERE id = 3", p -> p.setBlob(1, blob3Update), null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)2);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob2Update));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test2U");
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(1);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)3);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob3Update));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test3U");
        this.connection.execute(new String[]{"DELETE FROM debezium.blob_test WHERE id = 1"});
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
        Struct before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test1U");
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.blob_test WHERE id = 2"});
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.blob_test WHERE id = 3"});
        this.connection.execute(new String[]{"COMMIT"});
        records = this.consumeRecordsByTopic(4);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(4);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)2);
        before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test2U");
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(2);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)3);
        before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test3U");
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldStreamLargeBlobDataTypeValues() throws Exception {
        String ddl = "CREATE TABLE BLOB_TEST (ID numeric(9,0), VAL_BLOB blob, primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.blob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.BLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleBlobDataTypesIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Blob blob1 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 0, 24000));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (1, ?)", p -> p.setBlob(1, blob1), null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1));
        Blob blob2 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 10, 24010));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (2, ?)", p -> p.setBlob(1, blob2), null);
        Blob blob3 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 50, 24050));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (3, ?)", p -> p.setBlob(1, blob3), null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob2));
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(1);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)3);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob3));
        Blob blob1Update = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 1, 24001));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blob = ? WHERE id = 1", p -> p.setBlob(1, blob1Update), null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(1);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1Update));
        Blob blob2Update = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 2, 24002));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blob = ? WHERE id = 2", p -> p.setBlob(1, blob2Update), null);
        Blob blob3Update = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 3, 24003));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blob = ? WHERE id = 3", p -> p.setBlob(1, blob3Update), null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)2);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob2Update));
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(1);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)3);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob3Update));
        this.connection.execute(new String[]{"DELETE FROM debezium.blob_test WHERE id = 1"});
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
        Struct before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.blob_test WHERE id = 2"});
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.blob_test WHERE id = 3"});
        this.connection.execute(new String[]{"COMMIT"});
        records = this.consumeRecordsByTopic(4);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(4);
        records.forEach(System.out::println);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)2);
        before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(2);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)3);
        before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldStreamLargeBlobDataTypeValuesWithNonBlobFields() throws Exception {
        String ddl = "CREATE TABLE BLOB_TEST (ID numeric(9,0), VAL_BLOB blob, VAL_DATA varchar2(50), primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.blob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.BLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleBlobDataTypesIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Blob blob1 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 0, 24000));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (1, ?, 'Test1')", p -> p.setBlob(1, blob1), null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test1");
        Blob blob2 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 10, 24010));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (2, ?, 'Test2')", p -> p.setBlob(1, blob2), null);
        Blob blob3 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 50, 24050));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (3, ?, 'Test3')", p -> p.setBlob(1, blob3), null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob2));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test2");
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(1);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)3);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob3));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test3");
        Blob blob1Update = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 1, 24001));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blob = ?, val_data = 'Test1U' WHERE id = 1", p -> p.setBlob(1, blob1Update), null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(1);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1Update));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test1U");
        Blob blob2Update = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 2, 24002));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blob = ?, val_data = 'Test2U' WHERE id = 2", p -> p.setBlob(1, blob2Update), null);
        Blob blob3Update = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 3, 24003));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blob = ?, val_data = 'Test3U' WHERE id = 3", p -> p.setBlob(1, blob3Update), null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)2);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob2Update));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test2U");
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(1);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)3);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob3Update));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test3U");
        this.connection.execute(new String[]{"DELETE FROM debezium.blob_test WHERE id = 1"});
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
        Struct before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test1U");
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.blob_test WHERE id = 2"});
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.blob_test WHERE id = 3"});
        this.connection.execute(new String[]{"COMMIT"});
        records = this.consumeRecordsByTopic(4);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(4);
        records.forEach(System.out::println);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)2);
        before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test2U");
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(2);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)3);
        before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test3U");
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldStreamMixedBlobDataTypeValuesWithNonBlobFieldsSameTable() throws Exception {
        String ddl = "CREATE TABLE BLOB_TEST (ID numeric(9,0), VAL_BLOBS blob, VAL_BLOB blob, VAL_DATA varchar2(50), primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.blob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.BLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleBlobDataTypesIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Blob blob1a = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 1, 201));
        Blob blob1b = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 0, 24000));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (1, ?, ?, 'Test1')", p -> {
            p.setBlob(1, blob1a);
            p.setBlob(2, blob1b);
        }, null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_BLOBS")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1a));
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1b));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test1");
        Blob blob2a = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 10, 210));
        Blob blob2b = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 10, 24010));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (2, ?, ?, 'Test2')", p -> {
            p.setBlob(1, blob2a);
            p.setBlob(2, blob2b);
        }, null);
        Blob blob3a = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 50, 250));
        Blob blob3b = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 50, 24050));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (3, ?, ?, 'Test3')", p -> {
            p.setBlob(1, blob3a);
            p.setBlob(2, blob3b);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_BLOBS")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob2a));
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob2b));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test2");
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(1);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)3);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_BLOBS")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob3a));
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob3b));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test3");
        Blob blob1aUpdate = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 5, 205));
        Blob blob1bUpdate = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 1, 24001));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blobs = ?, val_blob = ?, val_data = 'Test1U' WHERE id = 1", p -> {
            p.setBlob(1, blob1aUpdate);
            p.setBlob(2, blob1bUpdate);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(1);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_BLOBS")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1aUpdate));
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1bUpdate));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test1U");
        Blob blob2aUpdate = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 2, 202));
        Blob blob2bUpdate = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 2, 24002));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blobs = ?, val_blob = ?, val_data = 'Test2U' WHERE id = 2", p -> {
            p.setBlob(1, blob2aUpdate);
            p.setBlob(2, blob2bUpdate);
        }, null);
        Blob blob3aUpdate = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 3, 203));
        Blob blob3bUpdate = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 3, 24003));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET val_blobs = ?, val_blob = ?, val_data = 'Test3U' WHERE id = 3", p -> {
            p.setBlob(1, blob3aUpdate);
            p.setBlob(2, blob3bUpdate);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)2);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_BLOBS")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob2aUpdate));
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob2bUpdate));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test2U");
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(1);
        VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)3);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("VAL_BLOBS")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob3aUpdate));
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob3bUpdate));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test3U");
        this.connection.execute(new String[]{"DELETE FROM debezium.blob_test WHERE id = 1"});
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(2);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
        Struct before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)before.get("VAL_BLOBS")).isNull();
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test1U");
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.blob_test WHERE id = 2"});
        this.connection.executeWithoutCommitting(new String[]{"DELETE FROM debezium.blob_test WHERE id = 3"});
        this.connection.execute(new String[]{"COMMIT"});
        records = this.consumeRecordsByTopic(4);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(4);
        records.forEach(System.out::println);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)2);
        before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)before.get("VAL_BLOBS")).isNull();
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test2U");
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(2);
        VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)3);
        before = OracleBlobDataTypesIT.before(record);
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)before.get("VAL_BLOBS")).isNull();
        Assertions.assertThat((Object)before.get("VAL_BLOB")).isNull();
        Assertions.assertThat((Object)before.get("VAL_DATA")).isEqualTo((Object)"Test3U");
        Assertions.assertThat((Object)OracleBlobDataTypesIT.after(record)).isNull();
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldNotStreamAnyChangesWhenLobEraseIsDetected() throws Exception {
        String ddl = "CREATE TABLE BLOB_TEST (ID numeric(9,0), VAL_BLOB blob, primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.blob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.BLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        LogInterceptor logInterceptor = new LogInterceptor();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleBlobDataTypesIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Blob blob1 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 0, 24000));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (1, ?)", p -> p.setBlob(1, blob1), null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1));
        this.connection.execute(new String[]{"DECLARE loc_b BLOB; amount integer; BEGIN SELECT \"VAL_BLOB\" INTO loc_b FROM BLOB_TEST WHERE ID = 1 for update; amount := 10;dbms_lob.erase(loc_b, amount, 1); end;"});
        Awaitility.await().atMost(Duration.ofMinutes(1L)).until(() -> logInterceptor.containsWarnMessage("LOB_ERASE for table"));
        this.assertNoRecordsToConsume();
    }

    @Test
    @FixFor(value={"DBZ-2948"})
    public void shouldStreamBlobFieldsWithPrimaryKeyChange() throws Exception {
        String ddl = "CREATE TABLE BLOB_TEST (ID numeric(9,0), VAL_BLOBS blob, VAL_BLOB blob, VAL_DATA varchar2(50), primary key(id))";
        this.connection.execute(new String[]{ddl});
        TestHelper.streamTable(this.connection, "debezium.blob_test");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.BLOB_TEST")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleBlobDataTypesIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        Blob blob1a = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 1, 201));
        Blob blob1b = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 0, 24000));
        this.connection.prepareQuery("INSERT INTO debezium.blob_test values (1, ?, ?, 'Test1')", p -> {
            p.setBlob(1, blob1a);
            p.setBlob(2, blob1b);
        }, null);
        this.connection.commit();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(1);
        SourceRecord record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("VAL_BLOBS")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1a));
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1b));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test1");
        Blob blob1aUpdate = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 5, 205));
        Blob blob1bUpdate = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 1, 24001));
        this.connection.prepareQuery("UPDATE debezium.blob_test SET id = 2, val_blobs = ?, val_blob = ?, val_data = 'Test1U' WHERE id = 1", p -> {
            p.setBlob(1, blob1aUpdate);
            p.setBlob(2, blob1bUpdate);
        }, null);
        this.connection.commit();
        records = this.consumeRecordsByTopic(3);
        Assertions.assertThat((List)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST"))).hasSize(3);
        record = (SourceRecord)records.recordsForTopic(OracleBlobDataTypesIT.topicName("BLOB_TEST")).get(2);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
        after = OracleBlobDataTypesIT.after(record);
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("VAL_BLOBS")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1aUpdate));
        Assertions.assertThat((Object)after.get("VAL_BLOB")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1bUpdate));
        Assertions.assertThat((Object)after.get("VAL_DATA")).isEqualTo((Object)"Test1U");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3631"})
    public void shouldReconcileTransactionWhenAllBlobClobAreInitializedAsNull() throws Exception {
        String DDL = "CREATE TABLE dbz3631 (ID NUMBER(38) NOT NULL,ENTITY_ID NUMBER(38) NOT NULL,DOCX BLOB,DOCX_SIGNATURE BLOB,XML_OOS BLOB,XML_OOS_SIGNATURE BLOB,PRIMARY KEY(ID))";
        TestHelper.dropTable(this.connection, "dbz3631");
        try {
            this.connection.execute(new String[]{"CREATE TABLE dbz3631 (ID NUMBER(38) NOT NULL,ENTITY_ID NUMBER(38) NOT NULL,DOCX BLOB,DOCX_SIGNATURE BLOB,XML_OOS BLOB,XML_OOS_SIGNATURE BLOB,PRIMARY KEY(ID))"});
            TestHelper.streamTable(this.connection, "dbz3631");
            Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM.DBZ3631")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleBlobDataTypesIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            this.connection.executeWithoutCommitting(new String[]{"INSERT INTO dbz3631 (ID,ENTITY_ID) VALUES (13268281,13340568)"});
            this.connection.commit();
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List table = records.recordsForTopic("server1.DEBEZIUM.DBZ3631");
            Assertions.assertThat((List)table).hasSize(1);
            SourceRecord record = (SourceRecord)table.get(0);
            Struct value = (Struct)record.value();
            Struct after = value.getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(13268281L));
            Assertions.assertThat((Object)after.get("ENTITY_ID")).isEqualTo((Object)BigDecimal.valueOf(13340568L));
            Assertions.assertThat((Object)after.get("DOCX")).isNull();
            Assertions.assertThat((Object)after.get("DOCX_SIGNATURE")).isNull();
            Assertions.assertThat((Object)after.get("XML_OOS")).isNull();
            Assertions.assertThat((Object)after.get("XML_OOS_SIGNATURE")).isNull();
            Assertions.assertThat((Object)value.get("op")).isEqualTo((Object)Envelope.Operation.CREATE.code());
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3631");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3645"})
    public void shouldNotEmitBlobFieldValuesWhenLobSupportIsNotEnabled() throws Exception {
        boolean logMinerAdapter = TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.LOG_MINER);
        TestHelper.dropTable(this.connection, "dbz3645");
        try {
            this.connection.execute(new String[]{"CREATE TABLE dbz3645 (id numeric(9,0), data blob, primary key(id))"});
            TestHelper.streamTable(this.connection, "dbz3645");
            Blob blob1 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 0, 250));
            this.connection.prepareQuery("INSERT INTO dbz3645 (id,data) values (1,?)", ps -> ps.setBlob(1, blob1), null);
            Blob blob2 = this.createBlob(OracleBlobDataTypesIT.part(BIN_DATA, 0, 25000));
            this.connection.prepareQuery("INSERT INTO dbz3645 (id,data) values (2,?)", ps -> ps.setBlob(1, blob2), null);
            this.connection.commit();
            Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3645")).with(OracleConnectorConfig.LOG_MINING_STRATEGY, "online_catalog")).with(OracleConnectorConfig.LOB_ENABLED, false)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleBlobDataTypesIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(2);
            List table = sourceRecords.recordsForTopic(OracleBlobDataTypesIT.topicName("DBZ3645"));
            Assertions.assertThat((List)table).hasSize(2);
            SourceRecord record = (SourceRecord)table.get(0);
            Struct after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isNull();
            record = (SourceRecord)table.get(1);
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("DATA")).isNull();
            this.connection.prepareQuery("INSERT INTO dbz3645 (id,data) values (3,?)", ps -> ps.setBlob(1, blob1), null);
            this.connection.prepareQuery("INSERT INTO dbz3645 (id,data) values (4,?)", ps -> ps.setBlob(1, blob2), null);
            this.connection.commit();
            sourceRecords = this.consumeRecordsByTopic(logMinerAdapter ? 3 : 2);
            table = sourceRecords.recordsForTopic(OracleBlobDataTypesIT.topicName("DBZ3645"));
            Assertions.assertThat((List)table).hasSize(logMinerAdapter ? 3 : 2);
            record = (SourceRecord)table.get(0);
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
            Assertions.assertThat((Object)after.get("DATA")).isNull();
            Assertions.assertThat((Object)((Struct)record.value()).get("op")).isEqualTo((Object)"c");
            if (logMinerAdapter) {
                record = (SourceRecord)table.get(1);
                after = ((Struct)record.value()).getStruct("after");
                Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
                Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)OracleBlobDataTypesIT.getByteBufferFromBlob(blob1));
                Assertions.assertThat((Object)((Struct)record.value()).get("op")).isEqualTo((Object)"u");
            }
            record = (SourceRecord)table.get(logMinerAdapter ? 2 : 1);
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)4);
            Assertions.assertThat((Object)after.get("DATA")).isNull();
            Assertions.assertThat((Object)((Struct)record.value()).get("op")).isEqualTo((Object)"c");
            this.assertNoRecordsToConsume();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3645");
        }
    }

    private static byte[] part(byte[] buffer, int start, int length) {
        return Arrays.copyOfRange(buffer, start, length);
    }

    private static Struct before(SourceRecord record) {
        return ((Struct)record.value()).getStruct("before");
    }

    private static Struct after(SourceRecord record) {
        return ((Struct)record.value()).getStruct("after");
    }

    private static String topicName(String tableName) {
        return "server1.DEBEZIUM." + tableName;
    }

    private static byte[] readBinaryData(String pathOnClasspath) {
        byte[] byArray;
        block8: {
            InputStream stream = Testing.Files.readResourceAsStream((String)pathOnClasspath);
            try {
                byArray = IoUtil.readBytes((InputStream)stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Fail.fail((String)("Unable to read '" + pathOnClasspath + "'"), (Throwable)e);
                    return null;
                }
            }
            stream.close();
        }
        return byArray;
    }

    private Blob createBlob(byte[] data) throws SQLException {
        Blob blob = this.connection.connection().createBlob();
        blob.setBytes(1L, data);
        return blob;
    }

    private static ByteBuffer getByteBufferFromBlob(Blob blob) throws SQLException {
        return ByteBuffer.wrap(blob.getBytes(1L, (int)blob.length()));
    }
}

