/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.xstream;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleDatabaseVersion;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.StreamingAdapter;
import io.debezium.connector.oracle.xstream.LcrEventHandler;
import io.debezium.connector.oracle.xstream.LcrPosition;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import oracle.sql.NUMBER;
import oracle.streams.StreamsException;
import oracle.streams.XStreamLCRCallbackHandler;
import oracle.streams.XStreamOut;
import oracle.streams.XStreamUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XstreamStreamingChangeEventSource
implements StreamingChangeEventSource<OracleOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XstreamStreamingChangeEventSource.class);
    private final OracleConnectorConfig connectorConfig;
    private final OracleConnection jdbcConnection;
    private final EventDispatcher<TableId> dispatcher;
    private final ErrorHandler errorHandler;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final OracleStreamingChangeEventSourceMetrics streamingMetrics;
    private final String xStreamServerName;
    private volatile XStreamOut xsOut;
    private final int posVersion;
    private final AtomicReference<PositionAndScn> lcrMessage = new AtomicReference();

    public XstreamStreamingChangeEventSource(OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, EventDispatcher<TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, OracleStreamingChangeEventSourceMetrics streamingMetrics) {
        this.connectorConfig = connectorConfig;
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.clock = clock;
        this.schema = schema;
        this.streamingMetrics = streamingMetrics;
        this.xStreamServerName = connectorConfig.getXoutServerName();
        this.posVersion = XstreamStreamingChangeEventSource.resolvePosVersion(jdbcConnection, connectorConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ChangeEventSource.ChangeEventSourceContext context, OracleOffsetContext offsetContext) throws InterruptedException {
        LcrEventHandler eventHandler = new LcrEventHandler(this.connectorConfig, this.errorHandler, this.dispatcher, this.clock, this.schema, offsetContext, StreamingAdapter.TableNameCaseSensitivity.INSENSITIVE.equals((Object)this.connectorConfig.getAdapter().getTableNameCaseSensitivity(this.jdbcConnection)), this, this.streamingMetrics);
        try (OracleConnection xsConnection = new OracleConnection((Configuration)this.jdbcConnection.config(), () -> this.getClass().getClassLoader());){
            try {
                String lcrPosition = offsetContext.getLcrPosition();
                byte[] startPosition = lcrPosition != null ? LcrPosition.valueOf(lcrPosition).getRawPosition() : this.convertScnToPosition(offsetContext.getScn());
                this.xsOut = XStreamOut.attach((oracle.jdbc.OracleConnection)((oracle.jdbc.OracleConnection)xsConnection.connection()), (String)this.xStreamServerName, (byte[])startPosition, (int)1, (int)1, (int)0);
                while (context.isRunning()) {
                    LOGGER.trace("Receiving LCR");
                    this.xsOut.receiveLCRCallback((XStreamLCRCallbackHandler)eventHandler, 0);
                }
            }
            finally {
                if (this.xsOut != null) {
                    try {
                        XStreamOut xsOut = this.xsOut;
                        this.xsOut = null;
                        xsOut.detach(0);
                    }
                    catch (StreamsException e) {
                        LOGGER.error("Couldn't detach from XStream outbound server " + this.xStreamServerName, (Throwable)e);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.errorHandler.setProducerThrowable(e);
        }
    }

    public void commitOffset(Map<String, ?> offset) {
        if (this.xsOut != null) {
            LOGGER.debug("Sending message to request recording of offsets to Oracle");
            LcrPosition lcrPosition = LcrPosition.valueOf((String)offset.get("lcr_position"));
            Scn scn = OracleOffsetContext.getScnFromOffsetMapByKey(offset, "scn");
            this.sendPublishedPosition(lcrPosition, scn);
        }
    }

    private byte[] convertScnToPosition(Scn scn) {
        try {
            return XStreamUtility.convertSCNToPosition((NUMBER)new NUMBER(scn.toString(), 0), (int)this.posVersion);
        }
        catch (SQLException | StreamsException e) {
            throw new RuntimeException(e);
        }
    }

    XStreamOut getXsOut() {
        return this.xsOut;
    }

    private void sendPublishedPosition(LcrPosition lcrPosition, Scn scn) {
        this.lcrMessage.set(new PositionAndScn(lcrPosition, scn != null ? this.convertScnToPosition(scn) : null));
    }

    PositionAndScn receivePublishedPosition() {
        return this.lcrMessage.getAndSet(null);
    }

    private static int resolvePosVersion(OracleConnection connection, OracleConnectorConfig connectorConfig) {
        String oracleVersion = connectorConfig.getOracleVersion();
        if (!Strings.isNullOrEmpty((String)oracleVersion)) {
            if ("11".equals(oracleVersion)) {
                return 1;
            }
            return 2;
        }
        OracleDatabaseVersion databaseVersion = connection.getOracleVersion();
        if (databaseVersion.getMajor() == 11) {
            return 1;
        }
        return 2;
    }

    public static class PositionAndScn {
        public final LcrPosition position;
        public final byte[] scn;

        public PositionAndScn(LcrPosition position, byte[] scn) {
            this.position = position;
            this.scn = scn;
        }
    }
}

