/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.connector.oracle.antlr.OracleDmlParser;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.parser.DmlParser;
import io.debezium.connector.oracle.logminer.parser.DmlParserException;
import io.debezium.connector.oracle.logminer.parser.SimpleDmlParser;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValue;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntry;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.Envelope;
import io.debezium.doc.FixFor;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.util.IoUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.connect.data.Struct;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class OracleDmlParserTest {
    private OracleDdlParser ddlParser;
    private OracleDmlParser antlrDmlParser;
    private SimpleDmlParser sqlDmlParser;
    private Tables tables;
    private static final String TABLE_NAME = "TEST";
    private static final String CATALOG_NAME = "ORCLPDB1";
    private static final String SCHEMA_NAME = "DEBEZIUM";
    private static final String FULL_TABLE_NAME = "DEBEZIUM\".\"TEST";
    private static final TableId TABLE_ID = TableId.parse((String)"ORCLPDB1.DEBEZIUM.TEST");
    private static final String SPATIAL_DATA = "SDO_GEOMETRY(2003, NULL, NULL, SDO_ELEM_INFO_ARRAY(1, 1003, 1), SDO_ORDINATE_ARRAY(102604.878, 85772.8286, 101994.879, 85773.6633, 101992.739, 84209.6648, 102602.738, 84208.83, 102604.878, 85772.8286))";
    private static final String SPATIAL_DATA_1 = "'unsupported type'";
    private static String CLOB_DATA;
    private static byte[] BLOB_DATA;
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    @Before
    public void setUp() {
        OracleValueConverters converters = new OracleValueConverters(new OracleConnectorConfig(TestHelper.defaultConfig().build()), null);
        this.ddlParser = new OracleDdlParser(true, CATALOG_NAME, SCHEMA_NAME);
        this.antlrDmlParser = new OracleDmlParser(true, CATALOG_NAME, SCHEMA_NAME, converters);
        this.sqlDmlParser = new SimpleDmlParser(CATALOG_NAME, converters);
        this.tables = new Tables();
        CLOB_DATA = StringUtils.repeat((String)"clob_", (int)4000);
        String blobString = "blob_";
        BLOB_DATA = Arrays.copyOf(blobString.getBytes(), 8000);
    }

    @Test
    public void shouldParseAliasUpdate() throws Exception {
        String createStatement = IoUtil.read((InputStream)IoUtil.getResourceAsStream((String)"ddl/create_table.sql", null, this.getClass(), null, null));
        this.ddlParser.parse(createStatement, this.tables);
        String dml = "update \"DEBEZIUM\".\"TEST\" a set a.\"col1\" = '9', a.col2 = 'diFFerent', a.col3 = 'anotheR', a.col4 = '123', a.col6 = 5.2, a.col8 = TO_TIMESTAMP('2019-05-14 02:28:32.302000'), a.col10 = " + CLOB_DATA + ", a.col11 = null, a.col12 = '1', a.col7 = TO_DATE('2018-02-22 00:00:00', 'YYYY-MM-DD HH24:MI:SS'), a.col13 = TO_DATE('2018-02-22 00:00:00', 'YYYY-MM-DD HH24:MI:SS') where a.ID = 5 and a.COL1 = 6 and a.\"COL2\" = 'text' and a.COL3 = 'text' and a.COL4 IS NULL and a.\"COL5\" IS NULL and a.COL6 IS NULL and a.COL8 = TO_TIMESTAMP('2019-05-14 02:28:32.') and a.col11 is null;";
        this.antlrDmlParser.parse(dml, this.tables);
        LogMinerDmlEntry record = this.antlrDmlParser.getDmlEntry();
        this.verifyUpdate(record, false, true, 9);
        record = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "1");
        this.verifyUpdate(record, false, true, 9);
    }

    @Test
    public void shouldParseTimestampFormats() throws Exception {
        String createStatement = IoUtil.read((InputStream)IoUtil.getResourceAsStream((String)"ddl/create_table.sql", null, this.getClass(), null, null));
        this.ddlParser.parse(createStatement, this.tables);
        String format1 = "TO_TIMESTAMP('2020-09-22 00:09:37.302000')";
        String format2 = "TO_TIMESTAMP('2020-09-22 00:09:37.')";
        String format3 = "TO_TIMESTAMP('2020-09-22 00:09:37')";
        String format4 = "TO_TIMESTAMP('22-SEP-20 12.09.37 AM')";
        String format5 = "TO_TIMESTAMP('22-SEP-20 12.09.37 PM')";
        String format6 = "TO_TIMESTAMP('29-SEP-20 06.02.24.777000 PM')";
        String format7 = "TO_TIMESTAMP('2020-09-22 00:09:37.0')";
        this.parseTimestamp(format1, false);
        this.parseTimestamp(format2, true);
        this.parseTimestamp(format3, true);
        this.parseTimestamp(format4, true);
        this.parseTimestamp(format5, false);
        this.parseTimestamp(format6, false);
        this.parseTimestamp(format7, true);
    }

    @Test
    @FixFor(value={"DBZ-2784"})
    public void shouldParseDateFormats() throws Exception {
        String createStatement = IoUtil.read((InputStream)IoUtil.getResourceAsStream((String)"ddl/create_table.sql", null, this.getClass(), null, null));
        this.ddlParser.parse(createStatement, this.tables);
        String format1 = "TO_DATE('2018-02-22 00:00:00', 'YYYY-MM-DD HH24:MI:SS')";
        this.parseDate(format1, true);
    }

    private void parseDate(String format, boolean validateDate) {
        String dml = "update \"DEBEZIUM\".\"TEST\" a set a.\"col7\" = " + format + ", a.\"col13\" = " + format + " where a.ID = 1;";
        LogMinerDmlEntry record = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "1");
        Assertions.assertThat((Object)record).isNotNull();
        Assertions.assertThat((List)record.getNewValues()).isNotEmpty();
        Assertions.assertThat((List)record.getOldValues()).isNotEmpty();
        if (validateDate) {
            Assertions.assertThat((Object)((LogMinerColumnValue)record.getNewValues().get(7)).getColumnData()).isEqualTo((Object)1519257600000L);
            Assertions.assertThat((Object)((LogMinerColumnValue)record.getNewValues().get(13)).getColumnData()).isEqualTo((Object)1519257600000L);
        }
    }

    private void parseTimestamp(String format, boolean validateTimestamp) {
        String dml = "update \"DEBEZIUM\".\"TEST\" a set a.\"col1\" = '9', a.col2 = 'diFFerent', a.col3 = 'anotheR', a.col4 = '123', a.col6 = 5.2, a.col8 = " + format + ", a.col10 = " + CLOB_DATA + ", a.col11 = null, a.col12 = '1' where a.ID = 5 and a.COL1 = 6 and a.\"COL2\" = 'text' and a.COL3 = 'text' and a.COL4 IS NULL and a.\"COL5\" IS NULL and a.COL6 IS NULL and a.COL8 = " + format + " and a.col11 is null;";
        LogMinerDmlEntry record = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "1");
        Assertions.assertThat((List)record.getNewValues()).isNotEmpty();
        Assertions.assertThat((List)record.getOldValues()).isNotEmpty();
        if (validateTimestamp) {
            Assertions.assertThat((Object)((LogMinerColumnValue)record.getNewValues().get(8)).getColumnData()).isEqualTo((Object)1600733377000000L);
        }
    }

    @Test
    public void shouldParseAliasInsert() throws Exception {
        String createStatement = IoUtil.read((InputStream)IoUtil.getResourceAsStream((String)"ddl/create_table.sql", null, this.getClass(), null, null));
        this.ddlParser.parse(createStatement, this.tables);
        String dml = "insert into \"DEBEZIUM\".\"TEST\" a (a.\"ID\",a.\"COL1\",a.\"COL2\",a.\"COL3\",a.\"COL4\",a.\"COL5\",a.\"COL6\",a.\"COL8\",a.\"COL9\",a.\"COL10\",a.\"COL13\") values ('5','4','tExt','text',NULL,NULL,NULL,NULL,EMPTY_BLOB(),EMPTY_CLOB(),TO_DATE('2018-02-22 00:00:00', 'YYYY-MM-DD HH24:MI:SS'));";
        this.antlrDmlParser.parse(dml, this.tables);
        LogMinerDmlEntry record = this.antlrDmlParser.getDmlEntry();
        this.verifyInsert(record);
        record = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "1");
        this.verifyInsert(record);
    }

    @Test
    public void shouldParseAliasDelete() throws Exception {
        String createStatement = IoUtil.read((InputStream)IoUtil.getResourceAsStream((String)"ddl/create_table.sql", null, this.getClass(), null, null));
        this.ddlParser.parse(createStatement, this.tables);
        String dml = "delete from \"DEBEZIUM\".\"TEST\" a where a.\"id\" = 6 and a.\"col1\" = 2 and a.\"col2\" = 'text' and a.col3 = 'tExt' and a.col4 is null and a.col5 is null  and a.col6 is null and a.col8 is null and a.col9 is null and a.col10 is null and a.col11 is null and a.col12 is null";
        this.antlrDmlParser.parse(dml, this.tables);
        LogMinerDmlEntry record = this.antlrDmlParser.getDmlEntry();
        this.verifyDelete(record, true);
        record = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "1");
        this.verifyDelete(record, true);
    }

    @Test
    public void shouldParseNoWhereClause() throws Exception {
        String createStatement = IoUtil.read((InputStream)IoUtil.getResourceAsStream((String)"ddl/create_table.sql", null, this.getClass(), null, null));
        this.ddlParser.parse(createStatement, this.tables);
        String dml = "update \"DEBEZIUM\".\"TEST\" a set a.\"id\"=1, a.\"col1\" = '9', a.col2 = 'diFFerent', a.col3 = 'anotheR', a.col4 = '123', a.col5 = null, a.col6 = 5.2, a.col8 = TO_TIMESTAMP('2019-05-14 02:28:32.302000'), a.col9=null, a.col10 = " + CLOB_DATA + ", a.col11 = null, a.col12 = '1', a.col7 = TO_DATE('2018-02-22 00:00:00', 'YYYY-MM-DD HH24:MI:SS'), a.col13 = TO_DATE('2018-02-22 00:00:00', 'YYYY-MM-DD HH24:MI:SS')";
        this.antlrDmlParser.parse(dml, this.tables);
        LogMinerDmlEntry record = this.antlrDmlParser.getDmlEntry();
        this.verifyUpdate(record, false, false, 9);
        record = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "1");
        this.verifyUpdate(record, false, false, 9);
        dml = "delete from \"DEBEZIUM\".\"TEST\" a ";
        this.antlrDmlParser.parse(dml, this.tables);
        record = this.antlrDmlParser.getDmlEntry();
        this.verifyDelete(record, false);
        record = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "1");
        this.verifyDelete(record, false);
    }

    @Test
    public void shouldParseInsertAndDeleteTable() throws Exception {
        String createStatement = IoUtil.read((InputStream)IoUtil.getResourceAsStream((String)"ddl/create_table.sql", null, this.getClass(), null, null));
        this.ddlParser.parse(createStatement, this.tables);
        String dml = "insert into \"DEBEZIUM\".\"TEST\"(\"ID\",\"COL1\",\"COL2\",\"COL3\",\"COL4\",\"COL5\",\"COL6\",\"COL8\",\"COL9\",\"COL10\") values ('5','4','tExt','text',NULL,NULL,NULL,NULL,EMPTY_BLOB(),EMPTY_CLOB());";
        this.antlrDmlParser.parse(dml, this.tables);
        LogMinerDmlEntry record = this.antlrDmlParser.getDmlEntry();
        this.verifyInsert(record);
        record = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "1");
        this.verifyInsert(record);
        dml = "delete from \"DEBEZIUM\".\"TEST\" where id = 6 and col1 = 2 and col2 = 'text' and col3 = 'tExt' and col4 is null and col5 is null  and col6 is null and col8 is null and col9 is null and col10 is null and col11 is null and col12 is null";
        this.antlrDmlParser.parse(dml, this.tables);
        record = this.antlrDmlParser.getDmlEntry();
        this.verifyDelete(record, true);
        record = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "");
        this.verifyDelete(record, true);
    }

    @Test
    public void shouldParseUpdateTable() throws Exception {
        String createStatement = IoUtil.read((InputStream)IoUtil.getResourceAsStream((String)"ddl/create_table.sql", null, this.getClass(), null, null));
        this.ddlParser.parse(createStatement, this.tables);
        String dml = "update \"DEBEZIUM\".\"TEST\" set \"col1\" = '9', col2 = 'diFFerent', col3 = 'anotheR', col4 = '123', col6 = '5.2', col8 = TO_TIMESTAMP('2019-05-14 02:28:32.302000'), col10='clob_', col12 = '1' where ID = 5 and COL1 = 6 and \"COL2\" = 'text' and COL3 = 'text' and COL4 IS NULL and \"COL5\" IS NULL and COL6 IS NULL AND COL7 = TO_DATE('2018-02-22 00:00:00', 'YYYY-MM-DD HH24:MI:SS') and COL8 = TO_TIMESTAMP('2019-05-14 02:28:32') and col11 = SDO_GEOMETRY(2003, NULL, NULL, SDO_ELEM_INFO_ARRAY(1, 1003, 1), SDO_ORDINATE_ARRAY(102604.878, 85772.8286, 101994.879, 85773.6633, 101992.739, 84209.6648, 102602.738, 84208.83, 102604.878, 85772.8286)) and COL13 = TO_DATE('2018-02-22 00:00:00', 'YYYY-MM-DD HH24:MI:SS');";
        this.antlrDmlParser.parse(dml, this.tables);
        LogMinerDmlEntry record = this.antlrDmlParser.getDmlEntry();
        record = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "");
        this.verifyUpdate(record, true, true, 11);
        dml = "update \"DEBEZIUM\".\"TEST\" set \"col1\" = '9', col2 = '$2a$10$aHo.lQk.YAkGl5AkXbjJhODBqwNLkqF94slP5oZ3boNzm0d04WnE2', col3 = NULL, col4 = '123', col6 = '5.2', col8 = TO_TIMESTAMP('2019-05-14 02:28:32.302000'), col10='clob_', col12 = '1' where ID = 5 and COL1 = 6 and \"COL2\" = 'johan.philtjens@dpworld.com' and COL3 = 'text' and COL4 IS NULL and \"COL5\" IS NULL and COL6 IS NULL and COL8 = TO_TIMESTAMP('2019-05-14 02:28:32') and col11 = SDO_GEOMETRY(2003, NULL, NULL, SDO_ELEM_INFO_ARRAY(1, 1003, 1), SDO_ORDINATE_ARRAY(102604.878, 85772.8286, 101994.879, 85773.6633, 101992.739, 84209.6648, 102602.738, 84208.83, 102604.878, 85772.8286));";
        record = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "");
    }

    @Test
    public void shouldParseUpdateNoChangesTable() throws Exception {
        String createStatement = IoUtil.read((InputStream)IoUtil.getResourceAsStream((String)"ddl/create_table.sql", null, this.getClass(), null, null));
        this.ddlParser.parse(createStatement, this.tables);
        String dml = "update \"DEBEZIUM\".\"TEST\" set \"col1\" = '6', col2 = 'text', col3 = 'text', col4 = NULL where ID = 5 and COL1 = 6 and \"COL2\" = 'text' and COL3 = Unsupported Type and COL4 IS NULL and \"COL5\" IS NULL and COL6 IS NULL and COL7 IS NULL and COL9 IS NULL and COL10 IS NULL and COL12 IS NULL and COL8 = TO_TIMESTAMP('2019-05-14 02:28:32') and col11 = SDO_GEOMETRY(2003, NULL, NULL, SDO_ELEM_INFO_ARRAY(1, 1003, 1), SDO_ORDINATE_ARRAY(102604.878, 85772.8286, 101994.879, 85773.6633, 101992.739, 84209.6648, 102602.738, 84208.83, 102604.878, 85772.8286));";
        LogMinerDmlEntry record = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "");
        boolean pass = record.getCommandType().equals((Object)Envelope.Operation.UPDATE) && record.getOldValues().size() == record.getNewValues().size() && record.getNewValues().containsAll(record.getOldValues());
        Assertions.assertThat((boolean)pass);
        Assertions.assertThat((Object)((LogMinerColumnValue)record.getOldValues().get(4)).getColumnData()).isNull();
    }

    @Test
    public void shouldParseSpecialCharacters() throws Exception {
        String createStatement = IoUtil.read((InputStream)IoUtil.getResourceAsStream((String)"ddl/create_table.sql", null, this.getClass(), null, null));
        this.ddlParser.parse(createStatement, this.tables);
        String dml = "insert into \"DEBEZIUM\".\"TEST\"(\"ID\",\"COL1\",\"COL2\",\"COL3\",\"COL4\",\"COL5\",\"COL6\",\"COL8\",\"COL9\",\"COL10\") values ('5','4','\\','\\test',NULL,NULL,NULL,NULL,EMPTY_BLOB(),EMPTY_CLOB());";
        this.antlrDmlParser.parse(dml, this.tables);
        Assertions.assertThat((Object)this.antlrDmlParser.getDmlEntry()).isNotNull();
        LogMinerDmlEntry result = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "1");
        Assertions.assertThat((Object)result).isNotNull();
        LogMinerColumnValue value = (LogMinerColumnValue)result.getNewValues().get(2);
        Assertions.assertThat((String)value.getColumnData().toString()).contains("\\");
        dml = "delete from \"DEBEZIUM\".\"TEST\" where id = 6 and col1 = 2 and col2 = 'te\\xt' and col3 = 'tExt\\' and col4 is null and col5 is null  and col6 is null and col8 is null and col9 is null and col10 is null and col11 is null and col12 is null";
        this.antlrDmlParser.parse(dml, this.tables);
        Assertions.assertThat((Object)this.antlrDmlParser.getDmlEntry()).isNotNull();
        result = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "");
        Assertions.assertThat((Object)result).isNotNull();
        value = (LogMinerColumnValue)result.getOldValues().get(3);
        Assertions.assertThat((String)value.getColumnData().toString()).contains("\\");
    }

    @Test
    public void shouldParseStrangeDml() throws Exception {
        String createStatement = IoUtil.read((InputStream)IoUtil.getResourceAsStream((String)"ddl/create_table.sql", null, this.getClass(), null, null));
        this.ddlParser.parse(createStatement, this.tables);
        String dml = null;
        LogMinerDmlEntry result = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "");
        Assertions.assertThat((Object)result).isNull();
        dml = "select * from test;null;";
        this.assertDmlParserException(dml, (DmlParser)this.sqlDmlParser, this.tables.forTable(TABLE_ID), "");
        Assertions.assertThat((Object)result).isNull();
        dml = "full dummy mess";
        this.assertDmlParserException(dml, (DmlParser)this.sqlDmlParser, this.tables.forTable(TABLE_ID), "");
        dml = "delete from non_exiting_table  where id = 6 and col1 = 2 and col2 = 'te\\xt' and col3 = 'tExt\\' and col4 is null and col5 is null  and col6 is null and col8 is null and col9 is null and col10 is null and col11 is null and col12 is null";
        this.assertDmlParserException(dml, (DmlParser)this.sqlDmlParser, this.tables.forTable(TABLE_ID), "");
        Update update = (Update)Mockito.mock(Update.class);
        Mockito.when((Object)update.getTables()).thenReturn(new ArrayList());
        dml = "update  \"DEBEZIUM\".\"TEST\" set col1 = 3  where id = 6 and col1 = 2 and col2 = 'te\\xt' and col3 = 'tExt\\' and col4 is null and col5 is null  and col6 is null and col8 is null and col9 is null and col10 is null and col11 is null and col12 is null and col20 is null";
        result = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "");
        Assertions.assertThat((int)result.getOldValues().size()).isEqualTo(12);
        Assertions.assertThat((result.getOldValues().size() == 12 ? 1 : 0) != 0).isTrue();
        dml = "update \"DEBEZIUM\".\"TEST\" set col1 = 3  where id = 6 and col1 = 2 and col2 = 'te\\xt' and col30 = 'tExt\\' and col4 is null and col5 is null  and col6 is null and col8 is null and col9 is null and col10 is null and col11 is null and col21 is null";
        result = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "");
        Assertions.assertThat((int)result.getNewValues().size()).isEqualTo(14);
        dml = "update table1, \"DEBEZIUM\".\"TEST\" set col1 = 3  where id = 6 and col1 = 2 and col2 = 'te\\xt' and col3 = 'tExt\\' and col4 is null and col5 is null  and col6 is null and col8 is null and col9 is null and col10 is null and col11 is null and col12 is null and col20 is null";
        this.assertDmlParserException(dml, (DmlParser)this.sqlDmlParser, this.tables.forTable(TABLE_ID), "");
    }

    private void assertDmlParserException(String sql, DmlParser parser, Table table, String txId) {
        try {
            LogMinerDmlEntry logMinerDmlEntry = parser.parse(sql, table, txId);
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(DmlParserException.class);
        }
    }

    private void verifyUpdate(LogMinerDmlEntry record, boolean checkGeometry, boolean checkOldValues, int oldValuesNumber) {
        Assertions.assertThat((Object)record.getCommandType()).isEqualTo((Object)Envelope.Operation.UPDATE);
        List newValues = record.getNewValues();
        Assertions.assertThat((int)newValues.size()).isEqualTo(14);
        String concatenatedNames = newValues.stream().map(LogMinerColumnValue::getColumnName).collect(Collectors.joining());
        Assertions.assertThat((boolean)"IDCOL1COL2COL3COL4COL5COL6COL7COL8COL9COL10COL11COL12COL13".equals(concatenatedNames));
        for (LogMinerColumnValue newValue : newValues) {
            String columnName;
            switch (columnName = newValue.getColumnName()) {
                case "COL1": {
                    Assertions.assertThat((Object)newValue.getColumnData()).isEqualTo((Object)BigDecimal.valueOf(900L, 2));
                    break;
                }
                case "COL2": {
                    Assertions.assertThat((Object)newValue.getColumnData()).isEqualTo((Object)"diFFerent");
                    break;
                }
                case "COL3": {
                    Assertions.assertThat((Object)newValue.getColumnData()).isEqualTo((Object)"anotheR");
                    break;
                }
                case "COL4": {
                    Assertions.assertThat((Object)newValue.getColumnData()).isEqualTo((Object)"123");
                    break;
                }
                case "COL6": {
                    Assertions.assertThat((Object)((Struct)newValue.getColumnData()).get("scale")).isEqualTo((Object)1);
                    Assertions.assertThat((byte)((byte[])((Struct)newValue.getColumnData()).get("value"))[0]).isEqualTo((byte)52);
                    break;
                }
                case "COL7": 
                case "COL13": {
                    Assertions.assertThat((Object)newValue.getColumnData()).isInstanceOf(Long.class);
                    Assertions.assertThat((Object)newValue.getColumnData()).isEqualTo((Object)1519257600000L);
                    break;
                }
                case "COL8": {
                    Assertions.assertThat((Object)newValue.getColumnData()).isInstanceOf(Long.class);
                    Assertions.assertThat((Object)newValue.getColumnData()).isEqualTo((Object)1557800912302000L);
                    break;
                }
                case "COL10": {
                    Assertions.assertThat((Object)newValue.getColumnData()).isInstanceOf(String.class);
                    Assertions.assertThat((boolean)newValue.getColumnData().toString().contains("clob_")).isTrue();
                    break;
                }
                case "COL11": {
                    if (checkGeometry) {
                        Assertions.assertThat((Object)newValue.getColumnData()).isInstanceOf(String.class);
                        Assertions.assertThat((boolean)newValue.getColumnData().toString().contains("SDO_GEOMETRY")).isTrue();
                        break;
                    }
                    Assertions.assertThat((Object)newValue.getColumnData()).isNull();
                    break;
                }
                case "COL12": {
                    Assertions.assertThat((Object)newValue.getColumnData()).isInstanceOf(Byte.class);
                    Assertions.assertThat((Object)newValue.getColumnData()).isEqualTo((Object)Byte.valueOf("1"));
                }
            }
        }
        List oldValues = record.getOldValues();
        if (!checkOldValues) {
            Assertions.assertThat((int)oldValues.size()).isEqualTo(0);
        } else {
            Assertions.assertThat((int)oldValues.size()).isEqualTo(oldValuesNumber);
            concatenatedNames = oldValues.stream().map(LogMinerColumnValue::getColumnName).collect(Collectors.joining());
            Assertions.assertThat((boolean)"IDCOL1COL2COL3COL4COL6COL8COL11COL12".equals(concatenatedNames));
            for (LogMinerColumnValue oldValue : oldValues) {
                String columnName;
                switch (columnName = oldValue.getColumnName()) {
                    case "COL1": {
                        Assertions.assertThat((Object)oldValue.getColumnData()).isEqualTo((Object)BigDecimal.valueOf(600L, 2));
                        break;
                    }
                    case "COL2": {
                        Assertions.assertThat((Object)oldValue.getColumnData()).isEqualTo((Object)"text");
                        break;
                    }
                    case "COL3": {
                        Assertions.assertThat((Object)oldValue.getColumnData()).isEqualTo((Object)"text");
                        break;
                    }
                    case "COL4": {
                        Assertions.assertThat((Object)oldValue.getColumnData()).isNull();
                        break;
                    }
                    case "COL5": {
                        Assertions.assertThat((Object)oldValue.getColumnData()).isNull();
                        break;
                    }
                    case "COL6": {
                        Assertions.assertThat((Object)oldValue.getColumnData()).isNull();
                        break;
                    }
                    case "COL8": {
                        Assertions.assertThat((Object)oldValue.getColumnData()).isInstanceOf(Long.class);
                        Assertions.assertThat((Object)oldValue.getColumnData()).isEqualTo((Object)1557800912000000L);
                        break;
                    }
                    case "COL11": {
                        if (checkGeometry) {
                            Assertions.assertThat((Object)oldValue.getColumnData()).isInstanceOf(String.class);
                            Assertions.assertThat((boolean)oldValue.getColumnData().toString().contains("SDO_GEOMETRY")).isTrue();
                            break;
                        }
                        Assertions.assertThat((Object)oldValue.getColumnData()).isNull();
                        break;
                    }
                    case "ID": {
                        Assertions.assertThat((Object)oldValue.getColumnData()).isEqualTo((Object)new BigDecimal(5));
                    }
                }
            }
        }
    }

    private void verifyInsert(LogMinerDmlEntry record) {
        List oldValues = record.getOldValues();
        Assertions.assertThat((int)oldValues.size()).isEqualTo(0);
        Assertions.assertThat((Object)record.getCommandType()).isEqualTo((Object)Envelope.Operation.CREATE);
        List newValues = record.getNewValues();
        Assertions.assertThat((int)newValues.size()).isEqualTo(14);
        Iterator iterator = newValues.iterator();
        Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isEqualTo((Object)new BigDecimal(5));
        Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isEqualTo((Object)BigDecimal.valueOf(400L, 2));
        Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isEqualTo((Object)"tExt");
        Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isEqualTo((Object)"text");
        Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isNull();
    }

    private void verifyDelete(LogMinerDmlEntry record, boolean checkOldValues) {
        Assertions.assertThat((Object)record.getCommandType()).isEqualTo((Object)Envelope.Operation.DELETE);
        List newValues = record.getNewValues();
        Assertions.assertThat((int)newValues.size()).isEqualTo(0);
        List oldValues = record.getOldValues();
        if (!checkOldValues) {
            Assertions.assertThat((int)oldValues.size()).isEqualTo(0);
        } else {
            Assertions.assertThat((int)oldValues.size()).isEqualTo(14);
            String concatenatedColumnNames = oldValues.stream().map(LogMinerColumnValue::getColumnName).collect(Collectors.joining());
            Assertions.assertThat((boolean)"IDCOL1COL2COL3COL4COL5COL6COL8COL9COL10COL11COL12".equals(concatenatedColumnNames));
            Iterator iterator = oldValues.iterator();
            Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isEqualTo((Object)new BigDecimal(6));
            Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isEqualTo((Object)BigDecimal.valueOf(200L, 2));
            Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isEqualTo((Object)"text");
            Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isEqualTo((Object)"tExt");
            Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isNull();
            Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isNull();
            Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isNull();
            Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isNull();
            Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isNull();
            Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isNull();
            Assertions.assertThat((Object)((LogMinerColumnValue)iterator.next()).getColumnData()).isNull();
        }
    }
}

