/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.junit;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.junit.RequireDatabaseOption;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.junit.AnnotationBasedTestRule;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.Objects;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SkipTestDependingOnDatabaseOptionRule
extends AnnotationBasedTestRule {
    private static final String FALSE = "FALSE";

    public Statement apply(Statement base, Description description) {
        String optionValue;
        RequireDatabaseOption option = (RequireDatabaseOption)this.hasAnnotation(description, RequireDatabaseOption.class);
        if (Objects.nonNull(option) && (Strings.isNullOrEmpty((String)(optionValue = this.getDatabaseOptionValue(option.value()))) || FALSE.equals(optionValue))) {
            return SkipTestDependingOnDatabaseOptionRule.emptyStatement((String)("Database option '" + optionValue + "' not available"), (Description)description);
        }
        return base;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDatabaseOptionValue(String option) {
        try (OracleConnection connection = TestHelper.testConnection();){
            String string = (String)connection.queryAndMap("SELECT VALUE FROM V$OPTION WHERE PARAMETER='" + option + "'", rs -> {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return null;
            });
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to resolve database option " + option, e);
        }
    }
}

