/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.AbstractOracleDatatypesTest;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public class SnapshotDatatypesIT
extends AbstractOracleDatatypesTest {
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws SQLException {
        AbstractOracleDatatypesTest.beforeClass();
        SnapshotDatatypesIT.createTables();
        SnapshotDatatypesIT.insertStringTypes();
        SnapshotDatatypesIT.insertFpTypes();
        SnapshotDatatypesIT.insertIntTypes();
        SnapshotDatatypesIT.insertTimeTypes();
    }

    @Before
    public void before() throws Exception {
        this.init(TemporalPrecisionMode.ADAPTIVE);
    }

    @Override
    protected void init(TemporalPrecisionMode temporalPrecisionMode) throws Exception {
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Debug.enable();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
        Configuration config = ((Configuration.Builder)this.connectorConfig().with(OracleConnectorConfig.TIME_PRECISION_MODE, (EnumeratedValue)temporalPrecisionMode)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        SnapshotDatatypesIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
    }

    @Override
    protected Configuration.Builder connectorConfig() {
        return (Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, this.getTableIncludeList());
    }

    private String getTableIncludeList() {
        switch (this.name.getMethodName()) {
            case "stringTypes": {
                return "debezium.type_string";
            }
            case "fpTypes": 
            case "fpTypesAsString": 
            case "fpTypesAsDouble": {
                return "debezium.type_fp";
            }
            case "intTypes": {
                return "debezium.type_int";
            }
            case "timeTypes": 
            case "timeTypesAsAdaptiveMicroseconds": 
            case "timeTypesAsConnect": {
                return "debezium.type_time";
            }
        }
        throw new IllegalArgumentException("Unexpected test method: " + this.name.getMethodName());
    }

    @Override
    protected boolean insertRecordsDuringTest() {
        return false;
    }
}

