/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.Scn;
import java.util.Objects;

public class LogFile {
    private final String fileName;
    private final Scn firstScn;
    private final Scn nextScn;
    private final boolean current;

    public LogFile(String fileName, Scn firstScn, Scn nextScn) {
        this(fileName, firstScn, nextScn, false);
    }

    public LogFile(String fileName, Scn firstScn, Scn nextScn, boolean current) {
        this.fileName = fileName;
        this.firstScn = firstScn;
        this.nextScn = nextScn;
        this.current = current;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Scn getFirstScn() {
        return this.firstScn;
    }

    public Scn getNextScn() {
        return this.isCurrent() ? Scn.MAX : this.nextScn;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public boolean isSameRange(LogFile other) {
        return Objects.equals(this.firstScn, other.getFirstScn()) && Objects.equals(this.nextScn, other.getNextScn());
    }

    public int hashCode() {
        return Objects.hash(this.firstScn, this.nextScn);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LogFile)) {
            return false;
        }
        return this.isSameRange((LogFile)obj);
    }
}

