/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class TransactionalBuffer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalBuffer.class);
    private final Map<String, Transaction> transactions = new HashMap<String, Transaction>();
    private final ErrorHandler errorHandler;
    private final Set<String> abandonedTransactionIds;
    private final Set<String> rolledBackTransactionIds;
    private final OracleStreamingChangeEventSourceMetrics streamingMetrics;
    private Scn lastCommittedScn;

    TransactionalBuffer(ErrorHandler errorHandler, OracleStreamingChangeEventSourceMetrics streamingMetrics) {
        this.errorHandler = errorHandler;
        this.lastCommittedScn = Scn.NULL;
        this.abandonedTransactionIds = new HashSet<String>();
        this.rolledBackTransactionIds = new HashSet<String>();
        this.streamingMetrics = streamingMetrics;
    }

    Set<String> getRolledBackTransactionIds() {
        return new HashSet<String>(this.rolledBackTransactionIds);
    }

    void registerCommitCallback(String transactionId, Scn scn, Instant changeTime, CommitCallback callback) {
        if (this.abandonedTransactionIds.contains(transactionId)) {
            LogMinerHelper.logWarn(this.streamingMetrics, "Captured DML for abandoned transaction {}, ignored", transactionId);
            return;
        }
        if (this.rolledBackTransactionIds.contains(transactionId)) {
            LogMinerHelper.logWarn(this.streamingMetrics, "Captured DML for rolled-back transaction {}, ignored", transactionId);
            return;
        }
        this.transactions.computeIfAbsent(transactionId, s -> new Transaction(scn));
        this.streamingMetrics.setActiveTransactions(this.transactions.size());
        this.streamingMetrics.incrementRegisteredDmlCount();
        this.streamingMetrics.calculateLagMetrics(changeTime);
        Transaction transaction = this.transactions.get(transactionId);
        if (transaction != null) {
            transaction.commitCallbacks.add(callback);
        }
    }

    boolean commit(String transactionId, Scn scn, OracleOffsetContext offsetContext, Timestamp timestamp, ChangeEventSource.ChangeEventSourceContext context, String debugMessage, EventDispatcher dispatcher) {
        Instant start = Instant.now();
        Transaction transaction = this.transactions.remove(transactionId);
        if (transaction == null) {
            return false;
        }
        Scn smallestScn = this.calculateSmallestScn();
        this.abandonedTransactionIds.remove(transactionId);
        if (offsetContext.getCommitScn() != null && offsetContext.getCommitScn().compareTo(scn) > 0 || this.lastCommittedScn.compareTo(scn) > 0) {
            LogMinerHelper.logWarn(this.streamingMetrics, "Transaction {} was already processed, ignore. Committed SCN in offset is {}, commit SCN of the transaction is {}, last committed SCN is {}", transactionId, offsetContext.getCommitScn(), scn, this.lastCommittedScn);
            this.streamingMetrics.setActiveTransactions(this.transactions.size());
            return false;
        }
        List commitCallbacks = transaction.commitCallbacks;
        LOGGER.trace("COMMIT, {}, smallest SCN: {}", (Object)debugMessage, (Object)smallestScn);
        this.commit(context, offsetContext, start, commitCallbacks, timestamp, smallestScn, scn, dispatcher);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(ChangeEventSource.ChangeEventSourceContext context, OracleOffsetContext offsetContext, Instant start, List<CommitCallback> commitCallbacks, Timestamp timestamp, Scn smallestScn, Scn scn, EventDispatcher<?> dispatcher) {
        try {
            int counter = commitCallbacks.size();
            for (CommitCallback callback : commitCallbacks) {
                if (!context.isRunning()) {
                    return;
                }
                callback.execute(timestamp, smallestScn, scn, --counter);
            }
            this.lastCommittedScn = Scn.valueOf(scn.longValue());
            if (!commitCallbacks.isEmpty()) {
                dispatcher.dispatchTransactionCommittedEvent((OffsetContext)offsetContext);
            }
        }
        catch (InterruptedException e) {
            LogMinerHelper.logError(this.streamingMetrics, "Thread interrupted during running", e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.errorHandler.setProducerThrowable((Throwable)e);
        }
        finally {
            this.streamingMetrics.incrementCommittedTransactions();
            this.streamingMetrics.setActiveTransactions(this.transactions.size());
            this.streamingMetrics.incrementCommittedDmlCount(commitCallbacks.size());
            this.streamingMetrics.setCommittedScn(scn);
            this.streamingMetrics.setOffsetScn(offsetContext.getScn());
            this.streamingMetrics.setLastCommitDuration(Duration.between(start, Instant.now()));
        }
    }

    boolean rollback(String transactionId, String debugMessage) {
        Transaction transaction = this.transactions.get(transactionId);
        if (transaction != null) {
            LOGGER.debug("Transaction rolled back: {}", (Object)debugMessage);
            this.transactions.remove(transactionId);
            this.abandonedTransactionIds.remove(transactionId);
            this.rolledBackTransactionIds.add(transactionId);
            this.streamingMetrics.setActiveTransactions(this.transactions.size());
            this.streamingMetrics.incrementRolledBackTransactions();
            this.streamingMetrics.addRolledBackTransactionId(transactionId);
            return true;
        }
        return false;
    }

    void abandonLongTransactions(Scn thresholdScn, OracleOffsetContext offsetContext) {
        LogMinerHelper.logWarn(this.streamingMetrics, "All transactions with first SCN <= {} will be abandoned, offset: {}", thresholdScn, offsetContext.getScn());
        Scn threshold = Scn.valueOf(thresholdScn.toString());
        Scn smallestScn = this.calculateSmallestScn();
        if (smallestScn == null) {
            return;
        }
        if (threshold.compareTo(smallestScn) < 0) {
            threshold = smallestScn;
        }
        Iterator<Map.Entry<String, Transaction>> iter = this.transactions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Transaction> transaction = iter.next();
            if (transaction.getValue().firstScn.compareTo(threshold) > 0) continue;
            LogMinerHelper.logWarn(this.streamingMetrics, "Following long running transaction {} will be abandoned and ignored: {} ", transaction.getKey(), transaction.getValue().toString());
            this.abandonedTransactionIds.add(transaction.getKey());
            iter.remove();
            this.streamingMetrics.addAbandonedTransactionId(transaction.getKey());
            this.streamingMetrics.setActiveTransactions(this.transactions.size());
        }
    }

    boolean isTransactionRegistered(String txId) {
        return this.transactions.get(txId) != null;
    }

    private Scn calculateSmallestScn() {
        Scn scn = this.transactions.isEmpty() ? null : this.transactions.values().stream().map(transaction -> ((Transaction)transaction).firstScn).min(Scn::compareTo).orElseThrow(() -> new DataException("Cannot calculate smallest SCN"));
        this.streamingMetrics.setOldestScn(scn == null ? Scn.valueOf(-1) : scn);
        return scn;
    }

    boolean isEmpty() {
        return this.transactions.isEmpty();
    }

    void setDatabaseTimeDifference(long difference) {
        this.streamingMetrics.setTimeDifference(difference);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.transactions.values().forEach(t -> result.append(t.toString()));
        return result.toString();
    }

    @Override
    public void close() {
        this.transactions.clear();
        if (this.streamingMetrics != null) {
            this.streamingMetrics.unregister(LOGGER);
        }
    }

    @NotThreadSafe
    private static final class Transaction {
        private final Scn firstScn;
        private Scn lastScn;
        private final List<CommitCallback> commitCallbacks;

        private Transaction(Scn firstScn) {
            this.firstScn = firstScn;
            this.commitCallbacks = new ArrayList<CommitCallback>();
            this.lastScn = firstScn;
        }

        public String toString() {
            return "Transaction{firstScn=" + this.firstScn + ", lastScn=" + this.lastScn + '}';
        }
    }

    public static interface CommitCallback {
        public void execute(Timestamp var1, Scn var2, Scn var3, int var4) throws InterruptedException;
    }
}

