/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr.listener;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.connector.oracle.antlr.OracleDmlParser;
import io.debezium.connector.oracle.antlr.listener.BaseDmlStringParserListener;
import io.debezium.connector.oracle.antlr.listener.ParserUtils;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValue;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValueWrapper;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntryImpl;
import io.debezium.data.Envelope;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.Column;
import io.debezium.text.ParsingException;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;

public class UpdateParserListener
extends BaseDmlStringParserListener {
    UpdateParserListener(String catalogName, String schemaName, OracleDmlParser parser) {
        super(catalogName, schemaName, parser);
    }

    @Override
    protected String getKey(Column column, int index) {
        return column.name();
    }

    public void enterUpdate_statement(PlSqlParser.Update_statementContext ctx) {
        this.init(ctx.general_table_ref().dml_table_expression_clause());
        this.isUpdate = true;
        super.enterUpdate_statement(ctx);
    }

    public void enterWhere_clause(PlSqlParser.Where_clauseContext ctx) {
        if (this.isUpdate) {
            this.parseRecursively(ctx.expression().logical_expression());
            ParserUtils.cloneOldToNewColumnValues(this.newColumnValues, this.oldColumnValues, this.table);
        }
        this.isUpdate = false;
        super.enterWhere_clause(ctx);
    }

    public void enterColumn_based_update_set_clause(PlSqlParser.Column_based_update_set_clauseContext ctx) {
        if (this.table == null) {
            throw new ParsingException(null, "Trying to parse a statement for a table which does not exist. Statement: " + AntlrDdlParser.getText((ParserRuleContext)ctx));
        }
        String columnName = ctx.column_name().getText().toUpperCase();
        String stripedName = ParserUtils.stripeAlias(columnName, this.alias);
        stripedName = ParserUtils.stripeQuotes(stripedName);
        String value = ctx.getText().substring(columnName.length() + 1);
        String nullValue = ctx.expression().getStop().getText();
        if ("null".equalsIgnoreCase(nullValue)) {
            value = nullValue;
        }
        String stripedValue = ParserUtils.removeApostrophes(value);
        Column column = this.table.columnWithName(stripedName);
        Object valueObject = ParserUtils.convertValueToSchemaType(column, stripedValue, this.converter);
        LogMinerColumnValueWrapper logMinerColumnValueWrapper = (LogMinerColumnValueWrapper)this.newColumnValues.get(stripedName);
        logMinerColumnValueWrapper.setProcessed(true);
        logMinerColumnValueWrapper.getColumnValue().setColumnData(valueObject);
        super.enterColumn_based_update_set_clause(ctx);
    }

    public void exitUpdate_statement(PlSqlParser.Update_statementContext ctx) {
        List<LogMinerColumnValue> actualNewValues = this.newColumnValues.values().stream().filter(LogMinerColumnValueWrapper::isProcessed).map(LogMinerColumnValueWrapper::getColumnValue).collect(Collectors.toList());
        List<LogMinerColumnValue> actualOldValues = this.oldColumnValues.values().stream().filter(LogMinerColumnValueWrapper::isProcessed).map(LogMinerColumnValueWrapper::getColumnValue).collect(Collectors.toList());
        LogMinerDmlEntryImpl newRecord = new LogMinerDmlEntryImpl(Envelope.Operation.UPDATE, actualNewValues, actualOldValues);
        this.parser.setDmlEntry(newRecord);
        super.exitUpdate_statement(ctx);
    }
}

