/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.HistoryRecorder;
import io.debezium.connector.oracle.logminer.LogMinerChangeRecordEmitter;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.RowMapper;
import io.debezium.connector.oracle.logminer.TransactionalBuffer;
import io.debezium.connector.oracle.logminer.parser.DmlParser;
import io.debezium.connector.oracle.logminer.parser.DmlParserException;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlParser;
import io.debezium.connector.oracle.logminer.parser.SimpleDmlParser;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntry;
import io.debezium.data.Envelope;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogMinerQueryResultProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerQueryResultProcessor.class);
    private final ChangeEventSource.ChangeEventSourceContext context;
    private final OracleStreamingChangeEventSourceMetrics streamingMetrics;
    private final TransactionalBuffer transactionalBuffer;
    private final DmlParser dmlParser;
    private final OracleOffsetContext offsetContext;
    private final OracleDatabaseSchema schema;
    private final EventDispatcher<TableId> dispatcher;
    private final OracleConnectorConfig connectorConfig;
    private final Clock clock;
    private final HistoryRecorder historyRecorder;
    private Scn currentOffsetScn = Scn.NULL;
    private Scn currentOffsetCommitScn = Scn.NULL;
    private long stuckScnCounter = 0L;

    LogMinerQueryResultProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleConnection jdbcConnection, OracleConnectorConfig connectorConfig, OracleStreamingChangeEventSourceMetrics streamingMetrics, TransactionalBuffer transactionalBuffer, OracleOffsetContext offsetContext, OracleDatabaseSchema schema, EventDispatcher<TableId> dispatcher, Clock clock, HistoryRecorder historyRecorder) {
        this.context = context;
        this.streamingMetrics = streamingMetrics;
        this.transactionalBuffer = transactionalBuffer;
        this.offsetContext = offsetContext;
        this.schema = schema;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.historyRecorder = historyRecorder;
        this.connectorConfig = connectorConfig;
        this.dmlParser = LogMinerQueryResultProcessor.resolveParser(connectorConfig, jdbcConnection);
    }

    private static DmlParser resolveParser(OracleConnectorConfig connectorConfig, OracleConnection connection) {
        if (connectorConfig.getLogMiningDmlParser().equals((Object)OracleConnectorConfig.LogMiningDmlParser.LEGACY)) {
            OracleValueConverters converter = new OracleValueConverters(connectorConfig, connection);
            return new SimpleDmlParser(connectorConfig.getCatalogName(), converter);
        }
        return new LogMinerDmlParser();
    }

    int processResult(ResultSet resultSet) {
        int dmlCounter = 0;
        int insertCounter = 0;
        int updateCounter = 0;
        int deleteCounter = 0;
        int commitCounter = 0;
        int rollbackCounter = 0;
        long rows = 0L;
        Instant startTime = Instant.now();
        while (this.context.isRunning()) {
            try {
                Instant rsNextStart = Instant.now();
                if (!resultSet.next()) break;
                ++rows;
                this.streamingMetrics.addCurrentResultSetNext(Duration.between(rsNextStart, Instant.now()));
            }
            catch (SQLException e) {
                LogMinerHelper.logError(this.streamingMetrics, "Closed resultSet", new Object[0]);
                return 0;
            }
            Scn scn = RowMapper.getScn(this.streamingMetrics, resultSet);
            String tableName = RowMapper.getTableName(this.streamingMetrics, resultSet);
            String segOwner = RowMapper.getSegOwner(this.streamingMetrics, resultSet);
            int operationCode = RowMapper.getOperationCode(this.streamingMetrics, resultSet);
            Timestamp changeTime = RowMapper.getChangeTime(this.streamingMetrics, resultSet);
            String txId = RowMapper.getTransactionId(this.streamingMetrics, resultSet);
            String operation = RowMapper.getOperation(this.streamingMetrics, resultSet);
            String userName = RowMapper.getUsername(this.streamingMetrics, resultSet);
            boolean isDml = false;
            if (operationCode == 1 || operationCode == 3 || operationCode == 2) {
                isDml = true;
            }
            String redoSql = RowMapper.getSqlRedo(this.streamingMetrics, resultSet, isDml, this.historyRecorder, scn, tableName, segOwner, operationCode, changeTime, txId);
            LOGGER.trace("scn={}, operationCode={}, operation={}, table={}, segOwner={}, userName={}", new Object[]{scn, operationCode, operation, tableName, segOwner, userName});
            String logMessage = String.format("transactionId=%s, SCN=%s, table_name=%s, segOwner=%s, operationCode=%s, offsetSCN=%s,  commitOffsetSCN=%s", txId, scn, tableName, segOwner, operationCode, this.offsetContext.getScn(), this.offsetContext.getCommitScn());
            if (scn == null) {
                LogMinerHelper.logWarn(this.streamingMetrics, "Scn is null for {}", logMessage);
                return 0;
            }
            if (operationCode == 7) {
                if (this.transactionalBuffer.isTransactionRegistered(txId)) {
                    this.historyRecorder.record(scn, tableName, segOwner, operationCode, changeTime, txId, 0, redoSql);
                }
                if (!this.transactionalBuffer.commit(txId, scn, this.offsetContext, changeTime, this.context, logMessage, this.dispatcher)) continue;
                LOGGER.trace("COMMIT, {}", (Object)logMessage);
                ++commitCounter;
                continue;
            }
            if (operationCode == 36) {
                if (this.transactionalBuffer.isTransactionRegistered(txId)) {
                    this.historyRecorder.record(scn, tableName, segOwner, operationCode, changeTime, txId, 0, redoSql);
                }
                if (!this.transactionalBuffer.rollback(txId, logMessage)) continue;
                LOGGER.trace("ROLLBACK, {}", (Object)logMessage);
                ++rollbackCounter;
                continue;
            }
            if (operationCode == 5) {
                this.historyRecorder.record(scn, tableName, segOwner, operationCode, changeTime, txId, 0, redoSql);
                LOGGER.info("DDL: {}, REDO_SQL: {}", (Object)logMessage, (Object)redoSql);
                continue;
            }
            if (operationCode == 34) {
                this.historyRecorder.record(scn, tableName, segOwner, operationCode, changeTime, txId, 0, redoSql);
                LogMinerHelper.logWarn(this.streamingMetrics, "Missing SCN,  {}", logMessage);
                continue;
            }
            if (operationCode != 1 && operationCode != 2 && operationCode != 3) continue;
            TableId tableId = RowMapper.getTableId(this.connectorConfig.getCatalogName(), resultSet);
            LOGGER.trace("DML,  {}, sql {}", (Object)logMessage, (Object)redoSql);
            if (redoSql == null) {
                LOGGER.trace("Redo SQL was empty, DML operation skipped.");
                continue;
            }
            ++dmlCounter;
            switch (operationCode) {
                case 1: {
                    ++insertCounter;
                    break;
                }
                case 3: {
                    ++updateCounter;
                    break;
                }
                case 2: {
                    ++deleteCounter;
                }
            }
            Table table = this.schema.tableFor(tableId);
            if (table == null) {
                LogMinerHelper.logWarn(this.streamingMetrics, "DML for table '{}' that is not known to this connector, skipping.", tableId);
                continue;
            }
            LogMinerDmlEntry dmlEntry = this.parse(redoSql, table, txId);
            dmlEntry.setObjectOwner(segOwner);
            dmlEntry.setSourceTime(changeTime);
            dmlEntry.setTransactionId(txId);
            dmlEntry.setObjectName(tableName);
            dmlEntry.setScn(scn);
            try {
                this.transactionalBuffer.registerCommitCallback(txId, scn, changeTime.toInstant(), (timestamp, smallestScn, commitScn, counter) -> {
                    if (smallestScn == null || scn.compareTo(smallestScn) < 0) {
                        this.offsetContext.setScn(scn);
                        this.streamingMetrics.setOldestScn(scn);
                    }
                    this.offsetContext.setTransactionId(txId);
                    this.offsetContext.setSourceTime(timestamp.toInstant());
                    this.offsetContext.setTableId(tableId);
                    if (counter == 0) {
                        this.offsetContext.setCommitScn(commitScn);
                    }
                    LOGGER.trace("Processing DML event {} scn {}", (Object)dmlEntry.toString(), (Object)scn);
                    this.dispatcher.dispatchDataChangeEvent((DataCollectionId)tableId, (ChangeRecordEmitter)new LogMinerChangeRecordEmitter(this.offsetContext, dmlEntry, this.schema.tableFor(tableId), this.clock));
                });
            }
            catch (Exception e) {
                LogMinerHelper.logError(this.streamingMetrics, "Following dmlEntry: {} cannot be dispatched due to the : {}", dmlEntry, e);
            }
        }
        Duration totalTime = Duration.between(startTime, Instant.now());
        if (dmlCounter > 0 || commitCounter > 0 || rollbackCounter > 0) {
            this.streamingMetrics.setLastCapturedDmlCount(dmlCounter);
            this.streamingMetrics.setLastDurationOfBatchProcessing(totalTime);
            this.warnStuckScn();
            this.currentOffsetScn = this.offsetContext.getScn();
            if (this.offsetContext.getCommitScn() != null) {
                this.currentOffsetCommitScn = this.offsetContext.getCommitScn();
            }
        }
        LOGGER.debug("{} Rows, {} DMLs, {} Commits, {} Rollbacks, {} Inserts, {} Updates, {} Deletes. Processed in {} millis. Lag:{}. Offset scn:{}. Offset commit scn:{}. Active transactions:{}. Sleep time:{}", new Object[]{rows, dmlCounter, commitCounter, rollbackCounter, insertCounter, updateCounter, deleteCounter, totalTime.toMillis(), this.streamingMetrics.getLagFromSourceInMilliseconds(), this.offsetContext.getScn(), this.offsetContext.getCommitScn(), this.streamingMetrics.getNumberOfActiveTransactions(), this.streamingMetrics.getMillisecondToSleepBetweenMiningQuery()});
        this.streamingMetrics.addProcessedRows(rows);
        this.historyRecorder.flush();
        return dmlCounter;
    }

    private void warnStuckScn() {
        if (this.offsetContext != null && this.offsetContext.getCommitScn() != null) {
            Scn scn = this.offsetContext.getScn();
            Scn commitScn = this.offsetContext.getCommitScn();
            if (this.currentOffsetScn.equals(scn) && !this.currentOffsetCommitScn.equals(commitScn)) {
                ++this.stuckScnCounter;
                if (this.stuckScnCounter == 25L) {
                    LogMinerHelper.logWarn(this.streamingMetrics, "Offset SCN {} is not changing. It indicates long transaction(s). Offset commit SCN: {}", this.currentOffsetScn, commitScn);
                    this.streamingMetrics.incrementScnFreezeCount();
                }
            } else {
                this.stuckScnCounter = 0L;
            }
        }
    }

    private LogMinerDmlEntry parse(String redoSql, Table table, String txId) {
        LogMinerDmlEntry dmlEntry;
        try {
            Instant parseStart = Instant.now();
            dmlEntry = this.dmlParser.parse(redoSql, table, txId);
            this.streamingMetrics.addCurrentParseTime(Duration.between(parseStart, Instant.now()));
        }
        catch (DmlParserException e) {
            StringBuilder message = new StringBuilder();
            message.append("DML statement couldn't be parsed.");
            message.append(" Please open a Jira issue with the statement '").append(redoSql).append("'.");
            if (OracleConnectorConfig.LogMiningDmlParser.FAST.equals((Object)this.connectorConfig.getLogMiningDmlParser())) {
                message.append(" You can set internal.log.mining.dml.parser='legacy' as a workaround until the parse error is fixed.");
            }
            throw new DmlParserException(message.toString(), (Throwable)((Object)e));
        }
        if (dmlEntry.getOldValues().isEmpty() && (Envelope.Operation.UPDATE.equals((Object)dmlEntry.getCommandType()) || Envelope.Operation.DELETE.equals((Object)dmlEntry.getCommandType()))) {
            LOGGER.warn("The DML event '{}' contained no before state.", (Object)redoSql);
            this.streamingMetrics.incrementWarningCount();
        }
        return dmlEntry;
    }
}

