/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.parser.SimpleDmlParser;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValue;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValueImpl;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValueWrapper;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntryImpl;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.Envelope;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.util.IoUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class ValueHolderTest {
    private static final Scn SCN_ONE = new Scn(BigInteger.ONE);
    private static final String TABLE_NAME = "TEST";
    private static final String CATALOG_NAME = "CATALOG";
    private static final String SCHEMA_NAME = "DEBEZIUM";
    private OracleDdlParser ddlParser;
    private SimpleDmlParser sqlDmlParser;
    private Tables tables;
    private static final String FULL_TABLE_NAME = "DEBEZIUM\".\"TEST";
    private static final TableId TABLE_ID = TableId.parse((String)"CATALOG.DEBEZIUM.TEST");
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    @Before
    public void setUp() {
        OracleValueConverters converters = new OracleValueConverters(new OracleConnectorConfig(TestHelper.defaultConfig().build()), null);
        this.ddlParser = new OracleDdlParser(true, CATALOG_NAME, SCHEMA_NAME);
        this.sqlDmlParser = new SimpleDmlParser(CATALOG_NAME, converters);
        this.tables = new Tables();
    }

    @Test
    public void testValueHolders() throws Exception {
        LogMinerColumnValueImpl column1 = new LogMinerColumnValueImpl("COLUMN1", 2);
        Assertions.assertThat((boolean)column1.equals(column1)).isTrue();
        Assertions.assertThat((boolean)column1.equals(null)).isFalse();
        Assertions.assertThat((boolean)new LogMinerColumnValueWrapper((LogMinerColumnValue)column1).isProcessed()).isFalse();
        column1.setColumnData((Object)new BigDecimal(5));
        LogMinerColumnValueImpl column2 = new LogMinerColumnValueImpl("COLUMN2", 12);
        column2.setColumnData((Object)"Text");
        ArrayList<LogMinerColumnValueImpl> newValues = new ArrayList<LogMinerColumnValueImpl>();
        newValues.add(column1);
        newValues.add(column2);
        LogMinerDmlEntryImpl dmlEntryExpected = new LogMinerDmlEntryImpl(Envelope.Operation.CREATE, newValues, Collections.emptyList());
        dmlEntryExpected.setTransactionId("transaction_id");
        dmlEntryExpected.setObjectName(TABLE_NAME);
        dmlEntryExpected.setObjectOwner(SCHEMA_NAME);
        dmlEntryExpected.setScn(SCN_ONE);
        dmlEntryExpected.setSourceTime(new Timestamp(1000L));
        String createStatement = IoUtil.read((InputStream)IoUtil.getResourceAsStream((String)"ddl/create_small_table.sql", null, this.getClass(), null, null));
        this.ddlParser.parse(createStatement, this.tables);
        String dml = "insert into \"DEBEZIUM\".\"TEST\"  (\"column1\",\"column2\") values ('5','Text');";
        LogMinerDmlEntry dmlEntryParsed = this.sqlDmlParser.parse(dml, this.tables.forTable(TABLE_ID), "1");
        Assertions.assertThat((boolean)dmlEntryParsed.equals(dmlEntryExpected)).isTrue();
        Assertions.assertThat((dmlEntryExpected.getCommandType() == Envelope.Operation.CREATE ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((boolean)dmlEntryExpected.getScn().equals((Object)SCN_ONE)).isTrue();
        Assertions.assertThat((boolean)dmlEntryExpected.getSourceTime().equals(new Timestamp(1000L))).isTrue();
        Assertions.assertThat((boolean)dmlEntryExpected.getTransactionId().equals("transaction_id")).isTrue();
        Assertions.assertThat((boolean)dmlEntryExpected.getObjectOwner().equals(SCHEMA_NAME)).isTrue();
        Assertions.assertThat((boolean)dmlEntryExpected.getObjectName().equals(TABLE_NAME)).isTrue();
        Assertions.assertThat((boolean)dmlEntryExpected.equals(null)).isFalse();
        Assertions.assertThat((boolean)dmlEntryExpected.equals((Object)dmlEntryExpected)).isTrue();
    }
}

