/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.doc.FixFor;
import io.debezium.relational.TableId;
import java.io.IOException;
import java.sql.SQLRecoverableException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Iterator;
import org.fest.assertions.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class SqlUtilsTest {
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();
    private static final String LOG_MINER_CONTENT_QUERY_TEMPLATE = "SELECT SCN, SQL_REDO, OPERATION_CODE, TIMESTAMP, XID, CSF, TABLE_NAME, SEG_OWNER, OPERATION, USERNAME FROM V$LOGMNR_CONTENTS WHERE SCN > ? AND SCN <= ? AND ((OPERATION_CODE IN (5,34) AND USERNAME NOT IN ('SYS','SYSTEM','${user}')) OR (OPERATION_CODE IN (7,36)) OR (OPERATION_CODE IN (1,2,3) AND TABLE_NAME != 'LOG_MINING_FLUSH' ${systemTablePredicate}${schemaPredicate}${tablePredicate}))";
    private static final String USERNAME = "USERNAME";

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithNoFilters() {
        OracleConnectorConfig config = (OracleConnectorConfig)Mockito.mock(OracleConnectorConfig.class);
        Mockito.when((Object)config.schemaIncludeList()).thenReturn(null);
        Mockito.when((Object)config.schemaExcludeList()).thenReturn(null);
        Mockito.when((Object)config.tableIncludeList()).thenReturn(null);
        Mockito.when((Object)config.tableExcludeList()).thenReturn(null);
        String result = SqlUtils.logMinerContentsQuery((OracleConnectorConfig)config, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(null, null));
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithSchemaInclude() {
        OracleConnectorConfig config = (OracleConnectorConfig)Mockito.mock(OracleConnectorConfig.class);
        Mockito.when((Object)config.schemaIncludeList()).thenReturn((Object)"SCHEMA1,SCHEMA2");
        Mockito.when((Object)config.schemaExcludeList()).thenReturn(null);
        Mockito.when((Object)config.tableIncludeList()).thenReturn(null);
        Mockito.when((Object)config.tableExcludeList()).thenReturn(null);
        String schema = "AND (REGEXP_LIKE(SEG_OWNER,'^SCHEMA1$','i') OR REGEXP_LIKE(SEG_OWNER,'^SCHEMA2$','i')) ";
        String result = SqlUtils.logMinerContentsQuery((OracleConnectorConfig)config, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(schema, null));
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithSchemaExclude() {
        OracleConnectorConfig config = (OracleConnectorConfig)Mockito.mock(OracleConnectorConfig.class);
        Mockito.when((Object)config.schemaIncludeList()).thenReturn(null);
        Mockito.when((Object)config.schemaExcludeList()).thenReturn((Object)"SCHEMA1,SCHEMA2");
        Mockito.when((Object)config.tableIncludeList()).thenReturn(null);
        Mockito.when((Object)config.tableExcludeList()).thenReturn(null);
        String schema = "AND (NOT REGEXP_LIKE(SEG_OWNER,'^SCHEMA1$','i') AND NOT REGEXP_LIKE(SEG_OWNER,'^SCHEMA2$','i')) ";
        String result = SqlUtils.logMinerContentsQuery((OracleConnectorConfig)config, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(schema, null));
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithTableInclude() {
        OracleConnectorConfig config = (OracleConnectorConfig)Mockito.mock(OracleConnectorConfig.class);
        Mockito.when((Object)config.schemaIncludeList()).thenReturn(null);
        Mockito.when((Object)config.schemaExcludeList()).thenReturn(null);
        Mockito.when((Object)config.tableIncludeList()).thenReturn((Object)"DEBEZIUM\\.TABLEA,DEBEZIUM\\.TABLEB");
        Mockito.when((Object)config.tableExcludeList()).thenReturn(null);
        String table = "AND (REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEA$','i') OR REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEB$','i')) ";
        String result = SqlUtils.logMinerContentsQuery((OracleConnectorConfig)config, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(null, table));
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithTableExcludes() {
        OracleConnectorConfig config = (OracleConnectorConfig)Mockito.mock(OracleConnectorConfig.class);
        Mockito.when((Object)config.schemaIncludeList()).thenReturn(null);
        Mockito.when((Object)config.schemaExcludeList()).thenReturn(null);
        Mockito.when((Object)config.tableIncludeList()).thenReturn(null);
        Mockito.when((Object)config.tableExcludeList()).thenReturn((Object)"DEBEZIUM\\.TABLEA,DEBEZIUM\\.TABLEB");
        String table = "AND (NOT REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEA$','i') AND NOT REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEB$','i')) ";
        String result = SqlUtils.logMinerContentsQuery((OracleConnectorConfig)config, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(null, table));
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithSchemaTableIncludes() {
        OracleConnectorConfig config = (OracleConnectorConfig)Mockito.mock(OracleConnectorConfig.class);
        Mockito.when((Object)config.schemaIncludeList()).thenReturn((Object)"SCHEMA1,SCHEMA2");
        Mockito.when((Object)config.schemaExcludeList()).thenReturn(null);
        Mockito.when((Object)config.tableIncludeList()).thenReturn((Object)"DEBEZIUM\\.TABLEA,DEBEZIUM\\.TABLEB");
        Mockito.when((Object)config.tableExcludeList()).thenReturn(null);
        String schema = "AND (REGEXP_LIKE(SEG_OWNER,'^SCHEMA1$','i') OR REGEXP_LIKE(SEG_OWNER,'^SCHEMA2$','i')) ";
        String table = "AND (REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEA$','i') OR REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEB$','i')) ";
        String result = SqlUtils.logMinerContentsQuery((OracleConnectorConfig)config, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(schema, table));
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithSchemaTableExcludes() {
        OracleConnectorConfig config = (OracleConnectorConfig)Mockito.mock(OracleConnectorConfig.class);
        Mockito.when((Object)config.schemaIncludeList()).thenReturn(null);
        Mockito.when((Object)config.schemaExcludeList()).thenReturn((Object)"SCHEMA1,SCHEMA2");
        Mockito.when((Object)config.tableIncludeList()).thenReturn(null);
        Mockito.when((Object)config.tableExcludeList()).thenReturn((Object)"DEBEZIUM\\.TABLEA,DEBEZIUM\\.TABLEB");
        String schema = "AND (NOT REGEXP_LIKE(SEG_OWNER,'^SCHEMA1$','i') AND NOT REGEXP_LIKE(SEG_OWNER,'^SCHEMA2$','i')) ";
        String table = "AND (NOT REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEA$','i') AND NOT REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEB$','i')) ";
        String result = SqlUtils.logMinerContentsQuery((OracleConnectorConfig)config, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(schema, table));
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void testLogMinerQueryWithSchemaExcludeTableInclude() {
        OracleConnectorConfig config = (OracleConnectorConfig)Mockito.mock(OracleConnectorConfig.class);
        Mockito.when((Object)config.schemaIncludeList()).thenReturn(null);
        Mockito.when((Object)config.schemaExcludeList()).thenReturn((Object)"SCHEMA1,SCHEMA2");
        Mockito.when((Object)config.tableIncludeList()).thenReturn((Object)"DEBEZIUM\\.TABLEA,DEBEZIUM\\.TABLEB");
        Mockito.when((Object)config.tableExcludeList()).thenReturn(null);
        String schema = "AND (NOT REGEXP_LIKE(SEG_OWNER,'^SCHEMA1$','i') AND NOT REGEXP_LIKE(SEG_OWNER,'^SCHEMA2$','i')) ";
        String table = "AND (REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEA$','i') OR REGEXP_LIKE(SEG_OWNER || '.' || TABLE_NAME,'^DEBEZIUM\\.TABLEB$','i')) ";
        String result = SqlUtils.logMinerContentsQuery((OracleConnectorConfig)config, (String)USERNAME);
        Assertions.assertThat((String)result).isEqualTo((Object)this.resolveLogMineryContentQueryFromTemplate(schema, table));
    }

    @Test
    public void testStatements() {
        SqlUtils.setRac((boolean)false);
        String result = SqlUtils.addLogFileStatement((String)"ADD", (String)"FILENAME");
        String expected = "BEGIN sys.dbms_logmnr.add_logfile(LOGFILENAME => 'FILENAME', OPTIONS => ADD);END;";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.databaseSupplementalLoggingMinCheckQuery();
        expected = "SELECT 'KEY', SUPPLEMENTAL_LOG_DATA_MIN FROM V$DATABASE";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.tableSupplementalLoggingCheckQuery((TableId)new TableId(null, "s", "t"));
        expected = "SELECT 'KEY', LOG_GROUP_TYPE FROM ALL_LOG_GROUPS WHERE OWNER = 's' AND TABLE_NAME = 't'";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.startLogMinerStatement((Scn)Scn.valueOf((long)10L), (Scn)Scn.valueOf((long)20L), (OracleConnectorConfig.LogMiningStrategy)OracleConnectorConfig.LogMiningStrategy.ONLINE_CATALOG, (boolean)true);
        expected = "BEGIN sys.dbms_logmnr.start_logmnr(startScn => '10', endScn => '20', OPTIONS => DBMS_LOGMNR.DICT_FROM_ONLINE_CATALOG  + DBMS_LOGMNR.CONTINUOUS_MINE  + DBMS_LOGMNR.NO_ROWID_IN_STMT);END;";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.startLogMinerStatement((Scn)Scn.valueOf((long)10L), (Scn)Scn.valueOf((long)20L), (OracleConnectorConfig.LogMiningStrategy)OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO, (boolean)false);
        expected = "BEGIN sys.dbms_logmnr.start_logmnr(startScn => '10', endScn => '20', OPTIONS => DBMS_LOGMNR.DICT_FROM_REDO_LOGS + DBMS_LOGMNR.DDL_DICT_TRACKING  + DBMS_LOGMNR.NO_ROWID_IN_STMT);END;";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.truncateTableStatement((String)"table_name");
        expected = "TRUNCATE TABLE table_name";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.diffInDaysQuery((Scn)Scn.valueOf((long)123L));
        expected = "select sysdate - CAST(scn_to_timestamp(123) as date) from dual";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.diffInDaysQuery(null);
        Assertions.assertThat((String)result).isNull();
        result = SqlUtils.bulkHistoryInsertStmt((String)"table_name");
        expected = "INSERT  /*+ APPEND */ INTO table_name SELECT * FROM LOG_MINING_TEMP";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.redoLogStatusQuery();
        expected = "SELECT F.MEMBER, R.STATUS FROM V$LOGFILE F, V$LOG R WHERE F.GROUP# = R.GROUP# ORDER BY 2";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.switchHistoryQuery();
        expected = "SELECT 'TOTAL', COUNT(1) FROM V$ARCHIVED_LOG WHERE FIRST_TIME > TRUNC(SYSDATE) AND DEST_ID IN (SELECT DEST_ID FROM V$ARCHIVE_DEST_STATUS WHERE STATUS='VALID' AND TYPE='LOCAL')";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.currentRedoNameQuery();
        expected = "SELECT F.MEMBER FROM V$LOG LOG, V$LOGFILE F  WHERE LOG.GROUP#=F.GROUP# AND LOG.STATUS='CURRENT'";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.currentRedoLogSequenceQuery();
        expected = "SELECT SEQUENCE# FROM V$LOG WHERE STATUS = 'CURRENT'";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.databaseSupplementalLoggingAllCheckQuery();
        expected = "SELECT 'KEY', SUPPLEMENTAL_LOG_DATA_ALL FROM V$DATABASE";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.currentScnQuery();
        expected = "SELECT CURRENT_SCN FROM V$DATABASE";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.oldestFirstChangeQuery((Duration)Duration.ofHours(0L));
        expected = "SELECT MIN(FIRST_CHANGE#) FROM (SELECT MIN(FIRST_CHANGE#) AS FIRST_CHANGE# FROM V$LOG UNION SELECT MIN(FIRST_CHANGE#) AS FIRST_CHANGE# FROM V$ARCHIVED_LOG)";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.allOnlineLogsQuery();
        expected = "SELECT MIN(F.MEMBER) AS FILE_NAME, L.NEXT_CHANGE# AS NEXT_CHANGE, F.GROUP#, L.FIRST_CHANGE# AS FIRST_CHANGE, L.STATUS  FROM V$LOG L, V$LOGFILE F  WHERE F.GROUP# = L.GROUP# AND L.NEXT_CHANGE# > 0  GROUP BY F.GROUP#, L.NEXT_CHANGE#, L.FIRST_CHANGE#, L.STATUS ORDER BY 3";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.tableExistsQuery((String)"table_name");
        expected = "SELECT '1' AS ONE FROM USER_TABLES WHERE TABLE_NAME = 'table_name'";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.logMiningHistoryDdl((String)"table_name");
        expected = "create  TABLE table_name(row_sequence NUMBER(19,0), captured_scn NUMBER(19,0), table_name VARCHAR2(30 CHAR), seg_owner VARCHAR2(30 CHAR), operation_code NUMBER(19,0), change_time TIMESTAMP(6), transaction_id VARCHAR2(50 CHAR), csf NUMBER(19,0), redo_sql VARCHAR2(4000 CHAR)) nologging";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.archiveLogsQuery((Scn)Scn.valueOf((long)10L), (Duration)Duration.ofHours(0L));
        expected = "SELECT NAME AS FILE_NAME, NEXT_CHANGE# AS NEXT_CHANGE, FIRST_CHANGE# AS FIRST_CHANGE FROM V$ARCHIVED_LOG WHERE NAME IS NOT NULL AND ARCHIVED = 'YES' AND STATUS = 'A' AND NEXT_CHANGE# > 10 ORDER BY 2";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.archiveLogsQuery((Scn)Scn.valueOf((long)10L), (Duration)Duration.ofHours(1L));
        expected = "SELECT NAME AS FILE_NAME, NEXT_CHANGE# AS NEXT_CHANGE, FIRST_CHANGE# AS FIRST_CHANGE FROM V$ARCHIVED_LOG  WHERE NAME IS NOT NULL AND FIRST_TIME >= SYSDATE - (1/24) AND ARCHIVED = 'YES'  AND STATUS = 'A' AND NEXT_CHANGE# > 10 ORDER BY 2";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.deleteLogFileStatement((String)"file_name");
        expected = "BEGIN SYS.DBMS_LOGMNR.REMOVE_LOGFILE(LOGFILENAME => 'file_name');END;";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.getHistoryTableNamesQuery();
        expected = "SELECT TABLE_NAME, '1' FROM USER_TABLES WHERE TABLE_NAME LIKE 'LM_HIST_%'";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
        result = SqlUtils.dropHistoryTableStatement((String)"table_name");
        expected = "DROP TABLE TABLE_NAME PURGE";
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
    }

    @Test
    public void shouldParseHistoryTableNames() {
        String name = SqlUtils.buildHistoryTableName((LocalDateTime)LocalDateTime.now());
        long diff = SqlUtils.parseRetentionFromName((String)name);
        Assertions.assertThat((long)diff).isEqualTo(0L);
        name = SqlUtils.buildHistoryTableName((LocalDateTime)LocalDateTime.now().minusHours(10L));
        diff = SqlUtils.parseRetentionFromName((String)name);
        Assertions.assertThat((long)diff).isEqualTo(10L);
        diff = SqlUtils.parseRetentionFromName((String)"LM_HIST_10_2_4_5");
        Assertions.assertThat((long)diff).isEqualTo(0L);
    }

    @Test
    public void shouldDetectConnectionProblems() {
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new IOException("connection"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new SQLRecoverableException("connection"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Throwable())).isFalse();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-03135 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-12543 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-00604 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-01089 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-00600 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-99999 problem"))).isFalse();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("NO MORE DATA TO READ FROM SOCKET problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("12543 problem"))).isFalse();
    }

    private String resolveLogMineryContentQueryFromTemplate(String schemaReplacement, String tableReplacement) {
        String query = LOG_MINER_CONTENT_QUERY_TEMPLATE;
        if (!OracleConnectorConfig.EXCLUDED_SCHEMAS.isEmpty()) {
            StringBuilder systemPredicate = new StringBuilder();
            systemPredicate.append("AND SEG_OWNER NOT IN (");
            Iterator i = OracleConnectorConfig.EXCLUDED_SCHEMAS.iterator();
            while (i.hasNext()) {
                String excludedSchema = (String)i.next();
                systemPredicate.append("'").append(excludedSchema.toUpperCase()).append("'");
                if (!i.hasNext()) continue;
                systemPredicate.append(",");
            }
            systemPredicate.append(") ");
            query = query.replace("${systemTablePredicate}", systemPredicate.toString());
        } else {
            query = query.replace("${systemTablePredicate}", "");
        }
        query = query.replace("${schemaPredicate}", schemaReplacement == null ? "" : schemaReplacement);
        query = query.replace("${tablePredicate}", tableReplacement == null ? "" : tableReplacement);
        query = query.replace("${user}", USERNAME);
        return query;
    }
}

