/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.logminer.parser.LogMinerDmlParser;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValue;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntry;
import io.debezium.data.Envelope;
import io.debezium.doc.FixFor;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class LogMinerDmlParserTest {
    private LogMinerDmlParser fastDmlParser;

    @Before
    public void beforeEach() throws Exception {
        this.fastDmlParser = new LogMinerDmlParser();
    }

    @Test
    @FixFor(value={"DBZ-3078"})
    public void testParsingInsert() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.TEST")).addColumn(Column.editor().name("ID").create()).addColumn(Column.editor().name("NAME").create()).addColumn(Column.editor().name("TS").create()).addColumn(Column.editor().name("UT").create()).addColumn(Column.editor().name("DATE").create()).addColumn(Column.editor().name("UT2").create()).addColumn(Column.editor().name("C1").create()).addColumn(Column.editor().name("C2").create()).addColumn(Column.editor().name("UNUSED").create()).create();
        String sql = "insert into \"DEBEZIUM\".\"TEST\"(\"ID\",\"NAME\",\"TS\",\"UT\",\"DATE\",\"UT2\",\"C1\",\"C2\") values ('1','Acme',TO_TIMESTAMP('2020-02-01 00:00:00.'),Unsupported Type,TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS'),Unsupported Type,NULL,NULL);";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((Object)entry.getCommandType()).isEqualTo((Object)Envelope.Operation.CREATE);
        Assertions.assertThat((List)entry.getOldValues()).isEmpty();
        Assertions.assertThat((List)entry.getNewValues()).hasSize(9);
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnName()).isEqualTo((Object)"ID");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(1)).getColumnName()).isEqualTo((Object)"NAME");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(2)).getColumnName()).isEqualTo((Object)"TS");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(3)).getColumnName()).isEqualTo((Object)"UT");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(4)).getColumnName()).isEqualTo((Object)"DATE");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(5)).getColumnName()).isEqualTo((Object)"UT2");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(6)).getColumnName()).isEqualTo((Object)"C1");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(7)).getColumnName()).isEqualTo((Object)"C2");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(8)).getColumnName()).isEqualTo((Object)"UNUSED");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnData()).isEqualTo((Object)"1");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(1)).getColumnData()).isEqualTo((Object)"Acme");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(2)).getColumnData()).isEqualTo((Object)"TO_TIMESTAMP('2020-02-01 00:00:00.')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(3)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(4)).getColumnData()).isEqualTo((Object)"TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(5)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(6)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(7)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(8)).getColumnData()).isNull();
    }

    @Test
    @FixFor(value={"DBZ-3078"})
    public void testParsingUpdate() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.TEST")).addColumn(Column.editor().name("ID").create()).addColumn(Column.editor().name("NAME").create()).addColumn(Column.editor().name("TS").create()).addColumn(Column.editor().name("UT").create()).addColumn(Column.editor().name("DATE").create()).addColumn(Column.editor().name("UT2").create()).addColumn(Column.editor().name("C1").create()).addColumn(Column.editor().name("IS").create()).addColumn(Column.editor().name("IS2").create()).addColumn(Column.editor().name("UNUSED").create()).create();
        String sql = "update \"DEBEZIUM\".\"TEST\" set \"NAME\" = 'Bob', \"TS\" = TO_TIMESTAMP('2020-02-02 00:00:00.'), \"UT\" = Unsupported Type, \"DATE\" = TO_DATE('2020-02-02 00:00:00', 'YYYY-MM-DD HH24:MI:SS'), \"UT2\" = Unsupported Type, \"C1\" = NULL where \"ID\" = '1' and \"NAME\" = 'Acme' and \"TS\" = TO_TIMESTAMP('2020-02-01 00:00:00.') and \"UT\" = Unsupported Type and \"DATE\" = TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS') and \"UT2\" = Unsupported Type and \"C1\" = NULL and \"IS\" IS NULL and \"IS2\" IS NULL;";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((Object)entry.getCommandType()).isEqualTo((Object)Envelope.Operation.UPDATE);
        Assertions.assertThat((List)entry.getOldValues()).hasSize(10);
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(0)).getColumnName()).isEqualTo((Object)"ID");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(1)).getColumnName()).isEqualTo((Object)"NAME");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(2)).getColumnName()).isEqualTo((Object)"TS");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(3)).getColumnName()).isEqualTo((Object)"UT");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(4)).getColumnName()).isEqualTo((Object)"DATE");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(5)).getColumnName()).isEqualTo((Object)"UT2");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(6)).getColumnName()).isEqualTo((Object)"C1");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(7)).getColumnName()).isEqualTo((Object)"IS");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(8)).getColumnName()).isEqualTo((Object)"IS2");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(9)).getColumnName()).isEqualTo((Object)"UNUSED");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(0)).getColumnData()).isEqualTo((Object)"1");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(1)).getColumnData()).isEqualTo((Object)"Acme");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(2)).getColumnData()).isEqualTo((Object)"TO_TIMESTAMP('2020-02-01 00:00:00.')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(3)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(4)).getColumnData()).isEqualTo((Object)"TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(5)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(6)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(7)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(8)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(9)).getColumnData()).isNull();
        Assertions.assertThat((List)entry.getNewValues()).hasSize(10);
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnName()).isEqualTo((Object)"ID");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(1)).getColumnName()).isEqualTo((Object)"NAME");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(2)).getColumnName()).isEqualTo((Object)"TS");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(3)).getColumnName()).isEqualTo((Object)"UT");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(4)).getColumnName()).isEqualTo((Object)"DATE");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(5)).getColumnName()).isEqualTo((Object)"UT2");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(6)).getColumnName()).isEqualTo((Object)"C1");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(7)).getColumnName()).isEqualTo((Object)"IS");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(8)).getColumnName()).isEqualTo((Object)"IS2");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(9)).getColumnName()).isEqualTo((Object)"UNUSED");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnData()).isEqualTo((Object)"1");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(1)).getColumnData()).isEqualTo((Object)"Bob");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(2)).getColumnData()).isEqualTo((Object)"TO_TIMESTAMP('2020-02-02 00:00:00.')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(3)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(4)).getColumnData()).isEqualTo((Object)"TO_DATE('2020-02-02 00:00:00', 'YYYY-MM-DD HH24:MI:SS')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(5)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(6)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(7)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(8)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(9)).getColumnData()).isNull();
    }

    @Test
    @FixFor(value={"DBZ-3078"})
    public void testParsingDelete() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.TEST")).addColumn(Column.editor().name("ID").create()).addColumn(Column.editor().name("NAME").create()).addColumn(Column.editor().name("TS").create()).addColumn(Column.editor().name("UT").create()).addColumn(Column.editor().name("DATE").create()).addColumn(Column.editor().name("IS").create()).addColumn(Column.editor().name("IS2").create()).addColumn(Column.editor().name("UNUSED").create()).create();
        String sql = "delete from \"DEBEZIUM\".\"TEST\" where \"ID\" = '1' and \"NAME\" = 'Acme' and \"TS\" = TO_TIMESTAMP('2020-02-01 00:00:00.') and \"UT\" = Unsupported Type and \"DATE\" = TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS') and \"IS\" IS NULL and \"IS2\" IS NULL;";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((Object)entry.getCommandType()).isEqualTo((Object)Envelope.Operation.DELETE);
        Assertions.assertThat((List)entry.getOldValues()).hasSize(8);
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(0)).getColumnName()).isEqualTo((Object)"ID");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(1)).getColumnName()).isEqualTo((Object)"NAME");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(2)).getColumnName()).isEqualTo((Object)"TS");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(3)).getColumnName()).isEqualTo((Object)"UT");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(4)).getColumnName()).isEqualTo((Object)"DATE");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(5)).getColumnName()).isEqualTo((Object)"IS");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(6)).getColumnName()).isEqualTo((Object)"IS2");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(7)).getColumnName()).isEqualTo((Object)"UNUSED");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(0)).getColumnData()).isEqualTo((Object)"1");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(1)).getColumnData()).isEqualTo((Object)"Acme");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(2)).getColumnData()).isEqualTo((Object)"TO_TIMESTAMP('2020-02-01 00:00:00.')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(3)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(4)).getColumnData()).isEqualTo((Object)"TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(5)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(6)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(7)).getColumnData()).isNull();
        Assertions.assertThat((List)entry.getNewValues()).isEmpty();
    }

    @Test
    @FixFor(value={"DBZ-3235"})
    public void testParsingUpdateWithNoWhereClauseIsAcceptable() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.TEST")).addColumn(Column.editor().name("COL1").create()).addColumn(Column.editor().name("COL2").create()).addColumn(Column.editor().name("COL3").create()).addColumn(Column.editor().name("UNUSED").create()).create();
        String sql = "update \"DEBEZIUM\".\"TEST\" set \"COL1\" = '1', \"COL2\" = NULL, \"COL3\" = 'Hello';";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((Object)entry.getCommandType()).isEqualTo((Object)Envelope.Operation.UPDATE);
        Assertions.assertThat((List)entry.getOldValues()).isEmpty();
        Assertions.assertThat((List)entry.getNewValues()).hasSize(4);
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnName()).isEqualTo((Object)"COL1");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnData()).isEqualTo((Object)"1");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(1)).getColumnName()).isEqualTo((Object)"COL2");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(1)).getColumnData()).isNull();
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(2)).getColumnName()).isEqualTo((Object)"COL3");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(2)).getColumnData()).isEqualTo((Object)"Hello");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(3)).getColumnName()).isEqualTo((Object)"UNUSED");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(3)).getColumnData()).isNull();
    }

    @Test
    @FixFor(value={"DBZ-3235"})
    public void testParsingDeleteWithNoWhereClauseIsAcceptable() throws Exception {
        Table table = Table.editor().tableId(TableId.parse((String)"DEBEZIUM.TEST")).addColumn(Column.editor().name("COL1").create()).addColumn(Column.editor().name("COL2").create()).addColumn(Column.editor().name("COL3").create()).addColumn(Column.editor().name("UNUSED").create()).create();
        String sql = "delete from \"DEBEZIUM\".\"TEST\";";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((Object)entry.getCommandType()).isEqualTo((Object)Envelope.Operation.DELETE);
        Assertions.assertThat((List)entry.getOldValues()).isEmpty();
        Assertions.assertThat((List)entry.getNewValues()).isEmpty();
    }

    @Test
    @FixFor(value={"DBZ-3258"})
    public void testNameWithWhitespaces() throws Exception {
        Table table = Table.editor().tableId(new TableId(null, "UNKNOWN", "OBJ# 74858")).addColumn(Column.editor().name("COL 1").create()).create();
        String sql = "insert into \"UNKNOWN\".\"OBJ# 74858\"(\"COL 1\") values (1)";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((Object)entry.getCommandType()).isEqualTo((Object)Envelope.Operation.CREATE);
        Assertions.assertThat((List)entry.getOldValues()).isEmpty();
        Assertions.assertThat((List)entry.getNewValues()).hasSize(1);
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnName()).isEqualTo((Object)"COL 1");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnData()).isEqualTo((Object)"1");
    }

    @Test
    @FixFor(value={"DBZ-3305"})
    public void testParsingUpdateWithNoWhereClauseFunctionAsLastColumn() throws Exception {
        Table table = Table.editor().tableId(new TableId(null, "TICKETUSER", "CRS_ORDER")).addColumn(Column.editor().name("AMOUNT_PAID").create()).addColumn(Column.editor().name("AMOUNT_UNPAID").create()).addColumn(Column.editor().name("PAY_STATUS").create()).addColumn(Column.editor().name("IS_DEL").create()).addColumn(Column.editor().name("TM_UPDATE").create()).create();
        String sql = "update \"TICKETUSER\".\"CRS_ORDER\" set \"AMOUNT_PAID\" = '0', \"AMOUNT_UNPAID\" = '540', \"PAY_STATUS\" = '10111015', \"IS_DEL\" = '0', \"TM_UPDATE\" = TO_DATE('2021-03-17 10:18:55', 'YYYY-MM-DD HH24:MI:SS');";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, table, null);
        Assertions.assertThat((Object)entry.getCommandType()).isEqualTo((Object)Envelope.Operation.UPDATE);
        Assertions.assertThat((List)entry.getOldValues()).isEmpty();
        Assertions.assertThat((List)entry.getNewValues()).hasSize(5);
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnName()).isEqualTo((Object)"AMOUNT_PAID");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(1)).getColumnName()).isEqualTo((Object)"AMOUNT_UNPAID");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(2)).getColumnName()).isEqualTo((Object)"PAY_STATUS");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(3)).getColumnName()).isEqualTo((Object)"IS_DEL");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(4)).getColumnName()).isEqualTo((Object)"TM_UPDATE");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnData()).isEqualTo((Object)"0");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(1)).getColumnData()).isEqualTo((Object)"540");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(2)).getColumnData()).isEqualTo((Object)"10111015");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(3)).getColumnData()).isEqualTo((Object)"0");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(4)).getColumnData()).isEqualTo((Object)"TO_DATE('2021-03-17 10:18:55', 'YYYY-MM-DD HH24:MI:SS')");
    }
}

