/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.oracle.Module;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.SourceInfo;
import io.debezium.data.VerifyRecord;
import io.debezium.relational.TableId;
import java.time.Instant;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class SourceInfoTest {
    private SourceInfo source;

    @Before
    public void beforeEach() {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.SERVER_NAME, "serverX")).with(OracleConnectorConfig.DATABASE_NAME, "mydb")).build());
        this.source = new SourceInfo(connectorConfig);
        this.source.setSourceTime(Instant.now());
        this.source.setTableId(new TableId("c", "s", "t"));
    }

    @Test
    public void versionIsPresent() {
        Assertions.assertThat((String)this.source.struct().getString("version")).isEqualTo((Object)Module.version());
    }

    @Test
    public void connectorIsPresent() {
        Assertions.assertThat((String)this.source.struct().getString("connector")).isEqualTo((Object)Module.name());
    }

    @Test
    public void schemaIsCorrect() {
        Schema schema = SchemaBuilder.struct().name("io.debezium.connector.oracle.Source").field("version", Schema.STRING_SCHEMA).field("connector", Schema.STRING_SCHEMA).field("name", Schema.STRING_SCHEMA).field("ts_ms", Schema.INT64_SCHEMA).field("snapshot", AbstractSourceInfoStructMaker.SNAPSHOT_RECORD_SCHEMA).field("db", Schema.STRING_SCHEMA).field("schema", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).field("txId", Schema.OPTIONAL_STRING_SCHEMA).field("scn", Schema.OPTIONAL_STRING_SCHEMA).field("commit_scn", Schema.OPTIONAL_STRING_SCHEMA).field("lcr_position", Schema.OPTIONAL_STRING_SCHEMA).build();
        VerifyRecord.assertConnectSchemasAreEqual(null, (Schema)this.source.schema(), (Schema)schema);
    }
}

