/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SignalsIT
extends AbstractConnectorTest {
    private static OracleConnection connection;

    @BeforeClass
    public static void beforeClass() throws SQLException {
        connection = TestHelper.testConnection();
        TestHelper.dropTable(connection, "debezium.customer");
        TestHelper.dropTable(connection, "debezium.debezium_signal");
        String ddl = "create table debezium.customer (  id numeric(9,0) not null,   name varchar2(1000),   score decimal(6, 2),   registered timestamp,   constraint mypk primary key (id))";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.customer to  " + TestHelper.getConnectorUserName()});
        connection.execute(new String[]{"ALTER TABLE debezium.customer ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        ddl = "create table debezium.debezium_signal ( id varchar2(64),  type varchar2(64),  data varchar2(2048) )";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.debezium_signal to  " + TestHelper.getConnectorUserName()});
        connection.execute(new String[]{"ALTER TABLE debezium.debezium_signal ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
    }

    @AfterClass
    public static void closeConnection() throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    @Before
    public void before() throws SQLException {
        connection.execute(new String[]{"delete from debezium.customer"});
        connection.execute(new String[]{"delete from debezium.debezium_signal"});
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @Test
    public void signalSchemaChange() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.CUSTOMER,DEBEZIUM\\.DEBEZIUM_SIGNAL")).with(OracleConnectorConfig.SIGNAL_DATA_COLLECTION, "ORCLPDB1.DEBEZIUM.DEBEZIUM_SIGNAL")).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(OracleConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(OracleConnectorConfig.LOG_MINING_STRATEGY, (EnumeratedValue)OracleConnectorConfig.LogMiningStrategy.ONLINE_CATALOG)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        SignalsIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (1, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"ALTER TABLE debezium.customer DROP CONSTRAINT mypk"});
        connection.execute(new String[]{"ALTER TABLE debezium.customer ADD CONSTRAINT mypk PRIMARY KEY (id, name)"});
        connection.execute(new String[]{"INSERT INTO debezium.debezium_signal VALUES('1', 'schema-changes', '{\"database\": \"ORCLPDB1\", \"schema\": \"DEBEZIUM\", \"changes\":[{\"type\":\"ALTER\",\"id\":\"\\\"ORCLPDB1\\\".\\\"DEBEZIUM\\\".\\\"CUSTOMER\\\"\",\"table\":{\"defaultCharsetName\":null,\"primaryKeyColumnNames\":[\"ID\", \"NAME\"],\"columns\":[{\"name\":\"ID\",\"jdbcType\":2,\"typeName\":\"NUMBER\",\"typeExpression\":\"NUMBER\",\"charsetName\":null,\"length\":9,\"scale\":0,\"position\":1,\"optional\":false,\"autoIncremented\":false,\"generated\":false},{\"name\":\"NAME\",\"jdbcType\":12,\"typeName\":\"VARCHAR2\",\"typeExpression\":\"VARCHAR2\",\"charsetName\":null,\"length\":1000,\"position\":2,\"optional\":true,\"autoIncremented\":false,\"generated\":false},{\"name\":\"SCORE\",\"jdbcType\":2,\"typeName\":\"NUMBER\",\"typeExpression\":\"NUMBER\",\"charsetName\":null,\"length\":6,\"scale\":2,\"position\":3,\"optional\":true,\"autoIncremented\":false,\"generated\":false},{\"name\":\"REGISTERED\",\"jdbcType\":93,\"typeName\":\"TIMESTAMP(6)\",\"typeExpression\":\"TIMESTAMP(6)\",\"charsetName\":null,\"length\":6,\"position\":4,\"optional\":true,\"autoIncremented\":false,\"generated\":false}]}}]}')"});
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (2, 'Battle-Bug', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        int expected = 6;
        List records = this.consumeRecordsByTopic(6).allRecordsInOrder();
        Assertions.assertThat((List)records).hasSize(6);
        SourceRecord pre = (SourceRecord)records.get(0);
        SourceRecord post = (SourceRecord)records.get(5);
        Assertions.assertThat((List)((Struct)pre.key()).schema().fields()).hasSize(1);
        Struct postKey = (Struct)post.key();
        Assertions.assertThat((List)postKey.schema().fields()).hasSize(2);
        Assertions.assertThat((Object)postKey.schema().field("ID")).isNotNull();
        Assertions.assertThat((Object)postKey.schema().field("NAME")).isNotNull();
        this.stopConnector();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (3, 'Crazy-Frog', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        records = this.consumeRecordsByTopic(1).allRecordsInOrder();
        Assertions.assertThat((List)records).hasSize(1);
        SourceRecord post2 = (SourceRecord)records.get(0);
        Struct postKey2 = (Struct)post2.key();
        Assertions.assertThat((List)postKey2.schema().fields()).hasSize(2);
        Assertions.assertThat((Object)postKey2.schema().field("ID")).isNotNull();
        Assertions.assertThat((Object)postKey2.schema().field("NAME")).isNotNull();
    }
}

