/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogFile;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LogMinerHelperTest {
    private OracleConnection connection = (OracleConnection)Mockito.mock(OracleConnection.class);
    private int current;
    private String[][] mockRows;

    @Before
    public void beforeEach() throws Exception {
        this.current = 0;
        this.mockRows = new String[0][];
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Connection conn = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.connection.connection()).thenReturn((Object)conn);
        Mockito.when((Object)this.connection.connection(false)).thenReturn((Object)conn);
        PreparedStatement pstmt = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)conn.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)pstmt);
        Mockito.when((Object)pstmt.executeQuery()).thenReturn((Object)rs);
        Mockito.when((Object)rs.next()).thenAnswer(it -> ++this.current <= this.mockRows.length);
        Mockito.when((Object)rs.getString(ArgumentMatchers.anyInt())).thenAnswer(it -> this.mockRows[this.current - 1][(Integer)it.getArguments()[0] - 1]);
    }

    @Test
    public void logsWithRegularScns() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700", "ACTIVE"}, {"logfile2", "103700", "12", "104000", "ACTIVE"}};
        List onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((OracleConnection)this.connection, (Scn)Scn.valueOf((long)10L));
        Assert.assertEquals((long)onlineLogs.size(), (long)2L);
        Assert.assertEquals((Object)LogMinerHelperTest.getLogFileNextScnByName(onlineLogs, "logfile1"), (Object)Scn.valueOf((long)103400L));
        Assert.assertEquals((Object)LogMinerHelperTest.getLogFileNextScnByName(onlineLogs, "logfile2"), (Object)Scn.valueOf((long)103700L));
    }

    @Test
    public void excludeLogsBeforeOffsetScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700", "ACTIVE"}, {"logfile2", "103700", "12", "104000", "ACTIVE"}, {"logfile3", "500", "13", "103100", "ACTIVE"}};
        List onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((OracleConnection)this.connection, (Scn)Scn.valueOf((long)600L));
        Assert.assertEquals((long)onlineLogs.size(), (long)2L);
        Assert.assertNull((Object)LogMinerHelperTest.getLogFileNextScnByName(onlineLogs, "logfile3"));
    }

    @Test
    public void nullsHandledAsMaxScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700", "ACTIVE"}, {"logfile2", "103700", "12", "104000", "ACTIVE"}, {"logfile3", null, "13", "103100", "CURRENT"}};
        List onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((OracleConnection)this.connection, (Scn)Scn.valueOf((long)600L));
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals((Object)LogMinerHelperTest.getLogFileNextScnByName(onlineLogs, "logfile3"), (Object)Scn.MAX);
    }

    @Test
    public void canHandleMaxScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700", "ACTIVE"}, {"logfile2", "103700", "12", "104000", "ACTIVE"}, {"logfile3", "18446744073709551615", "13", "104300", "CURRENT"}};
        List onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((OracleConnection)this.connection, (Scn)Scn.valueOf((long)600L));
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals((Object)LogMinerHelperTest.getLogFileNextScnByName(onlineLogs, "logfile3"), (Object)Scn.MAX);
    }

    @Test
    public void logsWithVeryLargeScnAreSupported() throws Exception {
        String scnLonger = "18446744073709551615";
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700", "ACTIVE"}, {"logfile2", "103700", "12", "104000", "ACTIVE"}, {"logfile3", scnLonger, "13", "104300", "ACTIVE"}};
        List onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((OracleConnection)this.connection, (Scn)Scn.valueOf((long)600L));
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals((Object)LogMinerHelperTest.getLogFileNextScnByName(onlineLogs, "logfile3"), (Object)Scn.valueOf((String)scnLonger));
    }

    @Test
    public void archiveLogsWithRegularScns() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "ACTIVE"}, {"logfile2", "103700", "12", "ACTIVE"}};
        List onlineLogs = LogMinerHelper.getArchivedLogFilesForOffsetScn((OracleConnection)this.connection, (Scn)Scn.valueOf((long)500L), (Duration)Duration.ofDays(60L));
        Assert.assertEquals((long)onlineLogs.size(), (long)2L);
        Assert.assertEquals((Object)LogMinerHelperTest.getLogFileNextScnByName(onlineLogs, "logfile1"), (Object)Scn.valueOf((long)103400L));
        Assert.assertEquals((Object)LogMinerHelperTest.getLogFileNextScnByName(onlineLogs, "logfile2"), (Object)Scn.valueOf((long)103700L));
    }

    @Test
    public void archiveExcludeLogsBeforeOffsetScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11"}, {"logfile2", "103700", "12"}};
        List onlineLogs = LogMinerHelper.getArchivedLogFilesForOffsetScn((OracleConnection)this.connection, (Scn)Scn.valueOf((long)600L), (Duration)Duration.ofDays(60L));
        Assert.assertEquals((long)onlineLogs.size(), (long)2L);
        Assert.assertNull((Object)LogMinerHelperTest.getLogFileNextScnByName(onlineLogs, "logfile3"));
    }

    @Test
    public void archiveNullsHandledAsMaxScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700"}, {"logfile2", "103700", "12", "104000"}, {"logfile3", null, "13", "104300"}};
        List onlineLogs = LogMinerHelper.getArchivedLogFilesForOffsetScn((OracleConnection)this.connection, (Scn)Scn.valueOf((long)500L), (Duration)Duration.ofDays(60L));
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals((Object)LogMinerHelperTest.getLogFileNextScnByName(onlineLogs, "logfile3"), (Object)Scn.MAX);
    }

    @Test
    public void archiveLogsWithVeryLargeScnAreSupported() throws Exception {
        String scnLonger = "18446744073709551615";
        this.mockRows = new String[][]{{"logfile1", "103400", "11"}, {"logfile2", "103700", "12"}, {"logfile3", scnLonger, "13"}};
        List onlineLogs = LogMinerHelper.getArchivedLogFilesForOffsetScn((OracleConnection)this.connection, (Scn)Scn.valueOf((long)500L), (Duration)Duration.ofDays(60L));
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals((Object)LogMinerHelperTest.getLogFileNextScnByName(onlineLogs, "logfile3"), (Object)Scn.valueOf((String)scnLonger));
    }

    private static Scn getLogFileNextScnByName(List<LogFile> logs, String name) {
        Optional<LogFile> file = logs.stream().filter(l -> l.getFileName().equals(name)).findFirst();
        if (file.isPresent()) {
            return file.get().getNextScn();
        }
        return null;
    }
}

