/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.HistoryRecorder;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.LogMinerQueryResultProcessor;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.connector.oracle.logminer.TransactionalBuffer;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Stopwatch;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerStreamingChangeEventSource
implements StreamingChangeEventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerStreamingChangeEventSource.class);
    private final OracleConnection jdbcConnection;
    private final EventDispatcher<TableId> dispatcher;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final OracleOffsetContext offsetContext;
    private final boolean isRac;
    private final Set<String> racHosts = new HashSet<String>();
    private final JdbcConfiguration jdbcConfiguration;
    private final OracleConnectorConfig.LogMiningStrategy strategy;
    private final OracleTaskContext taskContext;
    private final ErrorHandler errorHandler;
    private final boolean isContinuousMining;
    private final OracleStreamingChangeEventSourceMetrics streamingMetrics;
    private final OracleConnectorConfig connectorConfig;
    private final Duration archiveLogRetention;
    private Scn startScn;
    private Scn endScn;
    private List<BigInteger> currentRedoLogSequences;

    public LogMinerStreamingChangeEventSource(OracleConnectorConfig connectorConfig, OracleOffsetContext offsetContext, OracleConnection jdbcConnection, EventDispatcher<TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, OracleTaskContext taskContext, Configuration jdbcConfig, OracleStreamingChangeEventSourceMetrics streamingMetrics) {
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.schema = schema;
        this.offsetContext = offsetContext;
        this.connectorConfig = connectorConfig;
        this.strategy = connectorConfig.getLogMiningStrategy();
        this.isContinuousMining = connectorConfig.isContinuousMining();
        this.errorHandler = errorHandler;
        this.taskContext = taskContext;
        this.streamingMetrics = streamingMetrics;
        this.jdbcConfiguration = JdbcConfiguration.adapt((Configuration)jdbcConfig);
        this.isRac = connectorConfig.isRacSystem();
        if (this.isRac) {
            this.racHosts.addAll(connectorConfig.getRacNodes().stream().map(String::toUpperCase).collect(Collectors.toSet()));
            LogMinerHelper.instantiateFlushConnections(this.jdbcConfiguration, this.racHosts);
        }
        this.archiveLogRetention = connectorConfig.getLogMiningArchiveLogRetention();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ChangeEventSource.ChangeEventSourceContext context) {
        block49: {
            try (TransactionalBuffer transactionalBuffer = new TransactionalBuffer(this.errorHandler, this.streamingMetrics);){
                try {
                    long databaseTimeMs = LogMinerHelper.getTimeDifference(this.jdbcConnection).toMillis();
                    LOGGER.trace("Current time {} ms, database difference {} ms", (Object)System.currentTimeMillis(), (Object)databaseTimeMs);
                    transactionalBuffer.setDatabaseTimeDifference(databaseTimeMs);
                    this.startScn = this.offsetContext.getScn();
                    LogMinerHelper.createFlushTable(this.jdbcConnection);
                    if (!this.isContinuousMining && this.startScn.compareTo(LogMinerHelper.getFirstOnlineLogScn(this.jdbcConnection, this.archiveLogRetention)) < 0) {
                        throw new DebeziumException("Online REDO LOG files or archive log files do not contain the offset scn " + this.startScn + ".  Please perform a new snapshot.");
                    }
                    LogMinerHelper.setNlsSessionParameters(this.jdbcConnection);
                    LogMinerHelper.checkSupplementalLogging(this.jdbcConnection, this.connectorConfig.getPdbName(), this.schema);
                    this.initializeRedoLogsForMining(this.jdbcConnection, false, this.archiveLogRetention);
                    try (HistoryRecorder historyRecorder = this.connectorConfig.getLogMiningHistoryRecorder();){
                        historyRecorder.prepare(this.streamingMetrics, this.jdbcConfiguration, this.connectorConfig.getLogMinerHistoryRetentionHours());
                        LogMinerQueryResultProcessor processor = new LogMinerQueryResultProcessor(context, this.jdbcConnection, this.connectorConfig, this.streamingMetrics, transactionalBuffer, this.offsetContext, this.schema, this.dispatcher, this.clock, historyRecorder);
                        String query = SqlUtils.logMinerContentsQuery(this.connectorConfig, this.jdbcConnection.username());
                        try (PreparedStatement miningView = this.jdbcConnection.connection().prepareStatement(query, 1003, 1007, 1);){
                            this.currentRedoLogSequences = this.getCurrentRedoLogSequences();
                            Stopwatch stopwatch = Stopwatch.reusable();
                            while (context.isRunning()) {
                                Instant start = Instant.now();
                                this.endScn = LogMinerHelper.getEndScn(this.jdbcConnection, this.startScn, this.streamingMetrics, this.connectorConfig.getLogMiningBatchSizeDefault());
                                LogMinerHelper.flushLogWriter(this.jdbcConnection, this.jdbcConfiguration, this.isRac, this.racHosts);
                                if (this.hasLogSwitchOccurred()) {
                                    LOGGER.trace("Ending log mining startScn={}, endScn={}, offsetContext.getScn={}, strategy={}, continuous={}", new Object[]{this.startScn, this.endScn, this.offsetContext.getScn(), this.strategy, this.isContinuousMining});
                                    LogMinerHelper.endMining(this.jdbcConnection);
                                    this.initializeRedoLogsForMining(this.jdbcConnection, true, this.archiveLogRetention);
                                    this.abandonOldTransactionsIfExist(this.jdbcConnection, transactionalBuffer);
                                    this.currentRedoLogSequences = this.getCurrentRedoLogSequences();
                                }
                                LogMinerHelper.startLogMining(this.jdbcConnection, this.startScn, this.endScn, this.strategy, this.isContinuousMining, this.streamingMetrics);
                                stopwatch.start();
                                miningView.setFetchSize(this.connectorConfig.getMaxQueueSize());
                                miningView.setFetchDirection(1000);
                                miningView.setString(1, this.startScn.toString());
                                miningView.setString(2, this.endScn.toString());
                                try (ResultSet rs = miningView.executeQuery();){
                                    Duration lastDurationOfBatchCapturing = stopwatch.stop().durations().statistics().getTotal();
                                    this.streamingMetrics.setLastDurationOfBatchCapturing(lastDurationOfBatchCapturing);
                                    processor.processResult(rs);
                                    this.startScn = this.endScn;
                                    if (transactionalBuffer.isEmpty()) {
                                        LOGGER.debug("Transactional buffer empty, updating offset's SCN {}", (Object)this.startScn);
                                        this.offsetContext.setScn(this.startScn);
                                    }
                                }
                                this.streamingMetrics.setCurrentBatchProcessingTime(Duration.between(start, Instant.now()));
                                this.pauseBetweenMiningSessions();
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    try {
                        LogMinerHelper.logError(this.streamingMetrics, "Mining session stopped due to the {}", t);
                        this.errorHandler.setProducerThrowable(t);
                    }
                    catch (Throwable throwable) {
                        LOGGER.info("startScn={}, endScn={}, offsetContext.getScn()={}", new Object[]{this.startScn, this.endScn, this.offsetContext.getScn()});
                        LOGGER.info("Transactional buffer dump: {}", (Object)transactionalBuffer.toString());
                        LOGGER.info("Streaming metrics dump: {}", (Object)this.streamingMetrics.toString());
                        throw throwable;
                    }
                    LOGGER.info("startScn={}, endScn={}, offsetContext.getScn()={}", new Object[]{this.startScn, this.endScn, this.offsetContext.getScn()});
                    LOGGER.info("Transactional buffer dump: {}", (Object)transactionalBuffer.toString());
                    LOGGER.info("Streaming metrics dump: {}", (Object)this.streamingMetrics.toString());
                    break block49;
                }
                LOGGER.info("startScn={}, endScn={}, offsetContext.getScn()={}", new Object[]{this.startScn, this.endScn, this.offsetContext.getScn()});
                LOGGER.info("Transactional buffer dump: {}", (Object)transactionalBuffer.toString());
                LOGGER.info("Streaming metrics dump: {}", (Object)this.streamingMetrics.toString());
            }
        }
    }

    private void abandonOldTransactionsIfExist(OracleConnection connection, TransactionalBuffer transactionalBuffer) {
        Duration transactionRetention = this.connectorConfig.getLogMiningTransactionRetention();
        if (!Duration.ZERO.equals(transactionRetention)) {
            Scn offsetScn = this.offsetContext.getScn();
            Optional<Scn> lastScnToAbandonTransactions = LogMinerHelper.getLastScnToAbandon(connection, offsetScn, transactionRetention);
            lastScnToAbandonTransactions.ifPresent(thresholdScn -> {
                transactionalBuffer.abandonLongTransactions((Scn)thresholdScn, this.offsetContext);
                this.offsetContext.setScn((Scn)thresholdScn);
                this.startScn = this.endScn;
            });
        }
    }

    private void initializeRedoLogsForMining(OracleConnection connection, boolean postEndMiningSession, Duration archiveLogRetention) throws SQLException {
        if (!postEndMiningSession) {
            if (OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO.equals((Object)this.strategy)) {
                LogMinerHelper.buildDataDictionary(connection);
            }
            if (!this.isContinuousMining) {
                LogMinerHelper.setRedoLogFilesForMining(connection, this.startScn, archiveLogRetention);
            }
        } else if (!this.isContinuousMining) {
            if (OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO.equals((Object)this.strategy)) {
                LogMinerHelper.buildDataDictionary(connection);
            }
            LogMinerHelper.setRedoLogFilesForMining(connection, this.startScn, archiveLogRetention);
        }
    }

    private boolean hasLogSwitchOccurred() throws SQLException {
        List<BigInteger> newSequences = this.getCurrentRedoLogSequences();
        if (!newSequences.equals(this.currentRedoLogSequences)) {
            LOGGER.debug("Current log sequence(s) is now {}, was {}", newSequences, this.currentRedoLogSequences);
            this.currentRedoLogSequences = newSequences;
            Map logStatuses = (Map)this.jdbcConnection.queryAndMap(SqlUtils.redoLogStatusQuery(), rs -> {
                LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
                while (rs.next()) {
                    results.put(rs.getString(1), rs.getString(2));
                }
                return results;
            });
            int logSwitchCount = (Integer)this.jdbcConnection.queryAndMap(SqlUtils.switchHistoryQuery(), rs -> {
                if (rs.next()) {
                    return rs.getInt(2);
                }
                return 0;
            });
            Set<String> fileNames = LogMinerHelper.getCurrentRedoLogFiles(this.jdbcConnection);
            this.streamingMetrics.setRedoLogStatus(logStatuses);
            this.streamingMetrics.setSwitchCount(logSwitchCount);
            this.streamingMetrics.setCurrentLogFileName(fileNames);
            return true;
        }
        return false;
    }

    private List<BigInteger> getCurrentRedoLogSequences() throws SQLException {
        return (List)this.jdbcConnection.queryAndMap(SqlUtils.currentRedoLogSequenceQuery(), rs -> {
            ArrayList<BigInteger> sequences = new ArrayList<BigInteger>();
            if (rs.next()) {
                sequences.add(new BigInteger(rs.getString(1)));
            }
            return sequences;
        });
    }

    private void pauseBetweenMiningSessions() throws InterruptedException {
        Duration period = Duration.ofMillis(this.streamingMetrics.getMillisecondToSleepBetweenMiningQuery());
        Metronome.sleeper((Duration)period, (Clock)this.clock).pause();
    }

    public void commitOffset(Map<String, ?> offset) {
    }
}

