/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.logminer.LogMinerMetricsMXBean;
import io.debezium.connector.oracle.logminer.Scn;
import io.debezium.metrics.Metrics;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LogMinerMetrics
extends Metrics
implements LogMinerMetricsMXBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerMetrics.class);
    private final AtomicReference<Scn> currentScn = new AtomicReference();
    private final AtomicInteger logMinerQueryCount = new AtomicInteger();
    private final AtomicInteger totalCapturedDmlCount = new AtomicInteger();
    private final AtomicReference<Duration> totalDurationOfFetchingQuery = new AtomicReference();
    private final AtomicInteger lastCapturedDmlCount = new AtomicInteger();
    private final AtomicReference<Duration> lastDurationOfFetchingQuery = new AtomicReference();
    private final AtomicLong maxCapturedDmlCount = new AtomicLong();
    private final AtomicLong totalProcessedRows = new AtomicLong();
    private final AtomicReference<Duration> maxDurationOfFetchingQuery = new AtomicReference();
    private final AtomicReference<Duration> totalBatchProcessingDuration = new AtomicReference();
    private final AtomicReference<Duration> lastBatchProcessingDuration = new AtomicReference();
    private final AtomicReference<Duration> maxBatchProcessingDuration = new AtomicReference();
    private final AtomicReference<Duration> totalParseTime = new AtomicReference();
    private final AtomicReference<Duration> totalStartLogMiningSessionDuration = new AtomicReference();
    private final AtomicReference<Duration> lastStartLogMiningSessionDuration = new AtomicReference();
    private final AtomicReference<Duration> maxStartingLogMiningSessionDuration = new AtomicReference();
    private final AtomicReference<Duration> totalProcessingTime = new AtomicReference();
    private final AtomicReference<Duration> minBatchProcessingTime = new AtomicReference();
    private final AtomicReference<Duration> maxBatchProcessingTime = new AtomicReference();
    private final AtomicReference<Duration> totalResultSetNextTime = new AtomicReference();
    private final AtomicLong maxBatchProcessingThroughput = new AtomicLong();
    private final AtomicReference<String[]> currentLogFileName;
    private final AtomicReference<String[]> redoLogStatus;
    private final AtomicLong minimumLogsMined = new AtomicLong();
    private final AtomicLong maximumLogsMined = new AtomicLong();
    private final AtomicInteger switchCounter = new AtomicInteger();
    private final AtomicInteger batchSize = new AtomicInteger();
    private final AtomicLong millisecondToSleepBetweenMiningQuery = new AtomicLong();
    private final AtomicBoolean recordMiningHistory = new AtomicBoolean();
    private final AtomicInteger hoursToKeepTransaction = new AtomicInteger();
    private final AtomicLong networkConnectionProblemsCounter = new AtomicLong();
    private final int batchSizeMin;
    private final int batchSizeMax;
    private final int batchSizeDefault;
    private final long sleepTimeMin;
    private final long sleepTimeMax;
    private final long sleepTimeDefault;
    private final long sleepTimeIncrement;

    LogMinerMetrics(CdcSourceTaskContext taskContext, OracleConnectorConfig connectorConfig) {
        super(taskContext, "log-miner");
        this.currentScn.set(Scn.INVALID);
        this.currentLogFileName = new AtomicReference();
        this.minimumLogsMined.set(0L);
        this.maximumLogsMined.set(0L);
        this.redoLogStatus = new AtomicReference();
        this.switchCounter.set(0);
        this.recordMiningHistory.set(connectorConfig.isLogMiningHistoryRecorded());
        this.batchSizeDefault = connectorConfig.getLogMiningBatchSizeDefault();
        this.batchSizeMin = connectorConfig.getLogMiningBatchSizeMin();
        this.batchSizeMax = connectorConfig.getLogMiningBatchSizeMax();
        this.sleepTimeDefault = connectorConfig.getLogMiningSleepTimeDefault().toMillis();
        this.sleepTimeMin = connectorConfig.getLogMiningSleepTimeMin().toMillis();
        this.sleepTimeMax = connectorConfig.getLogMiningSleepTimeMax().toMillis();
        this.sleepTimeIncrement = connectorConfig.getLogMiningSleepTimeIncrement().toMillis();
        this.hoursToKeepTransaction.set(Long.valueOf(connectorConfig.getLogMiningTransactionRetention().toHours()).intValue());
        this.reset();
        LOGGER.info("Logminer metrics initialized {}", (Object)this);
    }

    @Override
    public void reset() {
        this.batchSize.set(this.batchSizeDefault);
        this.millisecondToSleepBetweenMiningQuery.set(this.sleepTimeDefault);
        this.totalCapturedDmlCount.set(0);
        this.totalProcessedRows.set(0L);
        this.maxDurationOfFetchingQuery.set(Duration.ZERO);
        this.lastDurationOfFetchingQuery.set(Duration.ZERO);
        this.logMinerQueryCount.set(0);
        this.maxBatchProcessingDuration.set(Duration.ZERO);
        this.totalDurationOfFetchingQuery.set(Duration.ZERO);
        this.lastCapturedDmlCount.set(0);
        this.maxCapturedDmlCount.set(0L);
        this.totalBatchProcessingDuration.set(Duration.ZERO);
        this.maxBatchProcessingThroughput.set(0L);
        this.lastBatchProcessingDuration.set(Duration.ZERO);
        this.networkConnectionProblemsCounter.set(0L);
        this.totalParseTime.set(Duration.ZERO);
        this.totalStartLogMiningSessionDuration.set(Duration.ZERO);
        this.lastStartLogMiningSessionDuration.set(Duration.ZERO);
        this.maxStartingLogMiningSessionDuration.set(Duration.ZERO);
        this.totalProcessingTime.set(Duration.ZERO);
        this.minBatchProcessingTime.set(Duration.ZERO);
        this.maxBatchProcessingTime.set(Duration.ZERO);
        this.totalResultSetNextTime.set(Duration.ZERO);
    }

    public void setCurrentScn(Scn scn) {
        this.currentScn.set(scn);
    }

    public void setCurrentLogFileName(Set<String> names) {
        this.currentLogFileName.set((String[])names.stream().toArray(String[]::new));
        if ((long)names.size() < this.minimumLogsMined.get()) {
            this.minimumLogsMined.set(names.size());
        }
        if ((long)names.size() > this.maximumLogsMined.get()) {
            this.maximumLogsMined.set(names.size());
        }
    }

    @Override
    public long getMinimumMinedLogCount() {
        return this.minimumLogsMined.get();
    }

    @Override
    public long getMaximumMinedLogCount() {
        return this.maximumLogsMined.get();
    }

    public void setRedoLogStatus(Map<String, String> status) {
        String[] statusArray = (String[])status.entrySet().stream().map(e -> (String)e.getKey() + " | " + (String)e.getValue()).toArray(String[]::new);
        this.redoLogStatus.set(statusArray);
    }

    public void setSwitchCount(int counter) {
        this.switchCounter.set(counter);
    }

    public void setLastCapturedDmlCount(int dmlCount) {
        this.lastCapturedDmlCount.set(dmlCount);
        if ((long)dmlCount > this.maxCapturedDmlCount.get()) {
            this.maxCapturedDmlCount.set(dmlCount);
        }
        this.totalCapturedDmlCount.getAndAdd(dmlCount);
    }

    public void setLastDurationOfBatchCapturing(Duration lastDuration) {
        this.lastDurationOfFetchingQuery.set(lastDuration);
        this.totalDurationOfFetchingQuery.accumulateAndGet(this.lastDurationOfFetchingQuery.get(), Duration::plus);
        if (this.maxDurationOfFetchingQuery.get().toMillis() < this.lastDurationOfFetchingQuery.get().toMillis()) {
            this.maxDurationOfFetchingQuery.set(lastDuration);
        }
        this.logMinerQueryCount.incrementAndGet();
    }

    public void setLastDurationOfBatchProcessing(Duration lastDuration) {
        this.lastBatchProcessingDuration.set(lastDuration);
        this.totalBatchProcessingDuration.accumulateAndGet(lastDuration, Duration::plus);
        if (this.maxBatchProcessingDuration.get().toMillis() < lastDuration.toMillis()) {
            this.maxBatchProcessingDuration.set(lastDuration);
        }
        if (this.getLastBatchProcessingThroughput() > this.maxBatchProcessingThroughput.get()) {
            this.maxBatchProcessingThroughput.set(this.getLastBatchProcessingThroughput());
        }
    }

    public void incrementNetworkConnectionProblemsCounter() {
        this.networkConnectionProblemsCounter.incrementAndGet();
    }

    @Override
    public Long getCurrentScn() {
        return this.currentScn.get().longValue();
    }

    @Override
    public long getTotalCapturedDmlCount() {
        return this.totalCapturedDmlCount.get();
    }

    @Override
    public String[] getCurrentRedoLogFileName() {
        return this.currentLogFileName.get();
    }

    @Override
    public String[] getRedoLogStatus() {
        return this.redoLogStatus.get();
    }

    @Override
    public int getSwitchCounter() {
        return this.switchCounter.get();
    }

    @Override
    public Long getLastDurationOfFetchQueryInMilliseconds() {
        return this.lastDurationOfFetchingQuery.get() == null ? 0L : this.lastDurationOfFetchingQuery.get().toMillis();
    }

    @Override
    public long getLastBatchProcessingTimeInMilliseconds() {
        return this.lastBatchProcessingDuration.get().toMillis();
    }

    @Override
    public Long getMaxDurationOfFetchQueryInMilliseconds() {
        return this.maxDurationOfFetchingQuery.get() == null ? 0L : this.maxDurationOfFetchingQuery.get().toMillis();
    }

    @Override
    public Long getMaxCapturedDmlInBatch() {
        return this.maxCapturedDmlCount.get();
    }

    @Override
    public int getLastCapturedDmlCount() {
        return this.lastCapturedDmlCount.get();
    }

    @Override
    public long getTotalProcessedRows() {
        return this.totalProcessedRows.get();
    }

    @Override
    public long getTotalResultSetNextTimeInMilliseconds() {
        return this.totalResultSetNextTime.get().toMillis();
    }

    @Override
    public long getAverageBatchProcessingThroughput() {
        if (this.totalBatchProcessingDuration.get().isZero()) {
            return 0L;
        }
        return Math.round(this.totalCapturedDmlCount.floatValue() / (float)this.totalBatchProcessingDuration.get().toMillis() * 1000.0f);
    }

    @Override
    public long getLastBatchProcessingThroughput() {
        if (this.lastBatchProcessingDuration.get().isZero()) {
            return 0L;
        }
        return Math.round(this.lastCapturedDmlCount.floatValue() / (float)this.lastBatchProcessingDuration.get().toMillis() * 1000.0f);
    }

    @Override
    public long getFetchingQueryCount() {
        return this.logMinerQueryCount.get();
    }

    @Override
    public int getBatchSize() {
        return this.batchSize.get();
    }

    @Override
    public long getMillisecondToSleepBetweenMiningQuery() {
        return this.millisecondToSleepBetweenMiningQuery.get();
    }

    @Override
    public boolean getRecordMiningHistory() {
        return this.recordMiningHistory.get();
    }

    @Override
    public int getHoursToKeepTransactionInBuffer() {
        return this.hoursToKeepTransaction.get();
    }

    @Override
    public long getMaxBatchProcessingThroughput() {
        return this.maxBatchProcessingThroughput.get();
    }

    @Override
    public long getNetworkConnectionProblemsCounter() {
        return this.networkConnectionProblemsCounter.get();
    }

    @Override
    public long getTotalParseTimeInMilliseconds() {
        return this.totalParseTime.get().toMillis();
    }

    public void addCurrentParseTime(Duration currentParseTime) {
        this.totalParseTime.accumulateAndGet(currentParseTime, Duration::plus);
    }

    @Override
    public long getTotalMiningSessionStartTimeInMilliseconds() {
        return this.totalStartLogMiningSessionDuration.get().toMillis();
    }

    public void addCurrentMiningSessionStart(Duration currentStartLogMiningSession) {
        this.lastStartLogMiningSessionDuration.set(currentStartLogMiningSession);
        if (currentStartLogMiningSession.compareTo(this.maxStartingLogMiningSessionDuration.get()) > 0) {
            this.maxStartingLogMiningSessionDuration.set(currentStartLogMiningSession);
        }
        this.totalStartLogMiningSessionDuration.accumulateAndGet(currentStartLogMiningSession, Duration::plus);
    }

    @Override
    public long getLastMiningSessionStartTimeInMilliseconds() {
        return this.lastStartLogMiningSessionDuration.get().toMillis();
    }

    @Override
    public long getMaxMiningSessionStartTimeInMilliseconds() {
        return this.maxStartingLogMiningSessionDuration.get().toMillis();
    }

    @Override
    public long getTotalProcessingTimeInMilliseconds() {
        return this.totalProcessingTime.get().toMillis();
    }

    @Override
    public long getMinBatchProcessingTimeInMilliseconds() {
        return this.minBatchProcessingTime.get().toMillis();
    }

    @Override
    public long getMaxBatchProcessingTimeInMilliseconds() {
        return this.maxBatchProcessingTime.get().toMillis();
    }

    public void setCurrentBatchProcessingTime(Duration currentBatchProcessingTime) {
        this.totalProcessingTime.accumulateAndGet(currentBatchProcessingTime, Duration::plus);
    }

    public void addCurrentResultSetNext(Duration currentNextTime) {
        this.totalResultSetNextTime.accumulateAndGet(currentNextTime, Duration::plus);
    }

    public void addProcessedRows(Long rows) {
        this.totalProcessedRows.getAndAdd(rows);
    }

    @Override
    public void setBatchSize(int size) {
        if (size >= this.batchSizeMin && size <= this.batchSizeMax) {
            this.batchSize.set(size);
        }
    }

    @Override
    public void setMillisecondToSleepBetweenMiningQuery(long milliseconds) {
        if (milliseconds >= this.sleepTimeMin && milliseconds < this.sleepTimeMax) {
            this.millisecondToSleepBetweenMiningQuery.set(milliseconds);
        }
    }

    @Override
    public void changeSleepingTime(boolean increment) {
        long sleepTime = this.millisecondToSleepBetweenMiningQuery.get();
        if (increment && sleepTime < this.sleepTimeMax) {
            sleepTime = this.millisecondToSleepBetweenMiningQuery.addAndGet(this.sleepTimeIncrement);
        } else if (sleepTime > this.sleepTimeMin) {
            sleepTime = this.millisecondToSleepBetweenMiningQuery.addAndGet(-this.sleepTimeIncrement);
        }
        LOGGER.debug("Updating sleep time window. Sleep time {}. Min sleep time {}. Max sleep time {}.", new Object[]{sleepTime, this.sleepTimeMin, this.sleepTimeMax});
    }

    @Override
    public void changeBatchSize(boolean increment) {
        int currentBatchSize = this.batchSize.get();
        if (increment && currentBatchSize < this.batchSizeMax) {
            currentBatchSize = this.batchSize.addAndGet(this.batchSizeMin);
        } else if (currentBatchSize > this.batchSizeMin) {
            currentBatchSize = this.batchSize.addAndGet(-this.batchSizeMin);
        }
        if (currentBatchSize == this.batchSizeMax) {
            LOGGER.info("LogMiner is now using the maximum batch size {}. This could be indicative of large SCN gaps", (Object)currentBatchSize);
        } else {
            LOGGER.debug("Updating batch size window. Batch size {}. Min batch size {}. Max batch size {}.", new Object[]{currentBatchSize, this.batchSizeMin, this.batchSizeMax});
        }
    }

    public String toString() {
        return "LogMinerMetrics{currentScn=" + this.currentScn + ", logMinerQueryCount=" + this.logMinerQueryCount + ", totalProcessedRows=" + this.totalProcessedRows + ", totalCapturedDmlCount=" + this.totalCapturedDmlCount + ", totalDurationOfFetchingQuery=" + this.totalDurationOfFetchingQuery + ", lastCapturedDmlCount=" + this.lastCapturedDmlCount + ", lastDurationOfFetchingQuery=" + this.lastDurationOfFetchingQuery + ", maxCapturedDmlCount=" + this.maxCapturedDmlCount + ", maxDurationOfFetchingQuery=" + this.maxDurationOfFetchingQuery + ", totalBatchProcessingDuration=" + this.totalBatchProcessingDuration + ", lastBatchProcessingDuration=" + this.lastBatchProcessingDuration + ", maxBatchProcessingDuration=" + this.maxBatchProcessingDuration + ", maxBatchProcessingThroughput=" + this.maxBatchProcessingThroughput + ", currentLogFileName=" + this.currentLogFileName + ", minLogFilesMined=" + this.minimumLogsMined + ", maxLogFilesMined=" + this.maximumLogsMined + ", redoLogStatus=" + this.redoLogStatus + ", switchCounter=" + this.switchCounter + ", batchSize=" + this.batchSize + ", millisecondToSleepBetweenMiningQuery=" + this.millisecondToSleepBetweenMiningQuery + ", recordMiningHistory=" + this.recordMiningHistory + ", hoursToKeepTransaction=" + this.hoursToKeepTransaction + ", networkConnectionProblemsCounter" + this.networkConnectionProblemsCounter + ", batchSizeDefault=" + this.batchSizeDefault + ", batchSizeMin=" + this.batchSizeMin + ", batchSizeMax=" + this.batchSizeMax + ", sleepTimeDefault=" + this.sleepTimeDefault + ", sleepTimeMin=" + this.sleepTimeMin + ", sleepTimeMax=" + this.sleepTimeMax + ", sleepTimeIncrement=" + this.sleepTimeIncrement + ", totalParseTime=" + this.totalParseTime + ", totalStartLogMiningSessionDuration=" + this.totalStartLogMiningSessionDuration + ", lastStartLogMiningSessionDuration=" + this.lastStartLogMiningSessionDuration + ", maxStartLogMiningSessionDuration=" + this.maxStartingLogMiningSessionDuration + ", totalProcessTime=" + this.totalProcessingTime + ", minBatchProcessTime=" + this.minBatchProcessingTime + ", maxBatchProcessTime=" + this.maxBatchProcessingTime + ", totalResultSetNextTime=" + this.totalResultSetNextTime + '}';
    }
}

