/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.util;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Strings;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Map;

public class TestHelper {
    private static final String PDB_NAME = "pdb.name";
    private static final String DATABASE_PREFIX = "database.";
    private static final String DATABASE_ADMIN_PREFIX = "database.admin.";
    public static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-connect.txt").toAbsolutePath();
    public static final String CONNECTOR_USER = "c##dbzuser";
    public static final String CONNECTOR_NAME = "oracle";
    public static final String SERVER_NAME = "server1";
    public static final String CONNECTOR_USER_PASS = "dbz";
    public static final String HOST = "localhost";
    public static final String SCHEMA_USER = "debezium";
    public static final String SCHEMA_PASS = "dbz";
    public static final String DATABASE = "ORCLPDB1";
    public static final String DATABASE_CDB = "ORCLCDB";
    public static final int PORT = 1521;
    public static final String TYPE_NAME_PARAMETER_KEY = "__debezium.source.column.type";
    public static final String TYPE_LENGTH_PARAMETER_KEY = "__debezium.source.column.length";
    public static final String TYPE_SCALE_PARAMETER_KEY = "__debezium.source.column.scale";

    public static String getConnectorUserName() {
        String userName = TestHelper.getDatabaseConfig(DATABASE_PREFIX).getString(JdbcConfiguration.USER.name());
        return Strings.isNullOrEmpty((String)userName) ? CONNECTOR_USER : userName;
    }

    private static String getConnectorUserPassword() {
        String password = TestHelper.getDatabaseConfig(DATABASE_PREFIX).getString(JdbcConfiguration.PASSWORD.name());
        return Strings.isNullOrEmpty((String)password) ? "dbz" : password;
    }

    public static String getDatabaseName() {
        String databaseName = TestHelper.getDatabaseConfig(DATABASE_PREFIX).getString(JdbcConfiguration.DATABASE);
        return Strings.isNullOrEmpty((String)databaseName) ? DATABASE : databaseName;
    }

    private static JdbcConfiguration defaultJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)TestHelper.getDatabaseConfig(DATABASE_PREFIX)).withDefault(JdbcConfiguration.HOSTNAME, HOST)).withDefault(JdbcConfiguration.PORT, 1521)).withDefault(JdbcConfiguration.USER, TestHelper.getConnectorUserName())).withDefault(JdbcConfiguration.PASSWORD, TestHelper.getConnectorUserPassword())).withDefault(JdbcConfiguration.DATABASE, DATABASE_CDB)).build();
    }

    public static Configuration.Builder defaultConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.defaultJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with(DATABASE_PREFIX + field, value));
        if (TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.XSTREAM)) {
            builder.withDefault(OracleConnectorConfig.XSTREAM_SERVER_NAME, "dbzxout");
        }
        if (!Configuration.fromSystemProperties((String)DATABASE_PREFIX).asMap().containsKey(PDB_NAME)) {
            builder.withDefault(OracleConnectorConfig.PDB_NAME, DATABASE);
        }
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)builder.with(OracleConnectorConfig.SERVER_NAME, SERVER_NAME)).with(OracleConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).with(OracleConnectorConfig.INCLUDE_SCHEMA_CHANGES, false);
    }

    public static OracleConnection defaultConnection() {
        Configuration config = TestHelper.defaultConfig().build();
        Configuration jdbcConfig = config.subset(DATABASE_PREFIX, true);
        return TestHelper.createConnection(config, jdbcConfig, true);
    }

    private static JdbcConfiguration testJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)TestHelper.getDatabaseConfig(DATABASE_PREFIX)).withDefault(JdbcConfiguration.HOSTNAME, HOST)).withDefault(JdbcConfiguration.PORT, 1521)).with(JdbcConfiguration.USER, SCHEMA_USER)).with(JdbcConfiguration.PASSWORD, "dbz")).withDefault(JdbcConfiguration.DATABASE, DATABASE)).build();
    }

    private static JdbcConfiguration adminJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)TestHelper.getDatabaseConfig(DATABASE_ADMIN_PREFIX)).withDefault(JdbcConfiguration.HOSTNAME, HOST)).withDefault(JdbcConfiguration.PORT, 1521)).withDefault(JdbcConfiguration.USER, "sys as sysdba")).withDefault(JdbcConfiguration.PASSWORD, "top_secret")).withDefault(JdbcConfiguration.DATABASE, TestHelper.getDatabaseName())).build();
    }

    private static Configuration.Builder testConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.testJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with(DATABASE_PREFIX + field, value));
        return builder;
    }

    private static Configuration.Builder adminConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.adminJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with(DATABASE_PREFIX + field, value));
        return builder;
    }

    private static Configuration getDatabaseConfig(String prefix) {
        String pdbName;
        Configuration config = Configuration.fromSystemProperties((String)prefix);
        if (config.hasKey(PDB_NAME) && Strings.isNullOrEmpty((String)(pdbName = config.getString(PDB_NAME)))) {
            Map map = config.asMap();
            map.remove(PDB_NAME);
            config = Configuration.from((Map)map);
        }
        return config;
    }

    public static OracleConnection testConnection() {
        Configuration config = TestHelper.testConfig().build();
        Configuration jdbcConfig = config.subset(DATABASE_PREFIX, true);
        return TestHelper.createConnection(config, jdbcConfig, false);
    }

    public static OracleConnection adminConnection() {
        Configuration config = TestHelper.adminConfig().build();
        Configuration jdbcConfig = config.subset(DATABASE_PREFIX, true);
        return TestHelper.createConnection(config, jdbcConfig, false);
    }

    private static OracleConnection createConnection(Configuration config, Configuration jdbcConfig, boolean autoCommit) {
        OracleConnection connection = new OracleConnection(jdbcConfig, TestHelper.class::getClassLoader);
        try {
            connection.setAutoCommit(autoCommit);
            String pdbName = new OracleConnectorConfig(config).getPdbName();
            if (!Strings.isNullOrEmpty((String)pdbName)) {
                connection.setSessionToPdb(pdbName);
            }
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create connection", e);
        }
    }

    public static void forceLogfileSwitch() {
        Configuration config = TestHelper.adminConfig().build();
        Configuration jdbcConfig = config.subset(DATABASE_PREFIX, true);
        try (OracleConnection jdbcConnection = new OracleConnection(jdbcConfig, TestHelper.class::getClassLoader);){
            if (new OracleConnectorConfig(TestHelper.defaultConfig().build()).getPdbName() != null) {
                jdbcConnection.resetSessionToCdb();
            }
            jdbcConnection.execute(new String[]{"ALTER SYSTEM SWITCH LOGFILE"});
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to switch logfile", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getNumberOfOnlineLogGroups() {
        Configuration config = TestHelper.adminConfig().build();
        Configuration jdbcConfig = config.subset(DATABASE_PREFIX, true);
        try (OracleConnection jdbcConnection = new OracleConnection(jdbcConfig, TestHelper.class::getClassLoader);){
            if (new OracleConnectorConfig(TestHelper.defaultConfig().build()).getPdbName() != null) {
                jdbcConnection.resetSessionToCdb();
            }
            int n = (Integer)jdbcConnection.queryAndMap("SELECT COUNT(GROUP#) FROM V$LOG", rs -> {
                rs.next();
                return rs.getInt(1);
            });
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get redo log groups", e);
        }
    }

    public static void forceFlushOfRedoLogsToArchiveLogs() {
        int groups = TestHelper.getNumberOfOnlineLogGroups();
        for (int i = 0; i < groups; ++i) {
            TestHelper.forceLogfileSwitch();
        }
    }

    public static void dropTable(OracleConnection connection, String table) {
        block2: {
            try {
                connection.execute(new String[]{"DROP TABLE " + table});
            }
            catch (SQLException e) {
                if (e.getMessage().contains("ORA-00942") && 942 == e.getErrorCode()) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    public static void streamTable(OracleConnection connection, String table) throws SQLException {
        connection.execute(new String[]{String.format("GRANT SELECT ON %s TO %s", table, TestHelper.getConnectorUserName())});
        connection.execute(new String[]{String.format("ALTER TABLE %s ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS", table)});
    }

    public static void purgeRecycleBin(OracleConnection connection) {
        try {
            connection.execute(new String[]{"PURGE RECYCLEBIN"});
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to clear user recyclebin", e);
        }
    }

    public static int defaultMessageConsumerPollTimeout() {
        return 120;
    }

    public static OracleConnectorConfig.ConnectorAdapter adapter() {
        String s = System.getProperty(OracleConnectorConfig.CONNECTOR_ADAPTER.name());
        return s == null || s.length() == 0 ? OracleConnectorConfig.ConnectorAdapter.LOG_MINER : OracleConnectorConfig.ConnectorAdapter.parse((String)s);
    }
}

