/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.config.Configuration;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.LogMinerMetrics;
import io.debezium.connector.oracle.logminer.Scn;
import io.debezium.doc.FixFor;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.fest.assertions.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class LogMinerMetricsTest {
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    private CdcSourceTaskContext getSourceTaskContext() {
        CdcSourceTaskContext taskContext = (CdcSourceTaskContext)Mockito.mock(CdcSourceTaskContext.class);
        Mockito.when((Object)taskContext.getConnectorName()).thenReturn((Object)"connector name");
        Mockito.when((Object)taskContext.getConnectorType()).thenReturn((Object)"connector type");
        return taskContext;
    }

    @Test
    public void testMetrics() {
        CdcSourceTaskContext taskContext = this.getSourceTaskContext();
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(Configuration.create().build());
        LogMinerMetrics metrics = new LogMinerMetrics(taskContext, connectorConfig);
        metrics.setLastCapturedDmlCount(1);
        Assertions.assertThat((metrics.getTotalCapturedDmlCount() == 1L ? 1 : 0) != 0).isTrue();
        metrics.setCurrentScn(Scn.valueOf((long)1000L));
        Assertions.assertThat((Long)metrics.getCurrentScn()).isEqualTo(1000L);
        metrics.setBatchSize(10);
        Assertions.assertThat((metrics.getBatchSize() == connectorConfig.getLogMiningBatchSizeDefault() ? 1 : 0) != 0).isTrue();
        metrics.setBatchSize(1000000);
        Assertions.assertThat((int)metrics.getBatchSize()).isEqualTo(connectorConfig.getLogMiningBatchSizeDefault());
        metrics.setBatchSize(6000);
        Assertions.assertThat((int)metrics.getBatchSize()).isEqualTo(6000);
        Assertions.assertThat((long)metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1000L);
        metrics.changeSleepingTime(true);
        Assertions.assertThat((long)metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1200L);
        metrics.changeSleepingTime(false);
        Assertions.assertThat((long)metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1000L);
        metrics.setMillisecondToSleepBetweenMiningQuery(-1L);
        Assertions.assertThat((long)metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1000L);
        metrics.setMillisecondToSleepBetweenMiningQuery(4000L);
        Assertions.assertThat((long)metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1000L);
        metrics.setMillisecondToSleepBetweenMiningQuery(2000L);
        Assertions.assertThat((long)metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(2000L);
        metrics.setLastDurationOfBatchCapturing(Duration.ofMillis(100L));
        Assertions.assertThat((Long)metrics.getLastDurationOfFetchQueryInMilliseconds()).isEqualTo(100L);
        metrics.setLastDurationOfBatchCapturing(Duration.ofMillis(200L));
        Assertions.assertThat((Long)metrics.getLastDurationOfFetchQueryInMilliseconds()).isEqualTo(200L);
        Assertions.assertThat((Long)metrics.getMaxDurationOfFetchQueryInMilliseconds()).isEqualTo(200L);
        Assertions.assertThat((long)metrics.getFetchingQueryCount()).isEqualTo(2L);
        metrics.setCurrentLogFileName(new HashSet<String>(Arrays.asList("name", "name1")));
        Assertions.assertThat((boolean)metrics.getCurrentRedoLogFileName()[0].equals("name")).isTrue();
        Assertions.assertThat((boolean)metrics.getCurrentRedoLogFileName()[1].equals("name1")).isTrue();
        metrics.setSwitchCount(5);
        Assertions.assertThat((metrics.getSwitchCounter() == 5 ? 1 : 0) != 0).isTrue();
        metrics.reset();
        metrics.setLastDurationOfBatchCapturing(Duration.ofMillis(1000L));
        Assertions.assertThat((Long)metrics.getLastDurationOfFetchQueryInMilliseconds()).isEqualTo(1000L);
        Assertions.assertThat((long)metrics.getFetchingQueryCount()).isEqualTo(1L);
        metrics.reset();
        metrics.setLastCapturedDmlCount(300);
        metrics.setLastDurationOfBatchProcessing(Duration.ofMillis(1000L));
        Assertions.assertThat((int)metrics.getLastCapturedDmlCount()).isEqualTo(300);
        Assertions.assertThat((long)metrics.getLastBatchProcessingTimeInMilliseconds()).isEqualTo(1000L);
        Assertions.assertThat((long)metrics.getAverageBatchProcessingThroughput()).isGreaterThanOrEqualTo(300L);
        Assertions.assertThat((Long)metrics.getMaxCapturedDmlInBatch()).isEqualTo(300L);
        Assertions.assertThat((long)metrics.getMaxBatchProcessingThroughput()).isEqualTo(300L);
        metrics.setLastCapturedDmlCount(500);
        metrics.setLastDurationOfBatchProcessing(Duration.ofMillis(1000L));
        Assertions.assertThat((long)metrics.getAverageBatchProcessingThroughput()).isEqualTo(400L);
        Assertions.assertThat((Long)metrics.getMaxCapturedDmlInBatch()).isEqualTo(500L);
        Assertions.assertThat((long)metrics.getMaxBatchProcessingThroughput()).isEqualTo(500L);
        Assertions.assertThat((long)metrics.getLastBatchProcessingThroughput()).isEqualTo(500L);
        metrics.setLastDurationOfBatchProcessing(Duration.ofMillis(5000L));
        Assertions.assertThat((long)metrics.getLastBatchProcessingThroughput()).isEqualTo(100L);
        metrics.setLastDurationOfBatchProcessing(Duration.ZERO);
        Assertions.assertThat((long)metrics.getLastBatchProcessingThroughput()).isEqualTo(0L);
        Assertions.assertThat((int)metrics.getHoursToKeepTransactionInBuffer()).isEqualTo(0);
        metrics.setRedoLogStatus(Collections.singletonMap("name", "current"));
        Assertions.assertThat((boolean)metrics.getRedoLogStatus()[0].equals("name | current")).isTrue();
        Assertions.assertThat((boolean)metrics.toString().contains("logMinerQueryCount"));
        Assertions.assertThat((boolean)metrics.getRecordMiningHistory()).isFalse();
        metrics.incrementNetworkConnectionProblemsCounter();
        Assertions.assertThat((long)metrics.getNetworkConnectionProblemsCounter()).isEqualTo(1L);
        metrics.setBatchSize(5000);
        metrics.changeBatchSize(true);
        Assertions.assertThat((int)metrics.getBatchSize()).isEqualTo(6000);
        metrics.changeBatchSize(false);
        Assertions.assertThat((int)metrics.getBatchSize()).isEqualTo(5000);
    }

    @Test
    @FixFor(value={"DBZ-2754"})
    public void testCustomTransactionRetention() throws Exception {
        CdcSourceTaskContext taskContext = this.getSourceTaskContext();
        Configuration config = ((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.LOG_MINING_TRANSACTION_RETENTION, 3)).build();
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(config);
        LogMinerMetrics metrics = new LogMinerMetrics(taskContext, connectorConfig);
        Assertions.assertThat((int)metrics.getHoursToKeepTransactionInBuffer()).isEqualTo(3);
    }
}

