/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.logminer.parser.LogMinerDmlParser;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValue;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntry;
import io.debezium.data.Envelope;
import io.debezium.doc.FixFor;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class LogMinerDmlParserTest {
    private static final String CATALOG_NAME = "ORCLCDB1";
    private static final String SCHEMA_NAME = "DEBEZIUM";
    private LogMinerDmlParser fastDmlParser;

    @Before
    public void beforeEach() throws Exception {
        this.fastDmlParser = new LogMinerDmlParser();
    }

    @Test
    @FixFor(value={"DBZ-3078"})
    public void testParsingInsert() throws Exception {
        String sql = "insert into \"DEBEZIUM\".\"TEST\"(\"ID\",\"NAME\",\"TS\",\"UT\",\"DATE\",\"UT2\",\"C1\",\"C2\") values ('1','Acme',TO_TIMESTAMP('2020-02-01 00:00:00.'),Unsupported Type,TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS'),Unsupported Type,NULL,NULL);";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, null, null, null);
        Assertions.assertThat((Object)entry.getCommandType()).isEqualTo((Object)Envelope.Operation.CREATE);
        Assertions.assertThat((List)entry.getOldValues()).isEmpty();
        Assertions.assertThat((List)entry.getNewValues()).hasSize(8);
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnName()).isEqualTo((Object)"ID");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(1)).getColumnName()).isEqualTo((Object)"NAME");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(2)).getColumnName()).isEqualTo((Object)"TS");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(3)).getColumnName()).isEqualTo((Object)"UT");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(4)).getColumnName()).isEqualTo((Object)"DATE");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(5)).getColumnName()).isEqualTo((Object)"UT2");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(6)).getColumnName()).isEqualTo((Object)"C1");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnData()).isEqualTo((Object)"1");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(1)).getColumnData()).isEqualTo((Object)"Acme");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(2)).getColumnData()).isEqualTo((Object)"TO_TIMESTAMP('2020-02-01 00:00:00.')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(3)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(4)).getColumnData()).isEqualTo((Object)"TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(5)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(6)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(7)).getColumnData()).isNull();
    }

    @Test
    @FixFor(value={"DBZ-3078"})
    public void testParsingUpdate() throws Exception {
        String sql = "update \"DEBEZIUM\".\"TEST\" set \"NAME\" = 'Bob', \"TS\" = TO_TIMESTAMP('2020-02-02 00:00:00.'), \"UT\" = Unsupported Type, \"DATE\" = TO_DATE('2020-02-02 00:00:00', 'YYYY-MM-DD HH24:MI:SS'), \"UT2\" = Unsupported Type, \"C1\" = NULL where \"ID\" = '1' and \"NAME\" = 'Acme' and \"TS\" = TO_TIMESTAMP('2020-02-01 00:00:00.') and \"UT\" = Unsupported Type and \"DATE\" = TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS') and \"UT2\" = Unsupported Type and \"C1\" = NULL and \"IS\" IS NULL and \"IS2\" IS NULL;";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, null, null, null);
        Assertions.assertThat((Object)entry.getCommandType()).isEqualTo((Object)Envelope.Operation.UPDATE);
        Assertions.assertThat((List)entry.getOldValues()).hasSize(9);
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(0)).getColumnName()).isEqualTo((Object)"ID");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(1)).getColumnName()).isEqualTo((Object)"NAME");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(2)).getColumnName()).isEqualTo((Object)"TS");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(3)).getColumnName()).isEqualTo((Object)"UT");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(4)).getColumnName()).isEqualTo((Object)"DATE");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(5)).getColumnName()).isEqualTo((Object)"UT2");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(0)).getColumnData()).isEqualTo((Object)"1");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(1)).getColumnData()).isEqualTo((Object)"Acme");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(2)).getColumnData()).isEqualTo((Object)"TO_TIMESTAMP('2020-02-01 00:00:00.')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(3)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(4)).getColumnData()).isEqualTo((Object)"TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(5)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(6)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(7)).getColumnData()).isNull();
        Assertions.assertThat((List)entry.getNewValues()).hasSize(9);
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnName()).isEqualTo((Object)"ID");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(1)).getColumnName()).isEqualTo((Object)"NAME");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(2)).getColumnName()).isEqualTo((Object)"TS");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(3)).getColumnName()).isEqualTo((Object)"UT");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(4)).getColumnName()).isEqualTo((Object)"DATE");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(5)).getColumnName()).isEqualTo((Object)"UT2");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnData()).isEqualTo((Object)"1");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(1)).getColumnData()).isEqualTo((Object)"Bob");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(2)).getColumnData()).isEqualTo((Object)"TO_TIMESTAMP('2020-02-02 00:00:00.')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(3)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(4)).getColumnData()).isEqualTo((Object)"TO_DATE('2020-02-02 00:00:00', 'YYYY-MM-DD HH24:MI:SS')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(5)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(6)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(7)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(8)).getColumnData()).isNull();
    }

    @Test
    @FixFor(value={"DBZ-3078"})
    public void testParsingDelete() throws Exception {
        String sql = "delete from \"DEBEZIUM\".\"TEST\" where \"ID\" = '1' and \"NAME\" = 'Acme' and \"TS\" = TO_TIMESTAMP('2020-02-01 00:00:00.') and \"UT\" = Unsupported Type and \"DATE\" = TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS') and \"IS\" IS NULL and \"IS2\" IS NULL;";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, null, null, null);
        Assertions.assertThat((Object)entry.getCommandType()).isEqualTo((Object)Envelope.Operation.DELETE);
        Assertions.assertThat((List)entry.getOldValues()).hasSize(7);
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(0)).getColumnName()).isEqualTo((Object)"ID");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(1)).getColumnName()).isEqualTo((Object)"NAME");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(2)).getColumnName()).isEqualTo((Object)"TS");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(3)).getColumnName()).isEqualTo((Object)"UT");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getOldValues().get(4)).getColumnName()).isEqualTo((Object)"DATE");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(0)).getColumnData()).isEqualTo((Object)"1");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(1)).getColumnData()).isEqualTo((Object)"Acme");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(2)).getColumnData()).isEqualTo((Object)"TO_TIMESTAMP('2020-02-01 00:00:00.')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(3)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(4)).getColumnData()).isEqualTo((Object)"TO_DATE('2020-02-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS')");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(5)).getColumnData()).isNull();
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getOldValues().get(6)).getColumnData()).isNull();
        Assertions.assertThat((List)entry.getNewValues()).isEmpty();
    }

    @Test
    @FixFor(value={"DBZ-3235"})
    public void testParsingUpdateWithNoWhereClauseIsAcceptable() throws Exception {
        String sql = "update \"DEBEZIUM\".\"TEST\" set \"COL1\" = '1', \"COL2\" = NULL, \"COL3\" = 'Hello';";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, null, null, null);
        Assertions.assertThat((Object)entry.getCommandType()).isEqualTo((Object)Envelope.Operation.UPDATE);
        Assertions.assertThat((List)entry.getOldValues()).isEmpty();
        Assertions.assertThat((List)entry.getNewValues()).hasSize(3);
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnName()).isEqualTo((Object)"COL1");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnData()).isEqualTo((Object)"1");
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(1)).getColumnName()).isEqualTo((Object)"COL2");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(1)).getColumnData()).isNull();
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(2)).getColumnName()).isEqualTo((Object)"COL3");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(2)).getColumnData()).isEqualTo((Object)"Hello");
    }

    @Test
    @FixFor(value={"DBZ-3235"})
    public void testParsingDeleteWithNoWhereClauseIsAcceptable() throws Exception {
        String sql = "delete from \"DEBEZIUM\".\"TEST\";";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, null, null, null);
        Assertions.assertThat((Object)entry.getCommandType()).isEqualTo((Object)Envelope.Operation.DELETE);
        Assertions.assertThat((List)entry.getOldValues()).isEmpty();
        Assertions.assertThat((List)entry.getNewValues()).isEmpty();
    }

    @Test
    @FixFor(value={"DBZ-3258"})
    public void testNameWithWhitespaces() throws Exception {
        String sql = "insert into \"UNKNOWN\".\"OBJ# 74858\"(\"COL 1\") values (1)";
        LogMinerDmlEntry entry = this.fastDmlParser.parse(sql, null, null, null);
        Assertions.assertThat((Object)entry.getCommandType()).isEqualTo((Object)Envelope.Operation.CREATE);
        Assertions.assertThat((List)entry.getOldValues()).isEmpty();
        Assertions.assertThat((List)entry.getNewValues()).hasSize(1);
        Assertions.assertThat((String)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnName()).isEqualTo((Object)"COL 1");
        Assertions.assertThat((Object)((LogMinerColumnValue)entry.getNewValues().get(0)).getColumnData()).isEqualTo((Object)"1");
    }
}

