/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Field;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Connector;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OracleConnectorTest {
    OracleConnector connector;

    @Before
    public void before() {
        this.connector = new OracleConnector();
    }

    @Test
    public void testValidateUnableToConnectNoThrow() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(OracleConnectorConfig.HOSTNAME.name(), "narnia");
        config.put(OracleConnectorConfig.PORT.name(), "4321");
        config.put(OracleConnectorConfig.DATABASE_NAME.name(), "oracle");
        config.put(OracleConnectorConfig.USER.name(), "pikachu");
        config.put(OracleConnectorConfig.PASSWORD.name(), "raichu");
        Config validated = this.connector.validate(config);
        for (ConfigValue value : validated.configValues()) {
            if (!value.name().equals(OracleConnectorConfig.HOSTNAME.name())) continue;
            Assertions.assertThat((boolean)((String)value.errorMessages().get(0)).startsWith("Unable to connect"));
        }
    }

    @Test
    public void shouldReturnConfigurationDefinition() {
        OracleConnectorTest.assertConfigDefIsValid((Connector)this.connector, OracleConnectorConfig.ALL_FIELDS);
    }

    protected static void assertConfigDefIsValid(Connector connector, Field.Set fields) {
        ConfigDef configDef = connector.config();
        Assertions.assertThat((Object)configDef).isNotNull();
        fields.forEach(expected -> {
            Assertions.assertThat((Collection)configDef.names()).contains(new Object[]{expected.name()});
            ConfigDef.ConfigKey key = (ConfigDef.ConfigKey)configDef.configKeys().get(expected.name());
            Assertions.assertThat((Object)key).isNotNull();
            Assertions.assertThat((String)key.name).isEqualTo((Object)expected.name());
            Assertions.assertThat((String)key.displayName).isEqualTo((Object)expected.displayName());
            Assertions.assertThat((Object)key.importance).isEqualTo((Object)expected.importance());
            Assertions.assertThat((String)key.documentation).isEqualTo((Object)expected.description());
            Assertions.assertThat((Object)key.type).isEqualTo((Object)expected.type());
            if (expected.equals((Object)OracleConnectorConfig.DATABASE_HISTORY)) {
                Assertions.assertThat((String)((Class)key.defaultValue).getName()).isEqualTo((Object)((String)expected.defaultValue()));
            }
            Assertions.assertThat((List)key.dependents).isEqualTo((Object)expected.dependents());
            Assertions.assertThat((Object)key.width).isNotNull();
            Assertions.assertThat((String)key.group).isNotNull();
            Assertions.assertThat((int)key.orderInGroup).isGreaterThan(0);
            Assertions.assertThat((Object)key.validator).isNull();
            Assertions.assertThat((Object)key.recommender).isNull();
        });
    }
}

