/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.doc.FixFor;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.relational.history.KafkaDatabaseHistory;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnectorConfigTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleConnectorConfigTest.class);
    private static final String TABLENAME_CASE_INSENSITIVE_WARNING = "The option '" + OracleConnectorConfig.TABLENAME_CASE_INSENSITIVE + "' is deprecated and will be removed in the future.";

    @Test
    public void validXtreamNoUrl() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.SERVER_NAME, "myserver")).with(OracleConnectorConfig.HOSTNAME, "MyHostname")).with(OracleConnectorConfig.DATABASE_NAME, "mydb")).with(OracleConnectorConfig.XSTREAM_SERVER_NAME, "myserver")).with(OracleConnectorConfig.USER, "debezium")).with(KafkaDatabaseHistory.BOOTSTRAP_SERVERS, "localhost:9092")).with(KafkaDatabaseHistory.TOPIC, "history")).build());
        Assert.assertTrue((boolean)connectorConfig.validateAndRecord((Iterable)OracleConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void validLogminerNoUrl() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.CONNECTOR_ADAPTER, "logminer")).with(OracleConnectorConfig.SERVER_NAME, "myserver")).with(OracleConnectorConfig.HOSTNAME, "MyHostname")).with(OracleConnectorConfig.DATABASE_NAME, "mydb")).with(OracleConnectorConfig.USER, "debezium")).with(KafkaDatabaseHistory.BOOTSTRAP_SERVERS, "localhost:9092")).with(KafkaDatabaseHistory.TOPIC, "history")).build());
        Assert.assertTrue((boolean)connectorConfig.validateAndRecord((Iterable)OracleConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void validXtreamWithUrl() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.SERVER_NAME, "myserver")).with(OracleConnectorConfig.URL, "jdbc:oci:thin:@myserver/mydatabase")).with(OracleConnectorConfig.DATABASE_NAME, "mydb")).with(OracleConnectorConfig.XSTREAM_SERVER_NAME, "myserver")).with(OracleConnectorConfig.USER, "debezium")).with(KafkaDatabaseHistory.BOOTSTRAP_SERVERS, "localhost:9092")).with(KafkaDatabaseHistory.TOPIC, "history")).build());
        Assert.assertTrue((boolean)connectorConfig.validateAndRecord((Iterable)OracleConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void validLogminerWithUrl() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.CONNECTOR_ADAPTER, "logminer")).with(OracleConnectorConfig.SERVER_NAME, "myserver")).with(OracleConnectorConfig.URL, "MyHostname")).with(OracleConnectorConfig.DATABASE_NAME, "mydb")).with(OracleConnectorConfig.USER, "debezium")).with(KafkaDatabaseHistory.BOOTSTRAP_SERVERS, "localhost:9092")).with(KafkaDatabaseHistory.TOPIC, "history")).build());
        Assert.assertTrue((boolean)connectorConfig.validateAndRecord((Iterable)OracleConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void validUrlTNS() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.CONNECTOR_ADAPTER, "logminer")).with(OracleConnectorConfig.SERVER_NAME, "myserver")).with(OracleConnectorConfig.URL, "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=192.68.1.11)(PORT=1701))(ADDRESS=(PROTOCOL=TCP)(HOST=192.68.1.12)(PORT=1701))(ADDRESS=(PROTOCOL=TCP)(HOST=192.68.1.13)(PORT=1701))(LOAD_BALANCE = yes)(FAILOVER = on)(CONNECT_DATA =(SERVER = DEDICATED)(SERVICE_NAME = myserver.mydomain.com)(FAILOVER_MODE =(TYPE = SELECT)(METHOD = BASIC)(RETRIES = 3)(DELAY = 5))))")).with(OracleConnectorConfig.DATABASE_NAME, "mydb")).with(OracleConnectorConfig.USER, "debezium")).with(KafkaDatabaseHistory.BOOTSTRAP_SERVERS, "localhost:9092")).with(KafkaDatabaseHistory.TOPIC, "history")).build());
        Assert.assertTrue((boolean)connectorConfig.validateAndRecord((Iterable)OracleConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void invalidNoHostnameNoUri() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.CONNECTOR_ADAPTER, "logminer")).with(OracleConnectorConfig.SERVER_NAME, "myserver")).with(OracleConnectorConfig.DATABASE_NAME, "mydb")).with(OracleConnectorConfig.USER, "debezium")).with(KafkaDatabaseHistory.BOOTSTRAP_SERVERS, "localhost:9092")).with(KafkaDatabaseHistory.TOPIC, "history")).build());
        Assert.assertFalse((boolean)connectorConfig.validateAndRecord((Iterable)OracleConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void validBatchDefaults() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(Configuration.create().build());
        Assert.assertEquals((long)connectorConfig.getLogMiningBatchSizeDefault(), (long)20000L);
        Assert.assertEquals((long)connectorConfig.getLogMiningBatchSizeMax(), (long)100000L);
        Assert.assertEquals((long)connectorConfig.getLogMiningBatchSizeMin(), (long)1000L);
    }

    @Test
    public void validSleepDefaults() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(Configuration.create().build());
        Assert.assertEquals((Object)connectorConfig.getLogMiningSleepTimeDefault(), (Object)OracleConnectorConfig.DEFAULT_SLEEP_TIME);
        Assert.assertEquals((Object)connectorConfig.getLogMiningSleepTimeMax(), (Object)OracleConnectorConfig.MAX_SLEEP_TIME);
        Assert.assertEquals((Object)connectorConfig.getLogMiningSleepTimeMin(), (Object)OracleConnectorConfig.MIN_SLEEP_TIME);
        Assert.assertEquals((Object)connectorConfig.getLogMiningSleepTimeIncrement(), (Object)OracleConnectorConfig.SLEEP_TIME_INCREMENT);
    }

    @Test
    public void validViewFetchSizeDefaults() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(Configuration.create().build());
        Assert.assertEquals((long)connectorConfig.getLogMiningViewFetchSize(), (long)10000L);
    }

    @Test
    @FixFor(value={"DBZ-2754"})
    public void validTransactionRetentionDefaults() throws Exception {
        Configuration config = Configuration.create().build();
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(config);
        Assertions.assertThat((Object)connectorConfig.getLogMiningTransactionRetention()).isEqualTo((Object)Duration.ZERO);
    }

    @Test
    @FixFor(value={"DBZ-2754"})
    public void testTransactionRetention() throws Exception {
        Field transactionRetentionField = OracleConnectorConfig.LOG_MINING_TRANSACTION_RETENTION;
        Configuration config = ((Configuration.Builder)Configuration.create().with(transactionRetentionField, 3)).build();
        Assertions.assertThat((boolean)config.validateAndRecord(Collections.singletonList(transactionRetentionField), arg_0 -> ((Logger)LOGGER).error(arg_0))).isTrue();
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(config);
        Assertions.assertThat((Object)connectorConfig.getLogMiningTransactionRetention()).isEqualTo((Object)Duration.ofHours(3L));
        config = ((Configuration.Builder)Configuration.create().with(transactionRetentionField, 0)).build();
        Assertions.assertThat((boolean)config.validateAndRecord(Collections.singletonList(transactionRetentionField), arg_0 -> ((Logger)LOGGER).error(arg_0))).isTrue();
        config = ((Configuration.Builder)Configuration.create().with(transactionRetentionField, -1)).build();
        Assertions.assertThat((boolean)config.validateAndRecord(Collections.singletonList(transactionRetentionField), arg_0 -> ((Logger)LOGGER).error(arg_0))).isFalse();
    }

    @Test
    @FixFor(value={"DBZ-3190"})
    public void shouldLogDeprecationWarningForTablenameCaseInsensitiveTrue() throws Exception {
        LogInterceptor logInterceptor = new LogInterceptor();
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.TABLENAME_CASE_INSENSITIVE, true)).build());
        Assertions.assertThat((Object)connectorConfig.getTablenameCaseInsensitive()).isEqualTo(Optional.of(true));
        Assertions.assertThat((boolean)logInterceptor.containsMessage(TABLENAME_CASE_INSENSITIVE_WARNING)).isTrue();
    }

    @Test
    @FixFor(value={"DBZ-3190"})
    public void shouldLogDeprecationWarningForTablenameCaseInsensitiveFalse() throws Exception {
        LogInterceptor logInterceptor = new LogInterceptor();
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.TABLENAME_CASE_INSENSITIVE, false)).build());
        Assertions.assertThat((Object)connectorConfig.getTablenameCaseInsensitive()).isEqualTo(Optional.of(false));
        Assertions.assertThat((boolean)logInterceptor.containsMessage(TABLENAME_CASE_INSENSITIVE_WARNING)).isTrue();
    }

    @Test
    @FixFor(value={"DBZ-3190"})
    public void shouldNotBePresentWhenTablenameCaseInsensitiveNotSupplied() throws Exception {
        LogInterceptor logInterceptor = new LogInterceptor();
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(Configuration.create().build());
        Assertions.assertThat((Object)connectorConfig.getTablenameCaseInsensitive()).isEqualTo(Optional.empty());
        Assertions.assertThat((boolean)logInterceptor.containsMessage(TABLENAME_CASE_INSENSITIVE_WARNING)).isFalse();
    }
}

