/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.LogFile;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.Scn;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.fest.assertions.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER, reason="LogMiner specific tests")
public class LogMinerHelperIT
extends AbstractConnectorTest {
    @Rule
    public final TestRule skipAdapterRule = new SkipTestDependingOnAdapterNameRule();
    private static OracleConnection conn;

    @BeforeClass
    public static void beforeSuperClass() throws SQLException {
        try (OracleConnection adminConnection = TestHelper.adminConnection();){
            adminConnection.resetSessionToCdb();
            LogMinerHelper.removeLogFilesFromMining((OracleConnection)adminConnection);
        }
        conn = TestHelper.defaultConnection();
        conn.resetSessionToCdb();
    }

    @AfterClass
    public static void closeConnection() throws SQLException {
        if (conn != null && conn.isConnected()) {
            conn.close();
        }
    }

    @Before
    public void before() throws SQLException {
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @Test
    public void shouldAddRightArchivedRedoFiles() throws Exception {
        Scn currentScn = LogMinerHelper.getCurrentScn((OracleConnection)conn);
        Map archivedRedoFiles = LogMinerHelper.getMap((OracleConnection)conn, (String)SqlUtils.archiveLogsQuery((Scn)currentScn, (Duration)Duration.ofHours(0L)), (String)"-1");
        Assertions.assertThat((archivedRedoFiles.size() == 0 ? 1 : 0) != 0).isTrue();
        List<Scn> oneDayArchivedNextScn = this.getOneDayArchivedLogNextScn(conn);
        Scn oldestArchivedScn = this.getOldestArchivedScn(oneDayArchivedNextScn);
        List archivedLogsForMining = LogMinerHelper.getArchivedLogFilesForOffsetScn((OracleConnection)conn, (Scn)oldestArchivedScn, (Duration)Duration.ofHours(0L));
        Assertions.assertThat((archivedLogsForMining.size() == oneDayArchivedNextScn.size() - 1 ? 1 : 0) != 0).isTrue();
        archivedRedoFiles = LogMinerHelper.getMap((OracleConnection)conn, (String)SqlUtils.archiveLogsQuery((Scn)oldestArchivedScn.subtract(Scn.valueOf((long)1L)), (Duration)Duration.ofHours(0L)), (String)"-1");
        Assertions.assertThat((archivedRedoFiles.size() == oneDayArchivedNextScn.size() ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void shouldAddRightRedoFiles() throws Exception {
        List<Scn> oneDayArchivedNextScn = this.getOneDayArchivedLogNextScn(conn);
        Scn oldestArchivedScn = this.getOldestArchivedScn(oneDayArchivedNextScn);
        LogMinerHelper.setRedoLogFilesForMining((OracleConnection)conn, (Scn)oldestArchivedScn, (Duration)Duration.ofHours(0L));
        List onlineLogFilesForMining = LogMinerHelper.getOnlineLogFilesForOffsetScn((OracleConnection)conn, (Scn)oldestArchivedScn);
        List archivedLogFilesForMining = LogMinerHelper.getArchivedLogFilesForOffsetScn((OracleConnection)conn, (Scn)oldestArchivedScn, (Duration)Duration.ofHours(0L));
        List archivedLogFiles = archivedLogFilesForMining.stream().filter(e -> {
            for (LogFile log : onlineLogFilesForMining) {
                if (!log.isSameRange(e)) continue;
                return false;
            }
            return true;
        }).map(LogFile::getFileName).collect(Collectors.toList());
        int archivedLogFilesCount = archivedLogFiles.size();
        Map redoLogFiles = LogMinerHelper.getMap((OracleConnection)conn, (String)SqlUtils.allOnlineLogsQuery(), (String)"-1");
        Assertions.assertThat((LogMinerHelperIT.getNumberOfAddedLogFiles(conn) == redoLogFiles.size() + archivedLogFilesCount ? 1 : 0) != 0).isTrue();
    }

    private Scn getOldestArchivedScn(List<Scn> oneDayArchivedNextScn) throws Exception {
        Optional archivedScn = oneDayArchivedNextScn.stream().min(Scn::compareTo);
        if (!archivedScn.isPresent()) {
            throw new Exception("cannot get oldest archived scn");
        }
        Scn oldestArchivedScn = (Scn)archivedScn.get();
        return oldestArchivedScn;
    }

    private static int getNumberOfAddedLogFiles(OracleConnection conn) throws SQLException {
        int counter = 0;
        try (PreparedStatement ps = conn.connection(false).prepareStatement("select * from V$LOGMNR_LOGS");
             ResultSet result = ps.executeQuery();){
            while (result.next()) {
                ++counter;
            }
        }
        return counter;
    }

    private List<Scn> getOneDayArchivedLogNextScn(OracleConnection conn) throws SQLException {
        ArrayList<Scn> allArchivedNextScn = new ArrayList<Scn>();
        try (PreparedStatement st = conn.connection(false).prepareStatement("SELECT NAME AS FILE_NAME, NEXT_CHANGE# AS NEXT_CHANGE FROM V$ARCHIVED_LOG  WHERE NAME IS NOT NULL AND FIRST_TIME >= SYSDATE - 1 AND ARCHIVED = 'YES'  AND STATUS = 'A' ORDER BY 2");
             ResultSet rs = st.executeQuery();){
            while (rs.next()) {
                allArchivedNextScn.add(Scn.valueOf((String)rs.getString(2)));
            }
        }
        return allArchivedNextScn;
    }
}

