/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.Scn;
import io.debezium.connector.oracle.logminer.TransactionalBufferMetrics;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class TransactionalBuffer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalBuffer.class);
    private final Map<String, Transaction> transactions = new HashMap<String, Transaction>();
    private final ErrorHandler errorHandler;
    private final Set<String> abandonedTransactionIds;
    private final Set<String> rolledBackTransactionIds;
    private final TransactionalBufferMetrics metrics;
    private Scn lastCommittedScn;

    TransactionalBuffer(OracleTaskContext taskContext, ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.lastCommittedScn = Scn.ZERO;
        this.abandonedTransactionIds = new HashSet<String>();
        this.rolledBackTransactionIds = new HashSet<String>();
        this.metrics = new TransactionalBufferMetrics(taskContext);
        this.metrics.register(LOGGER);
    }

    TransactionalBufferMetrics getMetrics() {
        return this.metrics;
    }

    Set<String> getRolledBackTransactionIds() {
        return new HashSet<String>(this.rolledBackTransactionIds);
    }

    void registerCommitCallback(String transactionId, Scn scn, Instant changeTime, CommitCallback callback) {
        if (this.abandonedTransactionIds.contains(transactionId)) {
            LogMinerHelper.logWarn(this.metrics, "Captured DML for abandoned transaction {}, ignored", transactionId);
            return;
        }
        if (this.rolledBackTransactionIds.contains(transactionId)) {
            LogMinerHelper.logWarn(this.metrics, "Captured DML for rolled-back transaction {}, ignored", transactionId);
            return;
        }
        this.transactions.computeIfAbsent(transactionId, s -> new Transaction(scn));
        this.metrics.setActiveTransactions(this.transactions.size());
        this.metrics.incrementRegisteredDmlCounter();
        this.metrics.calculateLagMetrics(changeTime);
        Transaction transaction = this.transactions.get(transactionId);
        if (transaction != null) {
            transaction.commitCallbacks.add(callback);
        }
    }

    boolean commit(String transactionId, Scn scn, OracleOffsetContext offsetContext, Timestamp timestamp, ChangeEventSource.ChangeEventSourceContext context, String debugMessage, EventDispatcher dispatcher) {
        Instant start = Instant.now();
        Transaction transaction = this.transactions.remove(transactionId);
        if (transaction == null) {
            return false;
        }
        Scn smallestScn = this.calculateSmallestScn();
        this.abandonedTransactionIds.remove(transactionId);
        if (offsetContext.getCommitScn() != null && offsetContext.getCommitScn() > scn.longValue() || this.lastCommittedScn.longValue() > scn.longValue()) {
            LogMinerHelper.logWarn(this.metrics, "Transaction {} was already processed, ignore. Committed SCN in offset is {}, commit SCN of the transaction is {}, last committed SCN is {}", transactionId, offsetContext.getCommitScn(), scn, this.lastCommittedScn);
            this.metrics.setActiveTransactions(this.transactions.size());
            return false;
        }
        List commitCallbacks = transaction.commitCallbacks;
        LOGGER.trace("COMMIT, {}, smallest SCN: {}", (Object)debugMessage, (Object)smallestScn);
        this.commit(context, offsetContext, start, commitCallbacks, timestamp, smallestScn, scn, dispatcher);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(ChangeEventSource.ChangeEventSourceContext context, OracleOffsetContext offsetContext, Instant start, List<CommitCallback> commitCallbacks, Timestamp timestamp, Scn smallestScn, Scn scn, EventDispatcher<?> dispatcher) {
        try {
            int counter = commitCallbacks.size();
            for (CommitCallback callback : commitCallbacks) {
                if (!context.isRunning()) {
                    return;
                }
                callback.execute(timestamp, smallestScn, scn, --counter);
            }
            this.lastCommittedScn = Scn.valueOf(scn.longValue());
            if (!commitCallbacks.isEmpty()) {
                dispatcher.dispatchTransactionCommittedEvent((OffsetContext)offsetContext);
            }
        }
        catch (InterruptedException e) {
            LogMinerHelper.logError(this.metrics, "Thread interrupted during running", e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.errorHandler.setProducerThrowable((Throwable)e);
        }
        finally {
            this.metrics.incrementCommittedTransactions();
            this.metrics.setActiveTransactions(this.transactions.size());
            this.metrics.incrementCommittedDmlCounter(commitCallbacks.size());
            this.metrics.setCommittedScn(scn);
            this.metrics.setOffsetScn(Scn.valueOf(offsetContext.getScn()));
            this.metrics.setLastCommitDuration(Duration.between(start, Instant.now()).toMillis());
        }
    }

    boolean rollback(String transactionId, String debugMessage) {
        Transaction transaction = this.transactions.get(transactionId);
        if (transaction != null) {
            LOGGER.debug("Transaction rolled back: {}", (Object)debugMessage);
            this.transactions.remove(transactionId);
            this.abandonedTransactionIds.remove(transactionId);
            this.rolledBackTransactionIds.add(transactionId);
            this.metrics.setActiveTransactions(this.transactions.size());
            this.metrics.incrementRolledBackTransactions();
            this.metrics.addRolledBackTransactionId(transactionId);
            return true;
        }
        return false;
    }

    void abandonLongTransactions(Long thresholdScn, OracleOffsetContext offsetContext) {
        LogMinerHelper.logWarn(this.metrics, "All transactions with first SCN <= {} will be abandoned, offset: {}", thresholdScn, offsetContext.getScn());
        Scn threshold = Scn.valueOf(thresholdScn);
        Scn smallestScn = this.calculateSmallestScn();
        if (smallestScn == null) {
            return;
        }
        if (threshold.compareTo(smallestScn) < 0) {
            threshold = smallestScn;
        }
        Iterator<Map.Entry<String, Transaction>> iter = this.transactions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Transaction> transaction = iter.next();
            if (transaction.getValue().firstScn.compareTo(threshold) > 0) continue;
            LogMinerHelper.logWarn(this.metrics, "Following long running transaction {} will be abandoned and ignored: {} ", transaction.getKey(), transaction.getValue().toString());
            this.abandonedTransactionIds.add(transaction.getKey());
            iter.remove();
            this.metrics.addAbandonedTransactionId(transaction.getKey());
            this.metrics.setActiveTransactions(this.transactions.size());
        }
    }

    boolean isTransactionRegistered(String txId) {
        return this.transactions.get(txId) != null;
    }

    private Scn calculateSmallestScn() {
        Scn scn = this.transactions.isEmpty() ? null : this.transactions.values().stream().map(transaction -> ((Transaction)transaction).firstScn).min(Scn::compareTo).orElseThrow(() -> new DataException("Cannot calculate smallest SCN"));
        this.metrics.setOldestScn(scn == null ? Scn.INVALID : scn);
        return scn;
    }

    boolean isEmpty() {
        return this.transactions.isEmpty();
    }

    void setDatabaseTimeDifference(long difference) {
        this.metrics.setTimeDifference(new AtomicLong(difference));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.transactions.values().forEach(t -> result.append(t.toString()));
        return result.toString();
    }

    @Override
    public void close() {
        this.transactions.clear();
        if (this.metrics != null) {
            this.metrics.unregister(LOGGER);
        }
    }

    @NotThreadSafe
    private static final class Transaction {
        private final Scn firstScn;
        private Scn lastScn;
        private final List<CommitCallback> commitCallbacks;

        private Transaction(Scn firstScn) {
            this.firstScn = firstScn;
            this.commitCallbacks = new ArrayList<CommitCallback>();
            this.lastScn = firstScn;
        }

        public String toString() {
            return "Transaction{firstScn=" + this.firstScn + ", lastScn=" + this.lastScn + '}';
        }
    }

    public static interface CommitCallback {
        public void execute(Timestamp var1, Scn var2, Scn var3, int var4) throws InterruptedException;
    }
}

