/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.xstream;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.xstream.LcrEventHandler;
import io.debezium.connector.oracle.xstream.LcrPosition;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import oracle.jdbc.OracleConnection;
import oracle.sql.NUMBER;
import oracle.streams.StreamsException;
import oracle.streams.XStreamLCRCallbackHandler;
import oracle.streams.XStreamOut;
import oracle.streams.XStreamUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XstreamStreamingChangeEventSource
implements StreamingChangeEventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(XstreamStreamingChangeEventSource.class);
    private final JdbcConnection jdbcConnection;
    private final EventDispatcher<TableId> dispatcher;
    private final ErrorHandler errorHandler;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final OracleOffsetContext offsetContext;
    private final String xStreamServerName;
    private volatile XStreamOut xsOut;
    private final boolean tablenameCaseInsensitive;
    private final int posVersion;
    private final AtomicReference<PositionAndScn> lcrMessage = new AtomicReference();

    public XstreamStreamingChangeEventSource(OracleConnectorConfig connectorConfig, OracleOffsetContext offsetContext, JdbcConnection jdbcConnection, EventDispatcher<TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema) {
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.clock = clock;
        this.schema = schema;
        this.offsetContext = offsetContext;
        this.xStreamServerName = connectorConfig.getXoutServerName();
        this.tablenameCaseInsensitive = connectorConfig.getTablenameCaseInsensitive();
        this.posVersion = connectorConfig.getOracleVersion().getPosVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        try {
            byte[] startPosition = this.offsetContext.getLcrPosition() != null ? this.offsetContext.getLcrPosition().getRawPosition() : this.convertScnToPosition(this.offsetContext.getScn());
            this.xsOut = XStreamOut.attach((OracleConnection)((OracleConnection)this.jdbcConnection.connection()), (String)this.xStreamServerName, (byte[])startPosition, (int)1, (int)1, (int)0);
            LcrEventHandler handler = new LcrEventHandler(this.errorHandler, this.dispatcher, this.clock, (RelationalDatabaseSchema)this.schema, this.offsetContext, this.tablenameCaseInsensitive, this);
            while (context.isRunning()) {
                LOGGER.trace("Receiving LCR");
                this.xsOut.receiveLCRCallback((XStreamLCRCallbackHandler)handler, 0);
            }
        }
        catch (Throwable e) {
            this.errorHandler.setProducerThrowable(e);
        }
        finally {
            if (this.xsOut != null) {
                try {
                    XStreamOut xsOut = this.xsOut;
                    this.xsOut = null;
                    xsOut.detach(0);
                }
                catch (StreamsException e) {
                    LOGGER.error("Couldn't detach from XStream outbound server " + this.xStreamServerName, (Throwable)e);
                }
            }
        }
    }

    public void commitOffset(Map<String, ?> offset) {
        if (this.xsOut != null) {
            LOGGER.debug("Sending message to request recording of offsets to Oracle");
            LcrPosition lcrPosition = LcrPosition.valueOf((String)offset.get("lcr_position"));
            Long scn = (Long)offset.get("scn");
            this.sendPublishedPosition(lcrPosition, scn);
        }
    }

    private byte[] convertScnToPosition(long scn) {
        try {
            return XStreamUtility.convertSCNToPosition((NUMBER)new NUMBER(scn), (int)this.posVersion);
        }
        catch (StreamsException e) {
            throw new RuntimeException(e);
        }
    }

    XStreamOut getXsOut() {
        return this.xsOut;
    }

    private void sendPublishedPosition(LcrPosition lcrPosition, Long scn) {
        this.lcrMessage.set(new PositionAndScn(lcrPosition, scn != null ? this.convertScnToPosition(scn) : null));
    }

    PositionAndScn receivePublishedPosition() {
        return this.lcrMessage.getAndSet(null);
    }

    public static class PositionAndScn {
        public final LcrPosition position;
        public final byte[] scn;

        public PositionAndScn(LcrPosition position, byte[] scn) {
            this.position = position;
            this.scn = scn;
        }
    }
}

