/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.SchemaChangeEvent;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseOracleSchemaChangeEventEmitter
implements SchemaChangeEventEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOracleSchemaChangeEventEmitter.class);
    private final OracleOffsetContext offsetContext;
    private final TableId tableId;
    private String sourceDatabaseName;
    private String objectOwner;
    private String ddlText;
    private String commandType;

    public BaseOracleSchemaChangeEventEmitter(OracleOffsetContext offsetContext, TableId tableId, String sourceDatabaseName, String objectOwner, String ddlText, String commandType) {
        this.offsetContext = offsetContext;
        this.tableId = tableId;
        this.sourceDatabaseName = sourceDatabaseName;
        this.objectOwner = objectOwner;
        this.ddlText = ddlText;
        this.commandType = commandType;
    }

    public void emitSchemaChangeEvent(SchemaChangeEventEmitter.Receiver receiver) throws InterruptedException {
        SchemaChangeEvent.SchemaChangeEventType eventType = this.getSchemaChangeEventType();
        if (eventType == null) {
            return;
        }
        Tables tables = new Tables();
        OracleDdlParser parser = new OracleDdlParser();
        parser.setCurrentDatabase(this.sourceDatabaseName);
        parser.setCurrentSchema(this.objectOwner);
        parser.parse(this.ddlText, tables);
        Set changedTableIds = tables.drainChanges();
        if (changedTableIds.isEmpty()) {
            throw new IllegalArgumentException("Couldn't parse DDL statement " + this.ddlText);
        }
        Table table = tables.forTable(this.tableId);
        receiver.schemaChangeEvent(new SchemaChangeEvent(this.offsetContext.getPartition(), this.offsetContext.getOffset(), this.offsetContext.getSourceInfo(), this.sourceDatabaseName, this.objectOwner, this.ddlText, table, eventType, false));
    }

    private SchemaChangeEvent.SchemaChangeEventType getSchemaChangeEventType() {
        switch (this.commandType) {
            case "CREATE TABLE": {
                return SchemaChangeEvent.SchemaChangeEventType.CREATE;
            }
            case "ALTER TABLE": {
                LOGGER.warn("ALTER TABLE not yet implemented");
                break;
            }
            case "DROP TABLE": {
                LOGGER.warn("DROP TABLE not yet implemented");
                break;
            }
            default: {
                LOGGER.debug("Ignoring DDL event of type {}", (Object)this.commandType);
            }
        }
        return null;
    }
}

