/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIs;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.TransactionalBufferMetrics;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class TransactionalBufferMetricsTest {
    private TransactionalBufferMetrics metrics;
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    @Before
    public void before() {
        CdcSourceTaskContext taskContext = (CdcSourceTaskContext)Mockito.mock(CdcSourceTaskContext.class);
        Mockito.when((Object)taskContext.getConnectorName()).thenReturn((Object)"connector name");
        Mockito.when((Object)taskContext.getConnectorType()).thenReturn((Object)"connector type");
        this.metrics = new TransactionalBufferMetrics(taskContext);
    }

    @After
    public void after() {
        this.metrics.reset();
    }

    @Test
    @SkipWhenAdapterNameIs(value=SkipWhenAdapterNameIs.AdapterName.LOGMINER, reason="Lag calculations fail")
    public void testLagMetrics() {
        long lag = this.metrics.getLagFromSource();
        Assertions.assertThat((long)lag).isEqualTo(0L);
        Instant dbEventTime = Instant.now().minusMillis(2000L);
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSource();
        Assertions.assertThat((long)lag).isEqualTo(2000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSource()).isEqualTo(2000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSource()).isEqualTo(0L);
        dbEventTime = Instant.now().plusMillis(2000L);
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSource();
        Assertions.assertThat((long)lag).isEqualTo(2000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSource()).isEqualTo(2000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSource()).isEqualTo(0L);
        this.metrics.reset();
        this.metrics.setTimeDifference(new AtomicLong(-1000L));
        dbEventTime = Instant.now().minusMillis(2000L);
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSource();
        Assertions.assertThat((long)lag).isEqualTo(3000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSource()).isEqualTo(3000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSource()).isEqualTo(0L);
        dbEventTime = Instant.now().minusMillis(3000L);
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSource();
        Assertions.assertThat((long)lag).isEqualTo(4000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSource()).isEqualTo(4000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSource()).isEqualTo(0L);
        this.metrics.reset();
        this.metrics.setTimeDifference(new AtomicLong(1000L));
        dbEventTime = Instant.now().minusMillis(2000L);
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSource();
        Assertions.assertThat((long)lag).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getMaxLagFromSource()).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getMinLagFromSource()).isEqualTo(0L);
    }

    @Test
    public void testOtherMetrics() {
        this.metrics.incrementScnFreezeCounter();
        Assertions.assertThat((int)this.metrics.getScnFreezeCounter()).isEqualTo(1);
        this.metrics.incrementErrorCounter();
        Assertions.assertThat((int)this.metrics.getErrorCounter()).isEqualTo(1);
        this.metrics.incrementWarningCounter();
        Assertions.assertThat((int)this.metrics.getWarningCounter()).isEqualTo(1);
        this.metrics.incrementCommittedDmlCounter(5000);
        for (int i = 0; i < 1000; ++i) {
            this.metrics.incrementRegisteredDmlCounter();
            this.metrics.incrementCommittedTransactions();
        }
        Assertions.assertThat((long)this.metrics.getRegisteredDmlCount()).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getNumberOfCommittedTransactions()).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getCommitThroughput()).isGreaterThanOrEqualTo(1000L);
        this.metrics.incrementRolledBackTransactions();
        Assertions.assertThat((long)this.metrics.getNumberOfRolledBackTransactions()).isEqualTo(1L);
        this.metrics.setActiveTransactions(Integer.valueOf(5));
        Assertions.assertThat((int)this.metrics.getNumberOfActiveTransactions()).isEqualTo(5);
        this.metrics.addRolledBackTransactionId("rolledback id");
        Assertions.assertThat((long)this.metrics.getNumberOfRolledBackTransactions()).isEqualTo(1L);
        Assertions.assertThat((boolean)this.metrics.getRolledBackTransactionIds().contains("rolledback id")).isTrue();
        this.metrics.addAbandonedTransactionId("abandoned id");
        Assertions.assertThat((int)this.metrics.getAbandonedTransactionIds().size()).isEqualTo(1);
        Assertions.assertThat((boolean)this.metrics.getAbandonedTransactionIds().contains("abandoned id")).isTrue();
        this.metrics.setOldestScn(Long.valueOf(10L));
        Assertions.assertThat((Long)this.metrics.getOldestScn()).isEqualTo(10L);
        this.metrics.setCommittedScn(Long.valueOf(10L));
        Assertions.assertThat((Long)this.metrics.getCommittedScn()).isEqualTo(10L);
        Assertions.assertThat((boolean)this.metrics.toString().contains("registeredDmlCounter=1000")).isTrue();
        this.metrics.setLastCommitDuration(Long.valueOf(100L));
        Assertions.assertThat((Long)this.metrics.getLastCommitDuration()).isEqualTo(100L);
        this.metrics.setLastCommitDuration(Long.valueOf(50L));
        Assertions.assertThat((Long)this.metrics.getMaxCommitDuration()).isEqualTo(100L);
        this.metrics.setOffsetScn(Long.valueOf(10L));
        Assertions.assertThat((this.metrics.getOldestScn() == 10L ? 1 : 0) != 0).isTrue();
    }
}

