/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Collect;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TransactionMetadataIT
extends AbstractConnectorTest {
    private static OracleConnection connection;

    @BeforeClass
    public static void beforeClass() throws SQLException {
        connection = TestHelper.testConnection();
        TestHelper.dropTable(connection, "debezium.customer");
        TestHelper.dropTable(connection, "debezium.orders");
        String ddl = "create table debezium.customer (  id numeric(9,0) not null,   name varchar2(1000),   score decimal(6, 2),   registered timestamp,   primary key (id))";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.customer to  " + TestHelper.getConnectorUserName()});
        connection.execute(new String[]{"ALTER TABLE debezium.customer ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        ddl = "create table debezium.orders ( id number(6) not null primary key,  order_date date not null,  purchaser number(4) not null,  quantity number(4) not null,  product_id number(4) not null)";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.orders to  " + TestHelper.getConnectorUserName()});
        connection.execute(new String[]{"ALTER TABLE debezium.orders ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
    }

    @AfterClass
    public static void closeConnection() throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    @Before
    public void before() throws SQLException {
        connection.execute(new String[]{"delete from debezium.customer"});
        connection.execute(new String[]{"delete from debezium.orders"});
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @Test
    public void transactionMetadata() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.CUSTOMER,DEBEZIUM\\.ORDERS")).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(OracleConnectorConfig.PROVIDE_TRANSACTION_METADATA, true)).with(OracleConnectorConfig.LOG_MINING_STRATEGY, (EnumeratedValue)OracleConnectorConfig.LogMiningStrategy.ONLINE_CATALOG)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        TransactionMetadataIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        connection.executeWithoutCommitting(new String[]{"INSERT INTO debezium.customer VALUES (1, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.executeWithoutCommitting(new String[]{"INSERT INTO debezium.orders VALUES (1, '01-FEB-2021', 1001, 1, 102)"});
        connection.execute(new String[]{"COMMIT"});
        int expectedRecordCount = 4;
        List records = this.consumeRecordsByTopic(4).allRecordsInOrder();
        Assertions.assertThat((List)records).hasSize(4);
        SourceRecord record = (SourceRecord)records.get(0);
        String expectedTxId = this.assertBeginTransaction(record);
        record = (SourceRecord)records.get(1);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        Struct after = (Struct)((Struct)record.value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Billie-Bob");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(1234.56));
        this.assertRecordTransactionMetadata(record, expectedTxId, 1L, 1L);
        record = (SourceRecord)records.get(2);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        after = (Struct)((Struct)record.value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("ORDER_DATE")).isEqualTo((Object)1612137600000L);
        Assertions.assertThat((Object)after.get("PURCHASER")).isEqualTo((Object)1001);
        Assertions.assertThat((Object)after.get("QUANTITY")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("PRODUCT_ID")).isEqualTo((Object)102);
        this.assertRecordTransactionMetadata(record, expectedTxId, 2L, 1L);
        record = (SourceRecord)records.get(3);
        this.assertEndTransaction(record, expectedTxId, 2L, Collect.hashMapOf((Object)"ORCLPDB1.DEBEZIUM.CUSTOMER", (Object)1, (Object)"ORCLPDB1.DEBEZIUM.ORDERS", (Object)1));
    }

    @Test
    @FixFor(value={"DBZ-3090"})
    public void transactionMetadataMultipleTransactions() throws Exception {
        try (OracleConnection secondaryConn = TestHelper.testConnection();){
            Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.CUSTOMER,DEBEZIUM\\.ORDERS")).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(OracleConnectorConfig.PROVIDE_TRANSACTION_METADATA, true)).with(OracleConnectorConfig.LOG_MINING_STRATEGY, (EnumeratedValue)OracleConnectorConfig.LogMiningStrategy.ONLINE_CATALOG)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            TransactionMetadataIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
            connection.executeWithoutCommitting(new String[]{"INSERT INTO debezium.customer VALUES (1, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
            connection.executeWithoutCommitting(new String[]{"INSERT INTO debezium.orders VALUES (2, '01-FEB-2021', 1001, 2, 102)"});
            secondaryConn.executeWithoutCommitting(new String[]{"INSERT INTO debezium.orders VALUES (1, '01-FEB-2021', 1001, 1, 102)"});
            secondaryConn.execute(new String[]{"COMMIT"});
            connection.execute(new String[]{"COMMIT"});
            int expectedRecordCount = 7;
            List records = this.consumeRecordsByTopic(7).allRecordsInOrder();
            Assertions.assertThat((List)records).hasSize(7);
            SourceRecord record = (SourceRecord)records.get(0);
            String expectedTxId = this.assertBeginTransaction(record);
            record = (SourceRecord)records.get(1);
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
            Struct after = (Struct)((Struct)record.value()).get("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("ORDER_DATE")).isEqualTo((Object)1612137600000L);
            Assertions.assertThat((Object)after.get("PURCHASER")).isEqualTo((Object)1001);
            Assertions.assertThat((Object)after.get("QUANTITY")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("PRODUCT_ID")).isEqualTo((Object)102);
            this.assertRecordTransactionMetadata(record, expectedTxId, 1L, 1L);
            record = (SourceRecord)records.get(2);
            this.assertEndTransaction(record, expectedTxId, 1L, Collect.hashMapOf((Object)"ORCLPDB1.DEBEZIUM.ORDERS", (Object)1));
            record = (SourceRecord)records.get(3);
            expectedTxId = this.assertBeginTransaction(record);
            record = (SourceRecord)records.get(4);
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
            after = (Struct)((Struct)record.value()).get("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Billie-Bob");
            Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(1234.56));
            this.assertRecordTransactionMetadata(record, expectedTxId, 1L, 1L);
            record = (SourceRecord)records.get(5);
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
            after = (Struct)((Struct)record.value()).get("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("ORDER_DATE")).isEqualTo((Object)1612137600000L);
            Assertions.assertThat((Object)after.get("PURCHASER")).isEqualTo((Object)1001);
            Assertions.assertThat((Object)after.get("QUANTITY")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("PRODUCT_ID")).isEqualTo((Object)102);
            this.assertRecordTransactionMetadata(record, expectedTxId, 2L, 1L);
            record = (SourceRecord)records.get(6);
            this.assertEndTransaction(record, expectedTxId, 2L, Collect.hashMapOf((Object)"ORCLPDB1.DEBEZIUM.CUSTOMER", (Object)1, (Object)"ORCLPDB1.DEBEZIUM.ORDERS", (Object)1));
        }
    }
}

