/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class OracleConnectorFilterIT
extends AbstractConnectorTest {
    private static OracleConnection connection;
    private static OracleConnection adminConnection;
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    @BeforeClass
    public static void beforeClass() throws SQLException {
        connection = TestHelper.testConnection();
        adminConnection = TestHelper.adminConnection();
    }

    @AfterClass
    public static void closeConnection() throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    @Before
    public void before() throws SQLException {
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        TestHelper.dropTable(connection, "debezium.table1");
        TestHelper.dropTable(connection, "debezium.table2");
        TestHelper.dropTable(connection, "debezium.table3");
        try {
            adminConnection.execute(new String[]{"DROP USER debezium2 CASCADE"});
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        adminConnection.execute(new String[]{"CREATE USER debezium2 IDENTIFIED BY dbz", "GRANT CONNECT TO debezium2", "GRANT CREATE SESSION TO debezium2", "GRANT CREATE TABLE TO debezium2", "GRANT CREATE SEQUENCE TO debezium2", "ALTER USER debezium2 QUOTA 100M ON users", "CREATE TABLE debezium2.table2 (id NUMERIC(9,0) NOT NULL, name VARCHAR2(1000), PRIMARY KEY (id))", "CREATE TABLE debezium2.nopk (id NUMERIC(9,0) NOT NULL)", "GRANT ALL PRIVILEGES ON debezium2.table2 TO debezium", "GRANT SELECT ON debezium2.table2 TO " + TestHelper.getConnectorUserName(), "GRANT SELECT ON debezium2.nopk TO " + TestHelper.getConnectorUserName(), "ALTER TABLE debezium2.table2 ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        String ddl = "CREATE TABLE debezium.table1 (  id NUMERIC(9,0) NOT NULL,   name VARCHAR2(1000),   PRIMARY KEY (id))";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.table1 TO " + TestHelper.getConnectorUserName()});
        connection.execute(new String[]{"ALTER TABLE debezium.table1 ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        ddl = "CREATE TABLE debezium.table2 (  id NUMERIC(9,0) NOT NULL,   name VARCHAR2(1000),   PRIMARY KEY (id))";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.table2 TO  " + TestHelper.getConnectorUserName()});
        connection.execute(new String[]{"ALTER TABLE debezium.table2 ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        TestHelper.dropTable(adminConnection, "debezium2.table2");
        TestHelper.dropTable(adminConnection, "debezium2.nopk");
        adminConnection.execute(new String[]{"DROP USER debezium2"});
    }

    @Test
    public void shouldApplyTableWhitelistConfiguration() throws Exception {
        this.shouldApplyTableInclusionConfiguration(true);
    }

    @Test
    public void shouldApplyTableIncludeListConfiguration() throws Exception {
        this.shouldApplyTableInclusionConfiguration(false);
    }

    @Test
    public void shouldApplyTableBlacklistConfiguration() throws Exception {
        this.shouldApplyTableExclusionsConfiguration(true);
    }

    @Test
    public void shouldApplyTableExcludeListConfiguration() throws Exception {
        this.shouldApplyTableExclusionsConfiguration(false);
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void shouldApplySchemaAndTableWhitelistConfiguration() throws Exception {
        this.shouldApplySchemaAndTableInclusionConfiguration(true);
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void shouldApplySchemaAndTableIncludeListConfiguration() throws Exception {
        this.shouldApplySchemaAndTableInclusionConfiguration(false);
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void shouldApplySchemaAndTableBlacklistConfiguration() throws Exception {
        this.shouldApplySchemaAndTableExclusionsConfiguration(true);
    }

    @Test
    @FixFor(value={"DBZ-3009"})
    public void shouldApplySchemaAndTableExcludeListConfiguration() throws Exception {
        this.shouldApplySchemaAndTableExclusionsConfiguration(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3167"})
    public void shouldApplyColumnIncludeListConfiguration() throws Exception {
        TestHelper.dropTable(connection, "table4");
        try {
            String ddl = "CREATE TABLE debezium.table4 (  id NUMERIC(9,0) NOT NULL,   name VARCHAR2(1000),   birth_date date,   PRIMARY KEY (id))";
            connection.execute(new String[]{ddl});
            connection.execute(new String[]{"GRANT SELECT ON debezium.table4 TO " + TestHelper.getConnectorUserName()});
            connection.execute(new String[]{"ALTER TABLE debezium.table4 ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
            connection.execute(new String[]{"INSERT INTO debezium.table4 VALUES (1, 'Text-1', '01-JAN-1990')"});
            connection.execute(new String[]{"COMMIT"});
            Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.TABLE4")).with(OracleConnectorConfig.COLUMN_INCLUDE_LIST, "DEBEZIUM\\.TABLE4\\.ID,DEBEZIUM\\.TABLE4\\.NAME")).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleConnectorFilterIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE4");
            Assertions.assertThat((List)testTableRecords).hasSize(1);
            VerifyRecord.isValidRead((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)1);
            Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text-1");
            Assertions.assertThat((Object)((SourceRecord)testTableRecords.get(0)).valueSchema().field("BIRTH_DATE")).isNull();
            OracleConnectorFilterIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            connection.execute(new String[]{"INSERT INTO debezium.table4 VALUES (2, 'Text-2', '31-DEC-1990')"});
            connection.execute(new String[]{"COMMIT"});
            records = this.consumeRecordsByTopic(1);
            testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE4");
            Assertions.assertThat((List)testTableRecords).hasSize(1);
            VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)2);
            after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text-2");
            Assertions.assertThat((Object)((SourceRecord)testTableRecords.get(0)).valueSchema().field("BIRTH_DATE")).isNull();
        }
        finally {
            TestHelper.dropTable(connection, "table4");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3167"})
    public void shouldApplyColumnExcludeListConfiguration() throws Exception {
        TestHelper.dropTable(connection, "table4");
        try {
            String ddl = "CREATE TABLE debezium.table4 (  id NUMERIC(9,0) NOT NULL,   name VARCHAR2(1000),   birth_date date,   PRIMARY KEY (id))";
            connection.execute(new String[]{ddl});
            connection.execute(new String[]{"GRANT SELECT ON debezium.table4 TO " + TestHelper.getConnectorUserName()});
            connection.execute(new String[]{"ALTER TABLE debezium.table4 ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
            connection.execute(new String[]{"INSERT INTO debezium.table4 VALUES (1, 'Text-1', '01-JAN-1990')"});
            connection.execute(new String[]{"COMMIT"});
            Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.TABLE4")).with(OracleConnectorConfig.COLUMN_EXCLUDE_LIST, "DEBEZIUM\\.TABLE4\\.BIRTH_DATE")).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL)).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleConnectorFilterIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE4");
            Assertions.assertThat((List)testTableRecords).hasSize(1);
            VerifyRecord.isValidRead((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)1);
            Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text-1");
            Assertions.assertThat((Object)((SourceRecord)testTableRecords.get(0)).valueSchema().field("BIRTH_DATE")).isNull();
            OracleConnectorFilterIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            connection.execute(new String[]{"INSERT INTO debezium.table4 VALUES (2, 'Text-2', '31-DEC-1990')"});
            connection.execute(new String[]{"COMMIT"});
            records = this.consumeRecordsByTopic(1);
            testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE4");
            Assertions.assertThat((List)testTableRecords).hasSize(1);
            VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)2);
            after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text-2");
            Assertions.assertThat((Object)((SourceRecord)testTableRecords.get(0)).valueSchema().field("BIRTH_DATE")).isNull();
        }
        finally {
            TestHelper.dropTable(connection, "table4");
        }
    }

    private void shouldApplyTableInclusionConfiguration(boolean useLegacyOption) throws Exception {
        Field option = OracleConnectorConfig.TABLE_INCLUDE_LIST;
        if (useLegacyOption) {
            option = OracleConnectorConfig.TABLE_WHITELIST;
        }
        boolean includeDdlChanges = true;
        if (TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.LOG_MINER)) {
            includeDdlChanges = false;
        }
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SCHEMA_INCLUDE_LIST, "DEBEZIUM")).with(option, "DEBEZIUM2\\.TABLE2,DEBEZIUM\\.TABLE1,DEBEZIUM\\.TABLE3")).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleConnectorFilterIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        OracleConnectorFilterIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        connection.execute(new String[]{"INSERT INTO debezium.table1 VALUES (1, 'Text-1')"});
        connection.execute(new String[]{"INSERT INTO debezium.table2 VALUES (2, 'Text-2')"});
        connection.execute(new String[]{"COMMIT"});
        if (includeDdlChanges) {
            String ddl = "CREATE TABLE debezium.table3 (  id NUMERIC(9, 0) NOT NULL,   name VARCHAR2(1000),   PRIMARY KEY (id))";
            connection.execute(new String[]{ddl});
            connection.execute(new String[]{"GRANT SELECT ON debezium.table3 TO " + TestHelper.getConnectorUserName()});
            connection.execute(new String[]{"ALTER TABLE debezium.table3 ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
            connection.execute(new String[]{"INSERT INTO debezium.table3 VALUES (3, 'Text-3')"});
            connection.execute(new String[]{"COMMIT"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(includeDdlChanges ? 2 : 1);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE1");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)1);
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text-1");
        testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE2");
        Assertions.assertThat((List)testTableRecords).isNull();
        if (includeDdlChanges) {
            testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE3");
            Assertions.assertThat((List)testTableRecords).hasSize(1);
            VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)3);
            after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
            Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text-3");
        }
    }

    private void shouldApplySchemaAndTableInclusionConfiguration(boolean useLegacyOption) throws Exception {
        Field option = OracleConnectorConfig.TABLE_INCLUDE_LIST;
        if (useLegacyOption) {
            option = OracleConnectorConfig.TABLE_WHITELIST;
        }
        boolean includeDdlChanges = true;
        if (TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.LOG_MINER)) {
            includeDdlChanges = false;
        }
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SCHEMA_INCLUDE_LIST, "DEBEZIUM,DEBEZIUM2")).with(option, "DEBEZIUM2\\.TABLE2,DEBEZIUM\\.TABLE1,DEBEZIUM\\.TABLE3")).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleConnectorFilterIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        OracleConnectorFilterIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        connection.execute(new String[]{"INSERT INTO debezium.table1 VALUES (1, 'Text-1')"});
        connection.execute(new String[]{"INSERT INTO debezium.table2 VALUES (2, 'Text-2')"});
        connection.execute(new String[]{"INSERT INTO debezium2.table2 VALUES (1, 'Text2-1')"});
        connection.execute(new String[]{"COMMIT"});
        if (includeDdlChanges) {
            String ddl = "CREATE TABLE debezium.table3 (  id NUMERIC(9, 0) NOT NULL,   name VARCHAR2(1000),   PRIMARY KEY (id))";
            connection.execute(new String[]{ddl});
            connection.execute(new String[]{"GRANT SELECT ON debezium.table3 TO " + TestHelper.getConnectorUserName()});
            connection.execute(new String[]{"ALTER TABLE debezium.table3 ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
            connection.execute(new String[]{"INSERT INTO debezium.table3 VALUES (3, 'Text-3')"});
            connection.execute(new String[]{"COMMIT"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE1");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)1);
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text-1");
        testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE2");
        Assertions.assertThat((List)testTableRecords).isNull();
        testTableRecords = records.recordsForTopic("server1.DEBEZIUM2.TABLE2");
        if (TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.XSTREAM)) {
            Assertions.assertThat((List)testTableRecords).isNull();
        } else {
            Assertions.assertThat((List)testTableRecords).hasSize(1);
            VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)1);
            after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text2-1");
        }
        if (includeDdlChanges) {
            testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE3");
            Assertions.assertThat((List)testTableRecords).hasSize(1);
            VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)3);
            after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
            Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text-3");
        }
    }

    private void shouldApplyTableExclusionsConfiguration(boolean useLegacyOption) throws Exception {
        Field option = OracleConnectorConfig.TABLE_EXCLUDE_LIST;
        if (useLegacyOption) {
            option = OracleConnectorConfig.TABLE_BLACKLIST;
        }
        boolean includeDdlChanges = true;
        if (TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.LOG_MINER)) {
            includeDdlChanges = false;
        }
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SCHEMA_INCLUDE_LIST, "DEBEZIUM")).with(option, "DEBEZIUM\\.TABLE2,DEBEZIUM\\.CUSTOMER.*")).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleConnectorFilterIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        OracleConnectorFilterIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        connection.execute(new String[]{"INSERT INTO debezium.table1 VALUES (1, 'Text-1')"});
        connection.execute(new String[]{"INSERT INTO debezium.table2 VALUES (2, 'Text-2')"});
        connection.execute(new String[]{"COMMIT"});
        if (includeDdlChanges) {
            String ddl = "CREATE TABLE debezium.table3 (  id NUMERIC(9,0) NOT NULL,   name VARCHAR2(1000),   PRIMARY KEY (id))";
            connection.execute(new String[]{ddl});
            connection.execute(new String[]{"GRANT SELECT ON debezium.table3 TO  " + TestHelper.getConnectorUserName()});
            connection.execute(new String[]{"INSERT INTO debezium.table3 VALUES (3, 'Text-3')"});
            connection.execute(new String[]{"COMMIT"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(includeDdlChanges ? 2 : 1);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE1");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)1);
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text-1");
        testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE2");
        Assertions.assertThat((List)testTableRecords).isNull();
        if (includeDdlChanges) {
            testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE3");
            Assertions.assertThat((List)testTableRecords).hasSize(1);
            VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)3);
            after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
            Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text-3");
        }
    }

    private void shouldApplySchemaAndTableExclusionsConfiguration(boolean useLegacyOption) throws Exception {
        Field option = OracleConnectorConfig.TABLE_EXCLUDE_LIST;
        if (useLegacyOption) {
            option = OracleConnectorConfig.TABLE_BLACKLIST;
        }
        boolean includeDdlChanges = true;
        boolean isLogMiner = false;
        if (TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.LOG_MINER)) {
            includeDdlChanges = false;
            isLogMiner = true;
        }
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SCHEMA_EXCLUDE_LIST, "DEBEZIUM,SYS")).with(option, "DEBEZIUM\\.TABLE2,DEBEZIUM\\.CUSTOMER.*,DEBEZIUM2\\.NOPK")).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleConnectorFilterIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        OracleConnectorFilterIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        connection.execute(new String[]{"INSERT INTO debezium.table1 VALUES (1, 'Text-1')"});
        connection.execute(new String[]{"INSERT INTO debezium.table2 VALUES (2, 'Text-2')"});
        connection.execute(new String[]{"INSERT INTO debezium2.table2 VALUES (1, 'Text2-1')"});
        connection.execute(new String[]{"COMMIT"});
        if (includeDdlChanges) {
            String ddl = "CREATE TABLE debezium.table3 (  id NUMERIC(9,0) NOT NULL,   name VARCHAR2(1000),   PRIMARY KEY (id))";
            connection.execute(new String[]{ddl});
            connection.execute(new String[]{"GRANT SELECT ON debezium.table3 TO  " + TestHelper.getConnectorUserName()});
            connection.execute(new String[]{"INSERT INTO debezium.table3 VALUES (3, 'Text-3')"});
            connection.execute(new String[]{"COMMIT"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(!isLogMiner ? 0 : 1);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE1");
        Assertions.assertThat((List)testTableRecords).isNull();
        testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE2");
        Assertions.assertThat((List)testTableRecords).isNull();
        testTableRecords = records.recordsForTopic("server1.DEBEZIUM2.TABLE2");
        if (!isLogMiner) {
            Assertions.assertThat((List)testTableRecords).isNull();
        } else {
            Assertions.assertThat((List)testTableRecords).hasSize(1);
            VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)1);
            Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text2-1");
        }
        if (includeDdlChanges) {
            testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE3");
            Assertions.assertThat((List)testTableRecords).isNull();
        }
    }

    @Test
    public void shouldTakeTimeDifference() throws Exception {
        Testing.Print.enable();
        String stmt = "select current_timestamp from dual";
        try (Connection conn = connection.connection(true);
             PreparedStatement ps = conn.prepareStatement(stmt);
             ResultSet rs = ps.executeQuery();){
            rs.next();
            Timestamp ts = rs.getTimestamp(1);
            Instant fromDb = ts.toInstant();
            Instant now = Instant.now();
            long diff = Duration.between(fromDb, now).toMillis();
            Testing.print((Object)("diff: " + diff));
        }
    }
}

