/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleDatabaseVersion;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.doc.FixFor;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Duration;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LogMinerHelperTest {
    private OracleConnection connection = (OracleConnection)Mockito.mock(OracleConnection.class);
    private int current;
    private String[][] mockRows;
    private String maxScnStr;
    private BigInteger maxScn;

    @Before
    public void beforeEach() throws Exception {
        this.current = 0;
        this.mockRows = new String[0][];
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Connection conn = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.connection.connection()).thenReturn((Object)conn);
        Mockito.when((Object)this.connection.connection(false)).thenReturn((Object)conn);
        Mockito.when((Object)this.connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)"Oracle Database 12c Enterprise Edition Release 12.2.0.1.0 - 64bit Production"));
        this.maxScnStr = LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)this.connection);
        this.maxScn = new BigInteger(this.maxScnStr);
        PreparedStatement pstmt = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)conn.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)pstmt);
        Mockito.when((Object)pstmt.executeQuery()).thenReturn((Object)rs);
        Mockito.when((Object)rs.next()).thenAnswer(it -> ++this.current <= this.mockRows.length);
        Mockito.when((Object)rs.getString(ArgumentMatchers.anyInt())).thenAnswer(it -> this.mockRows[this.current - 1][(Integer)it.getArguments()[0] - 1]);
    }

    @Test
    public void logsWithRegularScns() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700"}, {"logfile2", "103700", "12", "104000"}};
        Map onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((OracleConnection)this.connection, (Long)10L);
        Assert.assertEquals((long)onlineLogs.size(), (long)2L);
        Assert.assertEquals(onlineLogs.get("logfile1"), (Object)BigInteger.valueOf(103400L));
        Assert.assertEquals(onlineLogs.get("logfile2"), (Object)BigInteger.valueOf(103700L));
    }

    @Test
    public void excludeLogsBeforeOffsetScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700"}, {"logfile2", "103700", "12", "104000"}, {"logfile3", "500", "13", "103100"}};
        Map onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((OracleConnection)this.connection, (Long)600L);
        Assert.assertEquals((long)onlineLogs.size(), (long)2L);
        Assert.assertNull(onlineLogs.get("logfile3"));
    }

    @Test
    public void nullsHandledAsMaxScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700"}, {"logfile2", "103700", "12", "104000"}, {"logfile3", null, "13", "103100"}};
        Map onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((OracleConnection)this.connection, (Long)600L);
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals(onlineLogs.get("logfile3"), (Object)this.maxScn);
    }

    @Test
    public void canHandleMaxScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700"}, {"logfile2", "103700", "12", "104000"}, {"logfile3", this.maxScnStr, "13", "104300"}};
        Map onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((OracleConnection)this.connection, (Long)600L);
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals(onlineLogs.get("logfile3"), (Object)this.maxScn);
    }

    @Test
    public void logsWithLongerScnAreSupported() throws Exception {
        String scnLonger = "9295429630892703743";
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700"}, {"logfile2", "103700", "12", "104000"}, {"logfile3", scnLonger, "13", "104300"}};
        Map onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((OracleConnection)this.connection, (Long)600L);
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals(onlineLogs.get("logfile3"), (Object)new BigInteger(scnLonger));
    }

    @Test
    public void archiveLogsWithRegularScns() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11"}, {"logfile2", "103700", "12"}};
        Map onlineLogs = LogMinerHelper.getArchivedLogFilesForOffsetScn((OracleConnection)this.connection, (Long)500L, (Duration)Duration.ofDays(60L));
        Assert.assertEquals((long)onlineLogs.size(), (long)2L);
        Assert.assertEquals(onlineLogs.get("logfile1"), (Object)BigInteger.valueOf(103400L));
        Assert.assertEquals(onlineLogs.get("logfile2"), (Object)BigInteger.valueOf(103700L));
    }

    @Test
    @Ignore
    public void archiveExcludeLogsBeforeOffsetScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11"}, {"logfile2", "103700", "12"}, {"logfile3", "500", "13"}};
        Map onlineLogs = LogMinerHelper.getArchivedLogFilesForOffsetScn((OracleConnection)this.connection, (Long)600L, (Duration)Duration.ofDays(60L));
        Assert.assertEquals((long)onlineLogs.size(), (long)2L);
        Assert.assertNull(onlineLogs.get("logfile3"));
    }

    @Test
    public void archiveNullsHandledAsMaxScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700"}, {"logfile2", "103700", "12", "104000"}, {"logfile3", null, "13", "104300"}};
        Map onlineLogs = LogMinerHelper.getArchivedLogFilesForOffsetScn((OracleConnection)this.connection, (Long)500L, (Duration)Duration.ofDays(60L));
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals(onlineLogs.get("logfile3"), (Object)this.maxScn);
    }

    @Test
    public void archiveCanHandleMaxScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11"}, {"logfile2", "103700", "12"}, {"logfile3", this.maxScnStr, "13"}};
        Map onlineLogs = LogMinerHelper.getArchivedLogFilesForOffsetScn((OracleConnection)this.connection, (Long)500L, (Duration)Duration.ofDays(60L));
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals(onlineLogs.get("logfile3"), (Object)this.maxScn);
    }

    @Test
    public void archiveLogsWithLongerScnAreSupported() throws Exception {
        String scnLonger = "9295429630892703743";
        this.mockRows = new String[][]{{"logfile1", "103400", "11"}, {"logfile2", "103700", "12"}, {"logfile3", scnLonger, "13"}};
        Map onlineLogs = LogMinerHelper.getArchivedLogFilesForOffsetScn((OracleConnection)this.connection, (Long)500L, (Duration)Duration.ofDays(60L));
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals(onlineLogs.get("logfile3"), (Object)new BigInteger(scnLonger));
    }

    @Test
    @FixFor(value={"DBZ-3001"})
    public void testOracleMaxScn() throws Exception {
        OracleConnection connection = (OracleConnection)Mockito.mock(OracleConnection.class);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Connection conn = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.connection()).thenReturn((Object)conn);
        Mockito.when((Object)connection.connection(false)).thenReturn((Object)conn);
        String banner = "Oracle Database 11g Enterprise Edition Release 11.2.0.4.0 - 64bit Production";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"281474976710655");
        banner = "Oracle Database 12c Enterprise Edition Release 12.1.0.0.0 - 64bit Production";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"281474976710655");
        banner = "Oracle Database 12c Enterprise Edition Release 12.2.0.4.0 - 64bit Production";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"18446744073709551615");
        banner = "Oracle Database 18c Enterprise Edition Release 18.0.0.0.0 - 64bit Production";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"18446744073709551615");
        banner = "Oracle Database 18c Enterprise Edition Release 18.1.0.0.0 - 64bit Production";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"18446744073709551615");
        banner = "Oracle Database 18c Enterprise Edition Release 18.0.0.0.0 - Production" + System.lineSeparator() + "Version 18.2.0.0.0";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"18446744073709551615");
        banner = "Oracle Database 19c Enterprise Edition Release 19.0.0.0.0 - Production" + System.lineSeparator() + "Version 19.0.0.0.0";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"18446744073709551615");
        banner = "Oracle Database 19c Enterprise Edition Release 19.0.0.0.0 - Production" + System.lineSeparator() + "Version 19.1.0.0.0";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"18446744073709551615");
        banner = "Oracle Database 19c Enterprise Edition Release 19.0.0.0.0 - Production" + System.lineSeparator() + "Version 19.2.0.0.0";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"18446744073709551615");
        banner = "Oracle Database 19c Enterprise Edition Release 19.0.0.0.0 - Production" + System.lineSeparator() + "Version 19.3.0.0.0";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"18446744073709551615");
        banner = "Oracle Database 19c Enterprise Edition Release 19.0.0.0.0 - Production" + System.lineSeparator() + "Version 19.4.0.0.0";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"18446744073709551615");
        banner = "Oracle Database 19c Enterprise Edition Release 19.0.0.0.0 - Production" + System.lineSeparator() + "Version 19.5.0.0.0";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"18446744073709551615");
        banner = "Oracle Database 19c Enterprise Edition Release 19.0.0.0.0 - Production" + System.lineSeparator() + "Version 19.6.0.0.0";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"9295429630892703743");
        banner = "Oracle Database 19c Enterprise Edition Release 19.0.0.0.0 - Production" + System.lineSeparator() + "Version 19.7.0.0.0";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"9295429630892703743");
        banner = "Oracle Database 21c Enterprise Edition Release 21.0.0.0.0 - Production" + System.lineSeparator() + "Version 21.0.0.0.0";
        Mockito.when((Object)connection.getOracleVersion()).thenReturn((Object)OracleDatabaseVersion.parse((String)banner));
        Assertions.assertThat((String)LogMinerHelper.getDatabaseMaxScnValue((OracleConnection)connection)).isEqualTo((Object)"9295429630892703743");
    }
}

