/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.parser;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.logminer.parser.DmlParser;
import io.debezium.connector.oracle.logminer.parser.DmlParserException;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValue;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValueImpl;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntryImpl;
import io.debezium.data.Envelope;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LogMinerDmlParser
implements DmlParser {
    private static final String SINGLE_QUOTE = "'";
    private static final String NULL = "NULL";
    private static final String INSERT_INTO = "insert into ";
    private static final String UPDATE = "update ";
    private static final String DELETE_FROM = "delete from ";
    private static final String AND = "and ";
    private static final String OR = "or ";
    private static final String SET = " set ";
    private static final String WHERE = " where ";
    private static final String VALUES = " values ";
    private static final String UNSUPPORTED = "Unsupported";
    private static final String UNSUPPORTED_TYPE = "Unsupported Type";
    private static final int INSERT_INTO_LENGTH = "insert into ".length();
    private static final int UPDATE_LENGTH = "update ".length();
    private static final int DELETE_FROM_LENGTH = "delete from ".length();
    private static final int VALUES_LENGTH = " values ".length();
    private static final int SET_LENGTH = " set ".length();
    private static final int WHERE_LENGTH = " where ".length();

    @Override
    public LogMinerDmlEntry parse(String sql, Tables tables, TableId tableId, String txId) {
        if (sql != null && sql.length() > 0) {
            switch (sql.charAt(0)) {
                case 'i': {
                    return this.parseInsert(sql);
                }
                case 'u': {
                    return this.parseUpdate(sql);
                }
                case 'd': {
                    return this.parseDelete(sql);
                }
            }
        }
        throw new DmlParserException("Unknown supported SQL '" + sql + SINGLE_QUOTE);
    }

    private LogMinerDmlEntry parseInsert(String sql) {
        try {
            int index = INSERT_INTO_LENGTH;
            index = this.parseTableName(sql, index);
            ArrayList<String> columnNames = new ArrayList<String>();
            index = this.parseColumnListClause(sql, index, columnNames);
            ArrayList<String> columnValues = new ArrayList<String>(columnNames.size());
            index = this.parseColumnValuesClause(sql, index, columnValues);
            if (columnNames.size() != columnValues.size()) {
                throw new DmlParserException("Columns: " + columnNames + ", Values: " + columnValues);
            }
            ArrayList<LogMinerColumnValue> newValues = new ArrayList<LogMinerColumnValue>(columnNames.size());
            for (int i = 0; i < columnNames.size(); ++i) {
                newValues.add(LogMinerDmlParser.createColumnValue((String)columnNames.get(i), (String)columnValues.get(i)));
            }
            return new LogMinerDmlEntryImpl(Envelope.Operation.CREATE, newValues, Collections.emptyList());
        }
        catch (Exception e) {
            throw new DmlParserException("Failed to parse insert DML: '" + sql + SINGLE_QUOTE, e);
        }
    }

    private LogMinerDmlEntry parseUpdate(String sql) {
        try {
            int index = UPDATE_LENGTH;
            index = this.parseTableName(sql, index);
            ArrayList<String> newColumnNames = new ArrayList<String>();
            ArrayList<String> newColumnValues = new ArrayList<String>();
            index = this.parseSetClause(sql, index, newColumnNames, newColumnValues);
            ArrayList<String> oldColumnNames = new ArrayList<String>();
            ArrayList<String> oldColumnValues = new ArrayList<String>();
            this.parseWhereClause(sql, index, oldColumnNames, oldColumnValues);
            ArrayList<LogMinerColumnValue> oldValues = new ArrayList<LogMinerColumnValue>(oldColumnNames.size());
            for (int i = 0; i < oldColumnNames.size(); ++i) {
                LogMinerColumnValueImpl value = new LogMinerColumnValueImpl((String)oldColumnNames.get(i), 0);
                value.setColumnData(oldColumnValues.get(i));
                oldValues.add(value);
            }
            ArrayList<LogMinerColumnValue> newValues = new ArrayList<LogMinerColumnValue>(newColumnNames.size());
            for (LogMinerColumnValue oldValue : oldValues) {
                boolean found = false;
                for (int j = 0; j < newColumnNames.size(); ++j) {
                    if (!((String)newColumnNames.get(j)).equals(oldValue.getColumnName())) continue;
                    newValues.add(LogMinerDmlParser.createColumnValue((String)newColumnNames.get(j), (String)newColumnValues.get(j)));
                    found = true;
                    break;
                }
                if (found) continue;
                newValues.add(oldValue);
            }
            return new LogMinerDmlEntryImpl(Envelope.Operation.UPDATE, newValues, oldValues);
        }
        catch (Exception e) {
            throw new DmlParserException("Failed to parse update DML: '" + sql + SINGLE_QUOTE, e);
        }
    }

    private LogMinerDmlEntry parseDelete(String sql) {
        try {
            int index = DELETE_FROM_LENGTH;
            index = this.parseTableName(sql, index);
            ArrayList<String> columnNames = new ArrayList<String>();
            ArrayList<String> columnValues = new ArrayList<String>();
            this.parseWhereClause(sql, index, columnNames, columnValues);
            ArrayList<LogMinerColumnValue> oldValues = new ArrayList<LogMinerColumnValue>(columnNames.size());
            for (int i = 0; i < columnNames.size(); ++i) {
                oldValues.add(LogMinerDmlParser.createColumnValue((String)columnNames.get(i), (String)columnValues.get(i)));
            }
            return new LogMinerDmlEntryImpl(Envelope.Operation.DELETE, Collections.emptyList(), oldValues);
        }
        catch (Exception e) {
            throw new DmlParserException("Failed to parse delete DML: '" + sql + SINGLE_QUOTE, e);
        }
    }

    private int parseTableName(String sql, int index) {
        boolean inQuote = false;
        while (index < sql.length()) {
            char c = sql.charAt(index);
            if (c == '\"') {
                inQuote = !inQuote;
            } else if (c == ' ' || c == '(' && !inQuote) break;
            ++index;
        }
        return index;
    }

    private int parseColumnListClause(String sql, int start, List<String> columnNames) {
        int index;
        boolean inQuote = false;
        for (index = start; index < sql.length(); ++index) {
            char c = sql.charAt(index);
            if (c == '(' && !inQuote) {
                start = index + 1;
                continue;
            }
            if (c == ')' && !inQuote) {
                ++index;
                break;
            }
            if (c != '\"') continue;
            if (inQuote) {
                inQuote = false;
                columnNames.add(sql.substring(start + 1, index));
                start = index + 2;
                continue;
            }
            inQuote = true;
        }
        return index;
    }

    private int parseColumnValuesClause(String sql, int start, List<String> columnValues) {
        int index = start;
        int nested = 0;
        boolean inQuote = false;
        boolean inValues = false;
        if (!sql.substring(index, index + 8).equals(VALUES)) {
            throw new DebeziumException("Failed to parse DML: " + sql);
        }
        index += VALUES_LENGTH;
        while (index < sql.length()) {
            char c = sql.charAt(index);
            if (c == '(' && !inQuote && !inValues) {
                inValues = true;
                start = index + 1;
            } else if (c == '(' && !inQuote) {
                ++nested;
            } else if (c == '\'') {
                inQuote = !inQuote;
            } else if (!(inQuote || c != ',' && c != ')')) {
                if (c == ')' && nested != 0) {
                    --nested;
                } else if (c != ',' || nested == 0) {
                    String s = sql.substring(start, index);
                    if (s.startsWith(SINGLE_QUOTE) && s.endsWith(SINGLE_QUOTE)) {
                        s = s.substring(1, s.length() - 1);
                    }
                    columnValues.add(s.equals(UNSUPPORTED_TYPE) ? null : s);
                    start = index + 1;
                }
            }
            ++index;
        }
        return index;
    }

    private int parseSetClause(String sql, int start, List<String> columnNames, List<String> columnValues) {
        int index;
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        boolean inColumnName = true;
        boolean inColumnValue = false;
        boolean inSpecial = false;
        int nested = 0;
        if (!sql.substring(start, start + SET_LENGTH).equals(SET)) {
            throw new DebeziumException("Failed to parse DML: " + sql);
        }
        for (index = start += SET_LENGTH; index < sql.length(); ++index) {
            char lookAhead;
            char c = sql.charAt(index);
            char c2 = lookAhead = index + 1 < sql.length() ? sql.charAt(index + 1) : (char)'\u0000';
            if (c == '\"' && inColumnName) {
                if (inDoubleQuote) {
                    inDoubleQuote = false;
                    columnNames.add(sql.substring(start + 1, index));
                    start = index + 1;
                    inColumnName = false;
                    continue;
                }
                inDoubleQuote = true;
                start = index;
                continue;
            }
            if (c == '=' && !inColumnName && !inColumnValue) {
                inColumnValue = true;
                start = ++index + 1;
                continue;
            }
            if (c == '\'' && inColumnValue && nested == 0) {
                if (inSingleQuote) {
                    inSingleQuote = false;
                    columnValues.add(sql.substring(start + 1, index));
                    start = index + 1;
                    inColumnValue = false;
                    inColumnName = false;
                    continue;
                }
                inSingleQuote = true;
                start = index;
                continue;
            }
            if (c == ',' && !inColumnValue && !inColumnName) {
                inColumnName = true;
                start = ++index;
                continue;
            }
            if (inColumnValue && !inSingleQuote) {
                if (!inSpecial) {
                    start = index;
                    inSpecial = true;
                }
                if (c == '(') {
                    ++nested;
                    continue;
                }
                if (c == ')' && nested > 0) {
                    --nested;
                    continue;
                }
                if (c != ',' && c != ' ' || nested != 0) continue;
                String value = sql.substring(start, index);
                if (value.equals(NULL) || value.equals(UNSUPPORTED_TYPE)) {
                    columnValues.add(null);
                    start = index + 1;
                    inColumnValue = false;
                    inSpecial = false;
                    inColumnName = true;
                    continue;
                }
                if (value.equals(UNSUPPORTED)) continue;
                columnValues.add(sql.substring(start, index));
                start = index + 1;
                inColumnValue = false;
                inSpecial = false;
                inColumnName = true;
                continue;
            }
            if (inDoubleQuote || inSingleQuote || c != 'w' || lookAhead != 'h' || !sql.substring(index - 1, index + WHERE_LENGTH - 1).equals(WHERE)) continue;
            --index;
            break;
        }
        return index;
    }

    private int parseWhereClause(String sql, int start, List<String> columnNames, List<String> columnValues) {
        int index;
        int nested = 0;
        boolean inColumnName = true;
        boolean inColumnValue = false;
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        boolean inSpecial = false;
        if (!sql.substring(start, start + WHERE_LENGTH).equals(WHERE)) {
            throw new DebeziumException("Failed to parse DML: " + sql);
        }
        for (index = start += WHERE_LENGTH; index < sql.length(); ++index) {
            char lookAhead;
            char c = sql.charAt(index);
            char c2 = lookAhead = index + 1 < sql.length() ? sql.charAt(index + 1) : (char)'\u0000';
            if (c == '\"' && inColumnName) {
                if (inDoubleQuote) {
                    inDoubleQuote = false;
                    columnNames.add(sql.substring(start + 1, index));
                    start = index + 1;
                    inColumnName = false;
                    continue;
                }
                inDoubleQuote = true;
                start = index;
                continue;
            }
            if (c == '=' && !inColumnName && !inColumnValue) {
                inColumnValue = true;
                start = ++index + 1;
                continue;
            }
            if (c == '\'' && inColumnValue && nested == 0) {
                if (inSingleQuote) {
                    inSingleQuote = false;
                    columnValues.add(sql.substring(start + 1, index));
                    start = index + 1;
                    inColumnValue = false;
                    inColumnName = false;
                    continue;
                }
                inSingleQuote = true;
                start = index;
                continue;
            }
            if (inColumnValue && !inSingleQuote) {
                if (!inSpecial) {
                    start = index;
                    inSpecial = true;
                }
                if (c == '(') {
                    ++nested;
                    continue;
                }
                if (c == ')' && nested > 0) {
                    --nested;
                    continue;
                }
                if (c != ';' && c != ' ' || nested != 0) continue;
                String value = sql.substring(start, index);
                if (value.equals(NULL) || value.equals(UNSUPPORTED_TYPE)) {
                    columnValues.add(null);
                    start = index + 1;
                    inColumnValue = false;
                    inSpecial = false;
                    inColumnName = true;
                    continue;
                }
                if (value.equals(UNSUPPORTED)) continue;
                columnValues.add(sql.substring(start, index));
                start = index + 1;
                inColumnValue = false;
                inSpecial = false;
                inColumnName = true;
                continue;
            }
            if (inColumnValue || inColumnName) continue;
            if (c == 'a' && lookAhead == 'n' && sql.substring(index).startsWith(AND)) {
                start = index += 3;
                inColumnName = true;
                continue;
            }
            if (c != 'o' || lookAhead != 'r' || !sql.substring(index).startsWith(OR)) continue;
            start = index += 2;
            inColumnName = true;
        }
        return index;
    }

    private static String removeSingleQuotes(String text) {
        if (text.startsWith(SINGLE_QUOTE) && text.endsWith(SINGLE_QUOTE)) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    private static LogMinerColumnValue createColumnValue(String columnName, String columnValue) {
        LogMinerColumnValueImpl value = new LogMinerColumnValueImpl(columnName, 0);
        if (columnValue != null && !columnValue.equals(NULL)) {
            value.setColumnData(columnValue);
        }
        return value;
    }
}

