/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.util.Strings;
import java.io.IOException;
import java.sql.SQLRecoverableException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import oracle.net.ns.NetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtils {
    private static final String DATABASE_VIEW = "V$DATABASE";
    private static final String LOG_VIEW = "V$LOG";
    private static final String LOGFILE_VIEW = "V$LOGFILE";
    private static final String ARCHIVED_LOG_VIEW = "V$ARCHIVED_LOG";
    private static final String ARCHIVE_DEST_STATUS_VIEW = "V$ARCHIVE_DEST_STATUS";
    private static final String LOGMNR_CONTENTS_VIEW = "V$LOGMNR_CONTENTS";
    private static final String ALL_LOG_GROUPS = "ALL_LOG_GROUPS";
    static final String BUILD_DICTIONARY = "BEGIN DBMS_LOGMNR_D.BUILD (options => DBMS_LOGMNR_D.STORE_IN_REDO_LOGS); END;";
    static final String CURRENT_TIMESTAMP = "SELECT CURRENT_TIMESTAMP FROM DUAL";
    static final String END_LOGMNR = "BEGIN SYS.DBMS_LOGMNR.END_LOGMNR(); END;";
    static final String FILES_FOR_MINING = "SELECT FILENAME AS NAME FROM V$LOGMNR_LOGS";
    static final String LOGMNR_FLUSH_TABLE = "LOG_MINING_FLUSH";
    static final String FLUSH_TABLE_NOT_EMPTY = "SELECT '1' AS ONE FROM LOG_MINING_FLUSH";
    static final String CREATE_FLUSH_TABLE = "CREATE TABLE LOG_MINING_FLUSH(LAST_SCN NUMBER(19,0))";
    static final String INSERT_FLUSH_TABLE = "INSERT INTO LOG_MINING_FLUSH VALUES(0)";
    static final String UPDATE_FLUSH_TABLE = "UPDATE LOG_MINING_FLUSH SET LAST_SCN =";
    static final String LOGMNR_HISTORY_TEMP_TABLE = "LOG_MINING_TEMP";
    static final String LOGMNR_HISTORY_TABLE_PREFIX = "LM_HIST_";
    private static final String LOGMNR_HISTORY_SEQUENCE = "LOG_MINING_HIST_SEQ";
    static final String CREATE_LOGMINING_HISTORY_SEQUENCE = "CREATE SEQUENCE LOG_MINING_HIST_SEQ ORDER CACHE 10000";
    static final String LOGMINING_HISTORY_SEQUENCE_EXISTS = "SELECT '1' AS ONE FROM USER_SEQUENCES WHERE SEQUENCE_NAME = 'LOG_MINING_HIST_SEQ'";
    static final String INSERT_INTO_TEMP_HISTORY_TABLE_STMT = "INSERT /*+ APPEND */ INTO LOG_MINING_TEMP values(LOG_MINING_HIST_SEQ.nextVal, ?, ?, ?, ?, ?, ?, ?, ?)";
    static final String NLS_SESSION_PARAMETERS = "ALTER SESSION SET   NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'  NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF'  NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM'  NLS_NUMERIC_CHARACTERS = '.,'";
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlUtils.class);

    static void setRac(boolean isRac) {
        if (isRac) {
            // empty if block
        }
    }

    static String redoLogStatusQuery() {
        return String.format("SELECT F.MEMBER, R.STATUS FROM %s F, %s R WHERE F.GROUP# = R.GROUP# ORDER BY 2", LOGFILE_VIEW, LOG_VIEW);
    }

    static String switchHistoryQuery() {
        return String.format("SELECT 'TOTAL', COUNT(1) FROM %s WHERE FIRST_TIME > TRUNC(SYSDATE) AND DEST_ID IN (SELECT DEST_ID FROM %s WHERE STATUS='VALID' AND TYPE='LOCAL')", ARCHIVED_LOG_VIEW, ARCHIVE_DEST_STATUS_VIEW);
    }

    static String currentRedoNameQuery() {
        return String.format("SELECT F.MEMBER FROM %s LOG, %s F  WHERE LOG.GROUP#=F.GROUP# AND LOG.STATUS='CURRENT'", LOG_VIEW, LOGFILE_VIEW);
    }

    static String databaseSupplementalLoggingAllCheckQuery() {
        return String.format("SELECT 'KEY', SUPPLEMENTAL_LOG_DATA_ALL FROM %s", DATABASE_VIEW);
    }

    static String databaseSupplementalLoggingMinCheckQuery() {
        return String.format("SELECT 'KEY', SUPPLEMENTAL_LOG_DATA_MIN FROM %s", DATABASE_VIEW);
    }

    static String tableSupplementalLoggingCheckQuery(TableId tableId) {
        return String.format("SELECT 'KEY', LOG_GROUP_TYPE FROM %s WHERE OWNER = '%s' AND TABLE_NAME = '%s'", ALL_LOG_GROUPS, tableId.schema(), tableId.table());
    }

    static String currentScnQuery() {
        return String.format("SELECT CURRENT_SCN FROM %s", DATABASE_VIEW);
    }

    static String oldestFirstChangeQuery(Duration archiveLogRetention) {
        if (!archiveLogRetention.isNegative() && !archiveLogRetention.isZero()) {
            return String.format("SELECT MIN(FIRST_CHANGE#) FROM (SELECT MIN(FIRST_CHANGE#) AS FIRST_CHANGE# FROM %s UNION SELECT MIN(FIRST_CHANGE#) AS FIRST_CHANGE# FROM %s WHERE FIRST_TIME >= SYSDATE - (%d/24))", LOG_VIEW, ARCHIVED_LOG_VIEW, archiveLogRetention.toHours());
        }
        return String.format("SELECT MIN(FIRST_CHANGE#) FROM (SELECT MIN(FIRST_CHANGE#) AS FIRST_CHANGE# FROM %s UNION SELECT MIN(FIRST_CHANGE#) AS FIRST_CHANGE# FROM %s)", LOG_VIEW, ARCHIVED_LOG_VIEW);
    }

    public static String allOnlineLogsQuery() {
        return String.format("SELECT MIN(F.MEMBER) AS FILE_NAME, L.NEXT_CHANGE# AS NEXT_CHANGE, F.GROUP#, L.FIRST_CHANGE# AS FIRST_CHANGE  FROM %s L, %s F  WHERE F.GROUP# = L.GROUP# AND L.NEXT_CHANGE# > 0  GROUP BY F.GROUP#, L.NEXT_CHANGE#, L.FIRST_CHANGE# ORDER BY 3", LOG_VIEW, LOGFILE_VIEW);
    }

    public static String archiveLogsQuery(Long scn, Duration archiveLogRetention) {
        if (!archiveLogRetention.isNegative() && !archiveLogRetention.isZero()) {
            return String.format("SELECT NAME AS FILE_NAME, NEXT_CHANGE# AS NEXT_CHANGE, FIRST_CHANGE# AS FIRST_CHANGE FROM %s  WHERE NAME IS NOT NULL AND FIRST_TIME >= SYSDATE - (%d/24) AND ARCHIVED = 'YES'  AND STATUS = 'A' AND NEXT_CHANGE# > %s ORDER BY 2", ARCHIVED_LOG_VIEW, archiveLogRetention.toHours(), scn);
        }
        return String.format("SELECT NAME AS FILE_NAME, NEXT_CHANGE# AS NEXT_CHANGE, FIRST_CHANGE# AS FIRST_CHANGE FROM %s WHERE NAME IS NOT NULL AND ARCHIVED = 'YES' AND STATUS = 'A' AND NEXT_CHANGE# > %s ORDER BY 2", ARCHIVED_LOG_VIEW, scn);
    }

    static String startLogMinerStatement(Long startScn, Long endScn, OracleConnectorConfig.LogMiningStrategy strategy, boolean isContinuousMining) {
        String miningStrategy = strategy.equals((Object)OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO) ? "DBMS_LOGMNR.DICT_FROM_REDO_LOGS + DBMS_LOGMNR.DDL_DICT_TRACKING " : "DBMS_LOGMNR.DICT_FROM_ONLINE_CATALOG ";
        if (isContinuousMining) {
            miningStrategy = miningStrategy + " + DBMS_LOGMNR.CONTINUOUS_MINE ";
        }
        return "BEGIN sys.dbms_logmnr.start_logmnr(startScn => '" + startScn + "', endScn => '" + endScn + "', OPTIONS => " + miningStrategy + " + DBMS_LOGMNR.NO_ROWID_IN_STMT);END;";
    }

    static String logMinerContentsQuery(OracleConnectorConfig connectorConfig, String logMinerUser) {
        String tablePredicate;
        String schemaPredicate;
        StringBuilder query = new StringBuilder();
        query.append("SELECT SCN, SQL_REDO, OPERATION_CODE, TIMESTAMP, XID, CSF, TABLE_NAME, SEG_OWNER, OPERATION, USERNAME ");
        query.append("FROM ").append(LOGMNR_CONTENTS_VIEW).append(" ");
        query.append("WHERE OPERATION_CODE IN (1,2,3,5) ");
        query.append("AND SCN >= ? ");
        query.append("AND SCN < ? ");
        query.append("AND TABLE_NAME != '").append(LOGMNR_FLUSH_TABLE).append("' ");
        List<String> excludedSchemas = OracleConnectorConfig.getExcludedSchemaNames();
        if (!excludedSchemas.isEmpty()) {
            query.append("AND SEG_OWNER NOT IN (");
            Iterator<String> i = excludedSchemas.iterator();
            while (i.hasNext()) {
                String excludedSchema = i.next();
                query.append("'").append(excludedSchema.toUpperCase()).append("'");
                if (!i.hasNext()) continue;
                query.append(",");
            }
            query.append(") ");
        }
        if (!Strings.isNullOrEmpty((String)(schemaPredicate = SqlUtils.buildSchemaPredicate(connectorConfig)))) {
            query.append("AND ").append(schemaPredicate).append(" ");
        }
        if (!Strings.isNullOrEmpty((String)(tablePredicate = SqlUtils.buildTablePredicate(connectorConfig)))) {
            query.append("AND ").append(tablePredicate).append(" ");
        }
        query.append("OR (OPERATION_CODE IN (5,34) AND USERNAME NOT IN ('SYS','SYSTEM','").append(logMinerUser.toUpperCase()).append("')) ");
        query.append("OR (OPERATION_CODE IN (7,36))");
        return query.toString();
    }

    private static String buildSchemaPredicate(OracleConnectorConfig connectorConfig) {
        StringBuilder predicate = new StringBuilder();
        if (Strings.isNullOrEmpty((String)connectorConfig.schemaIncludeList())) {
            if (!Strings.isNullOrEmpty((String)connectorConfig.schemaExcludeList())) {
                List patterns = Strings.listOfRegex((String)connectorConfig.schemaExcludeList(), (int)0);
                predicate.append("(").append(SqlUtils.listOfPatternsToSql(patterns, "SEG_OWNER", true)).append(")");
            }
        } else {
            List patterns = Strings.listOfRegex((String)connectorConfig.schemaIncludeList(), (int)0);
            predicate.append("(").append(SqlUtils.listOfPatternsToSql(patterns, "SEG_OWNER", false)).append(")");
        }
        return predicate.toString();
    }

    private static String buildTablePredicate(OracleConnectorConfig connectorConfig) {
        StringBuilder predicate = new StringBuilder();
        if (Strings.isNullOrEmpty((String)connectorConfig.tableIncludeList())) {
            if (!Strings.isNullOrEmpty((String)connectorConfig.tableExcludeList())) {
                List patterns = Strings.listOfRegex((String)connectorConfig.tableExcludeList(), (int)0);
                predicate.append("(").append(SqlUtils.listOfPatternsToSql(patterns, "SEG_OWNER || '.' || TABLE_NAME", true)).append(")");
            }
        } else {
            List patterns = Strings.listOfRegex((String)connectorConfig.tableIncludeList(), (int)0);
            predicate.append("(").append(SqlUtils.listOfPatternsToSql(patterns, "SEG_OWNER || '.' || TABLE_NAME", false)).append(")");
        }
        return predicate.toString();
    }

    private static String listOfPatternsToSql(List<Pattern> patterns, String columnName, boolean applyNot) {
        StringBuilder predicate = new StringBuilder();
        Iterator<Pattern> i = patterns.iterator();
        while (i.hasNext()) {
            Pattern pattern = i.next();
            if (applyNot) {
                predicate.append("NOT ");
            }
            String text = SqlUtils.resolveRegExpLikePattern(pattern);
            predicate.append("REGEXP_LIKE(").append(columnName).append(",'").append(text).append("','i')");
            if (!i.hasNext()) continue;
            predicate.append(applyNot ? " AND " : " OR ");
        }
        return predicate.toString();
    }

    private static String resolveRegExpLikePattern(Pattern pattern) {
        String text = pattern.pattern();
        if (!text.startsWith("^")) {
            text = "^" + text;
        }
        if (!text.endsWith("$")) {
            text = text + "$";
        }
        return text;
    }

    static String addLogFileStatement(String option, String fileName) {
        return "BEGIN sys.dbms_logmnr.add_logfile(LOGFILENAME => '" + fileName + "', OPTIONS => " + option + ");END;";
    }

    static String deleteLogFileStatement(String fileName) {
        return "BEGIN SYS.DBMS_LOGMNR.REMOVE_LOGFILE(LOGFILENAME => '" + fileName + "');END;";
    }

    static String tableExistsQuery(String tableName) {
        return "SELECT '1' AS ONE FROM USER_TABLES WHERE TABLE_NAME = '" + tableName + "'";
    }

    static String getHistoryTableNamesQuery() {
        return "SELECT TABLE_NAME, '1' FROM USER_TABLES WHERE TABLE_NAME LIKE 'LM_HIST_%'";
    }

    static String dropHistoryTableStatement(String tableName) {
        return "DROP TABLE " + tableName.toUpperCase() + " PURGE";
    }

    static String logMiningHistoryDdl(String tableName) {
        return "create  TABLE " + tableName + "(row_sequence NUMBER(19,0), captured_scn NUMBER(19,0), table_name VARCHAR2(30 CHAR), seg_owner VARCHAR2(30 CHAR), operation_code NUMBER(19,0), change_time TIMESTAMP(6), transaction_id VARCHAR2(50 CHAR), csf NUMBER(19,0), redo_sql VARCHAR2(4000 CHAR)) nologging";
    }

    static String truncateTableStatement(String tableName) {
        return "TRUNCATE TABLE " + tableName;
    }

    static String bulkHistoryInsertStmt(String currentHistoryTableName) {
        return "INSERT  /*+ APPEND */ INTO " + currentHistoryTableName + " SELECT * FROM " + LOGMNR_HISTORY_TEMP_TABLE;
    }

    public static String diffInDaysQuery(Long scn) {
        if (scn == null) {
            return null;
        }
        return "select sysdate - CAST(scn_to_timestamp(" + scn + ") as date) from dual";
    }

    public static boolean connectionProblem(Throwable e) {
        if (e instanceof IOException) {
            return true;
        }
        Throwable cause = e.getCause();
        if (cause != null && cause.getCause() != null && cause.getCause() instanceof NetException) {
            return true;
        }
        if (e instanceof SQLRecoverableException) {
            return true;
        }
        if (e.getMessage() == null) {
            return false;
        }
        return e.getMessage().startsWith("ORA-03135") || e.getMessage().startsWith("ORA-12543") || e.getMessage().startsWith("ORA-00604") || e.getMessage().startsWith("ORA-01089") || e.getMessage().startsWith("ORA-00600") || e.getMessage().toUpperCase().contains("CONNECTION IS CLOSED") || e.getMessage().toUpperCase().startsWith("NO MORE DATA TO READ FROM SOCKET");
    }

    public static String buildHistoryTableName(LocalDateTime now) {
        int year = now.getYear();
        int month = now.getMonthValue();
        int day = now.getDayOfMonth();
        int hour = now.getHour();
        int minute = now.getMinute();
        return LOGMNR_HISTORY_TABLE_PREFIX + year + "_" + month + "_" + day + "_" + hour + "_" + minute;
    }

    public static long parseRetentionFromName(String historyTableName) {
        String[] tokens = historyTableName.split("_");
        if (tokens.length != 7) {
            return 0L;
        }
        LocalDateTime recorded = LocalDateTime.of(Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3]), Integer.parseInt(tokens[4]), Integer.parseInt(tokens[5]), Integer.parseInt(tokens[6]));
        return Duration.between(recorded, LocalDateTime.now()).toHours();
    }
}

