/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.config.Configuration;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.LogMinerMetrics;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class LogMinerMetricsTest {
    private LogMinerMetrics metrics;
    private OracleConnectorConfig connectorConfig;
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    @Before
    public void before() {
        CdcSourceTaskContext taskContext = (CdcSourceTaskContext)Mockito.mock(CdcSourceTaskContext.class);
        Mockito.when((Object)taskContext.getConnectorName()).thenReturn((Object)"connector name");
        Mockito.when((Object)taskContext.getConnectorType()).thenReturn((Object)"connector type");
        this.connectorConfig = new OracleConnectorConfig(Configuration.create().build());
        this.metrics = new LogMinerMetrics(taskContext, this.connectorConfig);
    }

    @Test
    public void testMetrics() {
        this.metrics.setLastCapturedDmlCount(1);
        Assertions.assertThat((this.metrics.getTotalCapturedDmlCount() == 1L ? 1 : 0) != 0).isTrue();
        this.metrics.setCurrentScn(Long.valueOf(1000L));
        Assertions.assertThat((Long)this.metrics.getCurrentScn()).isEqualTo(1000L);
        this.metrics.setBatchSize(10);
        Assertions.assertThat((this.metrics.getBatchSize() == this.connectorConfig.getLogMiningBatchSizeDefault() ? 1 : 0) != 0).isTrue();
        this.metrics.setBatchSize(1000000);
        Assertions.assertThat((int)this.metrics.getBatchSize()).isEqualTo(this.connectorConfig.getLogMiningBatchSizeDefault());
        this.metrics.setBatchSize(6000);
        Assertions.assertThat((int)this.metrics.getBatchSize()).isEqualTo(6000);
        Assertions.assertThat((long)this.metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1000L);
        this.metrics.changeSleepingTime(true);
        Assertions.assertThat((long)this.metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1200L);
        this.metrics.changeSleepingTime(false);
        Assertions.assertThat((long)this.metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1000L);
        this.metrics.setMillisecondToSleepBetweenMiningQuery(-1L);
        Assertions.assertThat((long)this.metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1000L);
        this.metrics.setMillisecondToSleepBetweenMiningQuery(4000L);
        Assertions.assertThat((long)this.metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(1000L);
        this.metrics.setMillisecondToSleepBetweenMiningQuery(2000L);
        Assertions.assertThat((long)this.metrics.getMillisecondToSleepBetweenMiningQuery()).isEqualTo(2000L);
        this.metrics.setLastDurationOfBatchCapturing(Duration.ofMillis(100L));
        Assertions.assertThat((Long)this.metrics.getLastDurationOfFetchingQuery()).isEqualTo(100L);
        this.metrics.setLastDurationOfBatchCapturing(Duration.ofMillis(200L));
        Assertions.assertThat((Long)this.metrics.getLastDurationOfFetchingQuery()).isEqualTo(200L);
        Assertions.assertThat((Long)this.metrics.getMaxDurationOfFetchingQuery()).isEqualTo(200L);
        Assertions.assertThat((long)this.metrics.getFetchingQueryCount()).isEqualTo(2L);
        this.metrics.setCurrentLogFileName(new HashSet<String>(Arrays.asList("name", "name1")));
        Assertions.assertThat((boolean)this.metrics.getCurrentRedoLogFileName()[0].equals("name")).isTrue();
        Assertions.assertThat((boolean)this.metrics.getCurrentRedoLogFileName()[1].equals("name1")).isTrue();
        this.metrics.setSwitchCount(5);
        Assertions.assertThat((this.metrics.getSwitchCounter() == 5 ? 1 : 0) != 0).isTrue();
        this.metrics.reset();
        this.metrics.setLastDurationOfBatchCapturing(Duration.ofMillis(1000L));
        Assertions.assertThat((Long)this.metrics.getLastDurationOfFetchingQuery()).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getFetchingQueryCount()).isEqualTo(1L);
        this.metrics.reset();
        this.metrics.setLastCapturedDmlCount(300);
        this.metrics.setLastDurationOfBatchProcessing(Duration.ofMillis(1000L));
        Assertions.assertThat((int)this.metrics.getLastCapturedDmlCount()).isEqualTo(300);
        Assertions.assertThat((long)this.metrics.getLastBatchProcessingDuration()).isEqualTo(1000L);
        Assertions.assertThat((long)this.metrics.getAverageBatchProcessingThroughput()).isGreaterThanOrEqualTo(300L);
        Assertions.assertThat((Long)this.metrics.getMaxCapturedDmlInBatch()).isEqualTo(300L);
        Assertions.assertThat((long)this.metrics.getMaxBatchProcessingThroughput()).isEqualTo(300L);
        this.metrics.setLastCapturedDmlCount(500);
        this.metrics.setLastDurationOfBatchProcessing(Duration.ofMillis(1000L));
        Assertions.assertThat((long)this.metrics.getAverageBatchProcessingThroughput()).isEqualTo(400L);
        Assertions.assertThat((Long)this.metrics.getMaxCapturedDmlInBatch()).isEqualTo(500L);
        Assertions.assertThat((long)this.metrics.getMaxBatchProcessingThroughput()).isEqualTo(500L);
        Assertions.assertThat((long)this.metrics.getLastBatchProcessingThroughput()).isEqualTo(500L);
        this.metrics.setLastDurationOfBatchProcessing(Duration.ofMillis(5000L));
        Assertions.assertThat((long)this.metrics.getLastBatchProcessingThroughput()).isEqualTo(100L);
        this.metrics.setLastDurationOfBatchProcessing(Duration.ZERO);
        Assertions.assertThat((long)this.metrics.getLastBatchProcessingThroughput()).isEqualTo(0L);
        Assertions.assertThat((int)this.metrics.getHoursToKeepTransactionInBuffer()).isEqualTo(4);
        this.metrics.setRedoLogStatus(Collections.singletonMap("name", "current"));
        Assertions.assertThat((boolean)this.metrics.getRedoLogStatus()[0].equals("name | current")).isTrue();
        Assertions.assertThat((boolean)this.metrics.toString().contains("logMinerQueryCount"));
        Assertions.assertThat((boolean)this.metrics.getRecordMiningHistory()).isFalse();
        this.metrics.setRecordMiningHistory(true);
        Assertions.assertThat((boolean)this.metrics.getRecordMiningHistory()).isTrue();
        this.metrics.setHoursToKeepTransactionInBuffer(3);
        Assertions.assertThat((int)this.metrics.getHoursToKeepTransactionInBuffer()).isEqualTo(3);
        this.metrics.incrementNetworkConnectionProblemsCounter();
        Assertions.assertThat((long)this.metrics.getNetworkConnectionProblemsCounter()).isEqualTo(1L);
        this.metrics.setBatchSize(5000);
        this.metrics.changeBatchSize(true);
        Assertions.assertThat((int)this.metrics.getBatchSize()).isEqualTo(6000);
        this.metrics.changeBatchSize(false);
        Assertions.assertThat((int)this.metrics.getBatchSize()).isEqualTo(5000);
    }
}

