/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnectorConfig;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnectorConfigTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleConnectorConfigTest.class);

    @Test
    public void validXtreamNoUrl() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.SERVER_NAME, "myserver")).with(OracleConnectorConfig.HOSTNAME, "MyHostname")).with(OracleConnectorConfig.DATABASE_NAME, "mydb")).with(OracleConnectorConfig.XSTREAM_SERVER_NAME, "myserver")).with(OracleConnectorConfig.USER, "debezium")).build());
        Assert.assertTrue((boolean)connectorConfig.getConfig().validateAndRecord((Iterable)OracleConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void validLogminerNoUrl() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.CONNECTOR_ADAPTER, "logminer")).with(OracleConnectorConfig.SERVER_NAME, "myserver")).with(OracleConnectorConfig.HOSTNAME, "MyHostname")).with(OracleConnectorConfig.DATABASE_NAME, "mydb")).with(OracleConnectorConfig.SCHEMA_NAME, "myschema")).with(OracleConnectorConfig.USER, "debezium")).build());
        Assert.assertTrue((boolean)connectorConfig.getConfig().validateAndRecord((Iterable)OracleConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void validXtreamWithUrl() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.SERVER_NAME, "myserver")).with(OracleConnectorConfig.URL, "jdbc:oci:thin:@myserver/mydatabase")).with(OracleConnectorConfig.DATABASE_NAME, "mydb")).with(OracleConnectorConfig.XSTREAM_SERVER_NAME, "myserver")).with(OracleConnectorConfig.USER, "debezium")).build());
        Assert.assertTrue((boolean)connectorConfig.getConfig().validateAndRecord((Iterable)OracleConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void validLogminerWithUrl() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.CONNECTOR_ADAPTER, "logminer")).with(OracleConnectorConfig.SERVER_NAME, "myserver")).with(OracleConnectorConfig.URL, "MyHostname")).with(OracleConnectorConfig.DATABASE_NAME, "mydb")).with(OracleConnectorConfig.SCHEMA_NAME, "myschema")).with(OracleConnectorConfig.USER, "debezium")).build());
        Assert.assertTrue((boolean)connectorConfig.getConfig().validateAndRecord((Iterable)OracleConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void validUrlTNS() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.CONNECTOR_ADAPTER, "logminer")).with(OracleConnectorConfig.SERVER_NAME, "myserver")).with(OracleConnectorConfig.URL, "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=192.68.1.11)(PORT=1701))(ADDRESS=(PROTOCOL=TCP)(HOST=192.68.1.12)(PORT=1701))(ADDRESS=(PROTOCOL=TCP)(HOST=192.68.1.13)(PORT=1701))(LOAD_BALANCE = yes)(FAILOVER = on)(CONNECT_DATA =(SERVER = DEDICATED)(SERVICE_NAME = myserver.mydomain.com)(FAILOVER_MODE =(TYPE = SELECT)(METHOD = BASIC)(RETRIES = 3)(DELAY = 5))))")).with(OracleConnectorConfig.DATABASE_NAME, "mydb")).with(OracleConnectorConfig.SCHEMA_NAME, "myschema")).with(OracleConnectorConfig.USER, "debezium")).build());
        Assert.assertTrue((boolean)connectorConfig.getConfig().validateAndRecord((Iterable)OracleConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void invalidNoHostnameNoUri() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(OracleConnectorConfig.CONNECTOR_ADAPTER, "logminer")).with(OracleConnectorConfig.SERVER_NAME, "myserver")).with(OracleConnectorConfig.DATABASE_NAME, "mydb")).with(OracleConnectorConfig.SCHEMA_NAME, "myschema")).with(OracleConnectorConfig.USER, "debezium")).build());
        Assert.assertFalse((boolean)connectorConfig.getConfig().validateAndRecord((Iterable)OracleConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void validBatchDefaults() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(Configuration.create().build());
        Assert.assertEquals((long)connectorConfig.getConfig().getInteger(OracleConnectorConfig.LOG_MINING_BATCH_SIZE_DEFAULT), (long)20000L);
        Assert.assertEquals((long)connectorConfig.getConfig().getInteger(OracleConnectorConfig.LOG_MINING_BATCH_SIZE_MAX), (long)100000L);
        Assert.assertEquals((long)connectorConfig.getConfig().getInteger(OracleConnectorConfig.LOG_MINING_BATCH_SIZE_MIN), (long)1000L);
        Assert.assertEquals((long)connectorConfig.getLogMiningBatchSizeDefault(), (long)20000L);
        Assert.assertEquals((long)connectorConfig.getLogMiningBatchSizeMax(), (long)100000L);
        Assert.assertEquals((long)connectorConfig.getLogMiningBatchSizeMin(), (long)1000L);
    }

    @Test
    public void validSleepDefaults() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(Configuration.create().build());
        Assert.assertEquals((long)connectorConfig.getConfig().getInteger(OracleConnectorConfig.LOG_MINING_SLEEP_TIME_DEFAULT_MS), (long)1000L);
        Assert.assertEquals((long)connectorConfig.getConfig().getInteger(OracleConnectorConfig.LOG_MINING_SLEEP_TIME_MAX_MS), (long)3000L);
        Assert.assertEquals((long)connectorConfig.getConfig().getInteger(OracleConnectorConfig.LOG_MINING_SLEEP_TIME_MIN_MS), (long)0L);
        Assert.assertEquals((long)connectorConfig.getConfig().getInteger(OracleConnectorConfig.LOG_MINING_SLEEP_TIME_INCREMENT_MS), (long)200L);
        Assert.assertEquals((long)connectorConfig.getLogMiningSleepTimeDefault().toMillis(), (long)1000L);
        Assert.assertEquals((long)connectorConfig.getLogMiningSleepTimeMax().toMillis(), (long)3000L);
        Assert.assertEquals((long)connectorConfig.getLogMiningSleepTimeMin().toMillis(), (long)0L);
        Assert.assertEquals((long)connectorConfig.getLogMiningSleepTimeIncrement().toMillis(), (long)200L);
    }

    @Test
    public void validViewFetchSizeDefaults() throws Exception {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(Configuration.create().build());
        Assert.assertEquals((long)connectorConfig.getConfig().getInteger(OracleConnectorConfig.LOG_MINING_VIEW_FETCH_SIZE), (long)10000L);
        Assert.assertEquals((long)connectorConfig.getLogMiningViewFetchSize(), (long)10000L);
    }
}

