/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.logminer.LogMinerHelper;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Duration;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LogMinerHelperTest {
    private Connection connection = (Connection)Mockito.mock(Connection.class);
    private int current;
    private String[][] mockRows;

    @Before
    public void beforeEach() throws Exception {
        this.current = 0;
        this.mockRows = new String[0][];
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        PreparedStatement pstmt = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)this.connection.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)pstmt);
        Mockito.when((Object)pstmt.executeQuery()).thenReturn((Object)rs);
        Mockito.when((Object)rs.next()).thenAnswer(it -> ++this.current <= this.mockRows.length);
        Mockito.when((Object)rs.getString(ArgumentMatchers.anyInt())).thenAnswer(it -> this.mockRows[this.current - 1][(Integer)it.getArguments()[0] - 1]);
    }

    @Test
    public void logsWithRegularScns() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700"}, {"logfile2", "103700", "12", "104000"}};
        Map onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((Connection)this.connection, (Long)10L);
        Assert.assertEquals((long)onlineLogs.size(), (long)2L);
        Assert.assertEquals(onlineLogs.get("logfile1"), (Object)BigInteger.valueOf(103400L));
        Assert.assertEquals(onlineLogs.get("logfile2"), (Object)BigInteger.valueOf(103700L));
    }

    @Test
    public void excludeLogsBeforeOffsetScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700"}, {"logfile2", "103700", "12", "104000"}, {"logfile3", "500", "13", "103100"}};
        Map onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((Connection)this.connection, (Long)600L);
        Assert.assertEquals((long)onlineLogs.size(), (long)2L);
        Assert.assertNull(onlineLogs.get("logfile3"));
    }

    @Test
    public void nullsHandledAsMaxScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700"}, {"logfile2", "103700", "12", "104000"}, {"logfile3", null, "13", "103100"}};
        Map onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((Connection)this.connection, (Long)600L);
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals(onlineLogs.get("logfile3"), (Object)LogMinerHelper.MAX_SCN_BI);
    }

    @Test
    public void canHandleMaxScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700"}, {"logfile2", "103700", "12", "104000"}, {"logfile3", "18446744073709551615", "13", "104300"}};
        Map onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((Connection)this.connection, (Long)600L);
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals(onlineLogs.get("logfile3"), (Object)LogMinerHelper.MAX_SCN_BI);
    }

    @Test
    public void logsWithLongerScnAreSupported() throws Exception {
        String scnLonger = "9295429630892703743";
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700"}, {"logfile2", "103700", "12", "104000"}, {"logfile3", scnLonger, "13", "104300"}};
        Map onlineLogs = LogMinerHelper.getOnlineLogFilesForOffsetScn((Connection)this.connection, (Long)600L);
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals(onlineLogs.get("logfile3"), (Object)new BigInteger(scnLonger));
    }

    @Test
    public void archiveLogsWithRegularScns() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11"}, {"logfile2", "103700", "12"}};
        Map onlineLogs = LogMinerHelper.getArchivedLogFilesForOffsetScn((Connection)this.connection, (Long)500L, (Duration)Duration.ofDays(60L));
        Assert.assertEquals((long)onlineLogs.size(), (long)2L);
        Assert.assertEquals(onlineLogs.get("logfile1"), (Object)BigInteger.valueOf(103400L));
        Assert.assertEquals(onlineLogs.get("logfile2"), (Object)BigInteger.valueOf(103700L));
    }

    @Test
    @Ignore
    public void archiveExcludeLogsBeforeOffsetScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11"}, {"logfile2", "103700", "12"}, {"logfile3", "500", "13"}};
        Map onlineLogs = LogMinerHelper.getArchivedLogFilesForOffsetScn((Connection)this.connection, (Long)600L, (Duration)Duration.ofDays(60L));
        Assert.assertEquals((long)onlineLogs.size(), (long)2L);
        Assert.assertNull(onlineLogs.get("logfile3"));
    }

    @Test
    public void archiveNullsHandledAsMaxScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11", "103700"}, {"logfile2", "103700", "12", "104000"}, {"logfile3", null, "13", "104300"}};
        Map onlineLogs = LogMinerHelper.getArchivedLogFilesForOffsetScn((Connection)this.connection, (Long)500L, (Duration)Duration.ofDays(60L));
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals(onlineLogs.get("logfile3"), (Object)LogMinerHelper.MAX_SCN_BI);
    }

    @Test
    public void archiveCanHandleMaxScn() throws Exception {
        this.mockRows = new String[][]{{"logfile1", "103400", "11"}, {"logfile2", "103700", "12"}, {"logfile3", "18446744073709551615", "13"}};
        Map onlineLogs = LogMinerHelper.getArchivedLogFilesForOffsetScn((Connection)this.connection, (Long)500L, (Duration)Duration.ofDays(60L));
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals(onlineLogs.get("logfile3"), (Object)LogMinerHelper.MAX_SCN_BI);
    }

    @Test
    public void archiveLogsWithLongerScnAreSupported() throws Exception {
        String scnLonger = "9295429630892703743";
        this.mockRows = new String[][]{{"logfile1", "103400", "11"}, {"logfile2", "103700", "12"}, {"logfile3", scnLonger, "13"}};
        Map onlineLogs = LogMinerHelper.getArchivedLogFilesForOffsetScn((Connection)this.connection, (Long)500L, (Duration)Duration.ofDays(60L));
        Assert.assertEquals((long)onlineLogs.size(), (long)3L);
        Assert.assertEquals(onlineLogs.get("logfile3"), (Object)new BigInteger(scnLonger));
    }
}

