/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.fest.assertions.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER, reason="LogMiner specific tests")
@Ignore(value="The super class before method fails, needs investigation - alter session insufficient privileges")
public class LogMinerHelperIT
extends AbstractConnectorTest {
    @Rule
    public final TestRule skipAdapterRule = new SkipTestDependingOnAdapterNameRule();
    private static OracleConnection connection;
    private static OracleConnection lmConnection;
    private static Connection conn;

    @BeforeClass
    public static void beforeSuperClass() throws SQLException {
        connection = TestHelper.testConnection();
        lmConnection = TestHelper.testConnection();
        conn = lmConnection.connection(false);
        lmConnection.resetSessionToCdb();
        LogMinerHelper.removeLogFilesFromMining((Connection)conn);
    }

    @AfterClass
    public static void closeConnection() throws SQLException {
        if (conn != null && !conn.isClosed()) {
            conn.close();
        }
        if (lmConnection != null && lmConnection.isConnected()) {
            lmConnection.close();
        }
        if (connection != null && connection.isConnected()) {
            connection.close();
        }
    }

    @Before
    public void before() throws SQLException {
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @Test
    public void shouldAddRightOnlineRedoFiles() throws Exception {
        long currentScn = LogMinerHelper.getCurrentScn((Connection)conn);
        LogMinerHelper.setRedoLogFilesForMining((Connection)conn, (Long)currentScn, (Duration)Duration.ofHours(0L));
        Assertions.assertThat((LogMinerHelperIT.getNumberOfAddedLogFiles(conn) == 1 ? 1 : 0) != 0).isTrue();
        Map redoLogFiles = LogMinerHelper.getMap((Connection)conn, (String)SqlUtils.allOnlineLogsQuery(), (String)"-1");
        Long oldestScn = this.getOldestOnlineScn(redoLogFiles);
        LogMinerHelper.setRedoLogFilesForMining((Connection)conn, (Long)oldestScn, (Duration)Duration.ofHours(0L));
        LogMinerHelper.setRedoLogFilesForMining((Connection)conn, (Long)oldestScn, (Duration)Duration.ofHours(0L));
        Assertions.assertThat((LogMinerHelperIT.getNumberOfAddedLogFiles(conn) == redoLogFiles.size() - 1 ? 1 : 0) != 0).isTrue();
        oldestScn = oldestScn - 1L;
        LogMinerHelper.setRedoLogFilesForMining((Connection)conn, (Long)oldestScn, (Duration)Duration.ofHours(0L));
        Assertions.assertThat((LogMinerHelperIT.getNumberOfAddedLogFiles(conn) == redoLogFiles.size() ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void shouldAddRightArchivedRedoFiles() throws Exception {
        long currentScn = LogMinerHelper.getCurrentScn((Connection)conn);
        Map archivedRedoFiles = LogMinerHelper.getMap((Connection)conn, (String)SqlUtils.archiveLogsQuery((Long)currentScn, (Duration)Duration.ofHours(0L)), (String)"-1");
        Assertions.assertThat((archivedRedoFiles.size() == 0 ? 1 : 0) != 0).isTrue();
        List<BigDecimal> oneDayArchivedNextScn = this.getOneDayArchivedLogNextScn(conn);
        long oldestArchivedScn = this.getOldestArchivedScn(oneDayArchivedNextScn);
        Map archivedLogsForMining = LogMinerHelper.getArchivedLogFilesForOffsetScn((Connection)conn, (Long)oldestArchivedScn, (Duration)Duration.ofHours(0L));
        Assertions.assertThat((archivedLogsForMining.size() == oneDayArchivedNextScn.size() - 1 ? 1 : 0) != 0).isTrue();
        archivedRedoFiles = LogMinerHelper.getMap((Connection)conn, (String)SqlUtils.archiveLogsQuery((Long)(oldestArchivedScn - 1L), (Duration)Duration.ofHours(0L)), (String)"-1");
        Assertions.assertThat((archivedRedoFiles.size() == oneDayArchivedNextScn.size() ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void shouldAddRightRedoFiles() throws Exception {
        List<BigDecimal> oneDayArchivedNextScn = this.getOneDayArchivedLogNextScn(conn);
        long oldestArchivedScn = this.getOldestArchivedScn(oneDayArchivedNextScn);
        LogMinerHelper.setRedoLogFilesForMining((Connection)conn, (Long)oldestArchivedScn, (Duration)Duration.ofHours(0L));
        Map onlineLogFilesForMining = LogMinerHelper.getOnlineLogFilesForOffsetScn((Connection)conn, (Long)oldestArchivedScn);
        Map archivedLogFilesForMining = LogMinerHelper.getArchivedLogFilesForOffsetScn((Connection)conn, (Long)oldestArchivedScn, (Duration)Duration.ofHours(0L));
        List archivedLogFiles = archivedLogFilesForMining.entrySet().stream().filter(e -> !onlineLogFilesForMining.values().contains(e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        int archivedLogFilesCount = archivedLogFiles.size();
        Map redoLogFiles = LogMinerHelper.getMap((Connection)conn, (String)SqlUtils.allOnlineLogsQuery(), (String)"-1");
        Assertions.assertThat((LogMinerHelperIT.getNumberOfAddedLogFiles(conn) == redoLogFiles.size() + archivedLogFilesCount ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void shouldCalculateAbandonTransactions() throws Exception {
        long twoHoursAgoScn;
        Map redoLogFiles = LogMinerHelper.getMap((Connection)conn, (String)SqlUtils.allOnlineLogsQuery(), (String)"-1");
        Long oldestOnlineScn = this.getOldestOnlineScn(redoLogFiles);
        Optional abandonWatermark = LogMinerHelper.getLastScnToAbandon((Connection)conn, (Long)oldestOnlineScn, (int)1);
        Assertions.assertThat((boolean)abandonWatermark.isPresent()).isTrue();
        long currentScn = LogMinerHelper.getCurrentScn((Connection)conn);
        abandonWatermark = LogMinerHelper.getLastScnToAbandon((Connection)conn, (Long)currentScn, (int)1);
        Assertions.assertThat((boolean)abandonWatermark.isPresent()).isFalse();
        List<BigDecimal> oneDayArchivedNextScn = this.getOneDayArchivedLogNextScn(conn);
        long oldestArchivedScn = this.getOldestArchivedScn(oneDayArchivedNextScn);
        abandonWatermark = LogMinerHelper.getLastScnToAbandon((Connection)conn, (Long)oldestArchivedScn, (int)1);
        Assertions.assertThat((boolean)abandonWatermark.isPresent()).isTrue();
        String scnQuery = "with minus_one as (select (systimestamp - INTERVAL '2' HOUR) as diff from dual) select timestamp_to_scn(diff) from minus_one";
        try (PreparedStatement ps = conn.prepareStatement(scnQuery);
             ResultSet rs = ps.executeQuery();){
            rs.next();
            twoHoursAgoScn = rs.getBigDecimal(1).longValue();
        }
        String query = SqlUtils.diffInDaysQuery((Long)twoHoursAgoScn);
        Float diffInDays = (Float)LogMinerHelper.getSingleResult((Connection)conn, (String)query, (LogMinerHelper.DATATYPE)LogMinerHelper.DATATYPE.FLOAT);
        Assertions.assertThat((Math.round(diffInDays.floatValue() * 24.0f) == 2 ? 1 : 0) != 0).isTrue();
        diffInDays = Float.valueOf(diffInDays.floatValue() + 0.6f);
        abandonWatermark = LogMinerHelper.getLastScnToAbandon((Connection)conn, (Long)twoHoursAgoScn, (int)Math.round(diffInDays.floatValue() * 24.0f));
        Assertions.assertThat((boolean)abandonWatermark.isPresent()).isFalse();
        abandonWatermark = LogMinerHelper.getLastScnToAbandon((Connection)conn, (Long)twoHoursAgoScn, (int)1);
        Assertions.assertThat((boolean)abandonWatermark.isPresent()).isTrue();
        abandonWatermark = LogMinerHelper.getLastScnToAbandon((Connection)conn, (Long)twoHoursAgoScn, (int)2);
        Assertions.assertThat((boolean)abandonWatermark.isPresent()).isTrue();
        abandonWatermark = LogMinerHelper.getLastScnToAbandon((Connection)conn, (Long)twoHoursAgoScn, (int)3);
        Assertions.assertThat((boolean)abandonWatermark.isPresent()).isFalse();
    }

    private Long getOldestOnlineScn(Map<String, String> redoLogFiles) throws Exception {
        Optional<BigDecimal> scn = redoLogFiles.values().stream().map(BigDecimal::new).min(BigDecimal::compareTo);
        if (!scn.isPresent()) {
            throw new Exception("cannot get oldest scn");
        }
        Long oldestScn = scn.get().longValue();
        return oldestScn;
    }

    private Long getOldestArchivedScn(List<BigDecimal> oneDayArchivedNextScn) throws Exception {
        Optional archivedScn = oneDayArchivedNextScn.stream().min(BigDecimal::compareTo);
        if (!archivedScn.isPresent()) {
            throw new Exception("cannot get oldest archived scn");
        }
        long oldestArchivedScn = ((BigDecimal)archivedScn.get()).longValue();
        return oldestArchivedScn;
    }

    private static int getNumberOfAddedLogFiles(Connection conn) throws SQLException {
        int counter = 0;
        try (PreparedStatement ps = conn.prepareStatement("select * from V$LOGMNR_LOGS");
             ResultSet result = ps.executeQuery();){
            while (result.next()) {
                ++counter;
            }
        }
        return counter;
    }

    private List<BigDecimal> getOneDayArchivedLogNextScn(Connection conn) throws SQLException {
        ArrayList<BigDecimal> allArchivedNextScn = new ArrayList<BigDecimal>();
        try (PreparedStatement st = conn.prepareStatement("SELECT NAME AS FILE_NAME, NEXT_CHANGE# AS NEXT_CHANGE FROM V$ARCHIVED_LOG  WHERE NAME IS NOT NULL AND FIRST_TIME >= SYSDATE - 1 AND ARCHIVED = 'YES'  AND STATUS = 'A' ORDER BY 2");
             ResultSet rs = st.executeQuery();){
            while (rs.next()) {
                allArchivedNextScn.add(rs.getBigDecimal(2));
            }
        }
        return allArchivedNextScn;
    }
}

