/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.SqlUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.fest.assertions.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class LogMinerUtilsTest {
    private static final BigDecimal SCN = BigDecimal.ONE;
    private static final BigDecimal OTHER_SCN = BigDecimal.TEN;
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    @Test
    public void testStartLogMinerStatement() {
        String statement = SqlUtils.startLogMinerStatement((Long)SCN.longValue(), (Long)OTHER_SCN.longValue(), (OracleConnectorConfig.LogMiningStrategy)OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO, (boolean)false);
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.DICT_FROM_REDO_LOGS")).isTrue();
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.DDL_DICT_TRACKING")).isTrue();
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.DICT_FROM_ONLINE_CATALOG")).isFalse();
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.CONTINUOUS_MINE")).isFalse();
        statement = SqlUtils.startLogMinerStatement((Long)SCN.longValue(), (Long)OTHER_SCN.longValue(), (OracleConnectorConfig.LogMiningStrategy)OracleConnectorConfig.LogMiningStrategy.ONLINE_CATALOG, (boolean)false);
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.DICT_FROM_REDO_LOGS")).isFalse();
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.DDL_DICT_TRACKING")).isFalse();
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.DICT_FROM_ONLINE_CATALOG")).isTrue();
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.CONTINUOUS_MINE")).isFalse();
        statement = SqlUtils.startLogMinerStatement((Long)SCN.longValue(), (Long)OTHER_SCN.longValue(), (OracleConnectorConfig.LogMiningStrategy)OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO, (boolean)true);
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.DICT_FROM_REDO_LOGS")).isTrue();
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.DDL_DICT_TRACKING")).isTrue();
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.DICT_FROM_ONLINE_CATALOG")).isFalse();
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.CONTINUOUS_MINE")).isTrue();
        statement = SqlUtils.startLogMinerStatement((Long)SCN.longValue(), (Long)OTHER_SCN.longValue(), (OracleConnectorConfig.LogMiningStrategy)OracleConnectorConfig.LogMiningStrategy.ONLINE_CATALOG, (boolean)true);
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.DICT_FROM_REDO_LOGS")).isFalse();
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.DDL_DICT_TRACKING")).isFalse();
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.DICT_FROM_ONLINE_CATALOG")).isTrue();
        Assertions.assertThat((boolean)statement.contains("DBMS_LOGMNR.CONTINUOUS_MINE")).isTrue();
    }

    @Test
    public void testConversion() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("one", "1001");
        map.put("two", "1002");
        map.put("three", "1007");
        map.put("four", "18446744073709551615");
        Map<String, Long> res = map.entrySet().stream().filter(entry -> new BigDecimal((String)entry.getValue()).longValue() > 1003L || new BigDecimal((String)entry.getValue()).longValue() == -1L).collect(Collectors.toMap(Map.Entry::getKey, e -> new BigDecimal((String)e.getValue()).longValue() == -1L ? Long.MAX_VALUE : new BigInteger((String)e.getValue()).longValue()));
        Assertions.assertThat(res).isNotEmpty();
    }
}

