/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.AbstractOracleDatatypesTest;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIs;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestRule;

@SkipWhenAdapterNameIs(value=SkipWhenAdapterNameIs.AdapterName.LOGMINER, reason="Implementation does not support creating/updating schema during streaming")
public class StreamingDatatypesIT
extends AbstractOracleDatatypesTest {
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    @Before
    public void before() throws Exception {
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        StreamingDatatypesIT.dropTables();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
        Configuration config = this.connectorConfig().build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        StreamingDatatypesIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        StreamingDatatypesIT.createTables();
    }

    @Override
    protected Configuration.Builder connectorConfig() {
        String tableIncludeList = this.getAllTables().stream().map(t -> t.replaceAll("\\.", "\\\\.")).collect(Collectors.joining(","));
        return (Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, tableIncludeList)).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY);
    }

    @Override
    protected boolean insertRecordsDuringTest() {
        return true;
    }
}

