/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.logminer.HistoryRecorder;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.Scn;
import io.debezium.connector.oracle.logminer.TransactionalBufferMetrics;
import io.debezium.relational.TableId;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowMapper.class);
    public static final int INSERT = 1;
    public static final int DELETE = 2;
    public static final int UPDATE = 3;
    public static final int DDL = 5;
    public static final int COMMIT = 7;
    public static final int MISSING_SCN = 34;
    public static final int ROLLBACK = 36;
    private static final int SCN = 1;
    private static final int SQL_REDO = 2;
    private static final int OPERATION_CODE = 3;
    private static final int CHANGE_TIME = 4;
    private static final int TX_ID = 5;
    private static final int CSF = 6;
    private static final int TABLE_NAME = 7;
    private static final int SEG_OWNER = 8;
    private static final int OPERATION = 9;
    private static final int USERNAME = 10;

    public static String getOperation(TransactionalBufferMetrics metrics, ResultSet rs) {
        try {
            return rs.getString(9);
        }
        catch (SQLException e) {
            RowMapper.logError(metrics, e, "OPERATION");
            return null;
        }
    }

    public static String getUsername(TransactionalBufferMetrics metrics, ResultSet rs) {
        try {
            return rs.getString(10);
        }
        catch (SQLException e) {
            RowMapper.logError(metrics, e, "USERNAME");
            return null;
        }
    }

    public static int getOperationCode(TransactionalBufferMetrics metrics, ResultSet rs) {
        try {
            return rs.getInt(3);
        }
        catch (SQLException e) {
            RowMapper.logError(metrics, e, "OPERATION_CODE");
            return 0;
        }
    }

    public static String getTableName(TransactionalBufferMetrics metrics, ResultSet rs) {
        try {
            return rs.getString(7);
        }
        catch (SQLException e) {
            RowMapper.logError(metrics, e, "TABLE_NAME");
            return "";
        }
    }

    public static String getSegOwner(TransactionalBufferMetrics metrics, ResultSet rs) {
        try {
            return rs.getString(8);
        }
        catch (SQLException e) {
            RowMapper.logError(metrics, e, "SEG_OWNER");
            return "";
        }
    }

    public static Timestamp getChangeTime(TransactionalBufferMetrics metrics, ResultSet rs) {
        try {
            return rs.getTimestamp(4);
        }
        catch (SQLException e) {
            RowMapper.logError(metrics, e, "CHANGE_TIME");
            return new Timestamp(Instant.now().getEpochSecond());
        }
    }

    public static Scn getScn(TransactionalBufferMetrics metrics, ResultSet rs) {
        try {
            return new Scn(rs.getBigDecimal(1));
        }
        catch (SQLException e) {
            RowMapper.logError(metrics, e, "SCN");
            return Scn.INVALID;
        }
    }

    public static String getTransactionId(TransactionalBufferMetrics metrics, ResultSet rs) {
        try {
            return DatatypeConverter.printHexBinary((byte[])rs.getBytes(5));
        }
        catch (SQLException e) {
            RowMapper.logError(metrics, e, "TX_ID");
            return "";
        }
    }

    public static String getSqlRedo(TransactionalBufferMetrics metrics, ResultSet rs, boolean isDml, HistoryRecorder historyRecorder, Scn scn, String tableName, String segOwner, int operationCode, Timestamp changeTime, String txId) {
        int lobLimitCounter = 9;
        StringBuilder result = new StringBuilder(4000);
        try {
            String redoSql = rs.getString(2);
            if (redoSql == null) {
                return null;
            }
            result = new StringBuilder(redoSql);
            int csf = rs.getInt(6);
            if (isDml) {
                historyRecorder.record(scn, tableName, segOwner, operationCode, changeTime, txId, csf, redoSql);
            }
            while (csf == 1) {
                rs.next();
                if (lobLimitCounter-- == 0) {
                    LOGGER.warn("LOB value was truncated due to the connector limitation of {} MB", (Object)40);
                    break;
                }
                result.append(rs.getString(2));
                csf = rs.getInt(6);
                if (!isDml) continue;
                historyRecorder.record(scn, tableName, segOwner, operationCode, changeTime, txId, csf, rs.getString(2));
            }
        }
        catch (SQLException e) {
            RowMapper.logError(metrics, e, "SQL_REDO");
        }
        return result.toString();
    }

    private static void logError(TransactionalBufferMetrics metrics, SQLException e, String s) {
        LogMinerHelper.logError(metrics, "Cannot get {}. This entry from log miner will be lost due to the {}", s, e);
    }

    public static TableId getTableId(String catalogName, ResultSet rs) throws SQLException {
        return new TableId(catalogName, rs.getString(8), rs.getString(7));
    }
}

